/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.common.FileTransferManager;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIAdminCommandsClientImpl
implements Serializable,
JBIAdminCommands {
    private static I18NBundle sI18NBundle = null;
    transient MBeanServerConnection remoteConnection;
    boolean isRemoteConnection;
    protected Object mLastUploadId = null;
    static final long serialVersionUID = 22798309571083089L;

    public JBIAdminCommandsClientImpl() {
        this(null, false);
    }

    public JBIAdminCommandsClientImpl(MBeanServerConnection serverConnection) {
        this(serverConnection, false);
    }

    public JBIAdminCommandsClientImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        this.remoteConnection = serverConnection;
        this.isRemoteConnection = isRemoteConnection;
    }

    boolean isRemoteConnection() {
        return this.isRemoteConnection;
    }

    @Override
    public String deployServiceAssembly(String zipFilePath, String targetName) throws JBIRemoteException {
        String result = null;
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "deployServiceAssembly", params, signature);
        this.removeUploadedFile();
        result = resultObject.toString();
        return result;
    }

    String validateServiceAssembly(String zipFilePath) {
        JBIArchive archive = null;
        ServiceAssemblyDD descriptor = null;
        String name = null;
        try {
            archive = new JBIArchive(zipFilePath);
            if (archive.isServiceAssemblyArchive()) {
                descriptor = (ServiceAssemblyDD)archive.getJbiDescriptor();
                name = descriptor.getName();
            }
        }
        catch (IOException ioException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    @Override
    public Map<String, String> deployServiceAssembly(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{zipFilePath, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "deployServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String getComponentInstallationDescriptor(String componentName) throws JBIRemoteException {
        String result = null;
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "getComponentInstallationDescriptor", params, signature);
        if (resultObject != null) {
            result = resultObject.toString();
        }
        return result;
    }

    @Override
    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "getServiceAssemblyDeploymentDescriptor", params, signature);
        return resultObject.toString();
    }

    @Override
    public String getSharedLibraryInstallationDescriptor(String sharedLibraryName) throws JBIRemoteException {
        String result = null;
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "getSharedLibraryInstallationDescriptor", params, signature);
        if (resultObject != null) {
            result = resultObject.toString();
        }
        return result;
    }

    @Override
    public String installComponent(String zipFilePath, Properties paramProps, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, paramProps, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installComponent", params, signature);
        this.removeUploadedFile();
        return resultObject.toString();
    }

    @Override
    public String installComponent(String zipFilePath, String targetName) throws JBIRemoteException {
        return this.installComponent(zipFilePath, new Properties(), targetName);
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, Properties paramProps, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{zipFilePath, paramProps, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installComponent", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponent(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        return this.installComponent(zipFilePath, new Properties(), targetNames);
    }

    @Override
    public String installSharedLibrary(String zipFilePath, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{zipFilePath, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installSharedLibrary", params, signature);
        this.removeUploadedFile();
        return resultObject.toString();
    }

    @Override
    public Map<String, String> installSharedLibrary(String zipFilePath, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{zipFilePath, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public boolean isJBIRuntimeEnabled() throws JBIRemoteException {
        boolean result = false;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        result = this.isRegistered(mbeanName);
        return result;
    }

    boolean isRegistered(ObjectName objectName) {
        boolean result = false;
        Boolean resultObject = null;
        try {
            resultObject = this.remoteConnection.isRegistered(objectName);
            if (resultObject != null) {
                result = resultObject;
            }
        }
        catch (IOException e) {
            result = false;
        }
        catch (RuntimeException exception) {
            result = false;
        }
        return result;
    }

    @Override
    public String listBindingComponents(String targetName) throws JBIRemoteException {
        return this.listBindingComponents(null, null, null, targetName);
    }

    @Override
    public String listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{state, sharedLibraryName, serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "listBindingComponents", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> listBindingComponents(String[] targetNames) throws JBIRemoteException {
        return this.listBindingComponents(null, null, null, targetNames);
    }

    @Override
    public Map<String, String> listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{state, sharedLibraryName, serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "listBindingComponents", params, signature);
        return resultObject;
    }

    @Override
    public String listServiceAssemblies(String targetName) throws JBIRemoteException {
        return this.listServiceAssemblies(null, null, targetName);
    }

    @Override
    public String listServiceAssemblies(String componentName, String targetName) throws JBIRemoteException {
        return this.listServiceAssemblies(null, componentName, targetName);
    }

    @Override
    public String listServiceAssemblies(String state, String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{state, componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "listServiceAssemblies", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> listServiceAssemblies(String[] targetNames) throws JBIRemoteException {
        return this.listServiceAssemblies(null, null, targetNames);
    }

    @Override
    public Map<String, String> listServiceAssemblies(String componentName, String[] targetNames) throws JBIRemoteException {
        return this.listServiceAssemblies(null, componentName, targetNames);
    }

    @Override
    public Map<String, String> listServiceAssemblies(String state, String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{state, componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "listServiceAssemblies", params, signature);
        return resultObject;
    }

    @Override
    public String listServiceEngines(String targetName) throws JBIRemoteException {
        return this.listServiceEngines(null, null, null, targetName);
    }

    @Override
    public String listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{state, sharedLibraryName, serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "listServiceEngines", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> listServiceEngines(String[] targetNames) throws JBIRemoteException {
        return this.listServiceEngines(null, null, null, targetNames);
    }

    @Override
    public Map<String, String> listServiceEngines(String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{state, sharedLibraryName, serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "listServiceEngines", params, signature);
        return resultObject;
    }

    @Override
    public String listSharedLibraries(String targetName) throws JBIRemoteException {
        return this.listSharedLibraries(null, targetName);
    }

    @Override
    public String listSharedLibraries(String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "listSharedLibraries", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> listSharedLibraries(String[] targetNames) throws JBIRemoteException {
        return this.listSharedLibraries(null, targetNames);
    }

    @Override
    public Map<String, String> listSharedLibraries(String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "listSharedLibraries", params, signature);
        return resultObject;
    }

    @Override
    public String listSharedLibraryDependents(String sharedLibraryName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "listSharedLibraryDependents", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> listSharedLibraryDependents(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "listSharedLibraryDependents", params, signature);
        return resultObject;
    }

    @Override
    public String showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, state, sharedLibraryName, serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "showBindingComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> showBindingComponent(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, state, sharedLibraryName, serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "showBindingComponent", params, signature);
        return resultObject;
    }

    @Override
    public String showServiceAssembly(String name, String state, String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, state, componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "showServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> showServiceAssembly(String name, String state, String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, state, componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "showServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, state, sharedLibraryName, serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "showServiceEngine", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> showServiceEngine(String name, String state, String sharedLibraryName, String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, state, sharedLibraryName, serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "showServiceEngine", params, signature);
        return resultObject;
    }

    @Override
    public String showSharedLibrary(String name, String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "showSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> showSharedLibrary(String name, String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{name, componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "showSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public String shutdownComponent(String componentName, String targetName) throws JBIRemoteException {
        boolean force = false;
        return this.shutdownComponent(componentName, force, targetName);
    }

    @Override
    public String shutdownComponent(String componentName, boolean force, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, force, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "shutdownComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        boolean force = false;
        return this.shutdownComponent(componentName, force, targetNames);
    }

    @Override
    public Map<String, String> shutdownComponent(String componentName, boolean force, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, force, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "shutdownComponent", params, signature);
        return resultObject;
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "shutdownServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public String shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceShutdown, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "shutdownServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, boolean forceShutdown, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceShutdown, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "shutdownServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> shutdownServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "shutdownServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String startComponent(String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "startComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> startComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "startComponent", params, signature);
        return resultObject;
    }

    @Override
    public String startServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "startServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> startServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "startServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String stopComponent(String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "stopComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> stopComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "stopComponent", params, signature);
        return resultObject;
    }

    @Override
    public String stopServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "stopServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> stopServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "stopServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject;
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, serviceUnitName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "getServiceUnitDeploymentDescriptor", params, signature);
        return resultObject.toString();
    }

    @Override
    public String installComponentFromDomain(String componentName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject.toString();
    }

    @Override
    public String installComponentFromDomain(String componentName, Properties properties, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, properties, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, forceDelete, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public String installSharedLibraryFromDomain(String libraryName, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{libraryName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "installSharedLibraryFromDomain", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, forceDelete, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public String deployServiceAssemblyFromDomain(String assemblyName, String targetName) throws JBIRemoteException {
        String result = null;
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{assemblyName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "deployServiceAssemblyFromDomain", params, signature);
        result = resultObject.toString();
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> installComponentFromDomain(String componentName, Properties properties, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, properties, targetNames};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installComponentFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, forceDelete, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> installSharedLibraryFromDomain(String libraryName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{libraryName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "installSharedLibraryFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, forceDelete, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> deployServiceAssemblyFromDomain(String assemblyName, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{assemblyName, targetNames};
        String[] signature = new String[]{"java.lang.String", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "deployServiceAssemblyFromDomain", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public String uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, forceDelete, retainInDomain, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject.toString();
    }

    @Override
    public String uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, forceDelete, retainInDomain, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject.toString();
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String targetName) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, retainInDomain, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject.toString();
    }

    @Override
    public Map<String, String> uninstallComponent(String componentName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, forceDelete, retainInDomain, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallComponent", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> uninstallSharedLibrary(String sharedLibraryName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{sharedLibraryName, forceDelete, retainInDomain, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "uninstallSharedLibrary", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{serviceAssemblyName, forceDelete, retainInDomain, targetNames};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean", targetNames.getClass().getName()};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "undeployServiceAssembly", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, Level> getComponentLoggerLevels(String componentName, String targetName, String targetInstanceName) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getComponentLoggerLevels", params, signature);
        return resultObject;
    }

    @Override
    public void setComponentLoggerLevel(String componentName, String loggerCustomName, Level logLevel, String targetName, String targetInstanceName) throws JBIRemoteException {
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, loggerCustomName, logLevel, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.logging.Level", "java.lang.String", "java.lang.String"};
        this.invokeMBeanOperation(mbeanName, "setComponentLoggerLevel", params, signature);
    }

    @Override
    public Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, extensionName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getComponentExtensionMBeanObjectNames", params, signature);
        return resultObject;
    }

    @Override
    public ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws JBIRemoteException {
        ObjectName[] resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, extensionName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (ObjectName[])this.invokeMBeanOperation(mbeanName, "getComponentExtensionMBeanObjectNames", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, Properties> getComponentConfiguration(String componentName, String targetName) throws JBIRemoteException {
        Map resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getComponentConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public Properties setComponentConfiguration(String componentName, Properties configurationValue, String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{componentName, configurationValue, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "setComponentConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public String updateComponent(String componentName, String zipFilePath) throws JBIRemoteException {
        Object resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        if (this.isRemoteConnection()) {
            zipFilePath = this.uploadFile(zipFilePath);
        }
        Object[] params = new Object[]{componentName, zipFilePath};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = this.invokeMBeanOperation(mbeanName, "updateComponent", params, signature);
        this.removeUploadedFile();
        return resultObject.toString();
    }

    @Override
    public boolean isTargetUp(String targetName) throws JBIRemoteException {
        boolean result = false;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Boolean resultObject = null;
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Boolean)this.invokeMBeanOperation(mbeanName, "isTargetUp", params, signature);
        if (resultObject != null) {
            result = resultObject;
        }
        return result;
    }

    @Override
    public Properties getRuntimeConfigurationMetaData(String propertyKeyName) throws JBIRemoteException {
        Properties resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{propertyKeyName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getRuntimeConfigurationMetaData", params, signature);
        return resultObject;
    }

    @Override
    public boolean setRuntimeConfiguration(Properties parameters, String targetName) throws JBIRemoteException {
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Boolean resultObject = null;
        Object[] params = new Object[]{parameters, targetName};
        String[] signature = new String[]{"java.util.Properties", "java.lang.String"};
        resultObject = (Boolean)this.invokeMBeanOperation(mbeanName, "setRuntimeConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfiguration(String targetName) throws JBIRemoteException {
        Properties resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getRuntimeConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public Properties getDefaultRuntimeConfiguration() throws JBIRemoteException {
        Properties resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = null;
        String[] signature = null;
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getDefaultRuntimeConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public boolean isServerRestartRequired() throws JBIRemoteException {
        Boolean resultObject = null;
        ObjectName mbeanName = this.getJbiAdminUiMBeanObjectName();
        Object[] params = null;
        String[] signature = null;
        resultObject = (Boolean)this.invokeMBeanOperation(mbeanName, "isServerRestartRequired", params, signature);
        return resultObject;
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws JBIRemoteException {
        Object result = null;
        if (this.remoteConnection != null) {
            try {
                result = this.remoteConnection.invoke(objectName, operationName, params, signature);
            }
            catch (InstanceNotFoundException jmxException) {
                throw JBIRemoteException.filterJmxExceptions(jmxException);
            }
            catch (MBeanException jmxException) {
                throw JBIRemoteException.filterJmxExceptions(jmxException);
            }
            catch (ReflectionException jmxException) {
                throw JBIRemoteException.filterJmxExceptions(jmxException);
            }
            catch (IOException jmxException) {
                throw JBIRemoteException.filterJmxExceptions(jmxException);
            }
        }
        return result;
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, String param) throws JBIRemoteException {
        Object[] params = new Object[]{param};
        String[] signature = new String[]{"java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    public ObjectName getAdminServiceMBeanObjectName() throws JBIRemoteException {
        try {
            ObjectName mbeanName = JBIJMXObjectNames.getAdminServiceMBeanObjectName();
            return mbeanName;
        }
        catch (MalformedObjectNameException objEx) {
            throw JBIRemoteException.filterJmxExceptions(objEx);
        }
    }

    public ObjectName getJbiAdminUiMBeanObjectName() throws JBIRemoteException {
        try {
            ObjectName mbeanName = JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName();
            return mbeanName;
        }
        catch (MalformedObjectNameException objEx) {
            throw JBIRemoteException.filterJmxExceptions(objEx);
        }
    }

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.client");
        }
        return sI18NBundle;
    }

    public MBeanServerConnection getMBeanServerConnection() throws IllegalStateException {
        if (this.remoteConnection == null) {
            throw new IllegalStateException(JBIResultXmlBuilder.createFailedJbiResultXml(JBIAdminCommandsClientImpl.getI18NBundle(), "jbi.ui.jmx.connection.not.open", null));
        }
        return this.remoteConnection;
    }

    public String uploadFile(String localFilePath) throws JBIRemoteException {
        File uploadFile = new File(localFilePath);
        String name = uploadFile.getName();
        try {
            FileTransferManager ftpManager = new FileTransferManager(this.getMBeanServerConnection());
            String uploadedFilePath = ftpManager.uploadArchive(uploadFile);
            this.mLastUploadId = ftpManager.getLastUploadId();
            String string = uploadedFilePath;
            return string;
        }
        catch (Exception ex) {
            String jbiMgmtMsg = JBIResultXmlBuilder.createJbiResultXml(JBIAdminCommandsClientImpl.getI18NBundle(), "jbi.ui.client.remote.file.upload.error", new Object[]{name}, ex);
            throw new JBIRemoteException(new Exception(jbiMgmtMsg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUploadedFile() {
        if (this.mLastUploadId == null) {
            return;
        }
        try {
            FileTransferManager ftpManager = new FileTransferManager(this.getMBeanServerConnection());
            ftpManager.removeUploadedArchive(this.mLastUploadId);
            this.mLastUploadId = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.mLastUploadId = null;
        }
    }

    public static String formatTargetNames(String target) {
        return target;
    }

    public static String formatTargetNames(String[] target) {
        String result = "{ ";
        for (int index = 0; index < target.length; ++index) {
            result = result + target[index];
            result = result + "  ";
        }
        result = result + "}";
        return result;
    }

    public static void displayResult(String testingOperation, String result) {
        System.out.println(" ** Testing: " + testingOperation + " **");
        System.out.println("Result is:");
        System.out.println(result);
        System.out.println("==============================");
    }

    public static void displayResult(String testingOperation, Map<String, String> resultObject) {
        System.out.println(" ** Testing: " + testingOperation + " **");
        System.out.println("Result is:");
        Set<String> keySet = resultObject.keySet();
        for (String key : keySet) {
            if (key == null) continue;
            String value = resultObject.get(key);
            System.out.println("Key: " + key);
            System.out.println("Value: " + value);
        }
        System.out.println("==============================");
    }

    public static void testPrepareSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        String result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        if (commands != null) {
            try {
                result = commands.installSharedLibrary(libraryArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installSharedLibrary(" + libraryArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.getSharedLibraryInstallationDescriptor(libraryName);
                JBIAdminCommandsClientImpl.displayResult("getSharedLibraryInstallationDescriptor(" + libraryName + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                Properties properties = new Properties();
                properties.setProperty("OutboundThreads", "15");
                result = commands.installComponent(bindingArtifactFile, properties, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + bindingArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.getComponentInstallationDescriptor(bindingName);
                JBIAdminCommandsClientImpl.displayResult("getComponentInstallationDescriptor(" + bindingName + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.startComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("startComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.installComponent(engineArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + engineArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.startComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("startComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.deployServiceAssembly(assemblyArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("deployServiceAssembly(" + assemblyArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.startServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("startServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testCleanupSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        String result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        if (commands != null) {
            try {
                result = commands.stopServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("stopServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.shutdownServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("shutdownServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.undeployServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("undeployServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.stopComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("stopComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.shutdownComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("shutdownComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.stopComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("stopComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.shutdownComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("shutdownComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallSharedLibrary(libraryName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallSharedLibrary(" + libraryName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testShowSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        String result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        String[] frameworkStates = new String[]{"Shutdown", "Started", "Stopped"};
        if (commands != null) {
            try {
                result = commands.listBindingComponents(targetName);
                JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceEngines(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listSharedLibraries(targetName);
                JBIAdminCommandsClientImpl.displayResult("listSharedLibraries(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceAssemblies(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceAssemblies(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.showSharedLibrary(libraryName, bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.showSharedLibrary(libraryName, engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            for (int index = 0; index < frameworkStates.length; ++index) {
                try {
                    result = commands.listBindingComponents(frameworkStates[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.listServiceEngines(frameworkStates[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showBindingComponent(bindingName, frameworkStates[index], null, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showBindingComponent(" + bindingName + ", " + frameworkStates[index] + ", " + null + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceEngine(engineName, frameworkStates[index], null, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceEngine(" + engineName + ", " + frameworkStates[index] + ", " + null + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceAssembly(assemblyName, frameworkStates[index], bindingName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceAssembly(" + assemblyName + ", " + frameworkStates[index] + ", " + bindingName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceAssembly(assemblyName, frameworkStates[index], engineName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceAssembly(" + assemblyName + ", " + frameworkStates[index] + ", " + engineName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                    continue;
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
            }
            try {
                result = commands.showSharedLibrary(libraryName, null, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + null + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.getServiceAssemblyDeploymentDescriptor(assemblyName);
                JBIAdminCommandsClientImpl.displayResult("getServiceAssemblyDeploymentDescriptor(" + assemblyName + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void testSingleTargetCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String targetName) {
        JBIAdminCommandsClientImpl.testPrepareSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
        JBIAdminCommandsClientImpl.testShowSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
        JBIAdminCommandsClientImpl.testCleanupSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
    }

    public static void testMultipleTargetsCases(JBIAdminCommands commands, String bindingName, String bindingArtifactFile, String engineName, String engineArtifactFile, String libraryName, String libraryArtifactFile, String assemblyName, String assemblyArtifactFile, String[] targetName) {
        Map<String, String> result = null;
        String[] states = new String[]{"started", "stopped", "shutdown", "unknown"};
        if (commands != null) {
            try {
                result = commands.installSharedLibrary(libraryArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installSharedLibrary(" + libraryArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.installComponent(bindingArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + bindingArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.installComponent(engineArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("installComponent(" + engineArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listBindingComponents(targetName);
                JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceEngines(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            for (int index = 0; index < states.length; ++index) {
                try {
                    result = commands.listBindingComponents(states[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listBindingComponents(" + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.listServiceEngines(states[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("listServiceEngines(" + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showBindingComponent(bindingName, states[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showBindingComponent(" + bindingName + ", " + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                try {
                    result = commands.showServiceEngine(engineName, states[index], libraryName, assemblyName, targetName);
                    JBIAdminCommandsClientImpl.displayResult("showServiceEngine(" + engineName + ", " + states[index] + ", " + libraryName + ", " + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
                    continue;
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
            }
            try {
                result = commands.showSharedLibrary(libraryName, bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.showSharedLibrary(libraryName, engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("showSharedLibrary(" + libraryName + ", " + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listSharedLibraries(targetName);
                JBIAdminCommandsClientImpl.displayResult("listSharedLibraries(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.deployServiceAssembly(assemblyArtifactFile, targetName);
                JBIAdminCommandsClientImpl.displayResult("deployServiceAssembly(" + assemblyArtifactFile + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.listServiceAssemblies(targetName);
                JBIAdminCommandsClientImpl.displayResult("listServiceAssemblies(" + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.undeployServiceAssembly(assemblyName, targetName);
                JBIAdminCommandsClientImpl.displayResult("undeployServiceAssembly(" + assemblyName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(bindingName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + bindingName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallComponent(engineName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallComponent(" + engineName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
            try {
                result = commands.uninstallSharedLibrary(libraryName, targetName);
                JBIAdminCommandsClientImpl.displayResult("uninstallSharedLibrary(" + libraryName + ", " + JBIAdminCommandsClientImpl.formatTargetNames(targetName) + ")", result);
            }
            catch (JBIRemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        block4: {
            JBIAdminCommands commands = null;
            String hostName = "localhost";
            int port = 5651;
            String userName = "admin";
            String password = "adminadmin";
            String dummyName = "foo";
            String targetName = "server";
            String[] targetNames = new String[]{targetName};
            boolean isJBIRuntimeEnabled = false;
            String bindingName = null;
            String bindingArtifactFile = null;
            String engineName = null;
            String engineArtifactFile = null;
            String libraryName = null;
            String libraryArtifactFile = null;
            String assemblyName = null;
            String assemblyArtifactFile = null;
            bindingArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/httpsoapbc.jar";
            engineArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/bpelserviceengine.jar";
            libraryArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/wsdlsl.jar";
            assemblyArtifactFile = "C:/cygwin/a/open-esb/ri-clients/jbi-admin-common/regress/testdata/artifacts/HelloCompositeApp.zip";
            bindingName = "sun-http-binding";
            engineName = "com.sun.bpelse-1.0-2";
            libraryName = "sun-wsdl-library";
            assemblyName = "HelloCompositeApp";
            try {
                commands = JBIAdminCommandsClientFactory.getInstance(hostName, port, userName, password);
                if (commands == null) break block4;
                try {
                    isJBIRuntimeEnabled = commands.isJBIRuntimeEnabled();
                }
                catch (JBIRemoteException e) {
                    e.printStackTrace();
                }
                System.out.println("The JBI Framework is " + (isJBIRuntimeEnabled ? "Enabled." : "NOT Enabled."));
                System.out.println(" ===================================");
                System.out.println(" === Testing Single Target Cases ===");
                System.out.println(" ===================================");
                JBIAdminCommandsClientImpl.testSingleTargetCases(commands, bindingName, bindingArtifactFile, engineName, engineArtifactFile, libraryName, libraryArtifactFile, assemblyName, assemblyArtifactFile, targetName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

