/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.ComponentManager;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.management.support.JbiNameInfo;
import com.sun.jbi.management.system.MessageServiceMBean;
import com.sun.jbi.management.system.ModelSystemService;
import com.sun.jbi.messaging.ConnectionManager;
import com.sun.jbi.messaging.DeliveryChannel;
import com.sun.jbi.messaging.DeliveryChannelImpl;
import com.sun.jbi.messaging.DynamicEndpoint;
import com.sun.jbi.messaging.EndpointListener;
import com.sun.jbi.messaging.EndpointRegistry;
import com.sun.jbi.messaging.ExchangeIdGenerator;
import com.sun.jbi.messaging.ExchangeIdGeneratorImpl;
import com.sun.jbi.messaging.LinkedEndpoint;
import com.sun.jbi.messaging.MessageExchange;
import com.sun.jbi.messaging.MessageExchangeProxy;
import com.sun.jbi.messaging.MessageServiceStatistics;
import com.sun.jbi.messaging.RegisteredEndpoint;
import com.sun.jbi.messaging.TimeoutListener;
import com.sun.jbi.messaging.util.Translator;
import com.sun.jbi.messaging.util.XMLUtil;
import com.sun.jbi.monitoring.ComponentStatisticsBase;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class MessageService
extends ModelSystemService
implements ServiceLifecycle,
MessageServiceMBean {
    private EnvironmentContext mEnvironmentContext;
    private EndpointRegistry mRegistry;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());
    private ComponentManager mComponentManager;
    private TransactionManager mTransactionManager;
    private Hashtable mChannels;
    private final JbiNameInfo mJbiNameInfo = new JbiNameInfo("MessageService");
    private EndpointListener mListener;
    private TimeoutListener mTimeout;
    private DeliveryChannel mTimeoutDC;
    private ExchangeIdGenerator mGenerator;
    private MessageServiceStatistics mStatistics;
    LinkedList mResources;

    public MessageService() {
        this.mChannels = new Hashtable();
        this.mResources = new LinkedList();
        this.mStatistics = new MessageServiceStatistics(this.mJbiNameInfo.name());
    }

    public void initService(EnvironmentContext ctx) throws JBIException {
        this.mEnvironmentContext = ctx;
        this.mRegistry = EndpointRegistry.getInstance();
        this.mComponentManager = ctx.getComponentManager();
        Translator.setStringTranslator(this.mEnvironmentContext.getStringTranslator("com.sun.jbi.messaging"));
        super.initModelSystemService(ctx, this.mLog, this.mJbiNameInfo);
        this.mStartMBeans.add(this.mMessageServiceMBeanName, MessageServiceMBean.class, this, true);
        super.bootstrap();
    }

    public void startService() throws JBIException {
        this.mGenerator = new ExchangeIdGeneratorImpl();
        this.mStatistics.setLastRestartTime(new Date());
    }

    public void stopService() throws JBIException {
        Enumeration e = this.mChannels.elements();
        while (e.hasMoreElements()) {
            DeliveryChannelImpl channel = (DeliveryChannelImpl)e.nextElement();
            channel.close();
        }
        this.mChannels.clear();
        this.mRegistry.clear();
    }

    public DeliveryChannelImpl activateChannel(String componentId, ClassLoader classLoader) throws MessagingException {
        return this.activateChannel(componentId, classLoader, null);
    }

    public synchronized DeliveryChannelImpl activateChannel(String componentId, ClassLoader classLoader, ComponentStatisticsBase stats) throws MessagingException {
        DeliveryChannelImpl dc;
        if (this.mChannels.containsKey(componentId)) {
            dc = (DeliveryChannelImpl)this.mChannels.get(componentId);
        } else {
            this.mLog.fine(Translator.translate("CHANNEL_CREATED", new Object[]{componentId}));
            dc = new DeliveryChannelImpl(componentId, classLoader, this, this.mListener, stats);
            this.addChannel(dc);
        }
        return dc;
    }

    public ConnectionManager getConnectionManager() {
        return this.mRegistry;
    }

    void addChannel(DeliveryChannelImpl channel) {
        this.mChannels.put(channel.getChannelId(), channel);
    }

    void removeChannel(String channelId) {
        this.mChannels.remove(channelId);
    }

    DeliveryChannelImpl getChannel(String channelId) {
        return (DeliveryChannelImpl)this.mChannels.get(channelId);
    }

    MessageServiceStatistics getStatistics() {
        return this.mStatistics;
    }

    TransactionManager getTransactionManager() {
        if (this.mTransactionManager == null && this.mEnvironmentContext != null) {
            this.mTransactionManager = this.mEnvironmentContext.getTransactionManager();
        }
        return this.mTransactionManager;
    }

    public void addXAResource(XAResource resource) {
        this.mResources.add(resource);
    }

    public XAResource[] getXAResources() {
        XAResource[] resources = new XAResource[this.mResources.size()];
        this.mResources.toArray(resources);
        return resources;
    }

    public void purgeXAResources() {
        this.mResources.clear();
    }

    void setTransactionManager(TransactionManager tm) {
        this.mTransactionManager = tm;
    }

    void doExchange(DeliveryChannelImpl channel, MessageExchangeProxy exchange) throws MessagingException {
        this.addressExchange(exchange, channel.getChannelId());
        exchange.validate(channel, false);
        DeliveryChannelImpl targetChannel = exchange.getSendChannel();
        MessageExchangeProxy targetExchange = exchange.getTwin();
        if (exchange.handleSend(channel)) {
            channel.removeReference(exchange);
        } else {
            channel.addReference(exchange);
        }
        targetChannel.queueExchange(targetExchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSynchExchange(DeliveryChannelImpl channel, MessageExchangeProxy exchange, long timeout) throws MessagingException {
        boolean active = true;
        boolean timedout = false;
        this.addressExchange(exchange, channel.getChannelId());
        exchange.validate(channel, true);
        DeliveryChannelImpl targetChannel = exchange.getSendChannel();
        MessageExchangeProxy targetExchange = exchange.getTwin();
        if (!exchange.handleSend(channel)) {
            channel.addReference(exchange);
        }
        MessageExchangeProxy messageExchangeProxy = exchange;
        synchronized (messageExchangeProxy) {
            block13: {
                exchange.setSynchState(timeout != 0L && this.mTimeout != null && this.mTimeoutDC != targetChannel ? 2 : 1);
                targetChannel.queueExchange(targetExchange);
                try {
                    while (true) {
                        exchange.wait(timeout);
                        int state = exchange.getSynchState();
                        if (state == 3) {
                            exchange.setSynchState(4);
                            break block13;
                        }
                        if (timeout == 0L) continue;
                        if (state == 1) {
                            exchange.terminate();
                            active = false;
                            break block13;
                        }
                        if (state == 2) break;
                    }
                    timedout = true;
                }
                catch (InterruptedException iEx) {
                    exchange.terminate();
                    active = false;
                }
            }
        }
        if (timedout) {
            if (this.mTimeout.checkTimeout(channel, exchange)) {
                exchange.terminate();
                active = false;
            } else {
                exchange.setSynchState(0);
            }
        }
        if (!active) {
            channel.removeReference(exchange);
        }
        return active;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addressExchange(MessageExchangeProxy exchange, String consumerId) throws MessagingException {
        RegisteredEndpoint endpoint = (RegisteredEndpoint)exchange.getEndpoint();
        if (endpoint == null) {
            QName serviceName = exchange.getService();
            if (serviceName != null) {
                RegisteredEndpoint[] endpoints = this.mRegistry.getInternalEndpointsForService(serviceName, true);
                if (endpoints.length == 0) throw new MessagingException(Translator.translate("CANT_FIND_ENDPOINT_FOR_SERVICE", new Object[]{serviceName.toString()}));
                endpoint = this.matchConsumerAndProvider(consumerId, endpoints, exchange);
            } else {
                QName interfaceName = exchange.getInterfaceName();
                if (interfaceName == null) throw new MessagingException(Translator.translate("ADDR_NO_ENDPOINT"));
                RegisteredEndpoint[] endpoints = this.mRegistry.getInternalEndpointsForInterface(interfaceName, this);
                if (endpoints.length == 0) throw new MessagingException(Translator.translate("CANT_FIND_ENDPOINT_FOR_INTERFACE", new Object[]{interfaceName.toString()}));
                endpoint = this.matchConsumerAndProvider(consumerId, endpoints, exchange);
            }
        }
        if (endpoint.isLinked()) {
            exchange.setEndpointLink(endpoint);
            endpoint = this.mRegistry.resolveLinkedEndpoint((LinkedEndpoint)endpoint);
            if (endpoint == null) {
                throw new MessagingException(Translator.translate("SERVICE_CONNECTION_NO_ENDPOINT", new Object[]{exchange.getEndpointLink().getServiceName(), exchange.getEndpointLink().getEndpointName()}));
            }
        }
        exchange.setEndpoint(endpoint);
    }

    Document queryDescriptor(ServiceEndpoint ref) {
        Document descriptor = null;
        if (ref instanceof LinkedEndpoint && (ref = this.mRegistry.resolveLinkedEndpoint((LinkedEndpoint)ref)) == null) {
            return null;
        }
        Component component = this.mComponentManager.getComponentInstance(((RegisteredEndpoint)ref).getOwnerId());
        if (component != null) {
            descriptor = component.getServiceDescription(ref);
        }
        return descriptor;
    }

    DynamicEndpoint resolveEndpointReference(DocumentFragment reference) {
        DynamicEndpoint dep = null;
        Set channels = ((Hashtable)this.mChannels.clone()).keySet();
        for (String id : channels) {
            Component comp = this.mComponentManager.getComponentInstance(id);
            ServiceEndpoint ep = comp.resolveEndpointReference(reference);
            if (ep == null) continue;
            dep = new DynamicEndpoint(ep, id, reference);
            break;
        }
        return dep;
    }

    void setComponentManager(ComponentManager compMgr) {
        this.mComponentManager = compMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegisteredEndpoint matchConsumerAndProvider(String consumerId, RegisteredEndpoint[] endpoints, MessageExchangeProxy exchange) throws MessagingException {
        RegisteredEndpoint match = null;
        Component consumer = this.mComponentManager.getComponentInstance(consumerId);
        if (endpoints.length == 1) {
            match = endpoints[0];
        } else {
            try {
                for (int i = 0; i < endpoints.length; ++i) {
                    Component provider = this.mComponentManager.getComponentInstance(endpoints[i].getOwnerId());
                    exchange.beforeCapabilityCheck(endpoints[i]);
                    if (!consumer.isExchangeWithProviderOkay((ServiceEndpoint)endpoints[i], (javax.jbi.messaging.MessageExchange)exchange) || !provider.isExchangeWithConsumerOkay((ServiceEndpoint)endpoints[i], (javax.jbi.messaging.MessageExchange)exchange)) continue;
                    match = endpoints[i];
                    break;
                }
            }
            finally {
                exchange.afterCapabilityCheck();
            }
        }
        if (match == null) {
            throw new MessagingException(Translator.translate("CAPABILITY_NO_MATCH"));
        }
        return match;
    }

    public int getActiveChannelCount() {
        return this.mChannels.size();
    }

    public String[] getActiveChannels() {
        return this.mChannels.keySet().toArray(new String[0]);
    }

    public int getActiveEndpointCount() {
        return this.mRegistry.countEndpoints(20);
    }

    public String[][] getActiveEndpoints() {
        ServiceEndpoint[] endpoints = this.mRegistry.listEndpoints(20);
        String[][] list = new String[endpoints.length][2];
        for (int i = 0; i < list.length; ++i) {
            list[i][0] = endpoints[i].getServiceName().toString();
            list[i][1] = endpoints[i].getEndpointName();
        }
        return list;
    }

    public String[][] getActiveEndpoints(String ownerId) {
        DeliveryChannelImpl dc = this.getChannel(ownerId);
        ServiceEndpoint[] endpoints = dc.getEndpoints();
        String[][] list = new String[endpoints.length][2];
        for (int i = 0; i < list.length; ++i) {
            list[i][1] = endpoints[i].getServiceName().toString();
            list[i][2] = endpoints[i].getEndpointName();
        }
        return list;
    }

    public String getDescriptor(String service, String endpoint) {
        String descStr = null;
        RegisteredEndpoint re = this.mRegistry.getInternalEndpoint(new QName(service), endpoint);
        try {
            Document desc = this.queryDescriptor(re);
            if (desc != null) {
                descStr = XMLUtil.getInstance().asString(desc);
            }
        }
        catch (MessagingException msgEx) {
            this.mLog.warning(msgEx.getMessage());
        }
        return descStr;
    }

    public void dumpState() {
        this.mLog.info(this.toString());
    }

    void setEndpointListener(EndpointListener listener) {
        this.mListener = listener;
    }

    void setTimeoutListener(DeliveryChannel dc, TimeoutListener timeout) {
        this.mTimeout = timeout;
        this.mTimeoutDC = dc;
    }

    void setExchangeIdGenerator(ExchangeIdGenerator generator) {
        this.mGenerator = generator;
    }

    String generateNextId() {
        return this.mGenerator.nextId();
    }

    boolean isExchangeOkay(MessageExchange me) {
        Component provider = this.mComponentManager.getComponentInstance(((RegisteredEndpoint)me.getEndpoint()).getOwnerId());
        return provider.isExchangeWithConsumerOkay(me.getEndpoint(), (javax.jbi.messaging.MessageExchange)me);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nMessage Service Status\n");
        sb.append("  Delivery Channel Count: ");
        sb.append(this.mChannels.size());
        sb.append("\n");
        Iterator i = this.mChannels.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
        }
        sb.append(this.mRegistry.toString());
        return sb.toString();
    }
}

