/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry.xml;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ServiceAssemblyInfo;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.ServiceAssemblyState;
import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.descriptor.ServiceAssemblyDescriptor;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.data.ServiceAssemblyInfoImpl;
import com.sun.jbi.management.registry.data.ServiceUnitInfoImpl;
import com.sun.jbi.management.registry.xml.ComponentQueryImpl;
import com.sun.jbi.management.registry.xml.GenericQueryImpl;
import com.sun.jbi.management.registry.xml.InstalledComponentsListType;
import com.sun.jbi.management.registry.xml.Jbi;
import com.sun.jbi.management.registry.xml.ObjectFactory;
import com.sun.jbi.management.registry.xml.ServiceAssemblyRefType;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.JBIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyQueryImpl
implements ServiceAssemblyQuery {
    private Jbi mJbiRegistry;
    private Registry mRegistry;
    private boolean mValidate;
    private ManagementContext mMgtCtx;
    private Logger mLogger;
    private StringTranslator mTranslator;
    private GenericQueryImpl mGenQuery;
    private ObjectFactory mObjectFactory;
    private String mTarget;
    private ComponentQueryImpl mComponentQuery;
    private static final String DOMAIN = "domain";

    public ServiceAssemblyQueryImpl(Jbi jbi, ManagementContext mgtCtx, boolean validate, String targetName, Registry registry) throws RegistryException {
        this.mTarget = targetName;
        this.mJbiRegistry = jbi;
        this.mRegistry = registry;
        this.mValidate = validate;
        this.mMgtCtx = mgtCtx;
        ServiceAssemblyQueryImpl serviceAssemblyQueryImpl = this;
        this.mLogger = serviceAssemblyQueryImpl.mMgtCtx.getLogger();
        ServiceAssemblyQueryImpl serviceAssemblyQueryImpl2 = this;
        this.mTranslator = serviceAssemblyQueryImpl2.mMgtCtx.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        this.mGenQuery = (GenericQueryImpl)this.mRegistry.getGenericQuery();
        this.mComponentQuery = (ComponentQueryImpl)this.mRegistry.getComponentQuery(this.mTarget);
        this.mObjectFactory = new ObjectFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServiceAssemblies() {
        List<String> serviceAssemblies = new ArrayList<String>();
        try {
            if (this.mTarget.equals(DOMAIN)) {
                serviceAssemblies = this.mGenQuery.getRegisteredServiceAssemblies();
            }
            InstalledComponentsListType target = null;
            target = this.mGenQuery.getInstalledEntities(this.mTarget);
            List<ServiceAssemblyRefType> saRefs = target.getServiceAssemblyRef();
            for (ServiceAssemblyRefType saRef : saRefs) {
                String saName = saRef.getNameRef();
                serviceAssemblies.add(saName);
            }
        }
        catch (RegistryException rex) {
            this.mLogger.warning(rex.getMessage());
        }
        finally {
            return serviceAssemblies;
        }
    }

    @Override
    public ServiceAssemblyInfo getServiceAssemblyInfo(String serviceAssemblyName) {
        try {
            if (this.mGenQuery.isServiceAssemblyRegistered(serviceAssemblyName)) {
                this.mLogger.finest("Getting Service Assembly " + serviceAssemblyName + " on target " + this.mTarget);
                ServiceAssemblyInfoImpl saInfo = new ServiceAssemblyInfoImpl();
                saInfo.setName(serviceAssemblyName);
                com.sun.jbi.management.descriptor.Jbi jbi = this.mGenQuery.getServiceAssemblyJbi(serviceAssemblyName);
                if (jbi == null) {
                    return saInfo;
                }
                ServiceAssemblyDescriptor descr = new ServiceAssemblyDescriptor(jbi);
                saInfo.setDescription(descr.getDescription());
                ArrayList<ServiceUnitInfo> resultSus = new ArrayList<ServiceUnitInfo>();
                if (this.mTarget != DOMAIN) {
                    List<ServiceUnitInfo> suList = descr.getServiceUnits();
                    ArrayList<ServiceUnitState> suStates = new ArrayList<ServiceUnitState>();
                    for (ServiceUnitInfo su : suList) {
                        ComponentInfo compInfo = this.mComponentQuery.getComponentInfo(su.getTargetComponent());
                        if (compInfo == null) continue;
                        List<ServiceUnitInfo> compSus = compInfo.getServiceUnitList();
                        for (ServiceUnitInfo suInfo : compSus) {
                            if (!suInfo.getName().equals(su.getName()) || !suInfo.getServiceAssemblyName().equals(serviceAssemblyName)) continue;
                            resultSus.add(suInfo);
                            suStates.add(suInfo.getState());
                        }
                    }
                    if (!suStates.isEmpty()) {
                        ServiceAssemblyState saState = ServiceAssemblyState.computeServiceAssemblyState(suStates);
                        saInfo.setStatus(saState);
                    } else {
                        ServiceAssemblyRefType saRef = this.mGenQuery.getServiceAssembly(serviceAssemblyName, this.mTarget);
                        if (saRef != null && saRef.getState() != null) {
                            saInfo.setStatus(ServiceAssemblyState.valueOfDeploymentServiceState(saRef.getState().value()));
                        } else {
                            saInfo.setStatus(ServiceAssemblyState.UNKNOWN);
                        }
                    }
                } else {
                    List<ServiceUnitInfo> suList = descr.getServiceUnits();
                    for (ServiceUnitInfo su : suList) {
                        ServiceUnitInfoImpl suInfo = (ServiceUnitInfoImpl)su;
                        String suRelPath = serviceAssemblyName + File.separator + su.getName();
                        String suArchiveDir = this.mRegistry.getRepository().findArchiveDirectory(ArchiveType.SERVICE_UNIT, suRelPath);
                        String filePath = suArchiveDir + File.separator + su.getTargetComponent();
                        suInfo.setFilePath(filePath);
                        resultSus.add(suInfo);
                    }
                    List<ServiceAssemblyState> saStates = this.getAllServiceAssemblyStates(serviceAssemblyName);
                    saInfo.setStatus(ServiceAssemblyState.getEffectiveServiceAssemblyState(saStates));
                }
                saInfo.setServiceUnitList(resultSus);
                return saInfo;
            }
            this.mLogger.finest("Service Assembly " + serviceAssemblyName + " not registered in domain");
        }
        catch (Exception rex) {
            rex.printStackTrace();
            this.mLogger.severe(rex.getMessage());
        }
        return null;
    }

    @Override
    public ServiceAssemblyState getStatus(String serviceAssemblyName) throws JBIException {
        return this.getServiceAssemblyInfo(serviceAssemblyName).getStatus();
    }

    private List<ServiceAssemblyState> getAllServiceAssemblyStates(String saName) throws RegistryException {
        ServiceAssemblyState saState;
        List<String> servers = this.mGenQuery.getServers();
        List<String> clusters = this.mGenQuery.getClusters();
        ArrayList<ServiceAssemblyState> saStates = new ArrayList<ServiceAssemblyState>();
        for (String server : servers) {
            saState = this.getServiceAssemblyStateOnTarget(saName, server);
            if (ServiceAssemblyState.UNKNOWN == saState) continue;
            saStates.add(saState);
        }
        for (String cluster : clusters) {
            saState = this.getServiceAssemblyStateOnTarget(saName, cluster);
            if (ServiceAssemblyState.UNKNOWN == saState) continue;
            saStates.add(saState);
        }
        return saStates;
    }

    private ServiceAssemblyState getServiceAssemblyStateOnTarget(String saName, String target) throws RegistryException {
        ServiceAssemblyQuery saQuery = this.mRegistry.getServiceAssemblyQuery(target);
        ServiceAssemblyInfo saInfo = saQuery.getServiceAssemblyInfo(saName);
        if (saInfo != null) {
            return saInfo.getStatus();
        }
        return ServiceAssemblyState.UNKNOWN;
    }
}

