/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.descriptor;

import com.sun.jbi.ServiceUnitInfo;
import com.sun.jbi.ServiceUnitState;
import com.sun.jbi.management.descriptor.Jbi;
import com.sun.jbi.management.descriptor.ServiceAssembly;
import com.sun.jbi.management.descriptor.ServiceUnit;
import com.sun.jbi.management.registry.data.ServiceUnitInfoImpl;
import com.sun.jbi.management.util.StringHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyDescriptor {
    private ServiceAssembly mSaType;

    public ServiceAssemblyDescriptor(Jbi jbi) throws IllegalArgumentException {
        this.mSaType = jbi.getServiceAssembly();
        if (this.mSaType == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getName() {
        if (this.mSaType.getIdentification() != null) {
            return StringHelper.trim(this.mSaType.getIdentification().getName());
        }
        return "";
    }

    public String getDescription() {
        if (this.mSaType.getIdentification() != null) {
            return StringHelper.trim(this.mSaType.getIdentification().getDescription());
        }
        return "";
    }

    public List<ServiceUnitInfo> getServiceUnits() {
        ArrayList<ServiceUnitInfo> resultSus = new ArrayList<ServiceUnitInfo>();
        List<ServiceUnit> suList = this.mSaType.getServiceUnit();
        for (ServiceUnit su : suList) {
            ServiceUnitInfoImpl suInfo = new ServiceUnitInfoImpl();
            suInfo.setServiceAssemblyName(this.getName());
            suInfo.setName(StringHelper.trim(su.getIdentification().getName()));
            suInfo.setTargetComponent(StringHelper.trim(su.getTarget().getComponentName()));
            suInfo.setState(ServiceUnitState.UNKNOWN);
            resultSus.add(suInfo);
        }
        return resultSus;
    }
}

