/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.ComponentManager;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.JBIProvider;
import com.sun.jbi.ServiceUnitRegistration;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.VersionInfo;
import com.sun.jbi.framework.ClassLoaderFactory;
import com.sun.jbi.framework.ComponentFramework;
import com.sun.jbi.framework.ComponentRegistry;
import com.sun.jbi.framework.FrameworkStatistics;
import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.ManagementMessageFactory;
import com.sun.jbi.management.common.LoggerMBean;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.facade.ManagementRuntimeService;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryBuilder;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.RegistrySpecImpl;
import com.sun.jbi.management.registry.RegistryType;
import com.sun.jbi.management.registry.xml.UpdaterImpl;
import com.sun.jbi.management.support.DefaultLoggerMBeanImpl;
import com.sun.jbi.management.support.MBeanHelper;
import com.sun.jbi.management.support.MBeanNamesImpl;
import com.sun.jbi.management.system.ConfigurationService;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementMessageFactoryImpl;
import com.sun.jbi.management.system.ManagementService;
import com.sun.jbi.messaging.ConnectionManager;
import com.sun.jbi.messaging.MessageService;
import com.sun.jbi.monitoring.FrameworkStatisticsMBean;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.util.EnvironmentAccess;
import com.sun.jbi.wsdl2.WsdlException;
import com.sun.jbi.wsdl2.WsdlFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class EnvironmentContext
implements com.sun.jbi.EnvironmentContext {
    private static final String NOT_YET_CREATED = "The Environment Context has not yet been created.";
    private static final String JBI_DEFAULT_LOG_LEVEL_VALUE = "INFO";
    private static final String JBI_DEFAULT_LOG_LEVEL_KEY = "com.sun.jbi.defaultLogLevel";
    private static final String JBI_INSTANCE_NAME_KEY = "com.sun.jbi.framework.JBIFramework.JbiName";
    private static final String JBI_ROOT = "jbi";
    private static final String JMX_DOMAIN_NAME = "com.sun.jbi";
    private static final String CONFIG_PATH = "/system/private/config";
    private static final String PROPERTY_NOT_FOUND = "PROPERTY_NOT_FOUND";
    private static EnvironmentContext sEnvironmentContext;
    private PlatformContext mPlatformContext;
    private String mAppServerInstallRoot;
    private String mAppServerInstanceRoot;
    private ComponentFramework mComponentFramework;
    private ComponentRegistry mComponentRegistry;
    private Registry mRegistry;
    private Level mDefaultLogLevel;
    private FrameworkStatistics mFrameworkStatistics;
    private Properties mInitialProperties;
    private String mJbiInstallRoot;
    private String mJbiInstanceRoot;
    private Logger mJbiLog;
    private Logger mLog;
    private static ObjectName sJbiLogMBeanName;
    private static ObjectName sLogMBeanName;
    private static ObjectName sStatsMBeanName;
    private ManagementService mManagementService;
    private ConfigurationService mConfigService;
    private ManagementMessageFactory mMFactory;
    private com.sun.jbi.management.MBeanHelper mMBeanHelper;
    private MBeanNames mMBeanNames;
    private VersionInfo mVersionInfo;
    private MBeanServer mMBeanServer;
    private InitialContext mNamingContext;
    private MessageService mNormalizedMessageService;
    private HashMap mStringTranslators;
    private ManagementRuntimeService mMgmtRuntimeService;
    private com.sun.jbi.framework.StringTranslator mTranslator;
    private TransactionManager mTransactionManager;
    private boolean mTransactionManagerUnavailable;
    private JBIProvider mProvider;
    private String mNamingPrefix;
    private JBIFramework mFramework;
    private Document mRegistryDocument;

    EnvironmentContext(PlatformContext platform, JBIFramework framework, Properties initialProperties) throws JBIException {
        sEnvironmentContext = this;
        EnvironmentAccess.setContext(this);
        this.mFrameworkStatistics = new FrameworkStatistics();
        this.mFramework = framework;
        this.mProvider = platform.getProvider();
        this.mPlatformContext = platform;
        this.mInitialProperties = initialProperties;
        String pkgName = this.getClass().getPackage().getName();
        this.mStringTranslators = new HashMap();
        this.mTranslator = new com.sun.jbi.framework.StringTranslator(pkgName, null);
        this.mStringTranslators.put(pkgName, this.mTranslator);
        this.createLogger(pkgName);
        this.mAppServerInstallRoot = platform.getInstallRoot();
        this.mAppServerInstanceRoot = platform.getInstanceRoot();
        this.mJbiInstallRoot = initialProperties.getProperty("com.sun.jbi.home") != null ? initialProperties.getProperty("com.sun.jbi.home") : this.mAppServerInstallRoot + File.separator + JBI_ROOT;
        this.mJbiInstanceRoot = this.mAppServerInstanceRoot + File.separator + JBI_ROOT;
        File dummyFile = new File(this.mJbiInstanceRoot);
        try {
            this.mJbiInstanceRoot = dummyFile.getCanonicalPath();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        this.mJbiInstanceRoot = this.mJbiInstanceRoot.replace('\\', '/');
        System.setProperty("com.sun.jbi.platform.installRoot", this.mAppServerInstallRoot);
        System.setProperty("com.sun.jbi.platform.instanceRoot", this.mAppServerInstanceRoot);
        this.mMBeanServer = platform.getMBeanServer();
        this.mMBeanNames = new MBeanNamesImpl(JMX_DOMAIN_NAME, platform.getInstanceName());
        this.mMBeanHelper = new MBeanHelper(this.mMBeanServer, this.mMBeanNames, this.mLog);
        this.createMBeans();
        this.mVersionInfo = new com.sun.jbi.management.VersionInfo();
        this.mLog.fine("JBI instance root set to " + this.mJbiInstanceRoot);
        if (null != this.mInitialProperties) {
            this.mLog.fine("Initial properties are:");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.mInitialProperties.list(new PrintWriter(bos));
            this.mLog.fine(this.mTranslator.getString("EC_INITIAL_PROPERTIES_LIST", bos));
        }
        this.mComponentFramework = new ComponentFramework();
        this.mComponentRegistry = new ComponentRegistry();
        this.mConfigService = new ConfigurationService();
        this.mManagementService = new ManagementService();
        this.mMFactory = new ManagementMessageFactoryImpl();
        this.mNormalizedMessageService = new MessageService();
        this.mMgmtRuntimeService = new ManagementRuntimeService();
    }

    void destroyInstance() {
        if (null != sJbiLogMBeanName) {
            this.unregisterMBean(sJbiLogMBeanName);
        }
        if (null != sLogMBeanName) {
            this.unregisterMBean(sLogMBeanName);
        }
        if (null != sStatsMBeanName) {
            this.unregisterMBean(sStatsMBeanName);
        }
        sEnvironmentContext = null;
    }

    public static EnvironmentContext getInstance() {
        if (null == sEnvironmentContext) {
            throw new IllegalStateException(NOT_YET_CREATED);
        }
        return sEnvironmentContext;
    }

    ComponentFramework getComponentFramework() {
        return this.mComponentFramework;
    }

    ComponentRegistry getComponentRegistry() {
        return this.mComponentRegistry;
    }

    FrameworkStatistics getFrameworkStatistics() {
        return this.mFrameworkStatistics;
    }

    Logger getJbiLogger() {
        return this.mJbiLog;
    }

    Logger getLogger() {
        return this.mLog;
    }

    long getComponentTimeout() {
        long componentTimeout = 0L;
        Object value = this.getConfigurationAttribute(ConfigurationCategory.Installation, "componentTimeout");
        if (value != null) {
            componentTimeout = ((Integer)value).intValue();
        }
        return componentTimeout;
    }

    long getDeploymentTimeout() {
        long deploymentTimeout = 0L;
        Object value = this.getConfigurationAttribute(ConfigurationCategory.Deployment, "deploymentTimeout");
        if (value != null) {
            deploymentTimeout = ((Integer)value).intValue();
        }
        return deploymentTimeout;
    }

    long getInstallationTimeout() {
        long installationTimeout = 0L;
        Object value = this.getConfigurationAttribute(ConfigurationCategory.Installation, "installationTimeout");
        if (value != null) {
            installationTimeout = ((Integer)value).intValue();
        }
        return installationTimeout;
    }

    long getServiceUnitTimeout() {
        long serviceUnitTimeout = 0L;
        Object value = this.getConfigurationAttribute(ConfigurationCategory.Deployment, "serviceUnitTimeout");
        if (value != null) {
            serviceUnitTimeout = ((Integer)value).intValue();
        }
        return serviceUnitTimeout;
    }

    void setAppServerInstanceRoot(String instanceRoot) {
        this.mAppServerInstanceRoot = instanceRoot;
    }

    void setComponentTimeout(long timeout) {
        this.setConfigurationAttribute(ConfigurationCategory.Installation, "componentTimeout", new Long(timeout));
    }

    void setDeploymentTimeout(long timeout) {
        this.setConfigurationAttribute(ConfigurationCategory.Deployment, "deploymentTimeout", new Long(timeout));
    }

    void setInstallationTimeout(long timeout) {
        this.setConfigurationAttribute(ConfigurationCategory.Installation, "installationTimeout", new Long(timeout));
    }

    void setServiceUnitTimeout(long timeout) {
        this.setConfigurationAttribute(ConfigurationCategory.Deployment, "serviceUnitTimeout", new Long(timeout));
    }

    void setJbiInstallRoot(String installRoot) {
        this.mJbiInstallRoot = installRoot;
    }

    void setJbiInstanceRoot(String instanceRoot) {
        this.mJbiInstanceRoot = instanceRoot;
    }

    void setNamingContext(InitialContext namingContext) {
        this.mNamingContext = namingContext;
    }

    void setNamingPrefix(String prefix) {
        this.mNamingPrefix = prefix;
    }

    void setPlatformContext(PlatformContext platform) {
        this.mPlatformContext = platform;
    }

    public String getAppServerInstallRoot() {
        return this.mAppServerInstallRoot;
    }

    public String getAppServerInstanceRoot() {
        return this.mAppServerInstanceRoot;
    }

    public ComponentManager getComponentManager() {
        return this.mComponentFramework;
    }

    public ComponentQuery getComponentQuery() {
        try {
            return ((Registry)this.getRegistry()).getComponentQuery();
        }
        catch (RegistryException rex) {
            this.mLog.warning(rex.getMessage());
            return null;
        }
    }

    public ComponentQuery getComponentQuery(String targetName) {
        try {
            return ((Registry)this.getRegistry()).getComponentQuery(targetName);
        }
        catch (RegistryException rex) {
            this.mLog.warning(rex.getMessage());
            return null;
        }
    }

    public PlatformContext getPlatformContext() {
        return this.mPlatformContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.sun.jbi.registry.Registry getRegistry() {
        boolean checkFramework = false;
        EnvironmentContext environmentContext = this;
        synchronized (environmentContext) {
            if (this.mRegistry == null) {
                this.getJustRegistry();
                checkFramework = true;
            }
        }
        if (checkFramework) {
            this.mFramework.frameworkReady();
        }
        return this.mRegistry;
    }

    public com.sun.jbi.registry.Registry getJustRegistry() {
        if (this.mRegistry == null) {
            Properties props = new Properties();
            props.setProperty("com.sun.jbi.registry.folder", this.getJbiInstanceRoot() + File.separator + "config");
            ManagementContext mgmtCtx = new ManagementContext(this);
            try {
                this.mRegistry = RegistryBuilder.buildRegistry(new RegistrySpecImpl(RegistryType.XML, props, mgmtCtx));
                ((UpdaterImpl)this.mRegistry.getUpdater()).correctTimestamps();
            }
            catch (RegistryException rEx) {
                String errMsg = this.mTranslator.getString("EC_JBI_REGISTRY_INIT_FAILED", rEx.getMessage());
                this.mLog.warning(rEx.getMessage());
                throw new RuntimeException(errMsg, (Throwable)((Object)rEx));
            }
            this.mLog.fine("JBIEnvironmentContext: Create the registry...");
        }
        return this.mRegistry;
    }

    void setRegistry(Registry registry) {
        this.mRegistry = registry;
    }

    public Document getReadOnlyRegistry() {
        if (this.mRegistryDocument == null) {
            try {
                File registryFile = new File(this.getJbiInstanceRoot() + "/config/jbi-registry.xml");
                if (registryFile.canRead()) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    this.mRegistryDocument = db.parse(registryFile);
                }
            }
            catch (Exception ex) {
                this.mLog.warning(ex.getMessage());
            }
        }
        return this.mRegistryDocument;
    }

    public boolean isFrameworkReady(boolean start) {
        if (start) {
            this.mFramework.frameworkReady();
        }
        return this.mFramework.isFrameworkReady();
    }

    public ConnectionManager getConnectionManager() {
        return this.mNormalizedMessageService.getConnectionManager();
    }

    public Level getDefaultLogLevel() {
        return this.mDefaultLogLevel;
    }

    public Properties getInitialProperties() {
        return this.mInitialProperties;
    }

    public String getJbiInstallRoot() {
        return this.mJbiInstallRoot;
    }

    public String getJbiInstanceRoot() {
        return this.mJbiInstanceRoot;
    }

    public Object getManagementClass(String aServiceName) {
        if (aServiceName.equals("MessageService")) {
            return this.mNormalizedMessageService;
        }
        return null;
    }

    public ManagementMessageFactory getManagementMessageFactory() {
        return this.mMFactory;
    }

    public ManagementService getManagementService() {
        return this.mManagementService;
    }

    public ConfigurationService getConfigurationService() {
        return this.mConfigService;
    }

    public com.sun.jbi.management.MBeanHelper getMBeanHelper() {
        return this.mMBeanHelper;
    }

    public MBeanNames getMBeanNames() {
        return this.mMBeanNames;
    }

    public MBeanServer getMBeanServer() {
        return this.mMBeanServer;
    }

    public InitialContext getNamingContext() {
        return this.mNamingContext;
    }

    public String getNamingPrefix() {
        return this.mNamingPrefix;
    }

    public MessageService getNormalizedMessageService() {
        return this.mNormalizedMessageService;
    }

    public JBIProvider getProvider() {
        return this.mProvider;
    }

    public ServiceUnitRegistration getServiceUnitRegistration() {
        return this.mComponentRegistry;
    }

    public StringTranslator getStringTranslator(String packageName) {
        com.sun.jbi.framework.StringTranslator translator = (com.sun.jbi.framework.StringTranslator)this.mStringTranslators.get(packageName);
        if (null == translator) {
            translator = new com.sun.jbi.framework.StringTranslator(packageName, null);
            this.mStringTranslators.put(packageName, translator);
            this.mLog.finer("StringTranslator created for package " + packageName);
        }
        return translator;
    }

    public StringTranslator getStringTranslator(String packageName, String componentId) {
        ClassLoader cl = null;
        com.sun.jbi.framework.StringTranslator translator = (com.sun.jbi.framework.StringTranslator)this.mStringTranslators.get(packageName);
        if (null == translator) {
            try {
                cl = ClassLoaderFactory.getInstance().getComponentClassLoader(componentId);
            }
            catch (JBIException ex) {
                this.mLog.severe(this.mTranslator.getString("EC_STRING_TRANSLATOR_CLASSLOADER_NOT_FOUND", componentId, packageName, ex.getMessage()));
            }
            translator = new com.sun.jbi.framework.StringTranslator(packageName, cl);
            this.mStringTranslators.put(packageName, translator);
        }
        return translator;
    }

    public StringTranslator getStringTranslatorFor(Object object) {
        return this.getStringTranslator(object.getClass().getPackage().getName());
    }

    public ManagementRuntimeService getMgmtRuntimeService() {
        return this.mMgmtRuntimeService;
    }

    public TransactionManager getTransactionManager() {
        if (null == this.mTransactionManager && !this.mTransactionManagerUnavailable) {
            try {
                this.mTransactionManager = this.mPlatformContext.getTransactionManager();
            }
            catch (Exception ex) {
                this.mTransactionManagerUnavailable = true;
                this.mLog.severe(this.mTranslator.getString("EC_TRANSACTION_MANAGER_NOT_FOUND", ex.getClass().getName()));
                this.mLog.severe(this.mTranslator.stackTraceToString(ex));
            }
        }
        return this.mTransactionManager;
    }

    public VersionInfo getVersionInfo() {
        return this.mVersionInfo;
    }

    public WsdlFactory getWsdlFactory() throws WsdlException {
        return com.sun.jbi.wsdl2.impl.WsdlFactory.newInstance();
    }

    private void createLogger(String pkgName) {
        this.mJbiLog = Logger.getLogger(JMX_DOMAIN_NAME);
        this.mLog = Logger.getLogger(pkgName);
        if (null == this.mJbiLog.getLevel()) {
            String logLevelString = null;
            logLevelString = null != this.mInitialProperties ? this.mInitialProperties.getProperty(JBI_DEFAULT_LOG_LEVEL_KEY, JBI_DEFAULT_LOG_LEVEL_VALUE) : JBI_DEFAULT_LOG_LEVEL_VALUE;
            try {
                this.mDefaultLogLevel = Level.parse(logLevelString);
            }
            catch (Exception e) {
                this.mLog.warning(this.mTranslator.getString("EC_INVALID_LOG_LEVEL", logLevelString, Level.INFO.getName()));
                this.mDefaultLogLevel = Level.INFO;
            }
            this.mJbiLog.setLevel(this.mDefaultLogLevel);
        } else {
            this.mDefaultLogLevel = this.mJbiLog.getLevel();
        }
        System.setProperty(JBI_DEFAULT_LOG_LEVEL_KEY, this.mDefaultLogLevel.getName());
    }

    private void createMBeans() {
        DefaultLoggerMBeanImpl logMBean;
        try {
            logMBean = new DefaultLoggerMBeanImpl(this.mJbiLog, "JBI default");
            sJbiLogMBeanName = this.registerMBean(logMBean, LoggerMBean.class, "Logger", "JBI", this.mJbiLog);
        }
        catch (JBIException ex) {
            this.mLog.severe(ex.getMessage());
            this.mLog.warning(this.mTranslator.getString("EC_NO_LOGGER_MBEAN"));
        }
        try {
            logMBean = new DefaultLoggerMBeanImpl(this.mLog, "Framework");
            sLogMBeanName = this.registerMBean(logMBean, LoggerMBean.class, "Logger", "Framework", this.mLog);
        }
        catch (JBIException ex) {
            this.mLog.severe(ex.getMessage());
            this.mLog.warning(this.mTranslator.getString("EC_NO_LOGGER_MBEAN"));
        }
        try {
            sStatsMBeanName = this.registerMBean(this.mFrameworkStatistics, FrameworkStatisticsMBean.class, "Statistics");
        }
        catch (JBIException ex) {
            this.mLog.severe(ex.getMessage());
            this.mLog.warning(this.mTranslator.getString("EC_NO_STATISTICS_MBEAN"));
        }
    }

    private ObjectName registerMBean(Object instance, Class interfaceClass, String mbeanType) throws JBIException {
        return this.registerMBean(instance, interfaceClass, mbeanType, null, null);
    }

    private ObjectName registerMBean(Object instance, Class interfaceClass, String mbeanType, String service, Logger logger) throws JBIException {
        if (null == this.getMBeanServer()) {
            return null;
        }
        this.mLog.finer("Registering framework " + mbeanType + " MBean");
        StandardMBean mbean = null;
        try {
            mbean = new StandardMBean(instance, interfaceClass);
        }
        catch (NotCompliantMBeanException ncEx) {
            String exName = ncEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("EC_MBEAN_CREATION_FAILED", exName), (Throwable)ncEx);
        }
        ObjectName mbeanName = null;
        mbeanName = "Logger" == mbeanType ? this.mMBeanNames.getSystemServiceLoggerMBeanName(service, logger) : this.mMBeanNames.getSystemServiceMBeanName("Framework", mbeanType);
        if (null == mbeanName) {
            String msg = this.mTranslator.getString("EC_MBEAN_NAME_CREATION_FAILED", "Framework", mbeanType);
            throw new JBIException(msg);
        }
        try {
            if (this.getMBeanServer().isRegistered(mbeanName)) {
                try {
                    this.getMBeanServer().unregisterMBean(mbeanName);
                }
                catch (InstanceNotFoundException infEx) {
                    // empty catch block
                }
            }
            this.getMBeanServer().registerMBean(mbean, mbeanName);
        }
        catch (InstanceAlreadyExistsException iaeEx) {
            String exName = iaeEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("EC_MBEAN_REGISTRATION_FAILED", exName), (Throwable)iaeEx);
        }
        catch (MBeanRegistrationException mbrEx) {
            String exName = mbrEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("EC_MBEAN_REGISTRATION_FAILED", exName), (Throwable)mbrEx);
        }
        catch (NotCompliantMBeanException ncEx) {
            String exName = ncEx.getClass().getName();
            throw new JBIException(this.mTranslator.getString("EC_MBEAN_REGISTRATION_FAILED", exName), (Throwable)ncEx);
        }
        return mbeanName;
    }

    private void unregisterMBean(ObjectName mbeanName) {
        if (null == this.getMBeanServer()) {
            return;
        }
        this.mLog.finer("Unregistering framework MBean: " + mbeanName);
        if (this.getMBeanServer().isRegistered(mbeanName)) {
            try {
                this.getMBeanServer().unregisterMBean(mbeanName);
            }
            catch (InstanceNotFoundException infEx) {
            }
            catch (MBeanRegistrationException mbrEx) {
                String exName = mbrEx.getClass().getName();
                this.mLog.warning(this.mTranslator.getString("EC_MBEAN_UNREGISTRATION_FAILED", mbeanName, exName));
            }
        }
    }

    public boolean isStartOnDeployEnabled() {
        boolean startOnDeploy = true;
        Object value = this.getConfigurationAttribute(ConfigurationCategory.Deployment, "startOnDeploy");
        if (value != null) {
            startOnDeploy = (Boolean)value;
        }
        return startOnDeploy;
    }

    private Object getConfigurationAttribute(ConfigurationCategory category, String attrName) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(category.toString());
        ObjectName configMBeanName = this.mMBeanNames.getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        Object attrValue = null;
        try {
            if (this.mMBeanServer.isRegistered(configMBeanName)) {
                attrValue = this.mMBeanServer.getAttribute(configMBeanName, attrName);
            }
        }
        catch (JMException jmex) {
            this.mLog.warning(jmex.getMessage());
        }
        return attrValue;
    }

    private void setConfigurationAttribute(ConfigurationCategory category, String attrName, Object attrValue) {
        MBeanNames.ServiceType svcType = MBeanNames.ServiceType.valueOf(category.toString());
        ObjectName configMBeanName = this.getMBeanNames().getSystemServiceMBeanName("ConfigurationService", ConfigurationBuilder.getControlType(svcType));
        try {
            Attribute attribute = new Attribute(attrName, attrValue);
            this.mMBeanServer.setAttribute(configMBeanName, attribute);
        }
        catch (JMException jmex) {
            this.mLog.warning(jmex.getMessage());
        }
    }
}

