/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIManagementMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ESBResultFormatter {
    public static final int TOP_MSG_FORMAT = 0;
    public static final int CAS_MSG_FORMAT = 1;
    public static final int INST_MSG_FORMAT = 2;
    public static final int COMP_MSG_FORMAT = 3;
    public static final String FAILED = "FAILED";
    public static final String SUCCESS = "SUCCESS";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String EXCEPTION = "EXCEPTION";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String INSTANCE_MARKER_ID = "JBI_INSTANCE_NAME";
    public static final String CAS_KEY = "";
    public static final String OUT_NORMAL = "normal";
    public static final String OUT_VERBOSE = "terse";
    public static final String OUT_DEBUG = "verbose";
    private String mOutLevel = "terse";
    private static I18NBundle sI18NBundle = null;

    public ESBResultFormatter() {
        this.mOutLevel = OUT_VERBOSE;
    }

    public ESBResultFormatter(String outLevel) {
        this.mOutLevel = outLevel;
    }

    public static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.common");
        }
        return sI18NBundle;
    }

    protected String getL10NMessage(String code, String msg) {
        return ESBResultFormatter.getI18NBundle().getMessage("esb.result.msg.format", code, msg);
    }

    protected String getL10NExptionMessage(String code, String msg) {
        String formattedMsg = this.getL10NMessage(code, msg);
        return ESBResultFormatter.getI18NBundle().getMessage("esb.result.ex.msg.format", formattedMsg);
    }

    protected String getL10NMessageType(String msgType) {
        String l10nMsgType = null;
        l10nMsgType = ERROR.equalsIgnoreCase(msgType) ? ESBResultFormatter.getI18NBundle().getMessage("esb.result.type.error") : (WARNING.equalsIgnoreCase(msgType) ? ESBResultFormatter.getI18NBundle().getMessage("esb.result.type.warning") : (INFO.equalsIgnoreCase(msgType) ? ESBResultFormatter.getI18NBundle().getMessage("esb.result.type.info") : ESBResultFormatter.getI18NBundle().getMessage("esb.result.type.unknown")));
        return l10nMsgType;
    }

    protected String getL10NMainMessage(String msgType, String code, String msg) {
        String formattedMsg = this.getL10NMessage(code, msg);
        String l10nType = this.getL10NMessageType(msgType);
        return ESBResultFormatter.getI18NBundle().getMessage("esb.result.1st.msg.format", l10nType, formattedMsg);
    }

    protected String getMainMessageI18NKey(int formatType) {
        switch (formatType) {
            case 1: {
                return "esb.result.cas.msg";
            }
            case 2: {
                return "esb.result.inst.msg";
            }
            case 3: {
                return "esb.result.comp.msg";
            }
        }
        return "esb.result.cas.msg";
    }

    protected String get2ndMessageI18NKey(int formatType) {
        switch (formatType) {
            case 1: {
                return "esb.result.cas.2nd.msg";
            }
            case 2: {
                return "esb.result.inst.2nd.msg";
            }
            case 3: {
                return "esb.result.comp.2nd.msg";
            }
        }
        return "esb.result.cas.2nd.msg";
    }

    protected String getExceptionMsgI18NKey(int formatType) {
        switch (formatType) {
            case 1: {
                return "esb.result.cas.ex.msg";
            }
            case 2: {
                return "esb.result.inst.ex.msg";
            }
            case 3: {
                return "esb.result.comp.ex.msg";
            }
        }
        return "esb.result.cas.ex.msg";
    }

    protected String get2ndExceptionMsgI18NKey(int formatType) {
        switch (formatType) {
            case 1: {
                return "esb.result.cas.2nd.ex.msg";
            }
            case 2: {
                return "esb.result.inst.2nd.ex.msg";
            }
            case 3: {
                return "esb.result.comp.2nd.ex.msg";
            }
        }
        return "esb.result.cas.2nd.ex.msg";
    }

    protected void printMainMessage(PrintWriter out, int formatType, String msgType, String msgCode, String msg) {
        String fmtMsg = this.getL10NMainMessage(msgType, msgCode, msg);
        out.print(ESBResultFormatter.getI18NBundle().getMessage(this.getMainMessageI18NKey(formatType), fmtMsg));
    }

    protected void print2ndMessage(PrintWriter out, int formatType, String msgCode, String msg) {
        String fmtMsg = this.getL10NMessage(msgCode, msg);
        out.print(ESBResultFormatter.getI18NBundle().getMessage(this.get2ndMessageI18NKey(formatType), fmtMsg));
    }

    protected void printExceptionMessage(PrintWriter out, int formatType, String msgCode, String msg) {
        String fmtMsg = this.getL10NExptionMessage(msgCode, msg);
        out.print(ESBResultFormatter.getI18NBundle().getMessage(this.getExceptionMsgI18NKey(formatType), fmtMsg));
    }

    protected void print2ndExceptionMessage(PrintWriter out, int formatType, String msgCode, String msg) {
        String fmtMsg = this.getL10NMessage(msgCode, msg);
        out.print(ESBResultFormatter.getI18NBundle().getMessage(this.get2ndExceptionMsgI18NKey(formatType), fmtMsg));
    }

    protected boolean printFormattedStatusMessages(PrintWriter out, int formatType, String msgType, List msgList) {
        boolean msgPrinted = false;
        if (msgList == null || msgList.size() == 0) {
            return msgPrinted;
        }
        for (int msgIdx = 0; msgIdx < msgList.size(); ++msgIdx) {
            JBIManagementMessage.MessageInfo msgInfo = (JBIManagementMessage.MessageInfo)msgList.get(msgIdx);
            String msgCode = msgInfo.getI18nId();
            String msg = msgInfo.getLocalizedMsg();
            if (msgIdx == 0) {
                this.printMainMessage(out, formatType, msgType, msgCode, msg);
            } else {
                out.println();
                this.print2ndMessage(out, formatType, msgCode, msg);
            }
            msgPrinted = true;
        }
        return msgPrinted;
    }

    protected boolean printFormattedExceptionMessages(PrintWriter out, int formatType, String msgType, List expList, boolean printMainMsg) {
        boolean msgPrinted = false;
        boolean mainMsgPrinted = false;
        if (expList == null || expList.size() == 0) {
            return msgPrinted;
        }
        for (int expIdx = 0; expIdx < expList.size(); ++expIdx) {
            JBIManagementMessage.ExceptionInfo expInfo = (JBIManagementMessage.ExceptionInfo)expList.get(expIdx);
            String msgCode = expInfo.getMessageInfo().getI18nId();
            String msg = expInfo.getMessageInfo().getLocalizedMsg();
            if (expIdx == 0) {
                if (printMainMsg) {
                    this.printMainMessage(out, formatType, msgType, msgCode, msg);
                    mainMsgPrinted = true;
                } else {
                    out.println();
                    this.printExceptionMessage(out, formatType, msgCode, msg);
                }
            } else if (mainMsgPrinted && expIdx == 1) {
                out.println();
                this.printExceptionMessage(out, formatType, msgCode, msg);
            } else {
                out.println();
                this.print2ndExceptionMessage(out, formatType, msgCode, msg);
            }
            msgPrinted = true;
        }
        return msgPrinted;
    }

    protected boolean printAllFormattedMessages(PrintWriter out, int formatType, String msgType, List msgList, List expList, boolean startWithNewLine) {
        boolean msgPrinted = false;
        boolean statusMsgPrinted = false;
        boolean expMsgPrinted = false;
        if (!(msgList != null && msgList.size() != 0 || expList != null && expList.size() != 0)) {
            return msgPrinted;
        }
        if (startWithNewLine) {
            out.println();
        }
        statusMsgPrinted = this.printFormattedStatusMessages(out, formatType, msgType, msgList);
        boolean printMainMsg = false;
        if (!statusMsgPrinted) {
            printMainMsg = true;
        }
        expMsgPrinted = this.printFormattedExceptionMessages(out, formatType, msgType, expList, printMainMsg);
        msgPrinted = statusMsgPrinted || expMsgPrinted;
        return msgPrinted;
    }

    public boolean printTaskResultMessages(PrintWriter out, int formatType, JBIManagementMessage.TaskResultInfo taskResultInfo) {
        boolean printed = false;
        boolean startWithNewLine = false;
        String msgType = taskResultInfo.getMessageType();
        List msgList = taskResultInfo.getStatusMessageInfoList();
        List expList = taskResultInfo.getExceptionInfoList();
        if (msgList != null && msgList.size() > 0 || expList != null && expList.size() > 0) {
            printed = this.printAllFormattedMessages(out, formatType, msgType, msgList, expList, startWithNewLine);
        }
        return printed;
    }

    public boolean printTaskResultMessages(PrintWriter out, JBIManagementMessage.TaskResultInfo taskResultInfo) {
        return this.printTaskResultMessages(out, 0, taskResultInfo);
    }

    public boolean printFrameworkLevelMessages(PrintWriter out, JBIManagementMessage.FrameworkTaskResult fwTaskResult) {
        JBIManagementMessage.TaskResultInfo taskResultInfo = fwTaskResult.getTaskResultInfo();
        return this.printTaskResultMessages(out, 2, taskResultInfo);
    }

    public boolean printComponentLevelMessages(PrintWriter out, JBIManagementMessage.ComponentTaskResult compTaskResult) {
        JBIManagementMessage.TaskResultInfo taskResultInfo = compTaskResult.getTaskResultInfo();
        return this.printTaskResultMessages(out, 3, taskResultInfo);
    }

    public void sortComponentTaskResultList(List compTaskResultList) {
        try {
            Collections.sort(compTaskResultList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JBIManagementMessage.ComponentTaskResult)o1).getComponentName().compareTo(((JBIManagementMessage.ComponentTaskResult)o2).getComponentName());
                }
            });
        }
        catch (ClassCastException ccEx) {
        }
        catch (UnsupportedOperationException unsupEx) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean printJbiTaskResultMessages(PrintWriter out, JBIManagementMessage.JBITaskResult jbiTaskResult) {
        boolean msgPrinted = false;
        boolean fwMsgPrinted = false;
        boolean firstCompMsgPrinted = false;
        fwMsgPrinted = this.printFrameworkLevelMessages(out, jbiTaskResult.getFrameworkTaskResult());
        List compList = jbiTaskResult.getComponentTaskResultList();
        this.sortComponentTaskResultList(compList);
        if (compList != null && compList.size() > 0) {
            for (int compIdx = 0; compIdx < compList.size(); ++compIdx) {
                boolean compMsgPrinted = false;
                StringWriter compBuff = new StringWriter();
                PrintWriter compOut = new PrintWriter(compBuff);
                JBIManagementMessage.ComponentTaskResult compTaskResult = (JBIManagementMessage.ComponentTaskResult)compList.get(compIdx);
                compMsgPrinted = this.printComponentLevelMessages(compOut, compTaskResult);
                compOut.close();
                if (!compMsgPrinted) continue;
                if (firstCompMsgPrinted || fwMsgPrinted) {
                    out.println();
                }
                String compName = compTaskResult.getComponentName();
                out.println(ESBResultFormatter.getI18NBundle().getMessage("esb.result.comp.msg.from.comp", compName));
                out.print(compBuff.getBuffer().toString());
                firstCompMsgPrinted = true;
            }
        }
        msgPrinted = fwMsgPrinted || firstCompMsgPrinted;
        return msgPrinted;
    }

    public boolean printInstanceLevelMessages(PrintWriter out, JBIManagementMessage.InstanceTaskResult instResult, boolean printInstanceName) {
        boolean instMsgPrinted = false;
        StringWriter instBuff = new StringWriter();
        PrintWriter instOut = new PrintWriter(instBuff);
        String instanceName = instResult.getInstanceName();
        JBIManagementMessage.JBITaskResult jbiTaskResult = instResult.getJBITaskResult();
        instMsgPrinted = this.printJbiTaskResultMessages(instOut, jbiTaskResult);
        instOut.close();
        if (instMsgPrinted) {
            if (printInstanceName) {
                out.println(ESBResultFormatter.getI18NBundle().getMessage("esb.result.inst.msg.from.inst", instanceName));
            }
            out.print(instBuff.getBuffer().toString());
        }
        return instMsgPrinted;
    }

    public boolean printInstanceLevelMessages(PrintWriter out, JBIManagementMessage.InstanceTaskResult instResult) {
        boolean printInstanceName = true;
        return this.printInstanceLevelMessages(out, instResult, printInstanceName);
    }

    public void sortInstanceResultList(List instResultList) {
        try {
            Collections.sort(instResultList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JBIManagementMessage.InstanceTaskResult)o1).getInstanceName().compareTo(((JBIManagementMessage.InstanceTaskResult)o2).getInstanceName());
                }
            });
        }
        catch (ClassCastException ccEx) {
        }
        catch (UnsupportedOperationException unsupEx) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean printESBTaskResult(PrintWriter out, JBIManagementMessage.ESBTaskResult esbResult) {
        boolean msgPrinted = false;
        boolean casMsgPrinted = false;
        casMsgPrinted = this.printJbiTaskResultMessages(out, esbResult.getCASTaskResult());
        boolean firstInstMsgPrinted = false;
        List instList = esbResult.getInstanceTaskResultList();
        this.sortInstanceResultList(instList);
        if (instList != null && instList.size() > 0) {
            for (int instIdx = 0; instIdx < instList.size(); ++instIdx) {
                boolean instMsgPrinted = false;
                StringWriter instBuff = new StringWriter();
                PrintWriter instOut = new PrintWriter(instBuff);
                JBIManagementMessage.InstanceTaskResult instResult = (JBIManagementMessage.InstanceTaskResult)instList.get(instIdx);
                boolean printInstaceName = true;
                instMsgPrinted = this.printInstanceLevelMessages(instOut, instResult, printInstaceName);
                instOut.close();
                if (!instMsgPrinted) continue;
                if (firstInstMsgPrinted || casMsgPrinted) {
                    out.println();
                }
                out.print(instBuff.getBuffer().toString());
                firstInstMsgPrinted = true;
            }
        }
        msgPrinted = casMsgPrinted || firstInstMsgPrinted;
        return msgPrinted;
    }

    private Map getInstanceMessagesMap(JBIManagementMessage.TaskResultInfo taskResult, boolean isExpInfo) {
        List infoList = null;
        HashMap instMap = new HashMap();
        List instInfoList = null;
        String instanceName = CAS_KEY;
        List list = infoList = isExpInfo ? taskResult.getExceptionInfoList() : taskResult.getStatusMessageInfoList();
        if (infoList == null || infoList.isEmpty()) {
            instInfoList = new ArrayList();
            instMap.put(CAS_KEY, instInfoList);
            return instMap;
        }
        for (int i = 0; i < infoList.size(); ++i) {
            Object info = infoList.get(i);
            JBIManagementMessage.MessageInfo msgInfo = isExpInfo ? ((JBIManagementMessage.ExceptionInfo)info).getMessageInfo() : (JBIManagementMessage.MessageInfo)info;
            String marker = msgInfo.getI18nId();
            if (INSTANCE_MARKER_ID.equals(marker)) {
                instanceName = msgInfo.getLocalizedMsg();
                instInfoList = (List)instMap.get(instanceName);
                continue;
            }
            if (instInfoList == null) {
                instInfoList = new ArrayList();
                instMap.put(instanceName, instInfoList);
            }
            instInfoList.add(info);
        }
        return instMap;
    }

    public JBIManagementMessage.TaskResultInfo createTaskResultInfo(JBIManagementMessage.TaskResultInfo taskResultInfo, List msgList, List expList) {
        ArrayList mList = msgList;
        ArrayList eList = expList;
        if (mList == null) {
            mList = new ArrayList();
        }
        if (eList == null) {
            eList = new ArrayList();
        }
        return new JBIManagementMessage.TaskResultInfo(taskResultInfo.getTaskId(), taskResultInfo.getResult(), taskResultInfo.getMessageType(), mList, eList);
    }

    public void updateInstanceMap(Map instMap, JBIManagementMessage.FrameworkTaskResult fwTaskResult, Map fwInstMsgMap, Map fwInstExpMap) {
        HashSet instSet = new HashSet();
        instSet.addAll(fwInstMsgMap.keySet());
        instSet.addAll(fwInstExpMap.keySet());
        for (String instName : instSet) {
            JBIManagementMessage.InstanceTaskResult instResult = (JBIManagementMessage.InstanceTaskResult)instMap.get(instName);
            if (instResult == null) {
                instResult = new JBIManagementMessage.InstanceTaskResult();
                instResult.setInstanceName(instName);
                instMap.put(instName, instResult);
            }
            JBIManagementMessage.TaskResultInfo taskResultInfo = this.createTaskResultInfo(fwTaskResult.getTaskResultInfo(), (List)fwInstMsgMap.get(instName), (List)fwInstExpMap.get(instName));
            JBIManagementMessage.FrameworkTaskResult instFwTaskResult = new JBIManagementMessage.FrameworkTaskResult(taskResultInfo, fwTaskResult.isCauseFramework(), fwTaskResult.getLocale());
            instResult.getJBITaskResult().setFrameworkTaskResult(instFwTaskResult);
        }
    }

    public void updateInstanceMap(Map instMap, JBIManagementMessage.ComponentTaskResult compResult, Map msgMap, Map expMap) {
        HashSet instSet = new HashSet();
        instSet.addAll(msgMap.keySet());
        instSet.addAll(expMap.keySet());
        for (String instName : instSet) {
            JBIManagementMessage.InstanceTaskResult instResult = (JBIManagementMessage.InstanceTaskResult)instMap.get(instName);
            if (instResult == null) {
                instResult = new JBIManagementMessage.InstanceTaskResult();
                instResult.setInstanceName(instName);
                instMap.put(instName, instResult);
            }
            JBIManagementMessage.TaskResultInfo taskResultInfo = this.createTaskResultInfo(compResult.getTaskResultInfo(), (List)msgMap.get(instName), (List)expMap.get(instName));
            JBIManagementMessage.ComponentTaskResult instCompTaskResult = new JBIManagementMessage.ComponentTaskResult(taskResultInfo, compResult.getComponentName());
            instResult.getJBITaskResult().getComponentTaskResultList().add(instCompTaskResult);
        }
    }

    public JBIManagementMessage.ESBTaskResult toESBTaskResult(JBIManagementMessage jbiMsg) {
        JBIManagementMessage.FrameworkTaskResult fwResult = jbiMsg.getFrameworkTaskResult();
        List compResultList = jbiMsg.getComponentTaskResultList();
        JBIManagementMessage.TaskResultInfo fwTaskResultInfo = fwResult.getTaskResultInfo();
        Map fwInstMsgMap = this.getInstanceMessagesMap(fwTaskResultInfo, false);
        Map fwInstExpMap = this.getInstanceMessagesMap(fwTaskResultInfo, true);
        HashMap instMap = new HashMap();
        this.updateInstanceMap(instMap, fwResult, fwInstMsgMap, fwInstExpMap);
        for (int i = 0; i < compResultList.size(); ++i) {
            JBIManagementMessage.ComponentTaskResult compResult = (JBIManagementMessage.ComponentTaskResult)compResultList.get(i);
            Map compInstMsgMap = this.getInstanceMessagesMap(compResult.getTaskResultInfo(), false);
            Map compInstExpMap = this.getInstanceMessagesMap(compResult.getTaskResultInfo(), true);
            this.updateInstanceMap(instMap, compResult, compInstMsgMap, compInstExpMap);
        }
        JBIManagementMessage.InstanceTaskResult casInstResult = (JBIManagementMessage.InstanceTaskResult)instMap.get(CAS_KEY);
        instMap.remove(CAS_KEY);
        ArrayList instTaskResultList = new ArrayList(instMap.values());
        JBIManagementMessage.JBITaskResult casTaskResult = null;
        casTaskResult = casInstResult != null ? casInstResult.getJBITaskResult() : new JBIManagementMessage.JBITaskResult();
        JBIManagementMessage.ESBTaskResult esbTaskResult = new JBIManagementMessage.ESBTaskResult(casTaskResult, instTaskResultList);
        return esbTaskResult;
    }

    public String getFormattedResult(JBIManagementMessage.ESBTaskResult esbResult) {
        if (esbResult == null) {
            return null;
        }
        String formattedMsg = null;
        StringWriter buff = new StringWriter();
        PrintWriter out = new PrintWriter(buff);
        this.printESBTaskResult(out, esbResult);
        out.close();
        formattedMsg = buff.getBuffer().toString();
        return formattedMsg;
    }

    public String getFormattedESBResult(JBIManagementMessage jbiMsg) {
        if (jbiMsg == null) {
            return null;
        }
        String formattedMsg = null;
        JBIManagementMessage.ESBTaskResult esbTaskResult = this.toESBTaskResult(jbiMsg);
        formattedMsg = this.getFormattedResult(esbTaskResult);
        return formattedMsg;
    }

    public String getFormattedESBResult(String jbiMgmtMsgXml) {
        JBIManagementMessage jbiMsg = JBIManagementMessage.createJBIManagementMessage(jbiMgmtMsgXml);
        return this.getFormattedESBResult(jbiMsg);
    }
}

