/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.servicetags;

import com.sun.scn.servicetags.util.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Formatter;
import org.w3c.dom.Element;

public class EnvironmentInformation {
    private String hostname;
    private String hostId;
    private String osName;
    private String osVersion;
    private String osArchitecture;
    private String systemModel;
    private String systemManufacturer;
    private String cpuManufacturer;
    private String serialNumber;

    public EnvironmentInformation() {
        this.osName = System.getProperty("os.name");
        this.osArchitecture = System.getProperty("os.arch");
        boolean isSolaris = false;
        boolean isWindows = false;
        boolean isLinux = false;
        if ("/".equals(File.separator)) {
            if ("SunOS".equals(this.osName)) {
                isSolaris = true;
            } else if ("linux".equalsIgnoreCase(this.osName)) {
                isLinux = true;
            }
        }
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            this.hostname = localMachine.getHostName();
        }
        catch (UnknownHostException uhe) {
            if (isLinux) {
                this.hostname = this.getFromCommandLine("/usr/bin/uname -n");
            }
            if (isSolaris) {
                this.hostname = this.getFromCommandLine("/usr/bin/uname -n");
            }
            if (isWindows) {
                // empty if block
            }
        }
        if (isLinux) {
            this.hostId = this.getFromCommandLine("/usr/bin/hostid");
            if (this.hostId != null && this.hostId.startsWith("0x")) {
                this.hostId = this.hostId.substring(2);
            }
            this.osVersion = this.getFromCommandLine("/usr/bin/uname -r");
            this.osArchitecture = this.getFromCommandLine("/usr/bin/uname -p");
            this.systemModel = this.getFromCommandLine("/usr/bin/uname -i");
        } else if (isSolaris) {
            this.hostId = this.getFromCommandLine("/usr/bin/hostid");
            this.osVersion = this.getFromCommandLine("/usr/bin/uname -r");
            this.osArchitecture = this.getFromCommandLine("/usr/bin/uname -p");
            this.systemModel = this.getFromCommandLine("/usr/bin/uname -i");
        } else if (isWindows) {
            // empty if block
        }
    }

    public EnvironmentInformation(Element e) {
        this.hostname = XMLUtil.getOptionalTextValue(e, "hostname");
        if (this.hostname == null || this.hostname.equals("null")) {
            this.hostname = "";
        }
        this.hostId = XMLUtil.getOptionalTextValue(e, "hostId");
        if (this.hostId == null || this.hostId.equals("null")) {
            this.hostId = "";
        }
        this.osName = XMLUtil.getOptionalTextValue(e, "osName");
        if (this.osName == null || this.osName.equals("null")) {
            this.osName = "";
        }
        this.osVersion = XMLUtil.getOptionalTextValue(e, "osVersion");
        if (this.osVersion == null || this.osVersion.equals("null")) {
            this.osVersion = "";
        }
        this.osArchitecture = XMLUtil.getOptionalTextValue(e, "osArchitecture");
        if (this.osArchitecture == null || this.osArchitecture.equals("null")) {
            this.osArchitecture = "";
        }
        this.systemModel = XMLUtil.getOptionalTextValue(e, "systemModel");
        if (this.systemModel == null || this.systemModel.equals("null")) {
            this.systemModel = "";
        }
        this.systemManufacturer = XMLUtil.getOptionalTextValue(e, "systemManufacturer");
        if (this.systemManufacturer == null || this.systemManufacturer.equals("null")) {
            this.systemManufacturer = "";
        }
        this.cpuManufacturer = XMLUtil.getOptionalTextValue(e, "cpuManufacturer");
        if (this.cpuManufacturer == null || this.cpuManufacturer.equals("null")) {
            this.cpuManufacturer = "";
        }
        this.serialNumber = XMLUtil.getOptionalTextValue(e, "serialNumber");
        if (this.serialNumber == null || this.serialNumber.equals("null")) {
            this.serialNumber = "";
        }
    }

    public EnvironmentInformation(String hostname, String hostId, String osName, String osVersion, String osArchitecture, String systemModel, String systemManufacturer, String cpuManufacturer, String serialNumber) {
        this.hostname = hostname;
        this.hostId = hostId;
        this.osName = osName;
        this.osVersion = osVersion;
        this.osArchitecture = osArchitecture;
        this.systemModel = systemModel;
        this.systemManufacturer = systemManufacturer;
        this.cpuManufacturer = cpuManufacturer;
        this.serialNumber = serialNumber;
    }

    public void setHostname() {
        this.hostname = this.hostname;
    }

    public void setOsName() {
        this.osName = this.osName;
    }

    public void setOsVersion() {
        this.osVersion = this.osVersion;
    }

    public void setOsArchitecture() {
        this.osArchitecture = this.osArchitecture;
    }

    public void setSystemModel() {
        this.systemModel = this.systemModel;
    }

    public void setSystemManufacturer() {
        this.systemManufacturer = this.systemManufacturer;
    }

    public void setCpuManufacturer() {
        this.cpuManufacturer = this.cpuManufacturer;
    }

    public void setSerialNumber() {
        this.serialNumber = this.serialNumber;
    }

    public void setHostId() {
        this.hostId = this.hostId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public String getSystemModel() {
        return this.systemModel;
    }

    public String getSystemManufacturer() {
        return this.systemManufacturer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getCpuManufacturer() {
        return this.cpuManufacturer;
    }

    public String toXMLString() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("<environment>\n", new Object[0]);
        fmt.format("<hostname>%s</hostname>\n", this.hostname);
        fmt.format("<hostId>%s<hostId/>\n", this.hostId);
        fmt.format("<osName>%s</osName>\n", this.osName);
        fmt.format("<osVersion>%s</osVersion>\n", this.osVersion);
        fmt.format("<osArchitecture>%s<osArchitecture/>\n", this.osArchitecture);
        fmt.format("<systemModel>%s<systemModel/>\n", this.systemModel);
        fmt.format("<systemManufacturer>%s<systemManufacturer/>\n", this.systemManufacturer);
        fmt.format("<cpuManufacturer>%s<cpuManufacturer/>\n", this.cpuManufacturer);
        fmt.format("<serialNumber>%s<serialNumber/>\n", this.serialNumber);
        fmt.format("</environment>\n", new Object[0]);
        return sb.toString();
    }

    private String getFromCommandLine(String cmd) {
        String res = null;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            int rv = proc.waitFor();
            if (rv == 0) {
                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                line = br.readLine();
                if (line != null) {
                    res = line;
                }
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

