/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionInitiator;
import com.sun.messaging.jmq.jmsclient.ConnectionMetaDataImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.InterestTable;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.QueueSessionImpl;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.ReadQTable;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import com.sun.messaging.jmq.jmsclient.TopicSessionImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.UnifiedSessionImpl;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsclient.notification.EventHandler;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jms.Connection;
import com.sun.messaging.jms.notification.EventListener;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.XASession;

public class ConnectionImpl
implements Connection,
Traceable {
    private static final String ENABLE_FAILOVER_PROP = "imq.enable_failover";
    protected static final Version version = new Version();
    private boolean daemonThreads = false;
    private boolean hasNamespace = false;
    private String raNamespaceUID = null;
    private Object nsSyncObj = new Object();
    ExceptionListener exceptionListener = null;
    protected String clientID = null;
    protected String clientIPAddress = null;
    protected ReadChannel readChannel = null;
    protected WriteChannel writeChannel = null;
    protected ProtocolHandler protocolHandler = null;
    private AuthenticationProtocolHandler authenticationHandler = null;
    protected FlowControl flowControl = null;
    protected ConnectionInitiator initiator = null;
    protected boolean reconnecting = false;
    private Object reconnectSyncObj = new Object();
    protected Hashtable producers = new Hashtable();
    protected ExceptionHandler exceptionHandler = null;
    protected InterestTable interestTable = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isTopicConnection = false;
    protected boolean isQueueConnection = false;
    protected boolean isStopped = true;
    protected boolean isClosed = true;
    protected boolean isCloseCalled = false;
    protected boolean isSuspended = false;
    protected Vector sessionTable = null;
    protected Vector connectionConsumerTable = null;
    protected Vector tempDestTable = null;
    protected long nextSessionId = 0L;
    protected boolean sessionIdReset = false;
    protected int nextTransactionID = 0;
    protected boolean openedFromXA = false;
    protected boolean protectMode = false;
    protected int flowControlMsgSize = 100;
    protected int flowControlWaterMark = 1000;
    protected int prefetchMaxMsgCount = 100;
    protected int prefetchThresholdPercent = 50;
    protected volatile boolean imqReconnect = false;
    protected boolean failoverEnabled = false;
    protected Hashtable licenseProps = null;
    protected boolean imqEnableSharedClientID = false;
    protected boolean imqEnableSharedSubscriptions = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    private int tempDestSequence = 0;
    private int tempDestCounter = 0;
    protected volatile boolean connectionIsBroken = false;
    protected volatile boolean recoverInProcess = false;
    protected static long nextConnectionID = 0L;
    protected Long connectionID = null;
    protected long localID = 0L;
    protected boolean jmqOverrideJMSMsgHeaders = false;
    protected boolean jmqOverrideJMSDeliveryMode = false;
    protected boolean jmqOverrideJMSExpiration = false;
    protected boolean jmqOverrideJMSPriority = false;
    protected boolean jmqOverrideMsgsToTempDests = false;
    protected int jmqJMSDeliveryMode = 2;
    protected long jmqJMSExpiration = 0L;
    protected int jmqJMSPriority = 4;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected long dupsOkAckTimeout = 7000L;
    protected boolean allowToSetClientID = true;
    protected boolean adminSetClientID = false;
    private Object syncObj = new Object();
    private transient String userName = null;
    private transient String password = null;
    private String ackOnProduce = null;
    private String ackOnAcknowledge = null;
    private String connectionType = "NORMAL";
    private boolean adminKeyUsed = false;
    protected ConnectionMetaDataImpl connectionMetaData = null;
    private boolean debug = Debug.debug;
    Properties configuration = null;
    private boolean isDedicatedToConnectionConsumer = true;
    private volatile boolean negotiateProtocolLevel = false;
    private int brokerProtocolLevel = 0;
    private String brokerVersion = "Unknown";
    private long imqPingInterval = 30000L;
    private static long WAIT_TIME_OUT = 30000L;
    protected EventListener eventListener = null;
    protected EventHandler eventHandler = null;
    protected volatile boolean isConnectedToHABroker = false;
    protected String JMQClusterID = null;
    protected Long JMQStoreSession = null;
    protected String JMQBrokerList = null;
    protected String savedJMQBrokerList = null;
    protected String JMQStoreOwner = null;
    protected String lastContactedBrokerAddress = null;
    private boolean extendedEventNotification = false;
    public static final String ROOT_LOGGER_NAME = "javax.jms";
    public static final String CONNECTION_LOGGER_NAME = "javax.jms.connection";
    protected static final Logger connectionLogger = Logger.getLogger("javax.jms.connection", "com.sun.messaging.jmq.jmsclient.resources.ClientResources");
    private static boolean isHADisabled = Boolean.getBoolean("imq.ha.disabled");

    public boolean isHAEnabled() {
        return !isHADisabled;
    }

    public ConnectionImpl(Properties properties, String string, String string2, String string3) throws JMSException {
        this.configuration = properties;
        this.userName = string;
        this.password = string2;
        if ("ADMINKEY".equals(string3)) {
            this.connectionType = "ADMIN";
            this.adminKeyUsed = true;
        } else if (string3 != null) {
            this.connectionType = string3;
        }
        this.connectionID = new Long(ConnectionImpl.getNextConnectionID());
        this.localID = this.connectionID;
        this.init();
        this.logLifeCycle("I100");
    }

    public long getLocalID() {
        return this.localID;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public void setBrokerVersion(String string) {
        if (this.debug) {
            Debug.println("setBrokerVersion : " + string);
        }
        this.brokerVersion = string;
    }

    public long generateUID() throws JMSException {
        return this.protocolHandler.generateUID();
    }

    protected int getBrokerProtocolLevel() {
        return this.brokerProtocolLevel;
    }

    protected void setBrokerProtocolLevel(int n) {
        if (this.debug) {
            Debug.println("setBrokerProtocolLevel : " + n);
        }
        this.brokerProtocolLevel = n;
    }

    protected boolean checkBrokerProtocolLevel() throws JMSException {
        return this.brokerProtocolLevel >= 200;
    }

    public static void checkHostPort(String string, int n) throws JMSException {
        if (n <= 0) {
            String string2 = "[" + string + "," + n + "]";
            String string3 = AdministeredObject.cr.getKString("C4090", string2);
            JMSException jMSException = new JMSException(string3, "C4090");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    public boolean getNegotiateProtocolLevel() {
        return this.negotiateProtocolLevel;
    }

    public void setNegotiateProtocolLevel(boolean bl) {
        if (this.debug) {
            Debug.println("setNegotiateProtocolLevel : " + bl);
        }
        this.negotiateProtocolLevel = bl;
    }

    protected void updateLicenseProps() throws JMSException {
        this.licenseProps = null;
        this.failoverEnabled = false;
        if (this.getBrokerProtocolLevel() > 350) {
            this.licenseProps = this.protocolHandler.getLicense();
        }
        if (this.licenseProps != null) {
            String string = (String)this.licenseProps.get(ENABLE_FAILOVER_PROP);
            if (string != null && "true".equalsIgnoreCase(string)) {
                this.failoverEnabled = true;
            }
            this.checkLicense();
        }
    }

    protected void hello() throws JMSException {
        this.protocolHandler.hello(this.userName, this.password);
        this.updateLicenseProps();
    }

    protected void hello(boolean bl) throws JMSException {
        this.protocolHandler.hello(this.userName, this.password, this.connectionID);
        this.updateLicenseProps();
    }

    private void checkLicense() throws JMSException {
        if (this.imqReconnect && !this.failoverEnabled && this.initiator.getAddrListSize() > 1) {
            String string = this.protocolHandler.getConnectionHandler().getBrokerHostName();
            String string2 = AdministeredObject.cr.getKString("C4097", string);
            JMSException jMSException = new JMSException(string2, "C4097");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    protected boolean waitForReconnecting(Exception exception) {
        boolean bl = false;
        if (!this.imqReconnect) {
            return false;
        }
        if (!(exception instanceof JMSException)) {
            return false;
        }
        JMSException jMSException = (JMSException)((Object)exception);
        String string = jMSException.getErrorCode();
        if ("C4001".equals(string) || "C4000".equals(string)) {
            SessionImpl.yield();
            try {
                this.checkReconnecting(null);
                bl = !this.isCloseCalled && !this.connectionIsBroken;
            }
            catch (Exception exception2) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkReconnecting(ReadWritePacket readWritePacket) throws JMSException {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            while (this.reconnecting) {
                try {
                    this.reconnectSyncObj.wait(WAIT_TIME_OUT);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.connectionIsBroken && !this.isCloseCalled) continue;
                return;
            }
        }
        if (readWritePacket != null) {
            this.checkPacketType(readWritePacket);
        }
    }

    private void checkPacketType(ReadWritePacket readWritePacket) throws JMSException {
        boolean bl = this.isAllowedToFailover(readWritePacket);
        if (!bl) {
            String string = AdministeredObject.cr.getKString("C4001") + ", packet type = " + PacketType.getString(readWritePacket.getPacketType());
            com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(string, "C4001");
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    private boolean isAllowedToFailover(ReadWritePacket readWritePacket) {
        long l;
        Object v;
        Hashtable hashtable = null;
        try {
            hashtable = readWritePacket.getProperties();
        }
        catch (Exception exception) {
            connectionLogger.log(Level.WARNING, "C4005", exception);
            return false;
        }
        if (hashtable != null && (v = hashtable.get("JMQSessionID")) != null) {
            return false;
        }
        int n = readWritePacket.getPacketType();
        if (n == 24 || n == 14 || n == 18 || n == 12 || n == 34 || n == 68 || n == 16 || n == 66 || n == 36 || n == 70 || n == 56 || n == 50 || n == 44 || n == 48) {
            return false;
        }
        return n != 6 && n != 2 && n != 3 && n != 1 && n != 5 && n != 4 || (l = readWritePacket.getTransactionID()) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getReconnecting() {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            return this.reconnecting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconnecting(boolean bl) {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            this.reconnecting = bl;
            this.reconnectSyncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndSetReconnecting() throws JMSException {
        Object object = this.reconnectSyncObj;
        synchronized (object) {
            if (!(this.reconnecting || this.connectionIsBroken || this.isCloseCalled)) {
                this.setReconnecting(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useNamespace() {
        Object object = this.nsSyncObj;
        synchronized (object) {
            return this.hasNamespace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRANamespaceUID(String string) {
        Object object = this.nsSyncObj;
        synchronized (object) {
            this.imqEnableSharedClientID = true;
            this.imqEnableSharedSubscriptions = true;
            this.raNamespaceUID = string;
            this.hasNamespace = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRANamespaceUID() {
        Object object = this.nsSyncObj;
        synchronized (object) {
            return this.raNamespaceUID;
        }
    }

    private void init() throws JMSException {
        block30: {
            try {
                String string;
                String string2;
                String string3;
                String string4;
                this.exceptionHandler = new ExceptionHandler();
                this.interestTable = new InterestTable();
                this.readQTable = new ReadQTable();
                this.ackQTable = new ReadQTable();
                this.requestMetaData = new Hashtable();
                this.sessionTable = new Vector();
                this.connectionConsumerTable = new Vector();
                this.tempDestTable = new Vector();
                String string5 = null;
                int n = 0;
                long l = 0L;
                String string6 = this.getTrimmedProperty("imqConfiguredClientID");
                if (string6 != null) {
                    this.clientID = string6;
                    this.adminSetClientID = true;
                }
                if (Boolean.valueOf(string5 = this.getProperty("imq.DaemonThreads", "false")).booleanValue()) {
                    this.daemonThreads = true;
                }
                if (Boolean.valueOf(string5 = this.getTrimmedProperty("imqOverrideJMSDeliveryMode")).booleanValue()) {
                    string5 = this.getTrimmedProperty("imqJMSDeliveryMode");
                    if ("PERSISTENT".equals(string5)) {
                        this.jmqJMSDeliveryMode = 2;
                        this.jmqOverrideJMSDeliveryMode = true;
                    }
                    if ("NON_PERSISTENT".equals(string5)) {
                        this.jmqJMSDeliveryMode = 1;
                        this.jmqOverrideJMSDeliveryMode = true;
                    }
                }
                if (Boolean.valueOf(string5 = this.getTrimmedProperty("imqOverrideJMSExpiration")).booleanValue() && (l = Long.parseLong(string5 = this.getTrimmedProperty("imqJMSExpiration"))) >= 0L) {
                    this.jmqJMSExpiration = l;
                    this.jmqOverrideJMSExpiration = true;
                }
                if (Boolean.valueOf(string5 = this.getTrimmedProperty("imqOverrideJMSPriority")).booleanValue() && (n = Integer.parseInt(string5 = this.getTrimmedProperty("imqJMSPriority"))) >= 0 && n <= 9) {
                    this.jmqJMSPriority = n;
                    this.jmqOverrideJMSPriority = true;
                }
                if (this.jmqOverrideJMSDeliveryMode || this.jmqOverrideJMSExpiration || this.jmqOverrideJMSPriority) {
                    this.jmqOverrideJMSMsgHeaders = true;
                }
                string5 = this.getTrimmedProperty("imqOverrideJMSHeadersToTemporaryDestinations");
                this.jmqOverrideMsgsToTempDests = Boolean.valueOf(string5);
                String string7 = this.getProperty("imqDisableSetClientID");
                if (Boolean.valueOf(string7).booleanValue()) {
                    this.setClientIDFlag();
                }
                if (Boolean.valueOf(string5 = this.getProperty("imqConnectionFlowLimitEnabled")).booleanValue()) {
                    this.protectMode = true;
                }
                if ((string5 = this.getTrimmedProperty("imqConnectionFlowLimit")) != null) {
                    this.flowControlWaterMark = Integer.parseInt(string5);
                }
                if ((string5 = this.getTrimmedProperty("imqConnectionFlowCount")) != null) {
                    this.flowControlMsgSize = Integer.parseInt(string5);
                }
                if ((string5 = this.getTrimmedProperty("imqConsumerFlowLimit")) != null) {
                    this.prefetchMaxMsgCount = Integer.parseInt(string5);
                }
                if ((string5 = this.getTrimmedProperty("imqConsumerFlowThreshold")) != null) {
                    this.prefetchThresholdPercent = Integer.parseInt(string5);
                }
                if ((string5 = this.getTrimmedProperty("imqReconnectEnabled")) != null) {
                    this.imqReconnect = Boolean.valueOf(string5);
                }
                if ((string5 = this.getTrimmedProperty("imqEnableSharedClientID")) != null) {
                    this.imqEnableSharedClientID = Boolean.valueOf(string5);
                }
                this.ackOnProduce = this.getTrimmedProperty("imqAckOnProduce");
                this.ackOnAcknowledge = this.getTrimmedProperty("imqAckOnAcknowledge");
                String string8 = System.getProperty("imqDupsOkLimit");
                if (string8 != null) {
                    this.dupsOkLimit = Integer.parseInt(string8);
                }
                if ((string5 = System.getProperty("imqDupsOkAckTimeout")) != null) {
                    this.dupsOkAckTimeout = Integer.parseInt(string5);
                }
                if ((string5 = System.getProperty("imqDupsOkAckOnEmptyQueue")) != null) {
                    this.dupsOkAckOnEmptyQueue = Boolean.valueOf(string5);
                }
                if ((string4 = System.getProperty("imqAckLimit")) != null) {
                    this.ackLimit = Integer.parseInt(string4);
                }
                if ((string3 = System.getProperty("imqAckIsLimited")) != null && string3.equals("true")) {
                    this.isAckLimited = true;
                }
                if ((string2 = System.getProperty("imq.dedicateToConnectionConsumer")) != null && string2.equals("false")) {
                    this.isDedicatedToConnectionConsumer = false;
                }
                if ((string = this.getTrimmedProperty("imqPingInterval")) != null) {
                    int n2 = Integer.parseInt(string);
                    this.imqPingInterval = n2 <= 0 ? 0L : (long)(n2 * 1000);
                }
                this.initiator = new ConnectionInitiator(this);
                this.setBrokerProtocolLevel(PacketType.getProtocolVersion());
                try {
                    this.openConnection(false);
                }
                catch (Exception exception) {
                    if (this.negotiateProtocolLevel) {
                        this.openConnection(false);
                        break block30;
                    }
                    if (exception instanceof JMSException) {
                        throw exception;
                    }
                    ExceptionHandler.handleException(exception, "C4038", true);
                }
            }
            catch (JMSException jMSException) {
                throw jMSException;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException(exception, "C4038", true);
            }
        }
    }

    private static synchronized long getNextConnectionID() {
        return nextConnectionID++;
    }

    protected Long getConnectionID() {
        return this.connectionID;
    }

    public Long _getConnectionID() {
        return this.connectionID;
    }

    protected void setConnectionID(Long l) {
        this.connectionID = l;
    }

    protected void setAuthenticationHandler(AuthenticationProtocolHandler authenticationProtocolHandler) {
        this.authenticationHandler = authenticationProtocolHandler;
    }

    protected AuthenticationProtocolHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTempDestSequence() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.tempDestCounter;
            return ++this.tempDestSequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseTempDestCounter() {
        Object object = this.syncObj;
        synchronized (object) {
            --this.tempDestCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTempDestCounter() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.tempDestCounter;
        }
    }

    protected void setProtectMode(boolean bl) {
        this.protectMode = bl;
    }

    protected boolean getProtectMode() {
        return this.protectMode;
    }

    protected int getDupsOkLimit() {
        return this.dupsOkLimit;
    }

    protected int getAckLimit() {
        return this.ackLimit;
    }

    protected boolean getIsAckLimited() {
        return this.isAckLimited;
    }

    protected boolean getIsDedicatedToConnectionConsumer() {
        return this.isDedicatedToConnectionConsumer && !this.connectionConsumerTable.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getNextSessionId() {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.nextSessionId;
            if (this.nextSessionId == Long.MAX_VALUE) {
                this.nextSessionId = 1L;
                this.sessionIdReset = true;
            }
            if (this.sessionIdReset) {
                boolean bl = false;
                while (!bl) {
                    SessionQueue sessionQueue = this.readQTable.get(new Long(this.nextSessionId));
                    if (sessionQueue == null) {
                        bl = true;
                        continue;
                    }
                    ++this.nextSessionId;
                    if (this.nextSessionId != Long.MAX_VALUE) continue;
                    this.nextSessionId = 1L;
                }
            }
            return new Long(this.nextSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextTransactionID() throws JMSException {
        Object object = this.syncObj;
        synchronized (object) {
            ++this.nextTransactionID;
            if (this.nextTransactionID == Integer.MAX_VALUE) {
                this.nextTransactionID = 1;
            }
            return this.nextTransactionID;
        }
    }

    protected void addToReadQTable(Object object, Object object2) {
        this.readQTable.put(object, object2);
    }

    protected void removeFromReadQTable(Object object) {
        this.readQTable.remove(object);
    }

    protected void addToAckQTable(Object object, Object object2) {
        this.ackQTable.put(object, object2);
    }

    protected void removeFromAckQTable(Object object) {
        this.ackQTable.remove(object);
    }

    protected void addMessageProducer(Object object, MessageProducerImpl messageProducerImpl) {
        MessageProducerImpl messageProducerImpl2 = this.producers.put(object, messageProducerImpl);
        if (this.debug && messageProducerImpl2 != null) {
            Debug.println("ERROR : Duplicate ProducerID in connection.addMessageProducer : " + object);
        }
    }

    protected void removeMessageProducer(Object object) {
        Object v = this.producers.remove(object);
        if (this.debug && v == null) {
            Debug.println("ERROR : Unknown producer in connection.removeMessageProducer : " + object);
        }
    }

    protected MessageProducerImpl findMessageProducer(Object object) {
        return (MessageProducerImpl)this.producers.get(object);
    }

    protected void addLocalInterest(Consumer consumer) {
    }

    protected void removeLocalInterest(Consumer consumer) {
        this.interestTable.removeInterest(consumer);
    }

    protected void addInterest(Consumer consumer) throws JMSException {
        this.addLocalInterest(consumer);
        this.writeChannel.addInterest(consumer);
    }

    protected void removeInterest(Consumer consumer) throws JMSException {
        this.writeChannel.removeInterest(consumer);
        this.removeLocalInterest(consumer);
    }

    protected void unsubscribe(String string) throws JMSException {
        Enumeration enumeration = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumerImpl = null;
        while (enumeration.hasMoreElements()) {
            connectionConsumerImpl = (ConnectionConsumerImpl)enumeration.nextElement();
            if (!connectionConsumerImpl.getDurable() || !connectionConsumerImpl.getDurableName().equals(string)) continue;
            String string2 = AdministeredObject.cr.getKString("C4007", string);
            JMSException jMSException = new JMSException(string2, "C4007");
            ExceptionHandler.throwJMSException(jMSException);
        }
        this.writeChannel.unsubscribe(string);
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    protected WriteChannel getWriteChannel() {
        return this.writeChannel;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    protected boolean isAdminKeyUsed() {
        return this.adminKeyUsed;
    }

    protected Properties getConfiguration() {
        return (Properties)this.configuration.clone();
    }

    public String getProperty(String string) {
        String string2 = (String)this.configuration.get(string);
        if (this.debug) {
            Debug.println("****** property " + string + " : " + string2);
        }
        return string2;
    }

    public String getTrimmedProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 != null && string2.trim().length() == 0) {
            string2 = null;
        }
        return string2;
    }

    protected String getProperty(String string, String string2) {
        String string3 = (String)this.configuration.get(string);
        if (string3 == null) {
            string3 = System.getProperty(string);
        }
        return string3 == null ? string2 : string3;
    }

    public ReadChannel getReadChannel() {
        return this.readChannel;
    }

    protected void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    protected boolean getIsTopicConnection() {
        return this.isTopicConnection;
    }

    protected void setIsTopicConnection(boolean bl) {
        this.isTopicConnection = bl;
    }

    protected boolean getISQueueConnection() {
        return this.isQueueConnection;
    }

    protected void setIsQueueConnection(boolean bl) {
        this.isQueueConnection = bl;
    }

    protected InterestTable getInterestTable() {
        return this.interestTable;
    }

    protected void addSession(SessionImpl sessionImpl) {
        this.sessionTable.addElement(sessionImpl);
    }

    protected boolean removeSession(SessionImpl sessionImpl) {
        return this.sessionTable.removeElement(sessionImpl);
    }

    protected void addConnectionConsumer(ConnectionConsumerImpl connectionConsumerImpl) {
        this.connectionConsumerTable.addElement(connectionConsumerImpl);
    }

    protected void removeConnectionConsumer(ConnectionConsumerImpl connectionConsumerImpl) {
        this.connectionConsumerTable.removeElement(connectionConsumerImpl);
    }

    protected void addTempDest(TemporaryDestination temporaryDestination) {
        this.tempDestTable.addElement(temporaryDestination);
    }

    protected void removeTempDest(TemporaryDestination temporaryDestination) {
        this.tempDestTable.removeElement(temporaryDestination);
    }

    protected void startSessions() throws JMSException {
        Enumeration enumeration = this.sessionTable.elements();
        SessionImpl sessionImpl = null;
        while (enumeration.hasMoreElements()) {
            sessionImpl = (SessionImpl)enumeration.nextElement();
            if (this.debug) {
                Debug.println("starting session: " + sessionImpl.getSessionId());
            }
            sessionImpl.start();
        }
    }

    protected void stopSessions() throws JMSException {
        Enumeration enumeration = this.sessionTable.elements();
        SessionImpl sessionImpl = null;
        while (enumeration.hasMoreElements()) {
            sessionImpl = (SessionImpl)enumeration.nextElement();
            if (this.debug) {
                Debug.println("stopping session: " + sessionImpl.getSessionId());
            }
            sessionImpl.stop();
        }
    }

    private void startConnectionConsumers() {
        Enumeration enumeration = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumerImpl = null;
        while (enumeration.hasMoreElements()) {
            connectionConsumerImpl = (ConnectionConsumerImpl)enumeration.nextElement();
            if (this.debug) {
                Debug.println("starting connectionConsumer: " + connectionConsumerImpl.getReadQueueId().intValue());
            }
            connectionConsumerImpl.start();
        }
    }

    private void stopConnectionConsumers() {
        Enumeration enumeration = this.connectionConsumerTable.elements();
        ConnectionConsumerImpl connectionConsumerImpl = null;
        while (enumeration.hasMoreElements()) {
            connectionConsumerImpl = (ConnectionConsumerImpl)enumeration.nextElement();
            if (this.debug) {
                Debug.println("stopping connectionConsumer: " + connectionConsumerImpl.getReadQueueId().intValue());
            }
            connectionConsumerImpl.stop();
        }
    }

    private void closeConnectionConsumers() throws JMSException {
        block3: {
            ConnectionConsumerImpl connectionConsumerImpl = null;
            try {
                while (!this.connectionConsumerTable.isEmpty()) {
                    connectionConsumerImpl = (ConnectionConsumerImpl)this.connectionConsumerTable.firstElement();
                    connectionConsumerImpl.close();
                    this.connectionConsumerTable.remove(connectionConsumerImpl);
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block3;
                Debug.printStackTrace(exception);
            }
        }
    }

    protected synchronized void suspendMessageDelivery() throws JMSException {
        if (this.getIsSuspended()) {
            return;
        }
        if (this.debug) {
            Debug.println("sending STOP to broker ...");
        }
        this.protocolHandler.stop();
        this.isSuspended = true;
    }

    protected synchronized void resumeMessageDelivery() throws JMSException {
        if (this.debug) {
            Debug.println("sending START to broker ...");
        }
        this.protocolHandler.start();
        this.isSuspended = false;
    }

    public boolean getIsSuspended() {
        return this.isSuspended;
    }

    public boolean getIsStopped() {
        return this.isStopped;
    }

    public String getClientID() throws JMSException {
        this.checkConnectionState();
        return this.clientID;
    }

    public void setClientID(String string) throws JMSException {
        this.checkConnectionState();
        this.checkSetClientID(string);
        this.protocolHandler.setClientID(string);
        this.clientID = string;
        this.setClientIDFlag();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkConnectionState();
        return this.connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkConnectionState();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkConnectionState();
        this.exceptionListener = exceptionListener;
        this.setClientIDFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkConnectionState();
        if (!this.isStopped) {
            return;
        }
        this.setClientIDFlag();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.protocolHandler.start();
            this.isStopped = false;
            this.startSessions();
            this.startConnectionConsumers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        this.checkConnectionState();
        if (this.isStopped || this.isClosed) {
            return;
        }
        if (this.connectionIsBroken) {
            this.exitConnection();
            return;
        }
        this.checkPermission();
        this.setClientIDFlag();
        if (this.debug) {
            Debug.println("stopping readChannel ...");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.protocolHandler.stop();
            this.stopSessions();
            this.stopConnectionConsumers();
            this.isStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.isCloseCalled = true;
        if (this.eventHandler != null) {
            this.eventHandler.close();
        }
        if (this.isClosed) {
            return;
        }
        if (this.connectionIsBroken || this.recoverInProcess) {
            this.exitConnection();
            return;
        }
        this.checkPermission();
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            block19: {
                if (this.isClosed) {
                    return;
                }
                try {
                    this.protocolHandler.incStoppedCount();
                    this.stop();
                    this.closeAllSessions();
                    this.closeConnectionConsumers();
                    this.isClosed = true;
                    this.protocolHandler.goodBye(true);
                }
                catch (JMSException jMSException) {
                    if (this.connectionIsBroken || this.recoverInProcess || this.isClosed) {
                        this.exitConnection();
                        break block19;
                    }
                    throw jMSException;
                }
                finally {
                    block20: {
                        try {
                            this.readChannel.close();
                            this.writeChannel.close();
                            this.protocolHandler.close();
                        }
                        catch (Exception exception) {
                            if (!this.debug) break block20;
                            Debug.printStackTrace(exception);
                        }
                    }
                    this.protocolHandler = null;
                    this.readChannel = null;
                    this.writeChannel = null;
                    this.authenticationHandler = null;
                    this.logLifeCycle("I101");
                }
            }
        }
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected void checkSetClientID(String string) throws JMSException {
        Object object;
        String string2;
        if (!this.allowToSetClientID) {
            string2 = AdministeredObject.cr.getKString("C4054");
            object = new IllegalStateException(string2, "C4054");
            ExceptionHandler.throwJMSException((JMSException)((Object)object));
        }
        if (string == null || string.trim().length() == 0) {
            string2 = AdministeredObject.cr.getKString("C4053", "\"\"");
            object = new InvalidClientIDException(string2, "C4053");
            ExceptionHandler.throwJMSException((JMSException)((Object)object));
        }
    }

    protected void setClientIDFlag() throws JMSException {
        this.allowToSetClientID = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllSessions() {
        connectionLogger.log(Level.FINEST, "closing all sessions ...");
        SessionImpl sessionImpl = null;
        try {
            while (this.sessionTable.size() > 0) {
                sessionImpl = (SessionImpl)this.sessionTable.firstElement();
                this.closeSession(sessionImpl);
            }
        }
        finally {
            connectionLogger.log(Level.FINEST, "all sessions closed ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSession(SessionImpl sessionImpl) {
        try {
            sessionImpl.close();
        }
        catch (Exception exception) {
            ExceptionHandler.rootLogger.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            this.sessionTable.remove(sessionImpl);
        }
    }

    protected void closeConsumerQueues() {
        Object[] objectArray = this.interestTable.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MessageConsumerImpl)) continue;
            ((MessageConsumerImpl)objectArray[i]).receiveQueue.close();
            ((MessageConsumerImpl)objectArray[i]).isClosed = true;
            connectionLogger.log(Level.FINEST, "Message consumer closed: " + objectArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitConnection() {
        connectionLogger.log(Level.FINEST, "Starting to exit connection ...");
        if (this.isClosed) {
            return;
        }
        try {
            this.closeAllSessions();
            this.closeConsumerQueues();
            this.closeConnectionConsumers();
            this.writeChannel.close();
        }
        catch (Exception exception) {
            ExceptionHandler.rootLogger.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            this.isClosed = true;
            this.setReconnecting(false);
        }
    }

    protected void closeConnection() throws JMSException {
        if (this.openedFromXA) {
            this.close();
        }
    }

    protected void openConnection(boolean bl) throws JMSException {
        if (!this.isClosed()) {
            return;
        }
        this.connectionMetaData = new ConnectionMetaDataImpl(this);
        this.protocolHandler = new ProtocolHandler(this);
        if (this.ackOnProduce != null) {
            if (this.ackOnProduce.equals("true")) {
                this.protocolHandler.enableWriteAcknowledge(true);
            } else if (this.ackOnProduce.equals("false")) {
                this.protocolHandler.enableWriteAcknowledge(false);
            }
        }
        if (this.ackOnAcknowledge != null && this.ackOnAcknowledge.equals("false")) {
            this.protocolHandler.setAckAck(false);
        }
        this.connectionIsBroken = false;
        this.recoverInProcess = false;
        this.readChannel = new ReadChannel(this);
        this.writeChannel = new WriteChannel(this);
        if (this.debug) {
            Debug.println(this);
        }
        try {
            this.hello();
            if (this.adminSetClientID) {
                this.protocolHandler.setClientID(this.clientID);
                this.setClientIDFlag();
            }
        }
        catch (JMSException jMSException) {
            if (!this.connectionIsBroken) {
                try {
                    this.protocolHandler.goodBye(false);
                }
                catch (JMSException jMSException2) {
                    // empty catch block
                }
            }
            try {
                this.readChannel.close();
                this.protocolHandler.close();
            }
            catch (JMSException jMSException3) {
                jMSException3.setLinkedException((Exception)((Object)jMSException));
                throw jMSException3;
            }
            throw jMSException;
        }
        this.isClosed = false;
        this.openedFromXA = bl;
    }

    protected void checkPermission() throws JMSException {
        SessionImpl sessionImpl = null;
        try {
            Enumeration enumeration = this.sessionTable.elements();
            while (enumeration.hasMoreElements()) {
                sessionImpl = (SessionImpl)enumeration.nextElement();
                sessionImpl.checkPermission();
            }
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException(exception.toString());
            illegalStateException.setLinkedException(exception);
            ExceptionHandler.throwJMSException((JMSException)illegalStateException);
        }
    }

    protected void checkConnectionState() throws JMSException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4062");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4062");
            ExceptionHandler.throwJMSException((JMSException)illegalStateException);
        }
    }

    protected boolean isBroken() {
        return this.connectionIsBroken;
    }

    protected synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean _isClosed() {
        return this.isClosed();
    }

    public synchronized void _unsetClientID() throws JMSException {
        this.clientID = null;
        this.allowToSetClientID = true;
        this.protocolHandler.unsetClientID();
    }

    public synchronized void _setClientID(String string) throws JMSException {
        this.checkConnectionState();
        this.protocolHandler.setClientID(string);
        this.clientID = string;
        this.allowToSetClientID = false;
    }

    public synchronized String _getClientID() {
        return this.clientID;
    }

    public synchronized void _closeForPooling() throws JMSException {
        block4: {
            TemporaryDestination temporaryDestination = null;
            try {
                while (!this.tempDestTable.isEmpty()) {
                    temporaryDestination = (TemporaryDestination)this.tempDestTable.firstElement();
                    temporaryDestination.delete();
                    this.tempDestTable.remove(temporaryDestination);
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block4;
                Debug.printStackTrace(exception);
            }
        }
        if (this.clientID != null) {
            this._unsetClientID();
        }
    }

    public void _setExceptionListenerFromRA(ExceptionListener exceptionListener) throws JMSException {
        this.checkConnectionState();
        this.exceptionListener = exceptionListener;
    }

    public boolean hasDaemonThreads() {
        return this.daemonThreads;
    }

    protected void setIsBroken(boolean bl) {
        this.connectionIsBroken = bl;
    }

    protected void setRecoverInProcess(boolean bl) {
        this.recoverInProcess = bl;
    }

    protected boolean getRecoverInProcess() {
        return this.recoverInProcess;
    }

    protected String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClientIDOrIPAddress() {
        if (this.clientID != null) {
            return this.clientID;
        }
        if (this.clientIPAddress == null) {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    this.clientIPAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception exception) {
                    this.clientIPAddress = "127.0.0.1";
                }
            }
        }
        return this.clientIPAddress;
    }

    public void dump(PrintStream printStream) {
        try {
            printStream.println("------ ConnectionImpl dump ------");
            printStream.println("clientID: " + this.clientID);
            printStream.println("host: " + this.configuration.getProperty("imqBrokerHostName"));
            printStream.println("port: " + this.configuration.getProperty("imqBrokerHostPort"));
            printStream.println("protectMode: " + this.protectMode);
            printStream.println("Flow control waterMark: " + this.flowControlWaterMark);
            printStream.println("Flow Control Message size: " + this.flowControlMsgSize);
            if (this.protocolHandler != null) {
                printStream.println("Broker acknowledge mode: " + this.protocolHandler.getAckEnabled());
                printStream.println("Require ack back from broker for auto/client ack: " + this.protocolHandler.getAckAck());
            }
            printStream.println("dupsOkLimit: " + this.dupsOkLimit);
            printStream.println("isAckLimited: " + this.isAckLimited);
            printStream.println("ackLimit: " + this.ackLimit);
            printStream.println("failoverEnabled: " + this.failoverEnabled);
            printStream.println("imqReconnectEnabled: " + this.imqReconnect);
            printStream.println("isConnectedToHaBroker: " + this.isConnectedToHABroker);
            printStream.println("Connection is stopped: " + this.isStopped);
            Enumeration enumeration = this.sessionTable.elements();
            while (enumeration.hasMoreElements()) {
                SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
                sessionImpl.dump(printStream);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    protected long getPingInterval() {
        return this.imqPingInterval;
    }

    public String toString() {
        return "BrokerAddress=" + this.getLastContactedBrokerAddress() + ", ConnectionID=" + this.getConnectionID() + ", ReconnectEnabled: " + this.imqReconnect + ", IsConnectedToHABroker: " + this.isConnectedToHABroker;
    }

    public Hashtable getDebugState(boolean bl) {
        Traceable traceable;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Configuration", this.configuration);
        hashtable.put("connectionID", String.valueOf(this.connectionID));
        hashtable.put("clientID", String.valueOf(this.clientID));
        hashtable.put("brokerProtocolLevel", String.valueOf(this.brokerProtocolLevel));
        hashtable.put("reconnecting", String.valueOf(this.reconnecting));
        hashtable.put("isTopicConnection", String.valueOf(this.isTopicConnection));
        hashtable.put("isQueueConnection", String.valueOf(this.isQueueConnection));
        hashtable.put("isStopped", String.valueOf(this.isStopped));
        hashtable.put("isClosed", String.valueOf(this.isClosed));
        hashtable.put("connectionIsBroken", String.valueOf(this.connectionIsBroken));
        hashtable.put("recoverInProcess", String.valueOf(this.recoverInProcess));
        hashtable.put("failoverEnabled", String.valueOf(this.failoverEnabled));
        hashtable.put("imqReconnectEnabled", String.valueOf(this.imqReconnect));
        hashtable.put("isConnectedToHABroker", String.valueOf(this.isConnectedToHABroker));
        if (this.JMQBrokerList != null) {
            hashtable.put("JMQBrokerList", this.JMQBrokerList);
        }
        if (this.JMQClusterID != null) {
            hashtable.put("JMQClusterID", this.JMQClusterID);
        }
        if (this.JMQStoreOwner != null) {
            hashtable.put("JMQStoreOwner", this.JMQStoreOwner);
        }
        if (this.JMQStoreSession != null) {
            hashtable.put("JMQStoreSession", String.valueOf(this.JMQStoreSession));
        }
        boolean bl2 = false;
        if (this.exceptionListener != null) {
            bl2 = true;
        }
        hashtable.put("IsExceptionListenerSet", String.valueOf(bl2));
        if (this.readChannel != null) {
            hashtable.put("readChannnelIsClosed", String.valueOf(this.readChannel.isClosed));
            hashtable.put("readChannnelReceivedGoodByeReply", String.valueOf(this.readChannel.receivedGoodByeReply));
        }
        if (this.protocolHandler != null) {
            hashtable.put("protocolHandlerIsClosed", String.valueOf(this.protocolHandler.isClosed()));
            hashtable.put("UserBrokerInfo", this.protocolHandler.getUserBrokerInfo());
        }
        hashtable.put("FlowControl", this.flowControl.getDebugState(this));
        hashtable.put("# sessions", String.valueOf(this.sessionTable.size()));
        int n = 0;
        Enumeration enumeration = this.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            traceable = (SessionImpl)enumeration.nextElement();
            hashtable.put("Session[" + n + "]", ((SessionImpl)traceable).getDebugState(bl));
            ++n;
        }
        hashtable.put("# connectionConsumers", String.valueOf(this.connectionConsumerTable.size()));
        n = 0;
        enumeration = this.connectionConsumerTable.elements();
        while (enumeration.hasMoreElements()) {
            traceable = (ConnectionConsumerImpl)enumeration.nextElement();
            hashtable.put("ConnectionConsuer[" + n + "]", ((ConnectionConsumerImpl)traceable).getDebugState(bl));
            ++n;
        }
        return hashtable;
    }

    public Object TEST_GetAttribute(String string) {
        if (string.startsWith("FlowControl")) {
            return this.flowControl.TEST_GetAttribute(string, this);
        }
        return null;
    }

    public void printDebugState() {
        try {
            DebugPrinter debugPrinter = new DebugPrinter(2);
            Hashtable hashtable = this.getDebugState(false);
            debugPrinter.setHashtable(hashtable);
            debugPrinter.println();
            debugPrinter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new UnifiedSessionImpl(this, bl, n);
    }

    public XASession createXASession() throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new XASessionImpl(this, false, 0);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createUnifiedConnectionConsumer(destination, string, serverSessionPool, n, null, false);
    }

    protected QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new QueueSessionImpl(this, bl, n);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createUnifiedConnectionConsumer((Destination)queue, string, serverSessionPool, n, null, false);
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        this.checkConnectionState();
        TopicSessionImpl topicSessionImpl = new TopicSessionImpl(this, bl, n);
        this.setClientIDFlag();
        return topicSessionImpl;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createUnifiedConnectionConsumer((Destination)topic, string, serverSessionPool, n, null, false);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        return this.createUnifiedConnectionConsumer((Destination)topic, string2, serverSessionPool, n, string, true);
    }

    private ConnectionConsumer createUnifiedConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n, String string2, boolean bl) throws JMSException {
        Object object;
        String string3;
        this.checkConnectionState();
        if (bl && (string2 == null || "".equals(string2))) {
            string3 = AdministeredObject.cr.getKString("C4066", "\"\"");
            object = new JMSException(string3, "C4066");
            ExceptionHandler.throwJMSException((JMSException)((Object)object));
        }
        if (n < 1) {
            string3 = String.valueOf(n);
            object = AdministeredObject.cr.getKString("C4030", string3);
            JMSException jMSException = new JMSException(object, "C4030");
            ExceptionHandler.throwJMSException(jMSException);
        }
        int n2 = 1;
        object = this.getProperty("imqLoadMaxToServerSession");
        if (object != null && object.equals("true")) {
            n2 = n;
        }
        this.setClientIDFlag();
        return new ConnectionConsumerImpl(this, destination, string, serverSessionPool, n2, string2);
    }

    public Session createSession(int n) throws JMSException {
        this.checkConnectionState();
        this.setClientIDFlag();
        return new UnifiedSessionImpl(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventListener(EventListener eventListener) throws JMSException {
        this.checkConnectionState();
        Object object = this.syncObj;
        synchronized (object) {
            if (eventListener != null) {
                this.constructEventHandler();
            }
            this.eventListener = eventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListener getEventListener() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.eventListener;
        }
    }

    public String getBrokerAddress() {
        String string = null;
        try {
            string = this.getProtocolHandler().getConnectionHandler().getBrokerAddress();
        }
        catch (Exception exception) {
            string = this.getLastContactedBrokerAddress();
        }
        return string;
    }

    public String getBrokerAddressList() {
        return this.JMQBrokerList;
    }

    public boolean isConnectedToHABroker() {
        return this.isConnectedToHABroker;
    }

    public boolean getIsCloseCalled() {
        return this.isCloseCalled;
    }

    private void constructEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler(this);
        }
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void triggerConnectionReconnectedEvent() {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionReconnectedEvent();
        } else {
            this.setReconnecting(false);
        }
        this.logLifeCycle("E301");
    }

    public void triggerConnectionReconnectFailedEvent(JMSException jMSException) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionReconnectFailedEvent(jMSException, this.lastContactedBrokerAddress);
        }
        this.logLifeCycle("E401");
    }

    public void triggerConnectionClosingEvent(long l) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionClosingEvent("E101", l);
        }
        this.logLifeCycle("E101");
    }

    public void triggerConnectionClosedEvent(String string, JMSException jMSException) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionClosedEvent(string, jMSException);
        }
        this.logLifeCycle(string);
    }

    public void triggerConnectionExitEvent(JMSException jMSException) {
        if (this.eventListener != null) {
            this.eventHandler.triggerConnectionExitEvent(jMSException, this.exceptionListener);
        } else if (this.exceptionListener != null) {
            this.exceptionListener.onException(jMSException);
        }
    }

    public void triggerConnectionAddressListChangedEvent(String string) {
        if (this.eventListener != null && this.extendedEventNotification) {
            this.eventHandler.triggerConnectionAddressListChangedEvent(string);
        }
        this.logLifeCycle("E600");
    }

    public void logLifeCycle(String string) {
        if (connectionLogger.isLoggable(Level.FINE)) {
            connectionLogger.log(Level.FINE, string, this);
        }
    }

    public boolean shouldUpdateAddressList() {
        boolean bl = false;
        bl = this.JMQBrokerList == null ? false : !this.JMQBrokerList.equals(this.savedJMQBrokerList);
        return bl;
    }

    public void setLastContactedBrokerAddress(String string) {
        this.lastContactedBrokerAddress = string;
    }

    public String getLastContactedBrokerAddress() {
        return this.lastContactedBrokerAddress;
    }

    public static Logger getConnectionLogger() {
        return connectionLogger;
    }

    public synchronized void setExtendedEventNotification(boolean bl) {
        this.extendedEventNotification = bl;
    }

    public synchronized boolean getExtendedEventNotification() {
        return this.extendedEventNotification;
    }

    public long getTimeout() {
        return this.protocolHandler.getTimeout();
    }

    public synchronized void setEnableSharedClientID(boolean bl) {
        this.imqEnableSharedClientID = bl;
    }

    public synchronized boolean getEnableSharedClientID() {
        return this.imqEnableSharedClientID;
    }

    public synchronized void setEnableSharedSubscriptions(boolean bl) {
        this.imqEnableSharedSubscriptions = bl;
    }

    public synchronized boolean getEnableSharedSubscriptions(boolean bl) {
        return this.imqEnableSharedSubscriptions;
    }

    public void setConnectedToHABroker() {
        if (this.isHAEnabled()) {
            this.isConnectedToHABroker = true;
            if (!"ADMIN".equals(this.connectionType)) {
                this.imqReconnect = true;
                this.configuration.setProperty("imqReconnectEnabled", Boolean.toString(true));
                connectionLogger.fine("Connected to HA broker, auto-reconnect is enabled");
            } else {
                connectionLogger.fine("*** admin user, no auto-reconnect");
            }
        } else {
            String string = AdministeredObject.cr.getKString("I112", this.getLastContactedBrokerAddress());
            connectionLogger.log(Level.WARNING, string);
        }
    }
}

