/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.web.PESessionLockingStandardPipeline;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;

public class SessionLockingStandardPipeline
extends PESessionLockingStandardPipeline {
    static final String PROXY_JROUTE_NAME = "proxy-jroute";
    static final String JROUTE_NAME = "JROUTE";

    public SessionLockingStandardPipeline(Container container) {
        super(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("entering NEW SessionLockingStandardPipeline>>invoke");
        }
        long startTime = 0L;
        if (isMonitoringEnabled) {
            startTime = System.currentTimeMillis();
        }
        try {
            super.invoke(request, response);
        }
        finally {
            if (isMonitoringEnabled) {
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                WebModuleStatistics stats = this.getWebModuleStatistics();
                if (stats != null) {
                    stats.processPipeline(elapsedTime);
                }
            }
        }
    }

    WebModuleStatistics getWebModuleStatistics() {
        WebModuleStatistics stats = null;
        Context ctx = (Context)this.getContainer();
        Manager mgr = ctx.getManager();
        if (!(mgr instanceof StandardManager)) {
            ReplicationManagerBase haMgr = (ReplicationManagerBase)mgr;
            stats = haMgr.getWebModuleStatistics();
        }
        return stats;
    }

    protected boolean lockSession(Request request) throws ServletException {
        boolean result = false;
        Session sess = this.getSession(request, true);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN LOCK_SESSION: sess =" + sess);
        }
        if (sess != null) {
            long pollTime = 200L;
            int maxNumberOfRetries = 7;
            int tryNumber = 0;
            boolean keepTrying = true;
            boolean lockResult = false;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("locking session: sess =" + sess);
            }
            StandardSession haSess = (StandardSession)sess;
            while (keepTrying) {
                lockResult = haSess.lockForeground();
                if (lockResult) {
                    keepTrying = false;
                    result = true;
                    break;
                }
                if (++tryNumber < maxNumberOfRetries) {
                    this.threadSleep(pollTime *= 2L);
                    continue;
                }
                _logger.warning("this should not happen-breaking background lock: sess =" + sess);
                haSess.unlockBackground();
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("finished locking session: sess =" + sess);
                _logger.finest("LOCK = " + haSess.getSessionLock());
            }
        }
        return result;
    }

    private Session getSession(Request request, boolean forLock) {
        ServletRequest servletReq = request.getRequest();
        HttpServletRequest httpReq = (HttpServletRequest)servletReq;
        HttpSession httpSess = httpReq.getSession(false);
        if (httpSess == null) {
            return null;
        }
        String id = httpSess.getId();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("SESSION_ID=" + id);
        }
        Manager mgr = this.getContainer().getManager();
        PersistentManagerBase pmb = (PersistentManagerBase)mgr;
        Session sess = null;
        try {
            if (forLock) {
                sess = pmb.findSession(id, this.hasFailoverOccurred(request));
                this.resetSession((HttpServletRequest)servletReq, sess);
            } else {
                sess = pmb.findSession(id, false);
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("RETRIEVED_SESSION=" + sess);
        }
        return sess;
    }

    private void resetSession(HttpServletRequest servletReq, Session sess) {
        CoyoteRequest coyoteRequest = this.getCoyoteRequest((ServletRequest)servletReq);
        coyoteRequest.setSession(sess);
    }

    private CoyoteRequest getCoyoteRequest(ServletRequest request) {
        CoyoteRequest coyoteRequest = null;
        ServletRequest current = request;
        while (current != null) {
            if (current instanceof CoyoteRequestFacade) {
                coyoteRequest = ((CoyoteRequestFacade)current).getUnwrappedCoyoteRequest();
                break;
            }
            if (!(current instanceof ServletRequestWrapper)) break;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        return coyoteRequest;
    }

    private boolean hasFailoverOccurred(Request request) {
        String jrouteId = request.getJrouteId();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in hasFailoverOccurred: jrouteId = " + jrouteId);
        }
        if (jrouteId == null) {
            return false;
        }
        HttpServletRequest httpReq = (HttpServletRequest)request.getRequest();
        Enumeration headers = httpReq.getHeaders(PROXY_JROUTE_NAME);
        String proxyJRouteValue = null;
        if (headers.hasMoreElements()) {
            proxyJRouteValue = (String)headers.nextElement();
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in hasFailoverOccurred: proxyJRouteValue = " + proxyJRouteValue);
        }
        if (proxyJRouteValue == null) {
            return false;
        }
        return !proxyJRouteValue.equalsIgnoreCase(jrouteId);
    }
}

