/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GMSNotEnabledException;
import com.sun.enterprise.ee.cms.core.GMSNotInitializedException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.SimpleInstanceArranger;
import com.sun.enterprise.web.ReplicationReceiver;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;

public class ReplicationHealthChecker
implements Runnable {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private static boolean _replicationPartnerOperationalFlag = true;
    private static boolean _replicationCommunicationOperationalFlag = false;
    private BooleanWrapper _healthCheckEnabledFlag = new BooleanWrapper();
    private static final ReplicationHealthChecker _soleInstance = new ReplicationHealthChecker();
    private static ReplicationReceiver _replicationReceiver = null;
    private static final Object _monitor = new Object();
    private static final Object _unloadMonitor = new Object();
    protected static boolean runtimeHealthCheckExceptionReported = false;
    protected static boolean runtimeHealthFailureErrorReported = false;
    private static final AtomicBoolean stoppingFlag = new AtomicBoolean(false);
    private static final AtomicBoolean clusterStoppingFlag = new AtomicBoolean(false);
    private static final AtomicInteger dispatchThreadCount = new AtomicInteger(0);
    private static final AtomicBoolean flushingFlag = new AtomicBoolean(false);
    private static final AtomicBoolean flushThreadWaitingFlag = new AtomicBoolean(false);
    private static CountDownLatch doneSignal = null;
    private static int _sleepIntervalSeconds = 5;
    protected int replicationHealthcheckIntervalInSeconds = -1;
    protected boolean started = false;
    protected Thread thread = null;
    protected volatile boolean threadDone = false;
    private volatile long instanceStartTime = -1L;
    protected String _threadName = "ReplicationHealthChecker";

    public static ReplicationHealthChecker getInstance() {
        return _soleInstance;
    }

    public String getThreadName() {
        return this._threadName;
    }

    public long getInstanceStartTime() {
        return this.instanceStartTime;
    }

    public void setInstanceStartTime(long value) {
        this.instanceStartTime = value;
    }

    public boolean isInstanceStarted() {
        return this.getTimeSinceInstanceStart() >= 0L;
    }

    public boolean isTimeSinceInstanceStartLessThan(long duration) {
        if (!this.isInstanceStarted()) {
            return false;
        }
        return this.getTimeSinceInstanceStart() < duration;
    }

    public long getTimeSinceInstanceStart() {
        long sTime = this.getInstanceStartTime();
        if (sTime == -1L) {
            return -1L;
        }
        return System.currentTimeMillis() - sTime;
    }

    public static ReplicationReceiver getReplicationReceiver() {
        return _replicationReceiver;
    }

    public static void setReplicationReceiver(ReplicationReceiver replicationReceiver) {
        _replicationReceiver = replicationReceiver;
    }

    public static boolean isReplicationPartnerOperational() {
        return _replicationPartnerOperationalFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setReplicationPartnerOperational(boolean value) {
        Object object = _monitor;
        synchronized (object) {
            if (!value) {
                System.out.println("setReplicationPartnerOperational:false stack dump follows:");
            } else {
                System.out.println("setReplicationPartnerOperational:true stack dump follows:");
            }
            _replicationPartnerOperationalFlag = value;
        }
    }

    public static boolean isReplicationCommunicationOperational() {
        return _replicationCommunicationOperationalFlag;
    }

    public static void setReplicationCommunicationOperational(boolean value) {
        if (!value) {
            System.out.println("setReplicationCommunicationOperational:false stack dump follows:");
        } else {
            System.out.println("setReplicationCommunicationOperational:true stack dump follows:");
        }
        ReplicationHealthChecker.setReplicationCommunicationOperational(value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setReplicationCommunicationOperational(boolean value, boolean report) {
        Object object = _monitor;
        synchronized (object) {
            _replicationCommunicationOperationalFlag = value;
            if (!value && !runtimeHealthFailureErrorReported && report) {
                System.out.println("ReplicationHealthChecker:health failure:stopping replication: check instance");
                runtimeHealthFailureErrorReported = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportError(String message) {
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        Object object = _monitor;
        synchronized (object) {
            if (!runtimeHealthFailureErrorReported) {
                runtimeHealthFailureErrorReported = true;
                System.out.println(message);
            }
        }
    }

    private boolean doPipesExist() {
        return ReplicationHealthChecker.isReplicationCommunicationOperational();
    }

    boolean doPipeTest() {
        ReplicationState testState = this.createHealthPingState();
        testState.setAckRequired(true);
        ReplicationState resultState = this.doTransmit(testState);
        return resultState != null;
    }

    protected ReplicationState doTransmit(ReplicationState transmitState) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationStateHC(transmitState);
        return resultState;
    }

    ReplicationState createHealthPingState() {
        return new ReplicationState("web", "pingtest", "pingappid", 0L, 0L, 0L, null, null, null, "healthCheck", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOkToProceed() {
        boolean condition;
        if (ReplicationHealthChecker.isFlushing()) {
            return true;
        }
        if (ReplicationHealthChecker.isClusterStopping()) {
            return false;
        }
        boolean bl = condition = ReplicationHealthChecker.isReplicationPartnerOperational() && ReplicationHealthChecker.isReplicationCommunicationOperational();
        if (condition) {
            return true;
        }
        Object object = _monitor;
        synchronized (object) {
            if (!condition && !runtimeHealthFailureErrorReported) {
                System.out.println("ReplicationHealthChecker:health failure");
                System.out.println("isReplicationPartnerOperational()=" + ReplicationHealthChecker.isReplicationPartnerOperational());
                System.out.println("isReplicationCommunicationOperational()=" + ReplicationHealthChecker.isReplicationCommunicationOperational());
                runtimeHealthFailureErrorReported = true;
            }
        }
        return condition;
    }

    protected boolean doReplicationHealthCheck() {
        return this.doReplicationHealthCheck(false);
    }

    protected boolean doReplicationHealthCheck(boolean quickCheck) {
        boolean healthyWithPipes;
        if (!ReplicationHealthChecker.isHealthCheckingEnabled()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("health check disabled - skipping");
            }
            return true;
        }
        if (runtimeHealthCheckExceptionReported) {
            return true;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("health check enabled - entering isReplicationPartnerOk()");
        }
        boolean replicationPartnerAlive = this.isReplicationPartnerOk();
        boolean lastReplicationPartnerState = ReplicationHealthChecker.isReplicationPartnerOperational();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationHealthCheck: replication partner is alive: " + replicationPartnerAlive);
        }
        boolean pipesExist = true;
        if (!lastReplicationPartnerState && replicationPartnerAlive) {
            pipesExist = this.doPipesExist();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("ReplicationHealthCheck: pipes exist: " + pipesExist);
            }
        }
        boolean bl = healthyWithPipes = replicationPartnerAlive && pipesExist;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicationHealthCheck: replica healthyWithPipes: " + healthyWithPipes);
        }
        ReplicationHealthChecker.setReplicationPartnerOperational(healthyWithPipes);
        if (lastReplicationPartnerState && !replicationPartnerAlive && !quickCheck) {
            this.doReplicationShutdownCleanup();
        }
        return ReplicationHealthChecker.isReplicationPartnerOperational();
    }

    private void doReplicationShutdownCleanup() {
    }

    String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    String getReshapeReplicateToInstanceName(String formerPartnerInstance) {
        String myName = this.getInstanceName();
        SimpleInstanceArranger arranger = new SimpleInstanceArranger();
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        List instanceNames = this.getConservativeMemberList(formerPartnerInstance);
        arranger.init(instanceNames);
        String result = arranger.getReplicaPeerName(myName);
        System.out.println("getReplicaPeerName = " + result);
        return result;
    }

    public void displayCurrentGroupMembers() {
        List coreMembers = this.getCurrentGroupMembersViaGMS();
        for (int i = 0; i < coreMembers.size(); ++i) {
            System.out.println("member[" + i + "]=" + coreMembers.get(i));
        }
    }

    public List getConservativeMemberList(String formerPartnerInstance) {
        List adminList = this.getCurrentGroupMembersViaAdmin();
        List gmsList = this.getCurrentGroupMembersViaGMS();
        if (formerPartnerInstance != null) {
            adminList.remove(formerPartnerInstance);
            gmsList.remove(formerPartnerInstance);
        }
        if (gmsList.size() <= adminList.size()) {
            return gmsList;
        }
        return adminList;
    }

    public List getCurrentGroupMembersViaAdmin() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        ArrayList instanceNames = lookup.getServerNamesInCluster();
        return instanceNames;
    }

    public List getCurrentGroupMembersViaGMS() {
        List coreMembers = new ArrayList();
        try {
            GroupManagementService gms = GMSFactory.getGMSModule((String)this.getClusterName());
            GroupHandle groupHandle = gms.getGroupHandle();
            coreMembers = groupHandle.getCurrentCoreMembers();
        }
        catch (GMSNotInitializedException ex1) {
        }
        catch (GMSNotEnabledException ex2) {
        }
        catch (GMSException gMSException) {
            // empty catch block
        }
        return coreMembers;
    }

    private String getClusterName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getClusterName();
    }

    public boolean isReplicationPartnerOk() {
        boolean result = true;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("isReplicationPartnerOk() begin:runtimeHealthCheckExceptionReported: " + runtimeHealthCheckExceptionReported);
        }
        return true;
    }

    protected int getReplicationHealthcheckIntervalInSecondsFromConfig() {
        ServerConfigLookup config = new ServerConfigLookup();
        return config.getHaStoreHealthcheckIntervalInSecondsFromConfig();
    }

    protected int getReplicationHealthcheckIntervalInSeconds() {
        if (this.replicationHealthcheckIntervalInSeconds > 0) {
            return this.replicationHealthcheckIntervalInSeconds;
        }
        this.replicationHealthcheckIntervalInSeconds = this.getReplicationHealthcheckIntervalInSecondsFromConfig();
        return this.replicationHealthcheckIntervalInSeconds;
    }

    boolean isIStarted() {
        return this.started;
    }

    public static boolean isStopping() {
        return stoppingFlag.get();
    }

    static void setStopping(boolean value) {
        if (value) {
            ReplicationHealthChecker.setReplicationCommunicationOperational(value, false);
        }
        stoppingFlag.set(value);
    }

    public static boolean isFlushing() {
        return flushingFlag.get();
    }

    static void setFlushing(boolean value) {
        flushingFlag.set(value);
    }

    public static boolean isFlushThreadWaiting() {
        return flushThreadWaitingFlag.get();
    }

    public static void incrementDispatchThreadCount() {
        dispatchThreadCount.incrementAndGet();
    }

    public static int getDispatchThreadCount() {
        return dispatchThreadCount.get();
    }

    public static void setFlushThreadWaiting(boolean value) {
        flushThreadWaitingFlag.set(value);
    }

    public static synchronized CountDownLatch getDoneSignal() {
        if (doneSignal == null) {
            int numberOfDispatchThreads = ReplicationHealthChecker.getDispatchThreadCount();
            doneSignal = new CountDownLatch(numberOfDispatchThreads);
        }
        return doneSignal;
    }

    public static Object getUnloadMonitor() {
        return _unloadMonitor;
    }

    public boolean isPipeInitializationCalled() {
        if (_replicationReceiver == null) {
            return false;
        }
        return ((JxtaReplicationReceiver)_replicationReceiver).isPipeInitializationCalled();
    }

    public static boolean isClusterStopping() {
        return clusterStoppingFlag.get();
    }

    static void setClusterStopping(boolean value) {
        clusterStoppingFlag.set(value);
    }

    Thread getThread() {
        return this.thread;
    }

    protected void threadSleep() {
        _sleepIntervalSeconds = this.getReplicationHealthcheckIntervalInSeconds();
        try {
            Thread.sleep((long)_sleepIntervalSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.doReplicationHealthCheck();
        }
    }

    private static void initializeHealthCheckEnabledFlag() {
        ServerConfigLookup config = new ServerConfigLookup();
        BooleanWrapper healthCheckEnabledWrapper = ReplicationHealthChecker.getInstance().getHealthCheckEnabledWrapper();
        if (healthCheckEnabledWrapper != null) {
            healthCheckEnabledWrapper.setValue(config.getHadbHealthCheckFromConfig());
        }
    }

    BooleanWrapper getHealthCheckEnabledWrapper() {
        return this._healthCheckEnabledFlag;
    }

    private static boolean isHealthCheckingEnabled() {
        return true;
    }

    public void start() throws LifecycleException {
        ReplicationHealthChecker.initializeHealthCheckEnabledFlag();
        if (this.started) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Replication health checking enabled");
        }
        this.threadStart();
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.threadStop();
        this.started = false;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    class BooleanWrapper {
        Boolean _value = null;

        public BooleanWrapper() {
        }

        public BooleanWrapper(boolean value) {
            this._value = new Boolean(value);
        }

        synchronized boolean getValue() {
            if (!this.isInitialized()) {
                return false;
            }
            return this._value;
        }

        synchronized void setValue(boolean value) {
            this._value = new Boolean(value);
        }

        boolean isInitialized() {
            return this._value != null;
        }
    }
}

