/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.JxtaReceiverPipeManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaStarter;
import com.sun.enterprise.ee.web.sessmgmt.JxtaUtil;
import com.sun.enterprise.ee.web.sessmgmt.PipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.JxtaServerPipe;
import net.jxta.util.PipeEventListener;

public class JxtaServerPipeWrapper
implements Runnable {
    public static final int ITERATIONS = 100;
    private PeerGroup netPeerGroup = null;
    private PipeAdvertisement pipeAdv;
    private JxtaServerPipe serverPipe;
    private static final MimeMediaType MEDIA_TYPE = new MimeMediaType("application/bin");
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private static final String SenderMessage = "pipe_tutorial";
    private static final String MESSAGE_MODE = "message_mode";
    private static final String MODE_STARTUP = "startup";
    private Thread acceptThread = null;
    private boolean threadContinue = false;

    private void startJxta(boolean isServer) {
        JxtaStarter jxtaStarter = JxtaStarter.createInstance();
        jxtaStarter.startJxta(isServer);
        this.netPeerGroup = jxtaStarter.getNetPeerGroup();
    }

    public void start() {
        this.startJxta(true);
        try {
            this.pipeAdv = JxtaUtil.getPipeAdvertisement(this.getInstanceName());
            this.serverPipe = new JxtaServerPipe(this.netPeerGroup, this.pipeAdv);
            this.serverPipe.setPipeTimeout(0);
        }
        catch (Exception e) {
            System.out.println("failed to bind to the JxtaServerPipe due to the following exception");
            e.printStackTrace();
        }
        this.acceptThread = new Thread(this);
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
    }

    public void stop() {
        ReplicationHealthChecker.setStopping(true);
        this.stopAcceptThread();
        this.closeServerPipe();
        this.closePipes();
    }

    public void restartLastGood(String partnerInstanceName) {
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        this.closeConnections();
        System.out.println("JxtaServerPipeWrapper restarting");
        try {
            this.pipeAdv = JxtaUtil.getPipeAdvertisement(this.getInstanceName());
            this.serverPipe = new JxtaServerPipe(this.netPeerGroup, this.pipeAdv);
            this.serverPipe.setPipeTimeout(0);
        }
        catch (Exception e) {
            System.out.println("failed to bind to the JxtaServerPipe due to the following exception");
            e.printStackTrace();
        }
        this.acceptThread = new Thread(this);
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
    }

    public void restart(String partnerInstanceName) {
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        this.closePipes(partnerInstanceName);
    }

    void closeConnections() {
        ReplicationHealthChecker.setReplicationCommunicationOperational(false);
        this.stopAcceptThread();
        this.closeServerPipe();
        this.closePipes();
    }

    private void closeServerPipe() {
        try {
            this.serverPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverPipe = null;
    }

    public void closePipes() {
        JxtaReceiverPipeManager pipeMgr = JxtaReceiverPipeManager.createInstance();
        pipeMgr.closePooledPipes();
    }

    public void respondToFailure(String failedPartnerInstance) {
        this.closePipes(failedPartnerInstance);
    }

    public void closePipes(String partnerInstanceName) {
        JxtaReceiverPipeManager pipeMgr = JxtaReceiverPipeManager.createInstance();
        pipeMgr.closePooledPipes(partnerInstanceName);
    }

    String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    int getNumberOfPipes() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        int result = lookup.getNumberOfReplicationPipesFromConfig();
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    public void run() {
        int numPipes = this.getNumberOfPipes();
        this.initForNewPipeRequests();
    }

    public String initPipes(int numPipes) {
        int i = 0;
        Object firstPipe = null;
        boolean connected = false;
        System.out.println("Waiting for JxtaBidiPipe connections on JxtaServerPipe");
        ArrayList<PipeWrapper> pipeWrappers = new ArrayList<PipeWrapper>();
        String sourceInstanceName = null;
        while (i < numPipes) {
            try {
                System.out.println("JxtaServerPipeWrapper:JxtaBidiPipe# " + i + " waiting to accept");
                JxtaBiDiPipe bipipe = this.serverPipe.accept();
                sourceInstanceName = bipipe.getRemotePeerAdvertisement().getName();
                if (bipipe == null) continue;
                PipeWrapper pipeWrapper = new PipeWrapper("pipe#" + i, "R", sourceInstanceName, bipipe);
                bipipe.setMessageListener((PipeMsgListener)pipeWrapper);
                bipipe.setPipeEventListener((PipeEventListener)pipeWrapper);
                if (i == 0) {
                    JxtaReceiverPipeManager.createInstance().setHealthPipeWrapper(pipeWrapper, sourceInstanceName);
                } else {
                    pipeWrappers.add(pipeWrapper);
                }
                System.out.println("JxtaServerPipeWrapper:JxtaBidiPipe " + i + " accepted, ready for sending messages to the other end");
                ++i;
            }
            catch (Exception e) {
                e.printStackTrace();
                return sourceInstanceName;
            }
        }
        JxtaReceiverPipeManager.createInstance().initPipePool(pipeWrappers, sourceInstanceName);
        return sourceInstanceName;
    }

    public void initForNewPipeRequests() {
        this.threadContinue = true;
        System.out.println("Waiting for additional JxtaBidiPipe connections on JxtaServerPipe");
        String sourceInstanceName = null;
        while (this.threadContinue) {
            try {
                System.out.println("JxtaServerPipeWrapper:JxtaBidiPipe# waiting to accept");
                JxtaBiDiPipe bipipe = this.serverPipe.accept();
                sourceInstanceName = bipipe.getRemotePeerAdvertisement().getName();
                System.out.println("JxtaServerPipeWrapper:incoming pipe request accepted - sourceInstanceName=" + sourceInstanceName);
                System.out.println("JxtaServerPipeWrapper:incoming pipe request accepted - pipeAdv = " + bipipe.getRemotePeerAdvertisement().toString());
                if (bipipe == null) continue;
                PipeWrapper pipeWrapper = new PipeWrapper("pipe", "R", sourceInstanceName, bipipe);
                bipipe.setMessageListener((PipeMsgListener)pipeWrapper);
                bipipe.setPipeEventListener((PipeEventListener)pipeWrapper);
                JxtaReceiverPipeManager.createInstance().addPipeWrapper(pipeWrapper, sourceInstanceName);
                System.out.println("JxtaServerPipeWrapper:JxtaBidiPipe accepted added to pool(sourceInstanceName=" + sourceInstanceName + "), ready for sending messages to the other end");
            }
            catch (SocketException se) {
                this.threadContinue = false;
            }
            catch (Exception e) {
                if (!ReplicationHealthChecker.isStopping()) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }

    private void stopAcceptThread() {
        this.threadContinue = false;
        this.acceptThread.interrupt();
        try {
            this.acceptThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendTestMessages(String sourceInstanceName) {
        System.out.println("using health pipe: sending 100 messages to the other end");
        PipeWrapper pipeWrapper = JxtaReceiverPipeManager.createInstance().getHealthPipeWrapper(sourceInstanceName);
        JxtaBiDiPipe bipipe = pipeWrapper.getPipe();
        Thread thread = new Thread((Runnable)new ConnectionHandler(bipipe), "Connection Handler Thread");
        thread.start();
    }

    class ConnectionHandler
    implements Runnable,
    PipeMsgListener {
        JxtaBiDiPipe pipe = null;

        ConnectionHandler(JxtaBiDiPipe pipe) {
            this.pipe = pipe;
            pipe.setMessageListener((PipeMsgListener)this);
        }

        JxtaBiDiPipe getPipe() {
            return this.pipe;
        }

        public void pipeMsgEvent(PipeMsgEvent event) {
            Message msg = null;
            try {
                MessageElement msgElement;
                msg = event.getMessage();
                if (msg == null) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Received an empty message, returning");
                    }
                    return;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Received a response");
                }
                if ((msgElement = msg.getMessageElement(JxtaServerPipeWrapper.SenderMessage, JxtaServerPipeWrapper.SenderMessage)).toString() == null) {
                    System.out.println("null msg received");
                } else {
                    System.out.println("Message  :" + msgElement.toString());
                }
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace();
                }
                return;
            }
        }

        private void sendTestMessages(JxtaBiDiPipe pipe) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            String instanceName = lookup.getServerName();
            try {
                for (int i = 0; i < 100; ++i) {
                    Message msg = new Message();
                    String data = "Message #" + i + " From Instance " + instanceName;
                    msg.addMessageElement(JxtaServerPipeWrapper.MESSAGE_MODE, (MessageElement)new StringMessageElement(JxtaServerPipeWrapper.MESSAGE_MODE, JxtaServerPipeWrapper.MODE_STARTUP, null));
                    msg.addMessageElement(JxtaServerPipeWrapper.SenderMessage, (MessageElement)new StringMessageElement(JxtaServerPipeWrapper.SenderMessage, data, null));
                    System.out.println("Sending :" + data);
                    pipe.sendMessage(msg);
                }
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }

        public void run() {
            try {
                this.sendTestMessages(this.pipe);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

