/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.ee.web.sessmgmt.InputPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.JxtaConnectErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReceiverPipeManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaRepair;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.JxtaSenderPipeManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaStarter;
import com.sun.enterprise.ee.web.sessmgmt.JxtaUtil;
import com.sun.enterprise.ee.web.sessmgmt.PipeConnectionResult;
import com.sun.enterprise.ee.web.sessmgmt.PipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.SimpleInstanceArranger;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.PipeEventListener;
import org.apache.catalina.LifecycleException;

public class JxtaBiDiPipeWrapper
implements PipeMsgListener,
RendezvousListener,
Runnable {
    private PeerGroup netPeerGroup = null;
    private PipeAdvertisement pipeAdv;
    private PeerID peerID;
    private JxtaBiDiPipe pipe;
    private boolean waitForRendezvous = false;
    private boolean stopped = false;
    private volatile boolean attemptingConnection = false;
    private String rendezvousLock = "Rendezvous Lock";
    private RendezVousService rendezvous;
    private static final String SenderMessage = "pipe_tutorial";
    private static final String InstanceNameMessage = "instance_name";
    private static final String completeLock = "completeLock";
    private static final String CLUSTER_MEMBERS = "cluster_members";
    private int count = 0;
    private static final String MESSAGE_ID = "message_id";
    private static final String MESSAGE_COMMAND = "message_command";
    private static final String RETURN_MSG_COMMAND = "response";
    private static final String MESSAGE_READY = "ready";
    private static final String ReadyMessage = "ready";
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    protected JxtaConnectErrorManager errorMgr = null;
    protected String timeoutSecs = new Long(300L).toString();
    private CountDownLatch doneSignal = new CountDownLatch(1);

    public JxtaBiDiPipeWrapper() {
        long timeout = new Long(this.timeoutSecs);
        this.errorMgr = new JxtaConnectErrorManager(timeout);
    }

    public JxtaConnectErrorManager getErrorManager() {
        long timeout = new Long(this.timeoutSecs);
        return new JxtaConnectErrorManager(timeout);
    }

    public void start() {
        String partnerName;
        block6: {
            this.startJxta(false);
            partnerName = this.getReplicateToInstanceName();
            try {
                String value = System.getProperty("RDVWAIT", "false");
                this.waitForRendezvous = Boolean.valueOf(value);
                this.pipeAdv = JxtaUtil.getPipeAdvertisement(this.getReplicateToInstanceName());
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINEST)) break block6;
                _logger.finest("failed to bind the JxtaBiDiPipe due to the following exception");
                e.printStackTrace();
            }
        }
        this.doneSignal = new CountDownLatch(1);
        Thread acceptThread = new Thread(this);
        acceptThread.setDaemon(true);
        acceptThread.start();
        long startTime = System.currentTimeMillis();
        try {
            this.doneSignal.await(45L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.out.println("JxtaBiDiPipeWrapper after await: wait time = " + (System.currentTimeMillis() - startTime));
        this.testStartupAndReshapeIfNecessary(partnerName);
        ReplicationResponseRepository.getInstance().start();
        try {
            JxtaReplicationSender.createInstance().start();
        }
        catch (LifecycleException ex) {
            // empty catch block
        }
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        healthChecker.setInstanceStartTime(System.currentTimeMillis());
    }

    void testStartupAndReshapeIfNecessary(String partnerName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("testStartupAndReshapeIfNecessary...");
        }
        if (this.areCurrentPipesOk()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JxtaBiDiPipeWrapper>>startup completed successfully: no reshape needed");
            }
            return;
        }
        if (this.isAttemptingConnection()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JxtaBiDiPipeWrapper>>startup partner failed: reshape needed");
            }
            this.setAttemptingConnection(false);
            this.respondToFailure(partnerName, true);
        }
    }

    public void run() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper-run method");
        }
        this.initializePropagatedPipes();
        int numPipes = this.getNumberOfPipes();
        System.out.println("JxtaBiDiPipeWrapper>>run-numPipes=" + numPipes);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper-numPipes=" + numPipes);
        }
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        String proposedPartner = healthChecker.getReshapeReplicateToInstanceName(null);
        System.out.println("about to connectToInstance: " + proposedPartner);
        this.setAttemptingConnection(true);
        boolean pipesCreated = this.attemptConnectionNumberOfTries(3);
        System.out.println("JxtaBiDiPipeWrapper:run:pipesCreated=" + pipesCreated);
        if (pipesCreated) {
            this.sentTestPropagatedMessage();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper:run() complete");
            }
            ReplicationHealthChecker.setReplicationCommunicationOperational(true);
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper>>run was unsuccessful: quitting run");
            }
            ReplicationHealthChecker.setReplicationCommunicationOperational(false);
        }
        this.setAttemptingConnection(false);
        System.out.println("doneSignal.countdown()");
        this.doneSignal.countDown();
    }

    private boolean attemptConnectionNumberOfTries(int numberOfTries) {
        boolean result = false;
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        for (int count = 0; count < numberOfTries; ++count) {
            String proposedPartner = healthChecker.getReshapeReplicateToInstanceName(null);
            System.out.println("about to connectToInstance: " + proposedPartner);
            result = this.connectToInstance(proposedPartner, false);
            if (result) break;
            this.closeNonPropagatedSenderConnections();
        }
        return result;
    }

    private void interruptConnectionAttempt() {
        this.setAttemptingConnection(false);
        try {
            Thread.currentThread();
            Thread.sleep(15000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setAttemptingConnection(boolean value) {
        this.attemptingConnection = value;
    }

    boolean isAttemptingConnection() {
        return this.attemptingConnection;
    }

    boolean isAlone() {
        return !this.isAttemptingConnection() && !ReplicationHealthChecker.isReplicationCommunicationOperational();
    }

    String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    int getNumberOfPipes() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        int result = lookup.getNumberOfReplicationPipesFromConfig();
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    String getReplicateToInstanceName() {
        String myName = this.getInstanceName();
        SimpleInstanceArranger arranger = this.getSimpleArranger();
        String result = arranger.getReplicaPeerName(myName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("getReplicaPeerName = " + result);
        }
        return result;
    }

    String getReplicatedFromInstanceName() {
        String myName = this.getInstanceName();
        SimpleInstanceArranger arranger = this.getSimpleArranger();
        String result = arranger.getReplicatedFromPeerName(myName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("getReplicatedFromPeerName = " + result);
        }
        return result;
    }

    SimpleInstanceArranger getSimpleArranger() {
        SimpleInstanceArranger arranger = new SimpleInstanceArranger();
        ServerConfigLookup lookup = new ServerConfigLookup();
        ArrayList instanceNames = lookup.getServerNamesInCluster();
        arranger.init(instanceNames);
        return arranger;
    }

    boolean isSizeTwoCluster() {
        String replicatedFrom = this.getReplicatedFromInstanceName();
        String replicateTo = this.getReplicateToInstanceName();
        if (replicatedFrom == null || replicateTo == null) {
            return false;
        }
        return replicatedFrom.equals(replicateTo);
    }

    ArrayList getClusterInstanceNamesList() {
        ArrayList<String> instanceNames = new ArrayList<String>();
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceNamesString = lookup.getAvailabilityServicePropertyString(CLUSTER_MEMBERS);
        if (instanceNamesString == null) {
            return instanceNames;
        }
        String[] instancesArray = instanceNamesString.split(",");
        List<String> instancesList = Arrays.asList(instancesArray);
        for (int i = 0; i < instancesList.size(); ++i) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("getClusterInstanceNamesList:elem" + i + " = " + instancesList.get(i).trim());
            }
            instanceNames.add(instancesList.get(i).trim());
        }
        return instanceNames;
    }

    private void initializePropagatedPipes() {
        this.initializePropagatedOutputPipe();
        this.initializePropagatedInputPipeWrapper();
    }

    private void initializePropagatedOutputPipe() {
        OutputPipe op = this.createPropagatedOutputPipe();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("setting JxtaSenderPipeManagers bidipipewrapper = " + this);
        }
        JxtaSenderPipeManager.createInstance().setJxtaBiDiPipeWrapper(this);
        JxtaSenderPipeManager.createInstance().setPropagatedOutputPipe(op);
    }

    private void initializePropagatedInputPipeWrapper() {
        InputPipeWrapper ipWrapper = this.createPropagatedInputPipeWrapper();
        JxtaReceiverPipeManager.createInstance().setPropagatedInputPipeWrapper(ipWrapper);
    }

    private void closeHealthPipes() {
        this.closeSenderHealthPipe();
        this.closeReceiverHealthPipe();
    }

    private void closeSenderHealthPipe() {
        JxtaSenderPipeManager.createInstance().closeHealthPipeWrapper();
    }

    private void closeReceiverHealthPipe() {
        JxtaReceiverPipeManager.createInstance().closeHealthPipeWrapper();
    }

    private void closePropagatedPipes() {
        JxtaSenderPipeManager.createInstance().closePropagatedOutputPipe();
        JxtaReceiverPipeManager.createInstance().closePropagatedInputPipeWrapper();
    }

    private void sentTestPropagatedMessage() {
        OutputPipe outputPipe = JxtaSenderPipeManager.createInstance().getPropagatedOutputPipe();
        this.sendTestPropagatedMessages(outputPipe);
    }

    private void sendTestPropagatedMessages(OutputPipe pipe) {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceName = lookup.getServerName();
        try {
            for (int i = 0; i < 1; ++i) {
                Message msg = new Message();
                String data = "Propagated Message #" + i + " From Instance " + instanceName;
                msg.addMessageElement(SenderMessage, (MessageElement)new StringMessageElement(SenderMessage, data, null));
                msg.addMessageElement(InstanceNameMessage, (MessageElement)new StringMessageElement(InstanceNameMessage, instanceName, null));
                if (i == 0) {
                    String readyMsgString = "ready";
                    msg.addMessageElement("ready", (MessageElement)new StringMessageElement("ready", readyMsgString, null));
                    System.out.println("Sending :" + readyMsgString + ":" + instanceName);
                }
                System.out.println("Sending :" + data);
                pipe.send(msg);
            }
        }
        catch (Exception ie) {
            ie.printStackTrace();
        }
    }

    OutputPipe createPropagatedOutputPipe() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String instanceName = lookup.getServerName();
        PipeService pipeService = this.netPeerGroup.getPipeService();
        PipeAdvertisement pipeAdv = JxtaUtil.getPropagatedPipeAdvertisement();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("prop pipe adv: " + pipeAdv);
        }
        OutputPipe op = null;
        try {
            op = pipeService.createOutputPipe(pipeAdv, 100L);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return op;
    }

    private InputPipeWrapper createPropagatedInputPipeWrapper() {
        PipeService pipeService = this.netPeerGroup.getPipeService();
        PipeAdvertisement pipeAdv = JxtaUtil.getPropagatedPipeAdvertisement();
        InputPipe ip = null;
        InputPipeWrapper ipWrapper = new InputPipeWrapper();
        try {
            ip = pipeService.createInputPipe(pipeAdv, (PipeMsgListener)ipWrapper);
            ipWrapper.setPipe(ip);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return ipWrapper;
    }

    private boolean createPipes(int numPipes) {
        PipeConnectionResult connectionResult = null;
        ArrayList<PipeWrapper> pipeWrappers = new ArrayList<PipeWrapper>();
        for (int i = 0; i < numPipes; ++i) {
            try {
                JxtaBiDiPipe nextPipe = new JxtaBiDiPipe();
                nextPipe.setReliable(true);
                PipeWrapper pipeWrapper = new PipeWrapper("pipe#" + i, "S", this.getReplicateToInstanceName(), nextPipe);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("JxtaBiDiPipeWrapper: Attempting to establish a connection");
                }
                System.out.println("JxtaBiDiPipeWrapper:run:before connectPipeWithRetries");
                connectionResult = this.connectPipeWithRetries(nextPipe, pipeWrapper);
                System.out.println("JxtaBiDiPipeWrapper:run:after connectPipeWithRetries:connectionResult=" + connectionResult.isConnected());
                pipeWrapper = connectionResult.getPipeWrapper();
                if (!connectionResult.isConnected() || !this.isAttemptingConnection()) {
                    System.out.println("JxtaBiDiPipeWrapper>>unable to complete createPipes:breaking:i= " + i);
                    System.out.println("JxtaBiDiPipeWrapper>>createPipes:connectionResult: " + connectionResult.isConnected());
                    System.out.println("JxtaBiDiPipeWrapper>>createPipes:isAttemptingConnection(): " + this.isAttemptingConnection());
                    break;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("JxtaBiDiPipe pipe # " + i + " created");
                }
                if (i == 0) {
                    JxtaSenderPipeManager.createInstance().setHealthPipeWrapper(pipeWrapper);
                    continue;
                }
                pipeWrappers.add(pipeWrapper);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        System.out.println("JxtaBiDiPipeWrapper>>createPipes stage one complete:connectionResultIsConnected:" + connectionResult.isConnected());
        if (connectionResult.isConnected()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("sender pipe pool about to be initialized");
            }
            JxtaSenderPipeManager.createInstance().initPipePool(pipeWrappers);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("sender pipe pool initialized");
            }
        }
        return connectionResult.isConnected();
    }

    private boolean createPipes(int numPipes, PipeAdvertisement pipeAdvertisement, String newPartnerInstance) {
        System.out.println("JxtaBiDiPipeWrapper>>createPipes:newPartnerInstance: " + newPartnerInstance);
        PipeConnectionResult connectionResult = null;
        PeerID partnerPeerId = JxtaStarter.getPeerID(newPartnerInstance);
        ArrayList<PipeWrapper> pipeWrappers = new ArrayList<PipeWrapper>();
        for (int i = 0; i < numPipes; ++i) {
            try {
                JxtaBiDiPipe nextPipe = new JxtaBiDiPipe();
                nextPipe.setReliable(true);
                PipeWrapper pipeWrapper = new PipeWrapper("pipe#" + i, "S", newPartnerInstance, nextPipe);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("JxtaBiDiPipeWrapper: Attempting to establish a connection");
                }
                connectionResult = this.connectPipeWithRetries(nextPipe, pipeWrapper, pipeAdvertisement, partnerPeerId);
                pipeWrapper = connectionResult.getPipeWrapper();
                if (!connectionResult.isConnected() || !this.isAttemptingConnection()) {
                    System.out.println("JxtaBiDiPipeWrapper>>createPipes:breaking:i= " + i);
                    break;
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("JxtaBiDiPipe pipe # " + i + " created");
                }
                if (i == 0) {
                    JxtaSenderPipeManager.createInstance().setHealthPipeWrapper(pipeWrapper);
                    continue;
                }
                pipeWrappers.add(pipeWrapper);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        System.out.println("JxtaBiDiPipeWrapper>>createPipes stage one complete:connectionResultIsConnected:" + connectionResult.isConnected());
        if (connectionResult.isConnected()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("sender pipe pool about to be initialized");
            }
            JxtaSenderPipeManager.createInstance().initPipePool(pipeWrappers);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("sender pipe pool initialized");
            }
        }
        return connectionResult.isConnected();
    }

    private void createPipesPrevious(int numPipes) {
        ArrayList<PipeWrapper> pipeWrappers = new ArrayList<PipeWrapper>();
        for (int i = 0; i < numPipes; ++i) {
            try {
                JxtaBiDiPipe nextPipe = new JxtaBiDiPipe();
                nextPipe.setReliable(true);
                PipeWrapper pipeWrapper = new PipeWrapper("pipe#" + i, "S", this.getReplicateToInstanceName(), nextPipe);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("JxtaBiDiPipeWrapper: Attempting to establish a connection");
                }
                nextPipe.connect(this.netPeerGroup, null, this.pipeAdv, 300000, (PipeMsgListener)pipeWrapper);
                nextPipe.setPipeEventListener((PipeEventListener)pipeWrapper);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("JxtaBiDiPipe pipe # " + i + " created");
                }
                if (i == 0) {
                    JxtaSenderPipeManager.createInstance().setHealthPipeWrapper(pipeWrapper);
                    continue;
                }
                pipeWrappers.add(pipeWrapper);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("sender pipe pool about to be initialized");
        }
        JxtaSenderPipeManager.createInstance().initPipePool(pipeWrappers);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("sender pipe pool initialized");
        }
    }

    private PipeConnectionResult connectPipeWithRetries(JxtaBiDiPipe aPipe, PipeWrapper pipeWrapper) {
        return this.connectPipeWithRetries(aPipe, pipeWrapper, this.pipeAdv, this.peerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PipeConnectionResult connectPipeWithRetries(JxtaBiDiPipe aPipe, PipeWrapper pipeWrapper, PipeAdvertisement pipeAdvertisement, PeerID partnerPeerId) {
        PipeConnectionResult result = new PipeConnectionResult(pipeWrapper);
        JxtaConnectErrorManager anErrorMgr = this.getErrorManager();
        try {
            anErrorMgr.txStart();
            while (!anErrorMgr.isTxCompleted() && this.isAttemptingConnection() && !ReplicationHealthChecker.isStopping()) {
                try {
                    aPipe.connect(this.netPeerGroup, null, pipeAdvertisement, 10000, (PipeMsgListener)pipeWrapper);
                    aPipe.setPipeEventListener((PipeEventListener)pipeWrapper);
                    result.setConnected(true);
                    anErrorMgr.txEnd();
                }
                catch (IOException e) {
                    result.setConnected(false);
                    anErrorMgr.checkError(e);
                }
                catch (Exception e1) {
                    result.setConnected(false);
                    anErrorMgr.txEnd();
                }
            }
            anErrorMgr.txEnd();
        }
        catch (HATimeoutException tex) {
            pipeWrapper = null;
            result.setPipeWrapper(null);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper connectPipeWithRetries() timed out: " + tex.getMessage());
            }
        }
        finally {
            anErrorMgr.txEnd();
        }
        return result;
    }

    private PipeWrapper connectPipeWithRetriesLastGood(JxtaBiDiPipe aPipe, PipeWrapper pipeWrapper) {
        return this.connectPipeWithRetriesLastGood(aPipe, pipeWrapper, this.pipeAdv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PipeWrapper connectPipeWithRetriesLastGood(JxtaBiDiPipe aPipe, PipeWrapper pipeWrapper, PipeAdvertisement pipeAdvertisement) {
        try {
            this.errorMgr.txStart();
            while (!this.errorMgr.isTxCompleted() && !ReplicationHealthChecker.isStopping()) {
                try {
                    aPipe.connect(this.netPeerGroup, null, pipeAdvertisement, 15000, (PipeMsgListener)pipeWrapper);
                    aPipe.setPipeEventListener((PipeEventListener)pipeWrapper);
                    this.errorMgr.txEnd();
                }
                catch (IOException e) {
                    this.errorMgr.checkError(e);
                }
            }
            this.errorMgr.txEnd();
        }
        catch (HATimeoutException tex) {
            pipeWrapper = null;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper connectPipeWithRetries() timed out: " + tex.getMessage());
            }
        }
        finally {
            this.errorMgr.txEnd();
        }
        return pipeWrapper;
    }

    PipeWrapper createPipe() {
        PipeWrapper pipeWrapper = null;
        try {
            JxtaBiDiPipe aPipe = new JxtaBiDiPipe();
            aPipe.setReliable(true);
            pipeWrapper = new PipeWrapper("created_pipe", "S", this.getReplicateToInstanceName(), aPipe);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper: Attempting to establish a connection");
            }
            aPipe.connect(this.netPeerGroup, null, this.pipeAdv, 300000, (PipeMsgListener)pipeWrapper);
            aPipe.setPipeEventListener((PipeEventListener)pipeWrapper);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("new JxtaBiDiPipe pipe created: " + aPipe);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pipeWrapper;
    }

    private void startJxta(boolean isServer) {
        JxtaStarter jxtaStarter = JxtaStarter.createInstance();
        jxtaStarter.startJxta(isServer);
        this.netPeerGroup = jxtaStarter.getNetPeerGroup();
        RendezVousService theRendezvous = jxtaStarter.getRendezvous();
        if (theRendezvous != null) {
            theRendezvous.addListener((RendezvousListener)this);
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper>>pipeMsgEvent");
        }
        Message msg = null;
        try {
            msg = event.getMessage();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper>>pipeMsgEvent:msg=" + msg);
            }
            if (msg == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Received an empty message, returning");
                }
                return;
            }
            MessageElement msgElement = msg.getMessageElement(SenderMessage, SenderMessage);
            MessageElement idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID);
            if (msgElement != null && _logger.isLoggable(Level.FINEST)) {
                _logger.finest("msgElement=" + msgElement.toString());
            }
            if (idMsgElement != null && _logger.isLoggable(Level.FINEST)) {
                _logger.finest("idMsgElement=" + idMsgElement.toString());
            }
            if (msgElement != null) {
                this.processStartupMessage(msg, msgElement);
            } else if (idMsgElement != null) {
                this.processIdMessage(msg, idMsgElement);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void processStartupMessage(Message msg, MessageElement msgElement) {
        if (msgElement.toString() == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("null msg received");
            }
        } else {
            ++this.count;
        }
    }

    private void processIdMessage(Message msg, MessageElement idMsgElement) {
        if (idMsgElement.toString() == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("null msg received");
            }
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("ID Message :" + idMsgElement.toString());
            }
            ReplicationState state = this.createReplicationState(msg);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("ID Message is response: " + state.isReturnMessage());
            }
            if (!state.isReturnMessage()) {
                // empty if block
            }
            this.finishProcessIdMessage(state);
        }
    }

    private void sendMessage(Message msg) {
        JxtaReplicationSender jxtaReplicationSender = JxtaReplicationSender.createInstance();
        jxtaReplicationSender.sendOverPipe(msg);
    }

    private void sendResponse(Message msg) {
        Message responseMsg = this.alterIncomingMessageToResponse(msg);
        this.sendMessage(responseMsg);
    }

    private Message alterIncomingMessageToResponse(Message msg) {
        msg.replaceMessageElement(MESSAGE_COMMAND, (MessageElement)new StringMessageElement(MESSAGE_COMMAND, RETURN_MSG_COMMAND, null));
        return msg;
    }

    private ReplicationState createReplicationState(Message msg) {
        return ReplicationState.createReplicationState(msg);
    }

    private void finishProcessIdMessage(ReplicationState state) {
        JxtaReplicationReceiver receiver = JxtaReplicationReceiver.createInstance();
        receiver.processMessage(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        ReplicationHealthChecker.setStopping(true);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper-stop() method");
        }
        try {
            JxtaReplicationSender.createInstance().stop();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
        this.closePipes();
        this.closeHealthPipes();
        this.closePropagatedPipes();
        ReplicationResponseRepository.getInstance().stop();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper:stop() complete");
        }
        String string = completeLock;
        synchronized (completeLock) {
            completeLock.notify();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    public void closePipes() {
        JxtaSenderPipeManager pipeMgr = JxtaSenderPipeManager.createInstance();
        pipeMgr.closePooledPipes();
    }

    private void closeNonPropagatedSenderConnections() {
        this.closePipes();
        this.closeSenderHealthPipe();
    }

    public void closeConnections() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper-closeConnections() method");
        }
        this.stop();
    }

    public void restart() {
        block6: {
            if (ReplicationHealthChecker.isStopping()) {
                return;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper-restart() method");
            }
            String newPartnerInstance = this.getReplicateToInstanceName();
            this.closeConnections();
            try {
                String value = System.getProperty("RDVWAIT", "false");
                this.waitForRendezvous = Boolean.valueOf(value);
                this.pipeAdv = JxtaUtil.getPipeAdvertisement(newPartnerInstance);
                this.peerID = JxtaStarter.getPeerID(newPartnerInstance);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINEST)) break block6;
                _logger.finest("failed to bind the JxtaBiDiPipe due to the following exception");
                e.printStackTrace();
            }
        }
        Thread acceptThread = new Thread(this);
        acceptThread.setDaemon(true);
        acceptThread.start();
        try {
            acceptThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repair();
    }

    public void reshape(String partnerInstanceName) {
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        healthChecker.displayCurrentGroupMembers();
        String newPartnerInstance = healthChecker.getReshapeReplicateToInstanceName(partnerInstanceName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("JxtaBiDiPipeWrapper>>reshape:newPartnerInstance: " + newPartnerInstance);
        }
        System.out.println("JxtaBiDiPipeWrapper>>reshape:newPartnerInstance: " + newPartnerInstance);
        System.out.println("JxtaBiDiPipeWrapper>>reshape:currentPartnerInstance: " + this.getCurrentPartnerInstanceName());
        System.out.println("JxtaBiDiPipeWrapper>>reshape:isAttemptingConnection:" + this.isAttemptingConnection());
        if (this.isAttemptingConnection() || newPartnerInstance == null || this.isOurself(newPartnerInstance)) {
            return;
        }
        if (newPartnerInstance.equalsIgnoreCase(this.getCurrentPartnerInstanceName())) {
            boolean currentPipesOk = this.areCurrentPipesOk();
            System.out.println("JxtaBiDiPipeWrapper>>reshape:before reshape - currentPipesOk = " + currentPipesOk);
            if (currentPipesOk) {
                return;
            }
        }
        System.out.println("JxtaBiDiPipeWrapper>>reshape:beforeConnectToInstance:newPartnerInstance: " + newPartnerInstance);
        System.out.println("JxtaBiDiPipeWrapper>>reshape:beforeConnectToInstance:currentPartnerInstance: " + this.getCurrentPartnerInstanceName());
        this.closeNonPropagatedSenderConnectionsAndConnectToInstance(newPartnerInstance);
        System.out.println("JxtaBiDiPipeWrapper:end of reshape: new partner=" + this.getCurrentPartnerInstanceName());
    }

    public void respondToFailure(String failedPartnerInstance) {
        JxtaSenderPipeManager senderPipeMgr = JxtaSenderPipeManager.createInstance();
        if (!senderPipeMgr.isOurPartnerInstance(failedPartnerInstance)) {
            return;
        }
        this.reshape(failedPartnerInstance);
    }

    public void respondToFailure(String failedPartnerInstance, boolean force) {
        JxtaSenderPipeManager senderPipeMgr;
        if (!force && !(senderPipeMgr = JxtaSenderPipeManager.createInstance()).isOurPartnerInstance(failedPartnerInstance)) {
            return;
        }
        this.reshape(failedPartnerInstance);
    }

    public void connectToNew(String newPartnerInstance) {
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:thisInstance = " + this.getInstanceName());
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:newPartnerInstance = " + newPartnerInstance);
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:currentPartnerInstance = " + this.getCurrentPartnerInstanceName());
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:isStopping = " + ReplicationHealthChecker.isStopping());
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        if (!this.isBetterReplicationPartner(newPartnerInstance)) {
            return;
        }
        boolean currentPartnerHealthy = this.areCurrentPipesOk();
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:before reconnect - currentPartnerHealthy = " + currentPartnerHealthy);
        healthChecker.displayCurrentGroupMembers();
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:isAttemptingConnection = " + this.isAttemptingConnection());
        if (this.isAttemptingConnection()) {
            this.interruptConnectionAttempt();
            this.closeNonPropagatedSenderConnectionsAndConnectToInstance(newPartnerInstance, true);
        } else {
            this.closeNonPropagatedSenderConnectionsAndConnectToInstance(newPartnerInstance);
        }
        System.out.println("JxtaBiDiPipeWrapper:end of connectToNew: new partner=" + this.getCurrentPartnerInstanceName());
        currentPartnerHealthy = this.areCurrentPipesOk();
        System.out.println("JxtaBiDiPipeWrapper>>connectToNew:after reconnect - currentPartnerHealthy = " + currentPartnerHealthy);
    }

    private synchronized void closeNonPropagatedSenderConnectionsAndConnectToInstance(String newPartnerInstance) {
        this.closeNonPropagatedSenderConnectionsAndConnectToInstance(newPartnerInstance, false);
    }

    private synchronized void closeNonPropagatedSenderConnectionsAndConnectToInstance(String newPartnerInstance, boolean forceReconnect) {
        System.out.println("JxtaBiDiPipeWrapper>>closeNonPropagatedSenderConnectionsAndConnectToInstance:forceReconnect:" + forceReconnect);
        if (!forceReconnect && this.checkIfProposedConnectionAlreadyOk(newPartnerInstance)) {
            System.out.println("JxtaBiDiPipeWrapper>>closeNonPropagatedSenderConnectionsAndConnectToInstance:connections already good returning for: " + newPartnerInstance);
            return;
        }
        System.out.println("JxtaBiDiPipeWrapper>>closeNonPropagatedSenderConnectionsAndConnectToInstance:doing close and connect for: " + newPartnerInstance);
        this.closeNonPropagatedSenderConnections();
        this.connectToInstance(newPartnerInstance);
    }

    boolean checkIfProposedConnectionAlreadyOk(String newPartnerInstance) {
        String currentPartnerInstance = this.getCurrentPartnerInstanceName();
        System.out.println("JxtaBiDiPipeWrapper>>checkIfProposedConnectionAlreadyOk: " + newPartnerInstance);
        System.out.println("JxtaBiDiPipeWrapper>>checkIfProposedConnectionAlreadyOk:currentPartnerInstance: " + currentPartnerInstance);
        if (currentPartnerInstance != null && currentPartnerInstance.equalsIgnoreCase(newPartnerInstance)) {
            boolean currentPipesOk = this.areCurrentPipesOk();
            System.out.println("JxtaBiDiPipeWrapper>>checkIfProposedConnectionAlreadyOk: - currentPipesOk = " + currentPipesOk);
            return currentPipesOk;
        }
        return false;
    }

    boolean areCurrentPipesOk() {
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        String currentInstanceName = this.getInstanceName();
        String currentPartnerInstanceName = this.getCurrentPartnerInstanceName();
        boolean currentPartnerHealthy = healthChecker.doPipeTest();
        System.out.println("JxtaBiDiPipeWrapper>>areCurrentPipesOk from: " + currentInstanceName + " to: " + currentPartnerInstanceName + ": " + currentPartnerHealthy);
        return currentPartnerHealthy;
    }

    private boolean connectToInstance(String newPartnerInstance) {
        return this.connectToInstance(newPartnerInstance, true);
    }

    private boolean connectToInstance(String newPartnerInstance, boolean repairNeeded) {
        String currentPartnerInstance = this.getCurrentPartnerInstanceName();
        System.out.println("JxtaBiDiPipeWrapper>>connectToInstance: " + newPartnerInstance);
        System.out.println("JxtaBiDiPipeWrapper>>connectToInstance:currentPartnerInstance: " + currentPartnerInstance);
        if (currentPartnerInstance != null && currentPartnerInstance.equalsIgnoreCase(newPartnerInstance)) {
            boolean currentPipesOk = this.areCurrentPipesOk();
            System.out.println("JxtaBiDiPipeWrapper>>connectToInstance:before connect - currentPipesOk = " + currentPipesOk);
            if (currentPipesOk) {
                return true;
            }
        }
        boolean reshapeSuccessful = false;
        try {
            String value = System.getProperty("RDVWAIT", "false");
            this.waitForRendezvous = Boolean.valueOf(value);
            PipeAdvertisement pipeAdvertisement = JxtaUtil.getPipeAdvertisement(newPartnerInstance);
            System.out.println("pipeAdvertisement for: " + newPartnerInstance + " is: " + pipeAdvertisement);
            System.out.println("this.pipeAdv: " + this.pipeAdv);
            int numPipes = this.getNumberOfPipes();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("JxtaBiDiPipeWrapper>>connectToInstance-numPipes=" + numPipes);
                _logger.finest("JxtaBiDiPipeWrapper>>connectToInstance:reshape pipeAdv=" + pipeAdvertisement);
            }
            System.out.println("JxtaBiDiPipeWrapper>>connectToInstance-numPipes=" + numPipes);
            System.out.println("JxtaBiDiPipeWrapper>>connectToInstance:reshape pipeAdv=" + pipeAdvertisement);
            long startTime = System.currentTimeMillis();
            this.setAttemptingConnection(true);
            reshapeSuccessful = this.createPipes(numPipes, pipeAdvertisement, newPartnerInstance);
            this.setAttemptingConnection(false);
            System.out.println("JxtaBiDiPipeWrapper>>createPipes took " + (System.currentTimeMillis() - startTime) + " millis");
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("failed to bind the JxtaBiDiPipe due to the following exception");
                e.printStackTrace();
            }
            this.setAttemptingConnection(false);
        }
        ReplicationHealthChecker.setReplicationCommunicationOperational(reshapeSuccessful);
        if (reshapeSuccessful && repairNeeded) {
            this.repair();
        }
        return reshapeSuccessful;
    }

    private void repair() {
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        Thread repairThread = new Thread(new JxtaRepair());
        repairThread.setDaemon(true);
        repairThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repairOnCurrentThread() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("repairOnCurrentThread");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("repairOnCurrentThread:will skip if ClusterStopping: " + ReplicationHealthChecker.isClusterStopping());
        }
        if (ReplicationHealthChecker.isClusterStopping()) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("repairOnCurrentThread: setting flushing true");
        }
        ReplicationHealthChecker.setFlushing(true);
        try {
            ReplicationMessageRouter router = ReplicationMessageRouter.createInstance();
            router.repairApps(System.currentTimeMillis(), false);
        }
        finally {
            ReplicationHealthChecker.setFlushing(false);
        }
    }

    private String getCurrentPartnerInstanceName() {
        JxtaSenderPipeManager jxtaSenderPipeManager = JxtaSenderPipeManager.createInstance();
        return jxtaSenderPipeManager.getPartnerInstanceName();
    }

    private boolean isOurself(String instanceName) {
        if (instanceName == null) {
            return false;
        }
        return instanceName.equalsIgnoreCase(this.getInstanceName());
    }

    boolean isBetterReplicationPartner(String proposedPartnerName) {
        if (proposedPartnerName == null) {
            return false;
        }
        String currentInstanceName = this.getInstanceName();
        String currentPartnerInstanceName = this.getCurrentPartnerInstanceName();
        SimpleInstanceArranger arranger = this.getSimpleArranger();
        return arranger.isBetterOrSameAsReplicationPartner(proposedPartnerName, currentPartnerInstanceName, currentInstanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rendezvousEvent(RendezvousEvent event) {
        block6: {
            block5: {
                System.out.println(event.getType());
                if (event.getType() == 0) break block5;
                if (event.getType() != 1) break block6;
            }
            String string = this.rendezvousLock;
            synchronized (string) {
                this.rendezvousLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRendezvousConnection() {
        if (this.waitForRendezvous && !this.rendezvous.isConnectedToRendezVous()) {
            System.out.println("Waiting for Rendezvous Connection");
            try {
                String string = this.rendezvousLock;
                synchronized (string) {
                    this.rendezvousLock.wait();
                }
                System.out.println("Connected to Rendezvous");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilCompleted() {
        try {
            System.out.println("Waiting for Messages.");
            String string = completeLock;
            synchronized (completeLock) {
                completeLock.wait();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.pipe.close();
                System.out.println("Done.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

