/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.initialization;

import com.sun.appserv.ha.util.PersistenceTypeResolver;
import com.sun.enterprise.ee.web.authenticator.HASSO;
import com.sun.enterprise.ee.web.authenticator.ReplicationSSOStoreFactoryImpl;
import com.sun.enterprise.ee.web.authenticator.ReplicationSingleSignOn;
import com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver;
import com.sun.enterprise.ee.web.sessmgmt.StoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EESSOFactory
implements SSOFactory {
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private final String EE_SSO_IMPL = "com.sun.enterprise.ee.web.authenticator.HASingleSignOn";
    private final String EE_SSO_STORE_FACTORY_IMPL = "com.sun.enterprise.ee.web.authenticator.SSOStoreFactoryImpl";

    public SingleSignOn createSingleSignOnValve(String virtualServerName) {
        if (EESSOFactory.getAvailabilityEnabled() && EESSOFactory.getSsoFailoverEnabled()) {
            return this.createHASingleSignOnValve(virtualServerName);
        }
        return new SingleSignOn();
    }

    private static boolean getAvailabilityEnabled() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        boolean isAvailabilityEnabled = serverConfigLookup.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("EESSOFactory : AvailabilityGloballyEnabled = " + isAvailabilityEnabled);
        }
        return isAvailabilityEnabled;
    }

    private static boolean getSsoFailoverEnabled() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        boolean webContainerAvailabilityEnabled = serverConfigLookup.getWebContainerAvailabilityEnabledFromConfig();
        boolean isSsoFailoverEnabled = serverConfigLookup.getSsoFailoverEnabledFromConfig();
        boolean isPersistenceTypeOkForFailover = EESSOFactory.isPersistenceTypeHAOrReplicated();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("EESSOFactory : WebContainerAvailabilityEnabled = " + webContainerAvailabilityEnabled);
            _logger.finest("EESSOFactory : SSOFailoverEnabled = " + isSsoFailoverEnabled);
            _logger.finest("EESSOFactory : PersistenceTypeOkForFailover = " + isPersistenceTypeOkForFailover);
        }
        return isSsoFailoverEnabled && webContainerAvailabilityEnabled && isPersistenceTypeOkForFailover;
    }

    public SingleSignOn createHASingleSignOnValve(String virtualServerName) {
        HASSO haSSO = null;
        haSSO = this.isPersistenceTypeHA() ? this.getHASingleSignOnImpl() : new ReplicationSingleSignOn(virtualServerName);
        this.initializeSSOvalve(haSSO);
        return (SingleSignOn)haSSO;
    }

    public HASSO getHASingleSignOnImpl() {
        HASSO haSSO = null;
        try {
            haSSO = (HASSO)Class.forName("com.sun.enterprise.ee.web.authenticator.HASingleSignOn").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return haSSO;
    }

    public void initializeSSOvalve(HASSO haSSO) {
        StoreFactory ssoStoreFactory = this.createSSOStoreFactoryImpl();
        StorePool storePool = new StorePool(100, -1, 100, ssoStoreFactory);
        haSSO.setSSOStorePool(storePool);
        haSSO.setPassedInPersistenceType(this.getPassedInPersistenceType());
    }

    public StoreFactory createSSOStoreFactoryImpl() {
        if (this.isPersistenceTypeHA()) {
            return this.getHASSOStoreFactoryImpl();
        }
        return new ReplicationSSOStoreFactoryImpl();
    }

    public StoreFactory getHASSOStoreFactoryImpl() {
        StoreFactory ssoStoreFactory = null;
        try {
            ssoStoreFactory = (StoreFactory)Class.forName("com.sun.enterprise.ee.web.authenticator.SSOStoreFactoryImpl").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssoStoreFactory;
    }

    private static boolean isPersistenceTypeHAOrReplicated() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        PersistenceType persistenceType = lookup.getPersistenceTypeFromConfig();
        String persistenceTypeString = persistenceType.getType();
        return persistenceTypeString.equalsIgnoreCase("HA") || persistenceTypeString.equalsIgnoreCase("Replicated") || EESSOFactory.isPersistenceTypeRegistered();
    }

    private static boolean isPersistenceTypeRegistered() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        PersistenceType persistenceType = lookup.getPersistenceTypeFromConfig();
        String persistenceTypeString = persistenceType.getType();
        EEPersistenceTypeResolver resolver = new EEPersistenceTypeResolver();
        return resolver.isRegisteredType(persistenceTypeString);
    }

    private boolean isPersistenceTypeHA() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        PersistenceType persistenceType = lookup.getPersistenceTypeFromConfig();
        String persistenceTypeString = persistenceType.getType();
        return persistenceTypeString.equalsIgnoreCase("HA");
    }

    private boolean isPersistenceTypeReplicated() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        PersistenceType persistenceType = lookup.getPersistenceTypeFromConfig();
        String persistenceTypeString = persistenceType.getType();
        return persistenceTypeString.equalsIgnoreCase("REPLICATED");
    }

    private String getPassedInPersistenceType() {
        String passedInPersistenceTypeString;
        ServerConfigLookup lookup = new ServerConfigLookup();
        PersistenceType persistenceType = lookup.getPersistenceTypeFromConfig();
        String resolvedPersistenceType = passedInPersistenceTypeString = persistenceType.getType();
        return resolvedPersistenceType;
    }

    private PersistenceTypeResolver getPersistenceTypeResolver() {
        String resolverClassName = "com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver";
        PersistenceTypeResolver persistenceTypeResolver = null;
        try {
            persistenceTypeResolver = (PersistenceTypeResolver)Class.forName(resolverClassName).newInstance();
        }
        catch (Exception ex) {
            System.out.println("unable to create persistence type resolver");
        }
        return persistenceTypeResolver;
    }
}

