/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.Metadata;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.enterprise.ee.web.authenticator.ReplicationSSOStorePoolElement;
import com.sun.enterprise.ee.web.authenticator.ReplicationSingleSignOn;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationWebEventPersistentManager;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;

public class ReplicationSSOStore
implements StorePoolElement,
ReplicationSSOStorePoolElement {
    static final String MODE_SSO = "sso";
    static final String MODE_WEB = "web";
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    protected String applicationId = null;
    private boolean debug = false;
    protected Container container = null;
    protected ReplicationSingleSignOn parent = null;

    public void cleanup() {
    }

    public SingleSignOnEntry loadSSO(String ssoId, ReplicationSingleSignOn repSingleSignOn) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>loadSSO:ssoId: " + ssoId + " stacktrace follows:");
        }
        if (ssoId == null) {
            return null;
        }
        ReplicationState localCachedState = repSingleSignOn.transferFromReplicationCache(ssoId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>loadSSO:localCachedState=" + localCachedState);
        }
        ReplicationState broadcastResultState = this.findSSOEntryViaBroadcast(ssoId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>loadSSO:broadcastResultState from broadcast=" + broadcastResultState);
        }
        ReplicationState bestState = this.getBestResult(localCachedState, broadcastResultState);
        HASingleSignOnEntry result = null;
        if (bestState != null && bestState.getState() != null) {
            try {
                result = this.getSSOEntry(bestState);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>loadSSO:ssoId " + ssoId + " ssoentry: " + (Object)((Object)result));
        }
        if (result != null) {
            this.save(ssoId, result);
        }
        return result;
    }

    private ReplicationState getBestResult(ReplicationState localState, ReplicationState broadcastResultState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("getBestResult:localState=" + localState + "other=" + broadcastResultState);
        }
        if (localState == null) {
            return broadcastResultState;
        }
        if (broadcastResultState == null) {
            return localState;
        }
        if (broadcastResultState.getVersion() >= localState.getVersion()) {
            return broadcastResultState;
        }
        return localState;
    }

    private ReplicationState findSSOEntryViaBroadcastOldAPI(String ssoId) {
        ReplicationState state = ReplicationState.createBroadcastQueryState(MODE_SSO, ssoId, null, this.getInstanceName());
        JxtaReplicationSender sender = JxtaReplicationSender.createInstance();
        ReplicationState result = sender.sendReplicationStateQuery(state);
        return result;
    }

    public String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    private ReplicationState findSSOEntryViaBroadcast(String ssoId) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>findSSOEntryViaBroadcast");
        }
        if (this.container == null) {
            System.out.println("error: ReplicationSSOStore>>findSSOEntryViaBroadcast: container null");
        }
        if (this.parent == null) {
            return null;
        }
        BackingStore replicator = this.parent.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in findSSOEntryViaBroadcast: replicator: " + replicator);
        }
        SimpleMetadata queryResult = null;
        try {
            queryResult = (SimpleMetadata)replicator.load(ssoId);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (queryResult == null) {
            return null;
        }
        ReplicationState result = new ReplicationState(MODE_SSO, ssoId, this.getApplicationId(), queryResult.getVersion(), 0L, 0L, queryResult.getExtraParam(), null, null, null, queryResult.getState(), null);
        return result;
    }

    public void saveOldAPI(String ssoId, SingleSignOnEntry ssoEntry) throws IOException {
        System.out.println("ReplicationSSOStore>>save");
        this.transmitSSOEntry(ssoId, ssoEntry, "save");
    }

    public void save(String ssoId, SingleSignOnEntry ssoEntry) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>save:ssoId = " + ssoId + " :ssoEntry = " + ssoEntry);
        }
        if (this.container == null) {
            System.out.println("error: ReplicationSSOStore>>save: container null");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>save:parent=" + this.parent);
        }
        if (this.parent == null) {
            return;
        }
        BackingStore replicator = this.parent.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore: in save: replicator: " + replicator);
        }
        SimpleMetadata simpleMetadata = this.createSimpleMetadata(ssoId, (HASingleSignOnEntry)ssoEntry);
        try {
            replicator.save(ssoId, (Metadata)simpleMetadata);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void saveForRepair(ReplicationState state) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("ReplicationSSOStore", "saveForRepair", state);
        }
        long tempStartTime = System.currentTimeMillis();
        this.transmitState(state, "save", true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>saveForRepair time = " + (System.currentTimeMillis() - tempStartTime));
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("ReplicationSSOStore", "saveForRepair");
        }
    }

    public void associateOldAPI(StandardSession session, String ssoId) throws IOException {
        String sessionId = session.getIdInternal();
        ReplicationManagerBase mgr = (ReplicationManagerBase)session.getManager();
        String appId = mgr.getApplicationId();
        ReplicationState transmitState = new ReplicationState(MODE_WEB, sessionId, appId, ((HASession)session).getVersion(), 0L, 0L, ssoId, null, null, "associate", null, null);
        System.out.println("ReplicationSSOStore>>associate");
        this.doTransmit(transmitState);
    }

    public void associate(StandardSession session, String ssoId) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>associate");
        }
        if (session instanceof HASession) {
            ((HASession)session).setSsoId(ssoId);
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)session.getManager();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>associate: mgr = " + (Object)((Object)mgr));
        }
        if (mgr instanceof ReplicationWebEventPersistentManager) {
            ((ReplicationWebEventPersistentManager)mgr).doValveSave((Session)session);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("exiting ReplicationSSOStore>>associate");
        }
    }

    public void removeOldAPI(String ssoId) throws IOException {
        ReplicationState transmitState = new ReplicationState(MODE_SSO, ssoId, this.getApplicationId(), 0L, 0L, 0L, ssoId, null, null, "remove", null, null);
        System.out.println("ReplicationSSOStore>>remove");
        this.doTransmit(transmitState);
    }

    public void remove(String ssoId) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>remove");
        }
        if (this.container == null) {
            System.out.println("error: ReplicationSSOStore>>remove: container null");
        }
        if (this.parent == null) {
            return;
        }
        BackingStore replicator = this.parent.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>remove: replicator: " + replicator);
        }
        try {
            replicator.remove(ssoId);
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String value) {
        this.applicationId = value;
    }

    public void removeInActiveSessions(String ssoId) throws IOException {
        ReplicationState transmitState = new ReplicationState(MODE_SSO, ssoId, this.getApplicationId(), 0L, 0L, 0L, ssoId, null, null, "removeInActiveSessions", null, null);
        System.out.println("ReplicationSSOStore>>removeInActiveSessions");
        this.doTransmit(transmitState);
    }

    public void setContainer(Container container) {
        this.container = container;
        this.debug("   container:    " + container);
    }

    public void setParent(ReplicationSingleSignOn parent) {
        this.parent = parent;
        this.debug("   parent:    " + parent);
    }

    public void updateLastAccessTimeOldAPI(String ssoId, long lat) throws IOException {
        ReplicationState transmitState = new ReplicationState(MODE_SSO, ssoId, this.getApplicationId(), 0L, lat, 0L, ssoId, null, null, "updateLastAccessTime", null, null);
        System.out.println("ReplicationSSOStore>>updateLastAccessTime");
        this.doTransmit(transmitState);
    }

    public void updateLastAccessTime(String ssoId, long lat) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>updateLastAccessTime");
        }
        if (this.container == null) {
            System.out.println("error: ReplicationSSOStore>>updateLastAccessTime: container null");
        }
        if (this.parent == null) {
            return;
        }
        BackingStore replicator = this.parent.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>updateLastAccessTime: replicator: " + replicator);
        }
        try {
            replicator.updateLastAccessTime(ssoId, lat, 0L);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    protected void transmitSSOEntry(String ssoId, SingleSignOnEntry ssoEntry, String command) throws IOException {
        ReplicationState transmitState = this.createReplicationState(ssoId, (HASingleSignOnEntry)ssoEntry, command);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>transmitSSOEntry");
        }
        this.doTransmit(transmitState);
    }

    protected void transmitSSOEntry(String ssoId, SingleSignOnEntry ssoEntry, String command, boolean wait) throws IOException {
        ReplicationState transmitState = this.createReplicationState(ssoId, (HASingleSignOnEntry)ssoEntry, command);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>transmitSSOEntry");
        }
        this.doTransmit(transmitState, wait);
    }

    protected void transmitState(ReplicationState state, String command) throws IOException {
        ReplicationState transmitState = this.createRepairReplicationState(state, command);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSSOStore>>transmitState");
        }
        this.doTransmit(transmitState);
    }

    protected void transmitState(ReplicationState state, String command, boolean wait) throws IOException {
        ReplicationState transmitState = this.createRepairReplicationState(state, command);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSSOStore>>transmitState");
        }
        this.doTransmit(transmitState, wait);
    }

    protected ReplicationState createRepairReplicationState(ReplicationState state, String command) throws IOException {
        ReplicationState transmitState = new ReplicationState(MODE_SSO, state.getId().toString(), state.getAppId(), state.getVersion(), state.getLastAccess(), state.getMaxInactiveInterval(), state.getExtraParam(), state.getQueryResult(), state.getInstanceName(), command, state.getState(), state.getTrunkState());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>createRepairReplicationState:transmitState=" + transmitState);
        }
        return transmitState;
    }

    protected ReplicationState createReplicationState(String ssoId, HASingleSignOnEntry ssoEntry, String command) throws IOException {
        byte[] ssoEntryState = this.getByteArray(ssoEntry);
        ReplicationState transmitState = new ReplicationState(MODE_SSO, ssoId, null, 0L, ssoEntry.lastAccessTime, 0L, ssoEntry.username, null, null, command, ssoEntryState, null);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>createReplicationState:transmitState=" + transmitState);
        }
        return transmitState;
    }

    protected SimpleMetadata createSimpleMetadata(String ssoId, HASingleSignOnEntry ssoEntry) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSsOStore>>createSimpleMetadata:ssoEntry=" + (Object)((Object)ssoEntry));
        }
        byte[] ssoEntryState = this.getByteArray(ssoEntry);
        String userName = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>createSimpleMetadata:ssoEntry.principal=" + ssoEntry.principal);
        }
        System.out.println("ReplicationSSOStore>>createSimpleMetadata:ssoEntry.principal=" + ssoEntry.principal);
        if (ssoEntry.principal != null) {
            userName = ssoEntry.principal.getName();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSsOStore>>createSimpleMetadata:userName=" + userName);
        }
        System.out.println("ReplicationSsOStore>>createSimpleMetadata:userName=" + userName);
        SimpleMetadata metaData = new SimpleMetadata(ssoEntry.getVersion(), ssoEntry.lastAccessTime, 0L, ssoEntryState, userName);
        return metaData;
    }

    protected SimpleMetadata createSparseSimpleMetadata(String ssoId) throws IOException {
        SimpleMetadata metaData = new SimpleMetadata(0L, 0L, 0L, null, ssoId);
        return metaData;
    }

    private void testDeserializeState(ReplicationState transmitState) {
        try {
            HASingleSignOnEntry ssoEntry = this.getSSOEntry(transmitState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ssoEntry = " + (Object)((Object)ssoEntry));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HASingleSignOnEntry getSSOEntry(ReplicationState replicationState) throws IOException, ClassNotFoundException {
        HASingleSignOnEntry _ssoEntry;
        String userName;
        block14: {
            byte[] state = replicationState.getState();
            userName = replicationState.getExtraParam();
            _ssoEntry = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            Object ssoId = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                String id = (String)replicationState.getId();
                userName = replicationState.getExtraParam();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ReplicationSSOStore>>getSSOEntry:userName=" + userName);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded ssoEntry from replicationssostore, length = " + state.length);
                }
                if ((ois = new ObjectInputStream(bis)) == null) break block14;
                try {
                    _ssoEntry = this.readSSOEntry(ois);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getSSOEntry :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        if (_ssoEntry.username == null) {
            _ssoEntry.username = userName;
        }
        return _ssoEntry;
    }

    public HASingleSignOnEntry readSSOEntry(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        HASingleSignOnEntry ssoEntry = new HASingleSignOnEntry(null, null, null, null, null);
        ssoEntry.readObjectData(ois);
        return ssoEntry;
    }

    public void sendResponse(ReplicationState state) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>sendResponse");
        }
        this.doReturnTransmit(state);
    }

    public void sendQueryResponse(ReplicationState state, String returnInstance) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationSSOStore>>sendQueryResponse:returnInstance: " + returnInstance);
        }
        this.doReturnQueryTransmit(state, returnInstance);
    }

    protected ReplicationState doReturnTransmit(ReplicationState transmitState) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationStateResponse(transmitState);
        return resultState;
    }

    protected ReplicationState doReturnQueryTransmit(ReplicationState transmitState, String returnInstance) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationStateQueryResponse(transmitState, returnInstance);
        return resultState;
    }

    protected ReplicationState doTransmit(ReplicationState transmitState) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationState(transmitState);
        return resultState;
    }

    protected ReplicationState doTransmit(ReplicationState transmitState, boolean wait) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationState(transmitState, wait);
        return resultState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(HASingleSignOnEntry ssoEntry) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            this.writeSSOEntry(ssoEntry, oos);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    public void writeSSOEntry(HASingleSignOnEntry ssoEntry, ObjectOutputStream oos) throws IOException {
        if (ssoEntry == null) {
            return;
        }
        ssoEntry.writeObjectData(oos);
    }

    public void debug(String s) {
        if (this.debug) {
            System.out.println("ReplicationSSOStore: " + s);
        }
    }
}

