/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.impl.SynchronizationClientImpl;
import com.sun.enterprise.ee.synchronization.util.io.Utils;
import com.sun.enterprise.ee.util.zip.Unzipper;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResponseProcessCommand
implements Command {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(ResponseProcessCommand.class);
    private SynchronizationRequest _request = null;
    private SynchronizationResponse _response = null;
    private static final String ZIP_SUFFIX = ".zip";
    private static final String NAME = "Synchronization-Response-Process-Command";

    ResponseProcessCommand(SynchronizationRequest req, SynchronizationResponse res) {
        this._request = req;
        this._response = res;
    }

    public void execute() throws SynchronizationException {
        try {
            _logger.log(Level.FINE, "synchronization.process_command", this._request.getMetaFileName());
            String baseDir = this._request.getBaseDirectory();
            Unzipper z = new Unzipper(baseDir);
            byte[] zipBytes = this._response.getZipBytes();
            long checksum = 0L;
            if (zipBytes != null) {
                checksum = z.writeZipBytes(zipBytes);
            } else {
                File tempZip = null;
                if (this.isSameHost()) {
                    String dasZipLoc = this._response.getZipLocation();
                    tempZip = new File(dasZipLoc);
                } else {
                    tempZip = this.downloadZip();
                }
                if (tempZip != null && tempZip.exists()) {
                    z.ignoreEntry("com.sun.appserv.SynchronizationResponse");
                    checksum = z.writeZipFile(tempZip.getCanonicalPath());
                }
            }
            _logger.log(Level.FINE, "synchronization.check_sum", new Long(checksum).toString());
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("syncResponseError", (Object)this._request.getMetaFileName());
            throw new SynchronizationException(msg, e);
        }
    }

    private boolean isSameHost() {
        long localLastModified;
        long dasLastModified;
        boolean tf = false;
        String dasZipLoc = this._response.getZipLocation();
        File zip = new File(dasZipLoc);
        if (zip.exists() && (dasLastModified = this._response.getLastModifiedOfZip()) == (localLastModified = zip.lastModified())) {
            String dasHostName = this._response.getDasHostName();
            try {
                InetAddress host = InetAddress.getLocalHost();
                if (dasHostName != null && dasHostName.equals(host.getHostName())) {
                    tf = true;
                }
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        return tf;
    }

    private File downloadZip() throws SynchronizationException, IOException {
        File zipfile = null;
        String dasZipLoc = this._response.getZipLocation();
        if (dasZipLoc != null) {
            SynchronizationClientImpl sClient = new SynchronizationClientImpl("server");
            zipfile = Utils.getTempZipFile();
            sClient.connect();
            sClient.getAbsolute(dasZipLoc, zipfile);
            sClient.disconnect();
        }
        return zipfile;
    }

    public String getName() {
        return NAME;
    }

    public Object getResult() {
        return null;
    }
}

