/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.events;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.EventAbstractFactory;
import com.sun.enterprise.admin.selfmanagement.event.EventBuilder;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.ee.selfmanagement.events.GMSEvent;
import com.sun.enterprise.ee.selfmanagement.events.GMSEventProxy;
import com.sun.enterprise.ee.selfmanagement.events.GMSFailEvent;
import com.sun.enterprise.ee.selfmanagement.events.GMSNotificationFilter;
import com.sun.enterprise.ee.selfmanagement.events.GMSStartEvent;
import com.sun.enterprise.ee.selfmanagement.events.GMSStopEvent;

public class GMSEventFactory
extends EventAbstractFactory {
    private static GMSEventFactory instance = new GMSEventFactory();

    GMSEventFactory() {
        EventBuilder.getInstance().addEventFactory("cluster", (EventAbstractFactory)this);
        try {
            GMSEventProxy proxy = (GMSEventProxy)this.getMBeanServer().instantiate("com.sun.enterprise.ee.selfmanagement.events.GMSEventProxy");
            this.getMBeanServer().registerMBean(proxy, GMSEvent.getGMSProxyObjectName());
            GMSStartEvent.getInstance(proxy);
            GMSFailEvent.getInstance(proxy);
            GMSStopEvent.getInstance(proxy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Event instrumentEvent(ElementProperty[] properties, String description) {
        String eventName = "*";
        String serverName = "*";
        for (int i = 0; i < properties.length; ++i) {
            ElementProperty property = properties[i];
            String propertyName = property.getName().toLowerCase();
            if (propertyName.equals("name")) {
                eventName = "cluster." + property.getValue().toLowerCase();
                if (GMSEvent.isValidType(eventName)) continue;
                throw new IllegalArgumentException(" name property of cluster event is invalid ");
            }
            if (!propertyName.equals("servername")) continue;
            serverName = property.getValue();
        }
        return new GMSEvent(eventName, new GMSNotificationFilter(serverName, eventName), description);
    }

    public static GMSEventFactory getInstance() {
        return instance;
    }
}

