/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.ee.selfmanagement.actions.LowMemoryAlertActionMBean;
import com.sun.enterprise.ee.selfmanagement.actions.MailAlert;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class LowMemoryAlertAction
implements MBeanRegistration,
LowMemoryAlertActionMBean,
NotificationListener {
    private ObjectName myObjectName = null;
    private String memoryPoolNames = "Perm Gen, Tenured Gen";
    private String listeners = null;
    private int threshold = 80;
    private int offset = 5;
    private String mailRecipients;
    private String mailResource;
    private List<String> listenersList = new ArrayList<String>(2);
    private List<String> poolNamesList = new ArrayList<String>(2);
    static StringManager sm = StringManager.getManager(LowMemoryAlertAction.class);
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " LowMemoryAlertAction : postRegister registration Done ");
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " LowMemoryAlertAction : preRegister ObjectName " + name);
        }
        this.myObjectName = name;
        return name;
    }

    public void preDeregister() throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " LowMemoryAlertAction : preDeRegister ");
        }
    }

    public void postDeregister() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " LowMemoryAlertAction : postDeRegister ");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        String notifType = notification.getType();
        if (notifType.equals("java.management.memory.threshold.exceeded")) {
            this.sendMailAlert(notification);
            if (this.offset != 0) {
                this.setThresholds();
            }
            return;
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, sm.getString("actions.activated", (Object)"Low Memory Alert", (Object)notification));
        }
        this.registerForMemoryThresholdNotifications();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setMailRecipients(String recipients) {
        this.mailRecipients = recipients;
    }

    public void setMailResource(String mailRes) {
        this.mailResource = mailRes;
    }

    public void setListeners(String listeners) {
        if (listeners != null) {
            this.listeners = listeners;
            StringTokenizer tokenizer = new StringTokenizer(listeners, ",");
            while (tokenizer.hasMoreTokens()) {
                this.listenersList.add(tokenizer.nextToken());
            }
        }
    }

    public void setMemoryPoolNames(String poolNames) {
        if (poolNames != null) {
            this.memoryPoolNames = poolNames;
            StringTokenizer tokenizer = new StringTokenizer(poolNames, ",");
            while (tokenizer.hasMoreTokens()) {
                this.poolNamesList.add(tokenizer.nextToken());
            }
        }
    }

    void registerForMemoryThresholdNotifications() {
        MemoryMXBean memMXBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)memMXBean);
        emitter.addNotificationListener(this, null, null);
        for (String listener : this.listenersList) {
            try {
                emitter.addNotificationListener((NotificationListener)Class.forName(listener).newInstance(), null, null);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, " Error in loading class " + listener, ex);
            }
        }
        this.setThresholds();
    }

    private void setThresholds() {
        this.threshold += this.offset;
        List<MemoryPoolMXBean> memPoolsList = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memPoolBean : memPoolsList) {
            if (!this.poolNamesList.contains(memPoolBean.getName()) || !memPoolBean.isUsageThresholdSupported()) continue;
            MemoryUsage usage = memPoolBean.getUsage();
            long thrsh = usage.getMax() * (long)this.threshold / 100L;
            memPoolBean.setUsageThreshold(thrsh);
        }
    }

    private void sendMailAlert(Notification notif) {
        MailAlert mAlert = new MailAlert();
        mAlert.setRecipients(this.mailRecipients);
        mAlert.setMailResource(this.mailResource);
        CompositeData cd = (CompositeData)notif.getUserData();
        MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
        String alertMsg = "Number of times the memory usage crossed the threshold = " + info.getCount() + " for the memory pool " + info.getPoolName() + " Memory Usage is " + info.getUsage();
        Notification n1 = new Notification(notif.getType(), notif.getSource(), notif.getSequenceNumber(), alertMsg);
        mAlert.notification(n1, null);
    }
}

