/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.selfmanagement.actions.InstanceHangAction;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckListenerHealth
implements Callable<Boolean> {
    static final String ANY_ADDR = "0.0.0.0";
    static final String HTTP_PROTOCOL = "http://";
    static final String HTTPS_PROTOCOL = "https://";
    static final String TYPE_KEY_NAME = "type";
    static final String NAME_KEY = "name";
    static final String HTTP_SELECTOR = "Selector";
    static final String BUSY_PTHREADS_NAME = "currentBusyProcessorThreads";
    static final String MAX_THREAD_NAME = "maxThreads";
    private Server server = null;
    private HttpListener listener = null;
    private int timeoutInSeconds;
    private int connectTimeout;
    private int listenerPort;
    private int countAcceptorThreads;
    boolean isHealthy = false;
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");

    public CheckListenerHealth(Server inst, HttpListener httpListener, int timeout) throws ConfigException {
        this.server = inst;
        this.listener = httpListener;
        this.timeoutInSeconds = timeout;
        String val = httpListener.getAcceptorThreads();
        this.countAcceptorThreads = Integer.parseInt(val);
        val = httpListener.getPort();
        PropertyResolver pr = new PropertyResolver(InstanceHangAction.configCtx, inst.getName());
        String resolvedPort = pr.resolve(val);
        this.listenerPort = Integer.parseInt(resolvedPort);
        this.connectTimeout = 5000;
    }

    private TrustManager[] setupAllTrust() {
        TrustManager[] trustAllCerts = null;
        try {
            trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trustAllCerts;
    }

    private Method reflectInstanceRegistry() {
        Method mthd = null;
        try {
            String INSTANCEREGISTRYCLASS = "com.sun.enterprise.ee.admin.clientreg.InstanceRegistry";
            String OPNAME = "getInstanceConnection";
            Class<?> reflec = Class.forName("com.sun.enterprise.ee.admin.clientreg.InstanceRegistry");
            Class[] types = new Class[]{Class.forName("java.lang.String")};
            mthd = reflec.getDeclaredMethod("getInstanceConnection", types);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mthd;
    }

    boolean checkInstanceStatistics(String listener) {
        MBeanServerConnection mbsConn = null;
        String domain = ApplicationServer.getServerContext().getDefaultDomainName();
        String name = "http" + this.listenerPort;
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        try {
            props.put(TYPE_KEY_NAME, HTTP_SELECTOR);
            props.put(NAME_KEY, name);
            ObjectName objName = new ObjectName(domain, props);
            Method refMethod = this.reflectInstanceRegistry();
            if (refMethod == null) {
                throw new Exception();
            }
            Object[] params = new Object[]{this.server.getName()};
            mbsConn = (MBeanServerConnection)refMethod.invoke(null, params);
            Integer val = (Integer)mbsConn.getAttribute(objName, MAX_THREAD_NAME);
            int maxThreads = val;
            val = (Integer)mbsConn.getAttribute(objName, BUSY_PTHREADS_NAME);
            int busyCount = val;
            if (busyCount == this.countAcceptorThreads * maxThreads) {
                _logger.log(Level.INFO, "sgmt.instancehang_listenermaxd", new Object[]{this.server.getName(), listener, val.toString()});
                return false;
            }
            _logger.log(Level.INFO, "sgmt.instancehang_listenersnotmaxd", new Object[]{this.server.getName(), listener, val});
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Boolean call() throws Exception {
        boolean isHealthy = true;
        String address = this.listener.getAddress();
        JMXConnectorConfig jmxCfg = null;
        String urlString = null;
        ConfigContext configCtx = InstanceHangAction.configCtx;
        try {
            boolean sslEnabled;
            if (address.equals(ANY_ADDR)) {
                jmxCfg = ServerHelper.getJMXConnectorInfo((ConfigContext)configCtx, (String)this.server.getName());
                address = jmxCfg.getHost();
            }
            if (sslEnabled = this.listener.isSecurityEnabled()) {
                urlString = HTTPS_PROTOCOL + address + ":" + this.listenerPort + "/";
                URL url = new URL(urlString);
                _logger.log(Level.INFO, "sgmt.instancehang_startlistcheck", new Object[]{this.server.getName(), urlString});
                TrustManager[] trustAllCerts = this.setupAllTrust();
                SSLContext sc = SSLContext.getInstance("SSL");
                KeyManager[] keyMgr = SSLUtils.getKeyManagers();
                sc.init(keyMgr, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HttpsURLConnection urlCon = (HttpsURLConnection)url.openConnection();
                urlCon.setConnectTimeout(this.connectTimeout);
                urlCon.setReadTimeout(this.timeoutInSeconds * 1000);
                urlCon.connect();
                InputStream buffer = urlCon.getInputStream();
                buffer.read();
            } else {
                urlString = HTTP_PROTOCOL + address + ":" + this.listenerPort + "/";
                URL url = new URL(urlString);
                _logger.log(Level.INFO, "sgmt.instancehang_startlistcheck", new Object[]{this.server.getName(), urlString});
                HttpURLConnection urlCon = (HttpURLConnection)url.openConnection();
                urlCon.setConnectTimeout(this.connectTimeout);
                urlCon.setReadTimeout(this.timeoutInSeconds * 1000);
                urlCon.connect();
                InputStream buffer = urlCon.getInputStream();
                buffer.read();
            }
        }
        catch (MalformedURLException ex) {
        }
        catch (IOException ex) {
            _logger.log(Level.WARNING, "sgmt.instancehang_listener_notresponding", new Object[]{this.server.getName(), urlString, this.timeoutInSeconds});
            isHealthy = this.checkInstanceStatistics(urlString);
            return isHealthy;
        }
        catch (IllegalArgumentException ex) {
        }
        catch (Exception ex) {
            // empty catch block
        }
        _logger.log(Level.INFO, "sgmt.instancehang_listenerresp", new Object[]{this.server.getName(), urlString});
        return isHealthy;
    }
}

