/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import java.util.Properties;

public class AgentConfig
extends RepositoryConfig {
    public static final String AGENT_INSTANCE_NAME = "agent";
    public static final String K_USER = "agent.user";
    public static final String K_PASSWORD = "agent.password";
    public static final String K_ADMIN_PORT = "agent.adminPort";
    public static final String K_AGENT_ROOT = "agent.root";
    public static final String K_ADMIN_HOST = "agent.adminHost";
    public static final String K_AGENT_PROTOCOL = "agent.protocol";
    public static final String K_AGENT_LOG_LEVEL = "agent.log.level";
    public static final String K_AGENT_LOG_FILE = "agent.log.file";
    public static final String K_AGENT_BIND_STATUS = "agent.bind.status";
    public static final String K_AGENT_POLLING_INTERVAL = "agent.polling.interval";
    public static final String K_DAS_HOST = "agent.das.host";
    public static final String K_DAS_PROTOCOL = "agent.das.protocol";
    public static final String K_DAS_PORT = "agent.das.port";
    public static final String K_DAS_USER = "agent.das.user";
    public static final String K_DAS_PASSWORD = "agent.das.password";
    public static final String K_MASTER_PASSWORD = "agent.masterpassword";
    public static final String K_NEW_MASTER_PASSWORD = "agent.newmasterpassword";
    public static final String K_SAVE_MASTER_PASSWORD = "agent.saveMasterPassword";
    public static final String K_CLIENT_HOST = "agent.client.host";
    public static final String K_EXTRA_PASSWORDS = "agent.extraPasswords";
    public static final String K_DO_NOT_CONFIRM_SERVER_CERT = "agent.doNotConfirmServerCert";
    public static final String K_DAS_IS_SECURE = "agent.das.isSecure";
    public static final String NODEAGENT_DELETED_STATUS = "DELETED";
    public static final String NODEAGENT_BOUND_STATUS = "BOUND";
    public static final String NODEAGENT_UNBOUND_STATUS = "UNBOUND";
    public static final String NODEAGENT_JMX_DEFAULT_PROTOCOL = "rmi_jrmp";
    public static final String NODEAGENT_DEFAULT_HOST_ADDRESS = "0.0.0.0";
    public static final String NODEAGENT_DEFAULT_DAS_IS_SECURE = "true";
    public static final String NODEAGENT_ATTEMPT_RENDEZVOUS = "attemptRendezvous";
    public static final String NODEAGENT_ATTEMPT_LOCAL_RENDEZVOUS = "attemptLocalRendezvous";
    public static final String AGENT_LISTEN_ADDRESS_NAME = "listenaddress";
    public static final String REMOTE_CLIENT_ADDRESS_NAME = "remoteclientaddress";
    public static final String AGENT_JMX_PROTOCOL_NAME = "agentjmxprotocol";
    public static final String DAS_JMX_PROTOCOL_NAME = "dasjmxprotocol";
    public static final String AGENT_DAS_IS_SECURE = "isDASSecure";

    public AgentConfig() {
    }

    public AgentConfig(String agentName, String agentRoot, String instanceName) {
        super(agentName, agentRoot, instanceName);
        this.put(K_AGENT_ROOT, agentRoot);
    }

    public AgentConfig(String agentName, String agentRoot) {
        this(agentName, agentRoot, AGENT_INSTANCE_NAME);
    }

    public AgentConfig(String agentName, String agentRoot, String adminUser, String adminPassword, Integer adminPort, String DASHost, String DASPort, String DASUser, String DASPassword, String masterPassword, Boolean saveMasterPassword, Properties agentProperties) {
        this(agentName, agentRoot);
        String remoteClientHost = System.getProperty("com.sun.aas.hostName");
        String listenAddress = NODEAGENT_DEFAULT_HOST_ADDRESS;
        String agentJmxProtocol = NODEAGENT_JMX_DEFAULT_PROTOCOL;
        String dasJmxProtocol = NODEAGENT_JMX_DEFAULT_PROTOCOL;
        String dasIsSecure = NODEAGENT_DEFAULT_DAS_IS_SECURE;
        if (agentProperties != null) {
            remoteClientHost = agentProperties.getProperty(REMOTE_CLIENT_ADDRESS_NAME, System.getProperty("com.sun.aas.hostName"));
            listenAddress = agentProperties.getProperty(AGENT_LISTEN_ADDRESS_NAME, NODEAGENT_DEFAULT_HOST_ADDRESS);
            agentJmxProtocol = agentProperties.getProperty(AGENT_JMX_PROTOCOL_NAME, NODEAGENT_JMX_DEFAULT_PROTOCOL);
            dasJmxProtocol = agentProperties.getProperty(DAS_JMX_PROTOCOL_NAME, NODEAGENT_JMX_DEFAULT_PROTOCOL);
            dasIsSecure = agentProperties.getProperty(AGENT_DAS_IS_SECURE, NODEAGENT_DEFAULT_DAS_IS_SECURE);
        }
        this.put(K_USER, adminUser);
        this.put(K_PASSWORD, adminPassword);
        this.put(K_ADMIN_PORT, adminPort);
        this.put(K_DAS_USER, DASUser);
        this.put(K_DAS_PASSWORD, DASPassword);
        this.put(K_DAS_HOST, DASHost);
        this.put(K_DAS_PORT, DASPort);
        this.put(K_DAS_PROTOCOL, dasJmxProtocol);
        this.put(K_MASTER_PASSWORD, masterPassword);
        this.put(K_SAVE_MASTER_PASSWORD, saveMasterPassword);
        this.put(K_AGENT_PROTOCOL, agentJmxProtocol);
        this.put(K_ADMIN_HOST, listenAddress);
        this.put(K_CLIENT_HOST, remoteClientHost);
        this.put(K_DAS_IS_SECURE, dasIsSecure);
        this.put(K_AGENT_BIND_STATUS, NODEAGENT_UNBOUND_STATUS);
    }

    public String getAgentName() {
        return super.getRepositoryName();
    }

    public String getAgentRoot() {
        return super.getRepositoryRoot();
    }
}

