/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class SystemPropertyBaseMBean
extends EEBaseConfigMBean
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager(SystemPropertyBaseMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(SystemPropertyBaseMBean.getLogger());
        }
        return _handler;
    }

    protected abstract String getLogMessageId();

    protected String getName() throws InstanceException {
        try {
            return (String)this.getAttribute("name");
        }
        catch (Exception ex) {
            throw SystemPropertyBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), "unknown");
        }
    }

    public Properties listSystemProperties(boolean inherit) throws InstanceException {
        String name = this.getName();
        try {
            return this.getPropertyConfigBean().listSystemProperties(name, inherit);
        }
        catch (Exception ex) {
            throw SystemPropertyBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public void createSystemProperties(Properties props) throws InstanceException {
        String name = this.getName();
        try {
            this.getPropertyConfigBean().createSystemProperties(props, name);
        }
        catch (Exception ex) {
            throw SystemPropertyBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public void deleteSystemProperty(String propertyName) throws InstanceException {
        String name = this.getName();
        try {
            this.getPropertyConfigBean().deleteSystemProperty(propertyName, name);
        }
        catch (Exception ex) {
            throw SystemPropertyBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }
}

