/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.admin.util.jmx.AttributeListUtils;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeans.EEApplicationsConfigMBean;
import com.sun.enterprise.ee.admin.mbeans.SystemPropertyBaseMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.ObjectName;

public abstract class ServerAndClusterBaseMBean
extends SystemPropertyBaseMBean
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager(ServerAndClusterBaseMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ServerAndClusterBaseMBean.getLogger());
        }
        return _handler;
    }

    private EEApplicationsConfigMBean getEEApplicationsConfigMBean() throws InstanceException, MBeanConfigException {
        try {
            return (EEApplicationsConfigMBean)MBeanRegistryFactory.getAdminMBeanRegistry().instantiateMBean("applications", new String[]{this.getDomainName()}, null, this.getConfigContext());
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), "");
        }
    }

    public void createResourceReference(boolean enabled, String referenceName) throws InstanceException {
        String name = this.getName();
        try {
            this.getResourcesConfigBean().createResourceReference(name, enabled, referenceName);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public void deleteResourceReference(String referenceName) throws InstanceException {
        String name = this.getName();
        try {
            this.getResourcesConfigBean().deleteResourceReference(name, referenceName);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public String[] listResourceReferencesAsString() throws InstanceException {
        String name = this.getName();
        try {
            return this.getResourcesConfigBean().listResourceReferencesAsString(name);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public void createApplicationReference(boolean enabled, String virtualServers, String referenceName) throws InstanceException {
        String name = this.getName();
        try {
            this.getEEApplicationsConfigMBean().createApplicationReference(name, enabled, virtualServers, referenceName);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public void deleteApplicationReference(String referenceName) throws InstanceException {
        String name = this.getName();
        try {
            this.getEEApplicationsConfigMBean().deleteApplicationReference(name, referenceName);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public String[] listApplicationReferencesAsString() throws InstanceException {
        String name = this.getName();
        try {
            return this.getEEApplicationsConfigMBean().listApplicationReferencesAsString(name);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public ObjectName listConfiguration() throws InstanceException {
        String name = this.getName();
        try {
            this.getConfigsConfigBean().listConfigurationsAsString(name);
            return this.getConfigurationObjectName(name);
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), name);
        }
    }

    public ObjectName[] listResourceRefsByType(String type) throws InstanceException {
        type = AttributeListUtils.dash2CamelCase((String)type);
        ArrayList<ObjectName> refsByType = new ArrayList<ObjectName>();
        try {
            ObjectName[] refs = (ObjectName[])this.invoke("getResourceRef", null, null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    String ref = (String)this.getMBeanServer().getAttribute(refs[i], "ref");
                    assert (ref != null);
                    String resType = ResourceHelper.getResourceType((ConfigContext)this.getConfigContext(), (String)ref);
                    if (!resType.equals(type) || ResourceHelper.isSystemResource((ConfigContext)this.getConfigContext(), (String)ref)) continue;
                    refsByType.add(refs[i]);
                }
            }
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), this.getName());
        }
        return refsByType.toArray(new ObjectName[0]);
    }

    public ObjectName[] listApplicationRefsByType(String type) throws InstanceException {
        type = AttributeListUtils.dash2CamelCase((String)type);
        ArrayList<ObjectName> refsByType = new ArrayList<ObjectName>();
        try {
            ObjectName[] refs = (ObjectName[])this.invoke("getApplicationRef", null, null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    String ref = (String)this.getMBeanServer().getAttribute(refs[i], "ref");
                    assert (ref != null);
                    String appType = ApplicationHelper.getApplicationType((ConfigContext)this.getConfigContext(), (String)ref);
                    if (!appType.equals(type) || ApplicationHelper.isSystemApp((ConfigContext)this.getConfigContext(), (String)ref)) continue;
                    refsByType.add(refs[i]);
                }
            }
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), this.getName());
        }
        return refsByType.toArray(new ObjectName[0]);
    }

    public ObjectName[] listApplicationRefs() throws InstanceException {
        ArrayList<ObjectName> userRefs = new ArrayList<ObjectName>();
        try {
            ObjectName[] refs = (ObjectName[])this.invoke("getApplicationRef", null, null);
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    String ref = (String)this.getMBeanServer().getAttribute(refs[i], "ref");
                    assert (ref != null);
                    String appType = ApplicationHelper.getApplicationType((ConfigContext)this.getConfigContext(), (String)ref);
                    if (ApplicationHelper.isSystemApp((ConfigContext)this.getConfigContext(), (String)ref)) continue;
                    userRefs.add(refs[i]);
                }
            }
        }
        catch (Exception ex) {
            throw ServerAndClusterBaseMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), this.getName());
        }
        return userRefs.toArray(new ObjectName[0]);
    }
}

