/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.mbeans.custom.BasicCustomMBeanConfigQueries;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanConfigQueries;
import com.sun.enterprise.admin.server.core.CustomMBeanException;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.mbeans.EnterpriseCustomMBeanOperations;
import java.util.List;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseCustomMBeanConfigQueries
extends BasicCustomMBeanConfigQueries
implements CustomMBeanConfigQueries {
    private final TargetType[] vTargets = new TargetType[4];

    public EnterpriseCustomMBeanConfigQueries() {
        this.vTargets[0] = TargetType.DOMAIN;
        this.vTargets[1] = TargetType.DAS;
        this.vTargets[2] = TargetType.SERVER;
        this.vTargets[3] = TargetType.CLUSTER;
    }

    public boolean existsMBean(String target, String name) throws CustomMBeanException {
        return false;
    }

    public boolean isMBeanEnabled(String target, String name) throws CustomMBeanException {
        return false;
    }

    public List<ObjectName> listMBeanConfigObjectNames(String target) throws CustomMBeanException {
        List ons = null;
        Target t = null;
        try {
            t = TargetBuilder.INSTANCE.createTarget(target, this.vTargets, target, this.acc);
        }
        catch (ConfigException e) {
            throw new CustomMBeanException((Throwable)e);
        }
        if (TargetType.DAS.equals((Object)t.getType()) || TargetType.SERVER.equals((Object)t.getType())) {
            if (TargetType.SERVER.equals((Object)t.getType())) {
                EnterpriseCustomMBeanOperations.checkClusteredInstance(this.acc, t.getName());
            }
            ons = super.listMBeanConfigObjectNamesForServer(t.getName());
        } else if (TargetType.DOMAIN.equals((Object)t.getType())) {
            ons = this.getMBeanDefinitionObjectNamesInDomain();
        } else {
            String nameOfAServerInCluster = null;
            try {
                Server[] servers = ServerHelper.getServersInCluster((ConfigContext)this.acc, (String)target);
                nameOfAServerInCluster = servers[0].getName();
                ons = super.listMBeanConfigObjectNamesForServer(nameOfAServerInCluster);
            }
            catch (ConfigException e) {
                throw new CustomMBeanException((Throwable)e);
            }
        }
        return ons;
    }

    public List<ObjectName> listMBeanConfigObjectNames(String target, int type, boolean state) throws CustomMBeanException {
        return null;
    }

    public List<String> listMBeanNames(String target) throws CustomMBeanException {
        return super.listMBeanNames(target);
    }

    private List<ObjectName> getMBeanDefinitionObjectNamesInDomain() throws CustomMBeanException {
        try {
            List mbeans = ServerBeansFactory.getAllMBeanDefinitions((ConfigContext)this.acc);
            return super.mbeans2ConfigMBeanObjectNames(mbeans);
        }
        catch (Exception e) {
            throw new CustomMBeanException((Throwable)e);
        }
    }
}

