/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class HADBConfigurePersistenceInfo
extends HADBInfo {
    String type;
    String frequency;
    String scope;
    String store;
    Properties props;
    private static final String[] LEGAL_TYPES_ARRAY = new String[]{"memory", "file", "ha", "jdbc-oracle", "jdbc-pointbase", "custom"};
    private static final String LEGAL_TYPES = "memory | file | ha | jdbc-oracle | jdbc-pointbase | custom";
    private static final String[] LEGAL_FREQS_ARRAY = new String[]{"web-method", "time-based", "on-demand"};
    private static final String LEGAL_FREQS = "web-method | time-based | on-demand";
    private static final String[] LEGAL_SCOPES_ARRAY = new String[]{"session", "modified-session", "modified-attribute"};
    private static final String LEGAL_SCOPES = "session | modified-session | modified-attribute";

    public HADBConfigurePersistenceInfo(String clusterOrDbName, Logger logger, ConfigContext configCtx, MBeanServer mbeanServer, String type, String frequency, String scope, String store, Properties props) throws HADBSetupException {
        super(null, null, null, null, clusterOrDbName, logger, configCtx, mbeanServer);
        this.type = type;
        this.frequency = frequency;
        this.scope = scope;
        this.store = store;
        this.props = props;
    }

    public void setup() throws HADBSetupException {
        this.verifyStandaloneCluster();
        this.setHadbRoot();
    }

    void validate() throws HADBSetupException {
        if (this.type == null || this.type.length() <= 0) {
            this.type = null;
        } else {
            this.validateOne(this.type, LEGAL_TYPES_ARRAY, "type", LEGAL_TYPES);
        }
        if (this.frequency == null || this.frequency.length() <= 0) {
            this.frequency = null;
        } else {
            this.validateOne(this.frequency, LEGAL_FREQS_ARRAY, "frequency", LEGAL_FREQS);
        }
        if (this.scope == null || this.scope.length() <= 0) {
            this.scope = null;
        } else {
            this.validateOne(this.scope, LEGAL_SCOPES_ARRAY, "scope", LEGAL_SCOPES);
        }
        if (this.store == null || this.store.length() <= 0) {
            this.store = null;
        }
        if (this.props == null || this.props.size() <= 0) {
            this.props = null;
        }
        if (this.type == null && this.frequency == null && this.scope == null && this.store == null && this.props == null) {
            throw new HADBSetupException("hadbmgmt-res.NothingToDo");
        }
    }

    private final void validateOne(String val, String[] valids, String argName, String validsMessage) throws HADBSetupException {
        for (int i = 0; i < valids.length; ++i) {
            if (!val.equals(valids[i])) continue;
            return;
        }
        throw new HADBSetupException("hadbmgmt-res.BadArgument", new Object[]{argName, validsMessage});
    }
}

