/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import java.io.File;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean protect(File f) {
        if (!f.exists()) {
            return true;
        }
        if (FileUtils.isUNIX()) {
            return FileUtils.protectUNIX(f);
        }
        return FileUtils.protectWindows(f);
    }

    private static boolean protectUNIX(File f) {
        String fname = f.getAbsolutePath();
        String mode = "0600";
        if (f.isDirectory()) {
            mode = "0700";
        }
        String cmd = "chmod " + mode + " " + fname;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return p.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean protectWindows(File f) {
        return true;
    }

    public static boolean isUNIX() {
        return File.separatorChar == '/';
    }
}

