/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.event.pluggable;

import com.sun.enterprise.admin.event.ElementChangeHelper;
import com.sun.enterprise.admin.event.pluggable.RestartEventHelper;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.event.EEEventDispatcher;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.proxy.InstanceProxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EERestartEventHelper
implements RestartEventHelper {
    private static Logger _logger = null;

    public void setRestartRequiredForTarget(ConfigContext ctx, ArrayList configChangeList) {
        try {
            AdminService admServ = AdminService.getAdminService();
            if (admServ != null && admServ.isDas()) {
                Set nonDynSet = ElementChangeHelper.getXPathesForDynamicallyNotReconfigurableElements((ArrayList)configChangeList);
                Iterator iter = nonDynSet.iterator();
                if (iter == null) {
                    EERestartEventHelper.getLogger().log(Level.FINE, "EERestartEventHelper: All changes were dynamically reconfigurable");
                    return;
                }
                HashSet<String> targetSet = new HashSet<String>();
                TargetBuilder tgtBldr = new TargetBuilder();
                while (iter.hasNext()) {
                    String xpath = (String)iter.next();
                    String target = null;
                    try {
                        target = tgtBldr.getTargetNameForXPath(xpath, ctx, true);
                        targetSet.add(target);
                    }
                    catch (Exception e) {
                        EERestartEventHelper.getLogger().log(Level.INFO, "eeadmin.no_target_for_xpath", xpath);
                    }
                }
                EEEventDispatcher eeDisp = new EEEventDispatcher();
                Set svrSet = eeDisp.resolveTargets(ctx, targetSet);
                this.setRestartRequiredForTargetInternal(ctx, svrSet, true);
            }
        }
        catch (Throwable t) {
            EERestartEventHelper.getLogger().log(Level.INFO, "eeadmin.exception_during_restart_reset", t);
        }
    }

    private void setRestartRequiredForTargetInternal(ConfigContext ctx, Set targets, boolean restart) {
        Iterator iter = null;
        if (targets != null) {
            iter = targets.iterator();
        }
        if (iter == null) {
            EERestartEventHelper.getLogger().log(Level.FINE, "EERestartEventHelper: No targets found for the configuration changes");
            return;
        }
        while (iter.hasNext()) {
            String inst = (String)iter.next();
            this.setRestartRequiredRemote(ctx, inst, true);
        }
    }

    void setRestartRequiredRemote(ConfigContext ctx, String inst, boolean restartFlag) {
        try {
            if (ServerHelper.isAServer((ConfigContext)ctx, (String)inst)) {
                ServerRuntimeMBean runtimeMBean = InstanceProxy.getInstanceProxy(inst);
                runtimeMBean.setRestartRequired(restartFlag);
            }
        }
        catch (Throwable t) {
            EERestartEventHelper.getLogger().log(Level.FINE, "eeadmin.setrestart.exception", t);
        }
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }
}

