/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.event;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.admin.event.EndPoint;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.StringTokenizer;
import java.util.logging.Logger;

abstract class TargetHelperBase {
    String _name = null;
    String _type = null;
    ConfigContext _context = null;
    static final String DELIM = "|";
    static final int TOKEN_NUM = 3;
    static final StringManager _strMgr = StringManager.getManager(TargetHelperBase.class);
    static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    TargetHelperBase(String target, ConfigContext ctx) {
        StringTokenizer st = new StringTokenizer(target, DELIM);
        int tokens = st.countTokens();
        if (tokens != 3) {
            String msg = _strMgr.getString("invalid.target", (Object)target);
            throw new IllegalArgumentException(msg);
        }
        String prefix = st.nextToken();
        this._name = st.nextToken();
        this._type = st.nextToken();
        this._context = ctx;
    }

    String getType() {
        return this._type;
    }

    String getName() {
        return this._name;
    }

    static EndPoint[] createEndPoints(Server[] servers, ConfigContext ctx) throws ConfigException {
        EndPoint[] endPoints = null;
        if (servers != null) {
            endPoints = new EndPoint[servers.length];
            for (int i = 0; i < servers.length; ++i) {
                _logger.finest("[TargetHelper] Creating end point for " + servers[i].getName());
                endPoints[i] = new EndPoint(servers[i], ctx);
            }
        }
        return endPoints;
    }

    static boolean isResourceTarget(String target) {
        StringTokenizer st;
        int tokens;
        boolean tf = false;
        if (target != null && target.startsWith("resources") && (tokens = (st = new StringTokenizer(target, DELIM)).countTokens()) == 3) {
            tf = true;
        }
        return tf;
    }

    static boolean isApplicationTarget(String target) {
        StringTokenizer st;
        int tokens;
        boolean tf = false;
        if (target != null && target.startsWith("applications") && (tokens = (st = new StringTokenizer(target, DELIM)).countTokens()) == 3) {
            tf = true;
        }
        return tf;
    }

    abstract EndPoint[] getEndPoints() throws ConfigException;
}

