/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.ee.admin.PortInUse;
import com.sun.enterprise.ee.admin.PortInUseException;
import com.sun.enterprise.ee.admin.PortReplacedException;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.ee.admin.concurrent.Executor;
import com.sun.enterprise.ee.admin.concurrent.Task;
import com.sun.enterprise.ee.admin.configbeans.ConfigsConfigBean;
import com.sun.enterprise.ee.admin.configbeans.NodeAgentsConfigBean;
import com.sun.enterprise.ee.admin.configbeans.PortConflictCheckerConfigBean;
import com.sun.enterprise.ee.admin.configbeans.PropertyConfigBean;
import com.sun.enterprise.ee.admin.configbeans.ServersAndClustersBaseBean;
import com.sun.enterprise.ee.admin.mbeanapi.NodeAgentMBean;
import com.sun.enterprise.ee.admin.mbeanapi.ServerRuntimeMBean;
import com.sun.enterprise.ee.admin.proxy.InstanceProxy;
import com.sun.enterprise.ee.admin.proxy.NodeAgentProxy;
import com.sun.enterprise.ee.admin.servermgmt.EEInstancesManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.enterprise.util.net.NetUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;

public class ServersConfigBean
extends ServersAndClustersBaseBean
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager(ServersConfigBean.class);
    private static final TargetType[] VALID_LIST_TYPES = new TargetType[]{TargetType.DOMAIN, TargetType.CLUSTER, TargetType.SERVER, TargetType.NODE_AGENT};
    private static final TargetType[] VALID_TYPES = new TargetType[]{TargetType.SERVER};

    public ServersConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    public void clearRuntimeStatus(String serverName) throws InstanceException {
        block2: {
            try {
                ServerRuntimeMBean serverMBean = InstanceProxy.getInstanceProxy(serverName);
                serverMBean.clearRuntimeStatus();
            }
            catch (Exception ex) {
                if (InstanceProxy.isUnreachable(ex)) break block2;
                throw new InstanceException((Throwable)ex);
            }
        }
    }

    public RuntimeStatus getRuntimeStatus(String serverName) throws InstanceException {
        try {
            ServerRuntimeMBean serverMBean = InstanceProxy.getInstanceProxy(serverName);
            return serverMBean.getRuntimeStatus();
        }
        catch (Exception ex) {
            if (InstanceProxy.isUnreachable(ex)) {
                return new RuntimeStatus(serverName);
            }
            throw new InstanceException((Throwable)ex);
        }
    }

    public boolean isRunning(String serverName) throws InstanceException {
        return this.getRuntimeStatus(serverName).isRunning();
    }

    public RuntimeStatusList getRuntimeStatus(Server[] servers) {
        return this.getRuntimeStatus(this.toStringArray(servers));
    }

    public RuntimeStatusList getRuntimeStatus(String[] servers) {
        Task[] tasks = new GetRuntimeStatusTask[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            tasks[i] = new GetRuntimeStatusTask(servers[i]);
        }
        Executor exec = new Executor(tasks);
        exec.run();
        RuntimeStatusList result = new RuntimeStatusList(servers.length);
        for (int i = 0; i < servers.length; ++i) {
            result.add((Object)((GetRuntimeStatusTask)tasks[i]).getStatus());
        }
        return result;
    }

    public RuntimeStatusList getServerInstanceRuntimeStatus(String targetName) throws InstanceException {
        ConfigContext configContext = this.getConfigContext();
        StringManager stringMgr = StringManager.getManager(EEInstancesManager.class);
        try {
            Target target = TargetBuilder.INSTANCE.createTarget("domain", VALID_LIST_TYPES, targetName, configContext);
            Server[] servers = target.getServers();
            return this.getRuntimeStatus(servers);
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.listInstances.Exception", targetName);
        }
    }

    public String[] listServerInstancesAsString(String targetName, boolean andStatus) throws InstanceException {
        ConfigContext configContext = this.getConfigContext();
        StringManager stringMgr = StringManager.getManager(EEInstancesManager.class);
        try {
            Target target = TargetBuilder.INSTANCE.createTarget("domain", VALID_LIST_TYPES, targetName, configContext);
            Server[] servers = target.getServers();
            int numServers = servers.length;
            ArrayList<String> result = new ArrayList<String>();
            String serverName = null;
            RuntimeStatusList statusList = null;
            if (andStatus) {
                statusList = this.getRuntimeStatus(servers);
            }
            for (int i = 0; i < numServers; ++i) {
                serverName = servers[i].getName();
                if (andStatus) {
                    if (ServerHelper.isDAS((ConfigContext)configContext, (String)serverName)) continue;
                    result.add(stringMgr.getString("listInstanceElement", (Object)serverName, (Object)statusList.getStatus(i).toShortString()));
                    continue;
                }
                result.add(serverName);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.listInstances.Exception", targetName);
        }
    }

    public String listDASServerInstanceAsString(boolean andStatus) throws InstanceException {
        ConfigContext configContext = this.getConfigContext();
        String dasName = null;
        try {
            Server das = ServerHelper.getDAS((ConfigContext)configContext);
            dasName = das.getName();
            return this.listServerInstancesAsString(dasName, andStatus)[0];
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.listInstances.Exception", dasName);
        }
    }

    public String[] listUnclusteredServerInstancesAsString(boolean andStatus, boolean excludeDASInstance) throws InstanceException {
        ConfigContext configContext = this.getConfigContext();
        StringManager stringMgr = StringManager.getManager(EEInstancesManager.class);
        try {
            Server[] servers = ServerHelper.getUnclusteredServers((ConfigContext)configContext, (boolean)excludeDASInstance);
            ArrayList<String> result = new ArrayList<String>();
            RuntimeStatusList statusList = null;
            if (andStatus) {
                statusList = this.getRuntimeStatus(servers);
            }
            for (int i = 0; i < servers.length; ++i) {
                String serverName = servers[i].getName();
                if (andStatus) {
                    result.add(stringMgr.getString("listInstanceElement", (Object)serverName, (Object)statusList.getStatus(i).toShortString()));
                    continue;
                }
                result.add(serverName);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.listInstances.Exception", "unclustered instances");
        }
    }

    public void startServerInstance(String serverName) throws InstanceException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = null;
            try {
                target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, serverName, configContext);
            }
            catch (Exception e) {
                throw new InstanceException(_strMgr.getString("noSuchInstance", (Object)serverName));
            }
            NodeAgent controller = target.getNodeAgents()[0];
            String agentName = controller.getName();
            NodeAgentsConfigBean ncb = this.getNodeAgentsConfigBean();
            if (ncb.isRunning(agentName)) {
                if (this.isRunning(serverName)) {
                    StringManagerBase sm = StringManagerBase.getStringManager((String)ServersConfigBean.getLogger().getResourceBundleName());
                    ServersConfigBean.getLogger().log(Level.WARNING, sm.getString("eeadmin.already.running", (Object)serverName));
                    return;
                }
            } else {
                throw new InstanceException(_strMgr.getString("agentNotRunning", (Object)agentName, (Object)serverName));
            }
            String installRoot = System.getProperty("com.sun.aas.installRoot");
            String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(agentName);
            agentMBean.startInstance(serverName);
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.startServerInstance.Exception", serverName);
        }
    }

    public void stopServerInstance(String serverName, int timeout) throws InstanceException {
        this.stopServerInstance(serverName, true, timeout);
    }

    public void stopServerInstance(String serverName) throws InstanceException {
        this.stopServerInstance(serverName, false, -1);
    }

    private void stopServerInstance(String serverName, boolean forcekill, int timeout) throws InstanceException {
        block5: {
            try {
                ConfigContext configContext = this.getConfigContext();
                Target target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, serverName, configContext);
                NodeAgent controller = target.getNodeAgents()[0];
                String agentName = controller.getName();
                NodeAgentsConfigBean ncb = this.getNodeAgentsConfigBean();
                if (ncb.isRunning(agentName)) {
                    NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(agentName);
                    if (forcekill) {
                        agentMBean.stopInstance(serverName, timeout);
                    } else {
                        agentMBean.stopInstance(serverName);
                    }
                    break block5;
                }
                throw new InstanceException(_strMgr.getString("agentNotRunning", (Object)agentName, (Object)serverName));
            }
            catch (Exception ex) {
                throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.stopServerInstance.Exception", serverName);
            }
        }
    }

    public void restartServerInstance(String serverName) throws InstanceException {
        boolean restarted = false;
        try {
            if (this.isRunning(serverName)) {
                this.stopServerInstance(serverName);
            }
            if (!this.isRunning(serverName)) {
                this.startServerInstance(serverName);
                restarted = true;
            }
            if (!restarted) {
                throw new InstanceException(_strMgr.getString("serverCannotRestart", (Object)serverName));
            }
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.restartServerInstance.Exception", serverName);
        }
    }

    private void deleteClusterReferences(String serverName) throws ConfigException, InstanceException {
        ConfigContext configContext = this.getConfigContext();
        Cluster cluster = ClusterHelper.getClusterForInstance((ConfigContext)configContext, (String)serverName);
        ServerRef ref = cluster.getServerRefByRef(serverName);
        if (ref == null) {
            throw new InstanceException(_strMgr.getString("clusterMissingServerRef", (Object)cluster.getName(), (Object)serverName));
        }
        cluster.removeServerRef(ref, true);
    }

    public void deleteServerInstance(String serverName) throws InstanceException {
        try {
            boolean isReachable;
            Server server;
            Servers servers;
            NodeAgent controller;
            ConfigContext configContext;
            block8: {
                configContext = this.getConfigContext();
                Target target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, serverName, configContext);
                controller = target.getNodeAgents()[0];
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
                servers = domain.getServers();
                server = target.getServers()[0];
                isReachable = true;
                try {
                    ServerRuntimeMBean serverMBean = InstanceProxy.getInstanceProxy(serverName);
                    Status status = serverMBean.getRuntimeStatus().getStatus();
                }
                catch (Exception ex) {
                    if (!InstanceProxy.isUnreachable(ex)) break block8;
                    isReachable = false;
                }
            }
            if (isReachable) {
                throw new InstanceException(_strMgr.getString("serverIsNotStopped", (Object)serverName));
            }
            if (ServerHelper.isServerStandAlone((ConfigContext)configContext, (String)serverName)) {
                String configName = server.getConfigRef();
                servers.removeServer(server, true);
                this.getConfigsConfigBean().deleteConfiguration(configName);
            } else {
                if (ServerHelper.isServerClustered((ConfigContext)configContext, (Server)server)) {
                    this.deleteClusterReferences(serverName);
                }
                servers.removeServer(server, true);
            }
            InstanceRegistry.removeInstanceConnection(serverName);
            this.flushAll();
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(controller.getName());
            agentMBean.synchronizeWithDAS();
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.deleteServerInstance.Exception", serverName);
        }
    }

    private void addServerProperties(Server server, Properties props) throws ConfigException {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                if (value == null) continue;
                SystemProperty sysProp = server.getSystemPropertyByName(name);
                if (sysProp != null) {
                    server.removeSystemProperty(sysProp, true);
                }
                SystemProperty ep = new SystemProperty();
                ep.setName(name);
                ep.setValue(value);
                server.addSystemProperty(ep, true);
            }
        }
    }

    protected void addApplicationReference(Object server, boolean enabled, String name, String virtualServers) throws ConfigException {
        ApplicationRef ref = new ApplicationRef();
        ref.setEnabled(enabled);
        ref.setRef(name);
        if (virtualServers != null) {
            ref.setVirtualServers(virtualServers);
        }
        ((Server)server).addApplicationRef(ref, true);
    }

    protected void addResourceReference(Object server, boolean enabled, String name) throws ConfigException {
        ResourceRef ref = new ResourceRef();
        ref.setEnabled(enabled);
        ref.setRef(name);
        ((Server)server).addResourceRef(ref, true);
    }

    private void createStandAloneServerInstance(Server server, Properties props) throws ConfigException, InstanceException {
        String standaloneConfigName = this.getConfigsConfigBean().createStandAloneConfiguration(server.getName(), props);
        this.createSharedServerInstance(standaloneConfigName, server, null);
    }

    private void createClusteredServerInstance(String clusterName, Server server, Properties props) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        this.addServerProperties(server, props);
        Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)configContext, (String)clusterName);
        server.setConfigRef(cluster.getConfigRef());
        Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
        domain.getServers().addServer(server, true);
        ServerRef serverRef = new ServerRef();
        serverRef.setRef(server.getName());
        cluster.addServerRef(serverRef, true);
        ApplicationRef[] appRefs = cluster.getApplicationRef();
        for (int i = 0; i < appRefs.length; ++i) {
            this.addApplicationReference(server, appRefs[i].isEnabled(), appRefs[i].getRef(), appRefs[i].getVirtualServers());
        }
        ResourceRef[] resRefs = cluster.getResourceRef();
        Object resRef = null;
        for (int i = 0; i < resRefs.length; ++i) {
            this.addResourceReference(server, resRefs[i].isEnabled(), resRefs[i].getRef());
        }
    }

    private void createSharedServerInstance(String configName, Server server, Properties props) throws ConfigException, InstanceException {
        ConfigContext configContext = this.getConfigContext();
        Config config = this.validateSharedConfiguration(configContext, configName);
        server.setConfigRef(configName);
        this.addServerProperties(server, props);
        this.addSystemApplications(server);
        this.addSystemResources(server);
        Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
        domain.getServers().addServer(server, true);
    }

    private ArrayList pickNonConflictingPorts(Server server, ArrayList portsInUse) throws ConfigException {
        Properties props = new Properties();
        boolean isBoundToHost = this.getPortConflictCheckerConfigBean().isBoundToHost(server);
        for (int i = 0; i < portsInUse.size(); ++i) {
            PortInUse portInUse = (PortInUse)portsInUse.get(i);
            int port = portInUse.getPort();
            int newPort = 0;
            newPort = isBoundToHost ? NetUtils.getNextFreePort((String)portInUse.getHostName(), (int)port) : port + 1;
            portInUse.setNewPort(newPort);
            props.put(portInUse.getPropertyName(), new Integer(newPort).toString());
        }
        this.addServerProperties(server, props);
        return portsInUse;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList resolvePortConflicts(Server server, Properties newProps) throws Exception {
        portChecker = this.getPortConflictCheckerConfigBean();
        serverName = server.getName();
        portsInUse = null;
        try {
            if (newProps != null) {
                portChecker.checkForPortConflicts(server, newProps, newProps, false);
            }
            i = 0;
            block6: while (true) {
                try {
                    portChecker.checkForPortConflicts(server, null, false);
                }
                catch (PortInUseException ex) {
                    if (i++ > 25) {
                        throw new InstanceException(ex.getMessage());
                    }
                    newPorts = this.pickNonConflictingPorts(server, ex.getConflictingPorts());
                    if (portsInUse == null) {
                        portsInUse = newPorts;
                        continue;
                    }
                    j = 0;
                    while (true) {
                        if (j < newPorts.size()) ** break;
                        continue block6;
                        newPort = (PortInUse)newPorts.get(j);
                        for (k = 0; k < portsInUse.size(); ++k) {
                            port = (PortInUse)portsInUse.get(k);
                            if (!port.getPropertyName().equals(newPort.getPropertyName())) continue;
                            port.setNewPort(newPort.getNewPort());
                            break;
                        }
                        ++j;
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            try {
                this.deleteServerInstance(serverName);
            }
            catch (Exception ex2) {
                sm = StringManagerBase.getStringManager((String)ServersConfigBean.getLogger().getResourceBundleName());
                ServersConfigBean.getLogger().log(Level.WARNING, sm.getString("eeadmin.createServerInstance.Exception", (Object)serverName), ex2);
            }
            throw ex;
        }
        return portsInUse;
    }

    public void createServerInstance(String nodeAgentName, String serverName, String configName, String clusterName, Properties props) throws InstanceException, PortReplacedException {
        ArrayList conflictingPorts = null;
        try {
            ConfigContext configContext = this.getConfigContext();
            if (!ConfigAPIHelper.isNameUnique((ConfigContext)configContext, (String)serverName)) {
                throw new InstanceException(_strMgr.getString("serverNameNotUnique", (Object)serverName));
            }
            ConfigAPIHelper.checkLegalName((String)serverName);
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            NodeAgents agents = domain.getNodeAgents();
            NodeAgent agent = agents.getNodeAgentByName(nodeAgentName);
            if (agent == null) {
                NodeAgentsConfigBean naMBean = this.getNodeAgentsConfigBean();
                naMBean.createNodeAgentConfig(nodeAgentName);
            }
            if (configName != null && clusterName != null) {
                throw new InstanceException(_strMgr.getString("configAndClusterMutuallyExclusive"));
            }
            Servers servers = domain.getServers();
            Server server = servers.getServerByName(serverName);
            if (server != null) {
                throw new InstanceException(_strMgr.getString("serverAlreadyExists", (Object)serverName));
            }
            server = new Server();
            server.setNodeAgentRef(nodeAgentName);
            server.setName(serverName);
            if (configName != null) {
                this.createSharedServerInstance(configName, server, props);
            } else if (clusterName != null) {
                this.createClusteredServerInstance(clusterName, server, props);
            } else {
                this.createStandAloneServerInstance(server, props);
            }
            conflictingPorts = this.resolvePortConflicts(server, props);
            this.flushAll();
            NodeAgentMBean agentMBean = NodeAgentProxy.getNodeAgentProxy(nodeAgentName);
            agentMBean.synchronizeWithDAS();
        }
        catch (Exception ex) {
            throw ServersConfigBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.createServerInstance.Exception", serverName);
        }
        if (conflictingPorts != null) {
            throw new PortReplacedException(conflictingPorts);
        }
    }

    private String[] toStringArray(Server[] sa) {
        int numServers = sa.length;
        String[] result = new String[numServers];
        for (int i = 0; i < numServers; ++i) {
            result[i] = sa[i].getName();
        }
        return result;
    }

    private PropertyConfigBean getPropertyConfigBean() {
        return new PropertyConfigBean(this.getConfigContext());
    }

    private NodeAgentsConfigBean getNodeAgentsConfigBean() {
        return new NodeAgentsConfigBean(this.getConfigContext());
    }

    private ConfigsConfigBean getConfigsConfigBean() {
        return new ConfigsConfigBean(this.getConfigContext());
    }

    private PortConflictCheckerConfigBean getPortConflictCheckerConfigBean() {
        return new PortConflictCheckerConfigBean(this.getConfigContext());
    }

    class GetRuntimeStatusTask
    extends Task {
        private static final long TIMEOUT_IN_MILLIS = 30000L;
        private String _serverName;
        private RuntimeStatus _status;

        public GetRuntimeStatusTask(String serverName) {
            super(30000L);
            this._serverName = serverName;
            this._status = new RuntimeStatus(this._serverName);
        }

        public RuntimeStatus getStatus() {
            return this._status;
        }

        public void run() {
            try {
                this._status = ServersConfigBean.this.getRuntimeStatus(this._serverName);
            }
            catch (InstanceException ex) {
                StringManagerBase sm = StringManagerBase.getStringManager((String)ServersAndClustersBaseBean.getLogger().getResourceBundleName());
                ServersAndClustersBaseBean.getLogger().log(Level.WARNING, sm.getString("eeadmin.listInstances.Exception", (Object)this._serverName), ex);
                this._status = new RuntimeStatus(this._serverName);
            }
        }
    }
}

