/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.cascading;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.cascading.CascadingLifecycleImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXConnector;

public class InstanceCascadingMBean
implements DynamicMBean {
    private String dClassName = this.getClass().getName();
    private String dDescription = "Implementation of a instance cascading dynamic MBean";
    private MBeanAttributeInfo[] dAttributes = new MBeanAttributeInfo[0];
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[2];
    private MBeanInfo dMBeanInfo = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManager _strMgr = StringManager.getManager(InstanceCascadingMBean.class);

    public InstanceCascadingMBean() {
        this.buildDynamicMBeanInfo();
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("attr_name_null")), _strMgr.getString("getter_null_attr", (Object)this.dClassName));
        }
        throw new AttributeNotFoundException(_strMgr.getString("attr_not_found", (Object)attribute_name, (Object)this.dClassName));
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("attr_name_null")), _strMgr.getString("setter_null_attr", (Object)this.dClassName));
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("attr_name_null")), _strMgr.getString("setter_null_attr", (Object)this.dClassName));
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("attr_array_null")), _strMgr.getString("getter_null_attr", (Object)this.dClassName));
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("attr_list_null")), _strMgr.getString("setter_null_attr", (Object)this.dClassName));
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("opr_name_null")), _strMgr.getString("opn_null", (Object)this.dClassName));
        }
        if (operationName.equals("cascadeInstance")) {
            if (params[0] == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("svr_name_null")), _strMgr.getString("opn_cascade_null", (Object)this.dClassName));
            }
            this.cascadeInstance((String)params[0]);
            return null;
        }
        if (operationName.equals("stopCascadeInstance")) {
            if (params[0] == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException(_strMgr.getString("svr_name_null")), _strMgr.getString("opn_cascade_null", (Object)this.dClassName));
            }
            this.stopCascadeInstance((String)params[0]);
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), _strMgr.getString("opn_not_found", (Object)operationName, (Object)this.dClassName));
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("InstanceCascadingMBean(): Constructs InstanceCascadingMBean object", constructors[0]);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("instanceName", "java.lang.String", "Server Instance Name")};
        this.dOperations[0] = new MBeanOperationInfo("cascadeInstance", "cascade remote server instance", params, "void", 1);
        this.dOperations[1] = new MBeanOperationInfo("stopCascadeInstance", "stop cascading remote server instance", params, "void", 1);
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, this.dAttributes, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    private void cascadeInstance(String instanceName) {
        String domain = ApplicationServer.getServerContext().getDefaultDomainName();
        ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            JMXConnector jmxConnector = ServerHelper.getJMXConnector((ConfigContext)configContext, (String)instanceName);
            CascadingLifecycleImpl cli = new CascadingLifecycleImpl();
            cli.cascadeInstance(domain, instanceName, jmxConnector);
        }
        catch (ConfigException ce) {
            ce.printStackTrace();
            _logger.log(Level.WARNING, "cascading.get_server_connector_config_error", ce);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            _logger.log(Level.WARNING, "cascadingConnectException", ioe);
        }
    }

    private void stopCascadeInstance(String instanceName) {
        CascadingLifecycleImpl cli = new CascadingLifecycleImpl();
        cli.stopCascadeInstance(instanceName);
    }
}

