/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.fileStreamer.BaseContext;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ServletStreamerContext
extends BaseContext {
    public static final String SERVLET_CONFIG = "contentSourceId";
    public static final String SERVLET_REQUEST = "contentSourceId";
    public static final String SERVLET_RESPONSE = "contentSourceId";
    public static final String CONTENT_SOURCE_ID = "contentSourceId";

    public ServletStreamerContext(ServletRequest request, ServletResponse resp, ServletConfig config) {
        this.setServletRequest(request);
        this.setServletResponse(resp);
        this.setServletConfig(config);
    }

    public ContentSource getContentSource() {
        String id = this.getServletRequest().getParameter("contentSourceId");
        if (id == null && (id = this.getServletConfig().getInitParameter("contentSourceId")) == null) {
            throw new RuntimeException("You must provide the 'contentSourceId' request parameter!");
        }
        ContentSource src = FileStreamer.getFileStreamer().getContentSource(id);
        if (src == null) {
            throw new RuntimeException("The ContentSource with id '" + id + "' is not registered!");
        }
        return src;
    }

    public void writeHeader(ContentSource source) {
        String contentType;
        ServletResponse resp = this.getServletResponse();
        if (!(resp instanceof HttpServletResponse)) {
            return;
        }
        long longTime = source.getLastModified(this);
        if (longTime != -1L) {
            ((HttpServletResponse)resp).setDateHeader("Last-Modified", longTime);
        }
        if ((contentType = (String)this.getAttribute("ContentType")) == null) {
            String ext = (String)this.getAttribute("extension");
            if (ext != null) {
                contentType = FileStreamer.getMimeType(ext);
            }
            if (contentType == null) {
                contentType = FileStreamer.getDefaultMimeType();
            }
        }
        ((HttpServletResponse)resp).setHeader("Content-type", contentType);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getServletResponse().getOutputStream();
    }

    public ServletConfig getServletConfig() {
        return (ServletConfig)this.getAttribute("contentSourceId");
    }

    protected void setServletConfig(ServletConfig config) {
        this.setAttribute("contentSourceId", config);
    }

    public ServletRequest getServletRequest() {
        return (ServletRequest)this.getAttribute("contentSourceId");
    }

    protected void setServletRequest(ServletRequest request) {
        this.setAttribute("contentSourceId", request);
    }

    public ServletResponse getServletResponse() {
        return (ServletResponse)this.getAttribute("contentSourceId");
    }

    protected void setServletResponse(ServletResponse response) {
        this.setAttribute("contentSourceId", response);
    }
}

