/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Stack;

public class ProgressBar
extends Component {
    protected Dimension size = new Dimension(250, 16);
    protected int progress = 0;
    protected int depth = 1;

    protected void drawProgress(Graphics g, int i, int j) {
        if (g == null) {
            return;
        }
        int k = this.size.width - 2 * this.depth;
        int l = (int)((double)k / 100.0 * (double)i);
        int i1 = (int)((double)k / 100.0 * (double)j);
        if (g != null) {
            if (i1 < l) {
                g.setColor(Color.white);
                g.fillRect(this.depth + i1, this.depth, l - i1, this.size.height - 2 * this.depth);
            } else {
                g.setColor(Color.blue);
                g.fillRect(this.depth + l, this.depth, i1 - l, this.size.height - 2 * this.depth);
            }
        }
    }

    protected void drawProgressBorder(Graphics g) {
        this.size = this.getSize();
        if (this.size.width == 0 || this.size.height == 0) {
            Stack<Container> stack = new Stack<Container>();
            Container container = this.getParent();
            Dimension dimension = null;
            if (container != null) {
                dimension = container.getSize();
            }
            while (container != null && (dimension.width == 0 || dimension.height == 0)) {
                stack.push(container);
                if ((container = container.getParent()) == null) continue;
                dimension = container.getSize();
            }
            if (container == null) {
                container = (Container)stack.pop();
            }
            if (container != null) {
                container.validate();
            }
            return;
        }
        Color color = this.getBackground();
        Color color1 = Color.white;
        Color color2 = Color.black;
        int i = 150 / this.depth;
        for (int j = 0; j < this.depth; ++j) {
            g.setColor(color1);
            g.drawLine(j, this.size.height - (j + 1), j, j);
            g.drawLine(j, j, this.size.width - (j + 1), j);
            g.setColor(color2);
            g.drawLine(j + 1, this.size.height - (j + 1), this.size.width - (j + 1), this.size.height - (j + 1));
            g.drawLine(this.size.width - (j + 1), this.size.height - (j + 1), this.size.width - (j + 1), j + 1);
            color1 = new Color(color1.getRed() - i, color1.getGreen() - i, color1.getBlue() - i);
            color2 = new Color(color2.getRed() + i, color2.getGreen() + i, color2.getBlue() + i);
        }
        g.setColor(Color.white);
        g.fillRect(this.depth, this.depth, this.size.width - 2 * this.depth, this.size.height - 2 * this.depth);
    }

    public int getDepth() {
        return this.depth;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Container container = this.getParent();
        if (container == null) {
            return this.size;
        }
        Dimension dimension = container.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return this.size;
        }
        Insets insets = container.getInsets();
        return new Dimension(dimension.width - insets.left - insets.right, this.size.height);
    }

    public int getProgress() {
        return this.progress;
    }

    public void paint(Graphics g) {
        Dimension dimension = this.getSize();
        g.setClip(0, 0, dimension.width, dimension.height);
        this.drawProgressBorder(g);
        this.drawProgress(g, 0, this.progress);
    }

    public void setDepth(int i) {
        this.depth = i;
    }

    public void setProgress(int i) {
        Graphics g = this.getGraphics();
        if (g != null) {
            Dimension dimension = this.getSize();
            g.setClip(0, 0, dimension.width, dimension.height);
        }
        this.drawProgress(g, this.progress, i);
        this.progress = i;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.size = dimension;
    }
}

