/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.certconversion;

import com.sun.enterprise.tools.upgrade.certconversion.CertificateException;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JKStoJKSConversionModule
implements BaseModule {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.certconversion");
    private String jksPath;
    private String sourceJksPath;
    private String trustJksPath;
    private String sourceTrustJksPath;
    private String jksKeyStorePassword;
    private String jksCAkeyStorePassword;
    private boolean certificateError = false;
    private CommonInfoModel commonInfo;

    public boolean upgrade(CommonInfoModel commonInfo) {
        try {
            String currentDomain = commonInfo.getCurrentDomain();
            if (!commonInfo.getDomainOptionList().contains(currentDomain)) {
                return true;
            }
            this.jksPath = commonInfo.getTargetJKSKeyStorePath();
            this.sourceJksPath = commonInfo.getSourceJKSKeyStorePath();
            this.trustJksPath = commonInfo.getTargetTrustedJKSKeyStorePath();
            this.sourceTrustJksPath = commonInfo.getSourceTrustedJKSKeyStorePath();
            this.jksKeyStorePassword = commonInfo.getJksKeystorePassword();
            this.jksCAkeyStorePassword = commonInfo.getJksCAKeystorePassword();
            this.commonInfo = commonInfo;
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.start_certificate_migration", (Object)currentDomain));
            this.doBackup(commonInfo);
            this.copyKeyPairs(this.sourceJksPath, this.jksPath);
            this.copyCACertificates(this.sourceTrustJksPath, this.trustJksPath);
            _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.finished_certificate_migration", (Object)currentDomain));
        }
        catch (CertificateException ce) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_migrate_certificates", (Object)ce));
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            return false;
        }
        return true;
    }

    private void doBackup(CommonInfoModel commonInfo) throws CertificateException {
        this.doCACertificateBackup();
        this.doKeyPairBackup();
    }

    private void doCACertificateBackup() throws CertificateException {
        this.copyCACertificates(this.trustJksPath, this.trustJksPath + ".back");
    }

    private void copyCACertificates(String sourceTrustJksPath, String targetTrustJksPath) throws CertificateException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            KeyStore keystoreSource = KeyStore.getInstance(KeyStore.getDefaultType());
            KeyStore keystoreTarget = KeyStore.getInstance(KeyStore.getDefaultType());
            in = new FileInputStream(new File(sourceTrustJksPath));
            keystoreSource.load(in, this.jksCAkeyStorePassword.toCharArray());
            keystoreTarget.load(null, this.jksCAkeyStorePassword.toCharArray());
            Enumeration<String> en = keystoreSource.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                Certificate cert = keystoreSource.getCertificate(alias);
                keystoreTarget.setCertificateEntry(alias, cert);
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.ca_transferred", (Object)alias));
            }
            out = new FileOutputStream(targetTrustJksPath);
            keystoreTarget.store(out, this.jksCAkeyStorePassword.toCharArray());
        }
        catch (java.security.cert.CertificateException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (NoSuchAlgorithmException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (FileNotFoundException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (KeyStoreException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private void doKeyPairBackup() throws CertificateException {
        this.copyKeyPairs(this.jksPath, this.jksPath + ".back");
    }

    private void copyKeyPairs(String sourceJksPath, String targetJksPath) throws CertificateException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            KeyStore keystoreSource = KeyStore.getInstance(KeyStore.getDefaultType());
            KeyStore keystoreTarget = KeyStore.getInstance(KeyStore.getDefaultType());
            in = new FileInputStream(new File(sourceJksPath));
            keystoreSource.load(in, this.jksKeyStorePassword.toCharArray());
            keystoreTarget.load(null, this.jksKeyStorePassword.toCharArray());
            Enumeration<String> en = keystoreSource.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.processing_keypair", (Object)alias));
                Key key = keystoreSource.getKey(alias, this.jksKeyStorePassword.toCharArray());
                Certificate[] cert = keystoreSource.getCertificateChain(alias);
                keystoreTarget.setKeyEntry(alias, key, this.jksKeyStorePassword.toCharArray(), cert);
                _logger.log(Level.INFO, this.sm.getString("enterprise.tools.upgrade.certconversion.alias_transferred", (Object)alias));
            }
            out = new FileOutputStream(targetJksPath);
            keystoreTarget.store(out, this.jksKeyStorePassword.toCharArray());
        }
        catch (java.security.cert.CertificateException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (NoSuchAlgorithmException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (FileNotFoundException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (KeyStoreException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (IOException e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.unknownError"), e);
            throw new CertificateException(this.sm.getString("enterprise.tools.upgrade.unknownError"));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public void recovery(CommonInfoModel commonInfo) {
        File keypairKeyStoreOriginalFile = new File(this.jksPath);
        File keypairKeyStoreBackupFile = new File(this.jksPath + ".back");
        File trustedKeyStoreOriginalFile = new File(this.trustJksPath);
        File trustedKeyStoreBackupFile = new File(this.trustJksPath + ".back");
        new File(this.jksPath + ".back1").delete();
        new File(this.trustJksPath + ".back1").delete();
        boolean success = keypairKeyStoreOriginalFile.renameTo(new File(this.jksPath + ".back1"));
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            return;
        }
        success = trustedKeyStoreOriginalFile.renameTo(new File(this.trustJksPath + ".back1"));
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            return;
        }
        keypairKeyStoreOriginalFile.delete();
        trustedKeyStoreOriginalFile.delete();
        success = keypairKeyStoreBackupFile.renameTo(keypairKeyStoreOriginalFile);
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            File keypairKeyStoreanotherBackupFile = new File(this.jksPath + ".back1");
            File trustedKeyStoreanotherBackupFile = new File(this.trustJksPath + ".back1");
            keypairKeyStoreanotherBackupFile.renameTo(keypairKeyStoreOriginalFile);
            trustedKeyStoreanotherBackupFile.renameTo(trustedKeyStoreOriginalFile);
            return;
        }
        success = trustedKeyStoreBackupFile.renameTo(trustedKeyStoreOriginalFile);
        if (!success) {
            _logger.log(Level.WARNING, this.sm.getString("enterprise.tools.upgrade.certconversion.could_not_recover_certificates"));
            File keypairKeyStoreanotherBackupFile = new File(this.jksPath + ".back1");
            File trustedKeyStoreanotherBackupFile = new File(this.trustJksPath + ".back1");
            keypairKeyStoreanotherBackupFile.renameTo(keypairKeyStoreOriginalFile);
            trustedKeyStoreanotherBackupFile.renameTo(trustedKeyStoreOriginalFile);
            return;
        }
        new File(this.jksPath + ".back1").delete();
        new File(this.trustJksPath + ".back1").delete();
    }

    public static void main(String[] args) {
        CommonInfoModel commonInfo = new CommonInfoModel();
        commonInfo.setSourceInstallDir(args[0]);
        commonInfo.setTargetInstallDir(args[1]);
        commonInfo.setCertDbPassword(args[2]);
        commonInfo.setJksKeystorePassword(args[3]);
        JKStoJKSConversionModule convModule = new JKStoJKSConversionModule();
        convModule.upgrade(commonInfo);
    }

    public String getName() {
        return this.sm.getString("enterprise.tools.upgrade.certconversion.moduleName");
    }
}

