/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.FileCacheMonitor;
import com.sun.appserv.management.monitor.HTTPServiceMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.FileCacheStats;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Timer;

public class FileCacheMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-2s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s %15$-5s %16$-5s";

    public FileCacheMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        String fileCacheTitle = localStrings.getString("commands.monitor.file_cache_monitoring_title");
        String title = String.format("%1$55s", fileCacheTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        HTTPServiceMonitor httpserviceMonitor = this.srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        FileCacheMonitor fileCacheMonitor = httpserviceMonitor.getFileCacheMonitor();
        if (fileCacheMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        FileCacheStats fileCacheStats = fileCacheMonitor.getFileCacheStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(fileCacheStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayHeader() {
        String cch = localStrings.getString("commands.monitor.cch");
        String ccm = localStrings.getString("commands.monitor.ccm");
        String ce = localStrings.getString("commands.monitor.ce");
        String ch = localStrings.getString("commands.monitor.ch");
        String cih = localStrings.getString("commands.monitor.cih");
        String cim = localStrings.getString("commands.monitor.cim");
        String cm = localStrings.getString("commands.monitor.cm");
        String coe = localStrings.getString("commands.monitor.coe");
        String fe = localStrings.getString("commands.monitor.fe");
        String me = localStrings.getString("commands.monitor.me");
        String mhcs = localStrings.getString("commands.monitor.mhcs");
        String mmcs = localStrings.getString("commands.monitor.mmcs");
        String moe = localStrings.getString("commands.monitor.moe");
        String sma = localStrings.getString("commands.monitor.sma");
        String shc = localStrings.getString("commands.monitor.shc");
        String smc = localStrings.getString("commands.monitor.smc");
        String header = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-2s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s %15$-5s %16$-5s", cch, ccm, ce, ch, cih, cim, cm, coe, fe, me, mhcs, mmcs, moe, sma, shc, smc);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.file_cache_write_to_file"));
        }
    }

    private void displayData(FileCacheStats fcs) {
        String data = String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-2s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s %15$-5s %16$-5s", fcs.getCountContentHits().getCount(), fcs.getCountContentMisses().getCount(), fcs.getCountEntries().getCount(), fcs.getCountHits().getCount(), fcs.getCountInfoHits().getCount(), fcs.getCountInfoMisses().getCount(), fcs.getCountMisses().getCount(), fcs.getCountOpenEntries().getCount(), fcs.getFlagEnabled().getCount(), fcs.getMaxEntries().getCount(), fcs.getMaxHeapCacheSize().getCount(), fcs.getMaxMmapCacheSize().getCount(), fcs.getMaxOpenEntries().getCount(), fcs.getSecondsMaxAge().getCount(), fcs.getSizeHeapCache().getCount(), fcs.getSizeMmapCache().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s,%11$s,%12$s,%13$s,%14$s,%15$s,%16$s", fcs.getCountContentHits().getCount(), fcs.getCountContentMisses().getCount(), fcs.getCountEntries().getCount(), fcs.getCountHits().getCount(), fcs.getCountInfoHits().getCount(), fcs.getCountInfoMisses().getCount(), fcs.getCountMisses().getCount(), fcs.getCountOpenEntries().getCount(), fcs.getFlagEnabled().getCount(), fcs.getMaxEntries().getCount(), fcs.getMaxHeapCacheSize().getCount(), fcs.getMaxMmapCacheSize().getCount(), fcs.getMaxOpenEntries().getCount(), fcs.getSecondsMaxAge().getCount(), fcs.getSizeHeapCache().getCount(), fcs.getSizeMmapCache().getCount());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.file_cache_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

