/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.ConnectionPoolStats;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Timer;

abstract class ConnectionPoolTask
extends MonitorTask {
    private final String displayFormat = "%1$-8s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s %15$-5s %16$-5s %17$-5s %18$-5s %19$-5s";

    public ConnectionPoolTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) {
        super(srm, filter, timer, verbose, fileName);
    }

    void displayData(ConnectionPoolStats cps) {
        String data = String.format("%1$-8s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s %15$-5s %16$-5s %17$-5s %18$-5s %19$-5s", cps.getAverageConnWaitTime().getCount(), cps.getConnRequestWaitTime().getLowWaterMark(), cps.getConnRequestWaitTime().getHighWaterMark(), cps.getConnRequestWaitTime().getCurrent(), cps.getNumConnAcquired().getCount(), cps.getNumConnCreated().getCount(), cps.getNumConnDestroyed().getCount(), cps.getNumConnFailedValidation().getCount(), cps.getNumConnFree().getLowWaterMark(), cps.getNumConnFree().getHighWaterMark(), cps.getNumConnFree().getCurrent(), cps.getNumConnNotSuccessfullyMatched().getCount(), cps.getNumConnReleased().getCount(), cps.getNumConnSuccessfullyMatched().getCount(), cps.getNumConnTimedOut().getCount(), cps.getNumConnUsed().getLowWaterMark(), cps.getNumConnUsed().getHighWaterMark(), cps.getNumConnUsed().getCurrent(), cps.getWaitQueueLength().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s,%11$s,%12$s,%13$s,%14$s,%15$s,%16$s,%17$s,%18$s,%19$s", cps.getAverageConnWaitTime().getCount(), cps.getConnRequestWaitTime().getLowWaterMark(), cps.getConnRequestWaitTime().getHighWaterMark(), cps.getConnRequestWaitTime().getCurrent(), cps.getNumConnAcquired().getCount(), cps.getNumConnCreated().getCount(), cps.getNumConnDestroyed().getCount(), cps.getNumConnFailedValidation().getCount(), cps.getNumConnFree().getLowWaterMark(), cps.getNumConnFree().getHighWaterMark(), cps.getNumConnFree().getCurrent(), cps.getNumConnNotSuccessfullyMatched().getCount(), cps.getNumConnReleased().getCount(), cps.getNumConnSuccessfullyMatched().getCount(), cps.getNumConnTimedOut().getCount(), cps.getNumConnUsed().getLowWaterMark(), cps.getNumConnUsed().getHighWaterMark(), cps.getNumConnUsed().getCurrent(), cps.getWaitQueueLength().getCount());
            this.writeToFile(fileData);
        }
    }

    void displayHeader() {
        String waitTime = localStrings.getString("commands.monitor.connection_pool_wait_time");
        String connReq = localStrings.getString("commands.monitor.connection_pool_conn_req");
        String connFree = localStrings.getString("commands.monitor.connection_pool_conn_free");
        String connUsed = localStrings.getString("commands.monitor.connection_pool_conn_used");
        String avg = localStrings.getString("commands.monitor.avg");
        String low = localStrings.getString("commands.monitor.low");
        String hi = localStrings.getString("commands.monitor.hi");
        String cur = localStrings.getString("commands.monitor.cur");
        String acq = localStrings.getString("commands.monitor.acq");
        String crt = localStrings.getString("commands.monitor.crt");
        String des = localStrings.getString("commands.monitor.des");
        String fai = localStrings.getString("commands.monitor.fai");
        String rej = localStrings.getString("commands.monitor.rej");
        String rel = localStrings.getString("commands.monitor.rel");
        String suc = localStrings.getString("commands.monitor.suc");
        String to = localStrings.getString("commands.monitor.to");
        String wai = localStrings.getString("commands.monitor.wai");
        String header = String.format("%1$s %2$12s %3$41s %4$40s", waitTime, connReq, connFree, connUsed);
        String subHeader = String.format("%1$-8s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-5s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s %14$-5s %15$-5s %16$-5s %17$-5s %18$-5s %19$-5s", avg, low, hi, cur, acq, crt, des, fai, low, hi, cur, rej, rel, suc, to, low, hi, cur, wai);
        CLILogger.getInstance().printMessage(header);
        CLILogger.getInstance().printMessage(subHeader);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.connection_pool_write_to_file"));
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.connection_pool_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

