/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ConnectionManagerMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.ConnectionManagerStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.Timer;

public class ConnectionManagerMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-20s %5$-5s %6$-5s %7$-5s";

    public ConnectionManagerMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        Map connectionManagerMap = srm.getConnectionManagerMonitorMap();
        if (connectionManagerMap == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_connection_manager"));
        }
        String[] keys = MapUtil.getKeyStrings((Map)connectionManagerMap);
        if (this.filter == null) {
            this.checkForNumberOfElements(keys);
            this.filter = keys[0];
        } else if (!connectionManagerMap.containsKey(this.filter)) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.filter}));
        }
        String connManagerMonitoring = localStrings.getString("commands.monitor.connection_manager_monitoring_title", new Object[]{this.filter});
        String title = String.format("%1$5s", connManagerMonitoring);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map connectionManagerMap = this.srm.getConnectionManagerMonitorMap();
        if (connectionManagerMap == null || connectionManagerMap.size() < 0) {
            super.cancelMonitorTask();
            return;
        }
        ConnectionManagerMonitor connectionManagerMonitor = (ConnectionManagerMonitor)connectionManagerMap.get(this.filter);
        if (connectionManagerMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        ConnectionManagerStats connectionManagerStats = connectionManagerMonitor.getConnectionManagerStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(connectionManagerStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayHeader() {
        String totalConn = localStrings.getString("commands.monitor.total_connections");
        String ci = localStrings.getString("commands.monitor.ci");
        String ciu = localStrings.getString("commands.monitor.ciu");
        String low = localStrings.getString("commands.monitor.low");
        String hi = localStrings.getString("commands.monitor.hi");
        String cur = localStrings.getString("commands.monitor.cur");
        String min = localStrings.getString("commands.monitor.min");
        String max = localStrings.getString("commands.monitor.max");
        String header = String.format("%1$35s", totalConn);
        String subheader = String.format("%1$-5s %2$-5s %3$-5s %4$-20s %5$-5s %6$-5s %7$-5s", ci, ciu, low, hi, cur, min, max);
        CLILogger.getInstance().printMessage(header);
        CLILogger.getInstance().printMessage(subheader);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.connection_manager_write_to_file"));
        }
    }

    private void displayData(ConnectionManagerStats cms) {
        String data = String.format("%1$-5s %2$-5s %3$-5s %4$-20s %5$-5s %6$-5s %7$-5s", cms.getConnectionsIdle().getCount(), cms.getConnectionsInUse().getCount(), cms.getTotalConnections().getLowerBound(), cms.getTotalConnections().getUpperBound(), cms.getTotalConnections().getLowWaterMark(), cms.getTotalConnections().getHighWaterMark(), cms.getTotalConnections().getCurrent());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s", cms.getConnectionsIdle().getCount(), cms.getConnectionsInUse().getCount(), cms.getTotalConnections().getLowerBound(), cms.getTotalConnections().getUpperBound(), cms.getTotalConnections().getLowWaterMark(), cms.getTotalConnections().getHighWaterMark(), cms.getTotalConnections().getCurrent());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.connection_manager_details");
        CLILogger.getInstance().printMessage(details);
    }
}

