/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.CLIProcessExecutor;
import com.sun.enterprise.cli.commands.DatabaseCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.OS;
import java.io.File;

public final class StopDatabaseCommand
extends DatabaseCommand {
    private static final String DB_HOST = "dbhost";
    private static final String DB_PORT = "dbport";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public String[] stopDatabaseCmd() throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false"};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false"};
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        try {
            this.prepareProcessExecutor();
            CLIProcessExecutor cpe = new CLIProcessExecutor();
            cpe.execute(this.pingDatabaseCmd(false), true);
            if (cpe.exitValue() > 0) {
                throw new CommandException(this.getLocalizedString("StopDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
            }
            if (cpe.exitValue() < 0) {
                throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}));
            }
            cpe.execute(this.stopDatabaseCmd(), true);
            if (cpe.exitValue() > 0) {
                throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}));
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

