/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.cli.commands.StartDomainCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class StartAppservCommand
extends StartDomainCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        CLILogger.getInstance().printWarning(this.getLocalizedString("CommandDeprecated", new Object[]{this.name}));
        this.validateOptions();
        String[] domainsList = null;
        try {
            DomainConfig domainConfig = new DomainConfig(null, this.getDomainsRoot());
            DomainsManager manager = this.getFeatureFactory().getDomainsManager();
            domainsList = manager.listDomains(domainConfig);
        }
        catch (Exception e) {
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
        boolean allDomainsStarted = true;
        if (domainsList.length == 0) {
            throw new CommandException(this.getLocalizedString("NoDomainsToStart"));
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("StartingAppserv", new Object[]{this.getDomainsRoot()}));
        for (int i = 0; i < domainsList.length; ++i) {
            try {
                this.startDomain(domainsList[i]);
                continue;
            }
            catch (Exception e) {
                allDomainsStarted = false;
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
                CLILogger.getInstance().printExceptionStackTrace(e);
                CLILogger.getInstance().printError(this.getLocalizedString("CannotStartDomainMsg", new Object[]{domainsList[i]}));
            }
        }
        if (!allDomainsStarted) {
            throw new CommandException(this.getLocalizedString("CannotStartOneOrMoreDomains"));
        }
    }
}

