/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.commands.MultiProcessCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.util.ASenvPropertyReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public abstract class S1ASCommand
extends Command {
    public static final String JMX_PROTOCOL = "jmxmp";
    public static final String TERSE = "terse";
    public static final String INTERACTIVE = "interactive";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String ECHO = "echo";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String SECURE = "secure";
    public static final String MAPPED_PASSWORD = "mappedpassword";
    public static final String OBJECT_NAME = "objectname";
    public static final String ARGUMENTS = "arguments";
    public static final String OPERATION = "operation";
    public static final String PARAMS = "params";
    public static final String PARAM_TYPES = "paramtypes";
    public static final String RETURN_TYPE = "returntype";
    public static final String DISPLAY_TYPE = "displaytype";
    public static final String PROPERTY = "property.";
    public static final String DOMAIN = "domain";
    public static final String ATTRIBUTE_LIST_CLASS = AttributeList.class.getName();
    public static final String PROPERTIES_CLASS = Properties.class.getName();
    public static final String BOOLEAN_CLASS = Boolean.class.getName();
    public static final String PRIMITIVE_BOOLEAN_CLASS = Boolean.TYPE.getName();
    public static final String STRING_ARRAY = new String[0].getClass().getName();
    public static final String MAP_CLASS = Map.class.getName();
    public static final String LONG_CLASS = Long.class.getName();
    public static final String PRIMITIVE_LONG_CLASS = Long.TYPE.getName();
    public static final String INTEGER_CLASS = Integer.class.getName();
    public static final String PRIMITIVE_INTEGER_CLASS = Integer.TYPE.getName();
    public static final String OBJECT_CLASS = Object.class.getName();
    public static final String PARAM_DELIMITER = ",";
    public static final String PARAM_VALUE_DELIMITER = "=";
    public static final String PROPERTY_DELIMITER = ":";
    protected static final String ASADMINPREFS = ".asadminprefs";
    private static final String ASADMINENV = "asadminenv.conf";
    protected static final String SHORTHAND_DELIMETER = ":";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String SET_DELIMETER = "=";
    protected static final String ENV_PREFIX = "AS_ADMIN_";
    protected static final String DEFAULT_NOT_DEPRECATED_PASSWORDFILE_OPTIONS = "password|adminpassword|userpassword|masterpassword|aliaspassword|mappedpassword";
    protected String NOT_DEPRECATED_PASSWORDFILE_OPTIONS = "password|adminpassword|userpassword|masterpassword|aliaspassword|mappedpassword";
    protected static final String COMMENT_PREFIX = "#";
    public static final String LIST_JMS_RESOURCES = "list-jms-resources";
    private String userValue = null;
    private boolean warningDisplayed = false;

    public S1ASCommand() {
        ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
        reader.setSystemProperties();
    }

    public boolean validateOptions() throws CommandValidationException {
        this.setLoggerLevel();
        if (this.getBooleanOption(ECHO)) {
            CLILogger.getInstance().printMessage(this.toString());
        }
        Map options = this.getOptions();
        for (String optionKey : options.keySet()) {
            if (!optionKey.matches(this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS)) continue;
            this.validatePasswordOption(optionKey);
        }
        this.readAsadminEnvFile();
        return true;
    }

    private void validatePasswordOption(String passwordOptionName) throws CommandValidationException {
        if (this.getCLOption(passwordOptionName) != null) {
            throw new CommandValidationException(this.getLocalizedString("PasswordsNotAllowedOnCommandLine", new Object[]{passwordOptionName}));
        }
        if (MultiProcessCommand.getLocalEnvironmentValue(passwordOptionName) == null && this.getENVOption(passwordOptionName) != null && this.getOption(PASSWORDFILE) == null) {
            CLILogger.getInstance().printWarning(this.getLocalizedString("PasswordsNotAllowedInEnvironment", new Object[]{passwordOptionName}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAsadminEnvFile() {
        String cr = System.getProperty("com.sun.aas.configRoot");
        File file = new File(cr, ASADMINENV);
        if (file.exists()) {
            CLILogger.getInstance().printDebugMessage("Reading asadminenv.conf file");
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                Properties prop = new Properties();
                prop.load(is);
                Enumeration<?> en = prop.propertyNames();
                while (en.hasMoreElements()) {
                    String optionName;
                    String entry = (String)en.nextElement();
                    if (!entry.startsWith(ENV_PREFIX) || this.getCLOption(optionName = entry.substring(ENV_PREFIX.length()).toLowerCase()) != null || this.getENVOption(optionName) != null) continue;
                    String optionValue = prop.getProperty(entry);
                    CLILogger.getInstance().printDebugMessage("asadminenv.conf: set the following options: " + optionName + "=" + optionValue);
                    this.setOption(optionName, optionValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ignore) {}
            }
        }
    }

    protected void setLoggerLevel() {
        boolean terse = this.getBooleanOption(TERSE);
        if (terse) {
            CLILogger.getInstance().setOutputLevel(Level.INFO);
        } else {
            CLILogger.getInstance().setOutputLevel(Level.FINE);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection(String protocol, String host, int port, String user, String password) throws CommandException {
        JMXServiceURL url = this.getJMXServiceURL(protocol, host, port);
        try {
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            CLILogger.getInstance().printDebugMessage("Get an MBeanSErverConnection");
            return jmxc.getMBeanServerConnection();
        }
        catch (IOException ioe) {
            throw new CommandException(ioe);
        }
    }

    private JMXServiceURL getJMXServiceURL(String protocol, String host, int port) throws CommandException {
        try {
            CLILogger.getInstance().printDebugMessage("Create a JMXMP connector client and connect it to the JMXMP connector server");
            JMXServiceURL url = new JMXServiceURL(protocol, host, port);
            CLILogger.getInstance().printDebugMessage("url = " + url.toString());
            return url;
        }
        catch (MalformedURLException mue) {
            throw new CommandException(mue);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection(String host, int port, String user, String password) throws CommandException, CommandValidationException {
        try {
            String jmxProtocol = null;
            jmxProtocol = this.getBooleanOption(SECURE) ? "s1ashttps" : "s1ashttp";
            JMXServiceURL url = new JMXServiceURL(jmxProtocol, host, port);
            JMXConnector conn = JMXConnectorFactory.connect(url, this.initEnvironment(user, password));
            return conn.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    protected ServerConnectionIdentifier createServerConnectionIdentifier(String host, int port, String user, String password) throws CommandException, CommandValidationException {
        ServerConnectionIdentifier conn = new ServerConnectionIdentifier();
        conn.setHostName(host);
        conn.setHostPort(port);
        conn.setUserName(user);
        conn.setPassword(password);
        if (this.getBooleanOption(SECURE)) {
            conn.setSecure(true);
        } else {
            conn.setSecure(false);
        }
        return conn;
    }

    private Map initEnvironment(String user, String password) throws CommandValidationException, CommandException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";
        env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        env.put("jmx.remote.protocol.provider.pkgs", "com.sun.enterprise.admin.jmx.remote.protocol");
        env.put("USER", user);
        env.put("PASSWORD", password);
        env.put("com.sun.enterprise.as.http.auth", "BASIC");
        return env;
    }

    protected String getHost() {
        return this.getOption(HOST);
    }

    protected int getPort() throws CommandValidationException {
        String port = this.getOption(PORT);
        return this.validatePort(port);
    }

    protected String getUser() throws CommandValidationException {
        if (this.getOption(USER) == null && this.userValue == null) {
            this.userValue = this.getUserFromASADMINPASS();
            if (this.userValue != null) {
                return this.userValue;
            }
            this.userValue = this.getValuesFromASADMINPREFS(USER);
            if (this.userValue != null) {
                CLILogger.getInstance().printDebugMessage("user value read from .asadminprefs");
                return this.userValue;
            }
            if (this.getBooleanOption(INTERACTIVE)) {
                try {
                    InputsAndOutputs.getInstance().getUserOutput().print(this.getLocalizedString("AdminUserPrompt"));
                    return InputsAndOutputs.getInstance().getUserInput().getLine();
                }
                catch (IOException ioe) {
                    throw new CommandValidationException(this.getLocalizedString("CannotReadOption", new Object[]{USER}));
                }
            }
        } else {
            if (this.getOption(USER) != null) {
                return this.getOption(USER);
            }
            if (this.userValue != null) {
                return this.userValue;
            }
        }
        throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{USER}));
    }

    protected String getUserFromASADMINPASS() {
        int port;
        String userValue = null;
        String host = this.getHost();
        if (host == null) {
            return userValue;
        }
        try {
            port = this.getPort();
        }
        catch (CommandValidationException cve) {
            return userValue;
        }
        try {
            LoginInfo login;
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            if (store.exists(host, port) && (userValue = (login = store.read(host, port)).getUser()) != null) {
                CLILogger.getInstance().printDebugMessage("user value read from " + store.getName());
            }
        }
        catch (Exception e) {
            Object[] params = new String[]{host, "" + port};
            String msg = this.getLocalizedString("LoginInfoCouldNotBeRead", params);
            CLILogger.getInstance().printWarning(msg);
            CLILogger.getInstance().printExceptionStackTrace(e);
        }
        return userValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getValuesFromASADMINPREFS(String nameOfValue) {
        String returnVal = null;
        File file = null;
        try {
            file = this.checkForFileExistence(System.getProperty("user.home"), ASADMINPREFS);
        }
        catch (Exception e) {
            CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
            return returnVal;
        }
        InputStream is = null;
        String optionValue = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String optionName;
                String entry = (String)en.nextElement();
                if (!entry.startsWith(ENV_PREFIX) || !(optionName = entry.substring(ENV_PREFIX.length()).toLowerCase()).equals(nameOfValue)) continue;
                optionValue = prop.getProperty(entry);
                break;
            }
        }
        catch (Exception e) {
            CLILogger.getInstance().printDebugMessage(e.getLocalizedMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
        }
        return optionValue;
    }

    protected String getPassword() throws CommandValidationException, CommandException {
        return this.getPassword(PASSWORD, "AdminPasswordPrompt", "AdminPasswordConfirmationPrompt", true, true, false, false, null, null, true, false, false, true);
    }

    protected boolean isPasswordValid(String passwd) {
        return passwd.length() >= 8;
    }

    protected String getPassword(String optionName, boolean allowedOnCommandLine, boolean readPrefsFile, boolean readPasswordOptionFromPrefs, boolean readMasterPasswordFile, RepositoryManager mgr, RepositoryConfig config, boolean promptUser, boolean confirm, boolean validate, boolean displayWarning) throws CommandValidationException, CommandException {
        return this.getPassword(optionName, "InteractiveOptionPrompt", "InteractiveOptionConfirmationPrompt", allowedOnCommandLine, readPrefsFile, readPasswordOptionFromPrefs, readMasterPasswordFile, mgr, config, promptUser, confirm, validate, displayWarning);
    }

    protected String getPassword(String optionName, String promptMsg, String confirmationPromptMsg, boolean allowedOnCommandLine, boolean readPrefsFile, boolean readPasswordOptionFromPrefs, boolean readMasterPasswordFile, RepositoryManager mgr, RepositoryConfig config, boolean promptUser, boolean confirm, boolean validate, boolean displayWarning) throws CommandValidationException, CommandException {
        String passwordVal = MultiProcessCommand.getLocalEnvironmentValue(optionName);
        if (passwordVal != null) {
            return passwordVal;
        }
        if (this.getOption(PASSWORDFILE) != null) {
            this.loadPasswordFileOptions(optionName);
        }
        if ((passwordVal = this.getOtherOption(optionName)) == null) {
            if (readPrefsFile) {
                if (this.getOption(PORT) != null && this.getHost() != null) {
                    String host = this.getHost();
                    int port = this.getPort();
                    try {
                        LoginInfo login;
                        LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
                        if (store.exists(host, port) && (passwordVal = (login = store.read(host, port)).getPassword()) != null) {
                            CLILogger.getInstance().printDebugMessage("password value read from " + store.getName());
                        }
                    }
                    catch (Exception e) {
                        Object[] params = new String[]{host, "" + port};
                        String msg = this.getLocalizedString("LoginInfoCouldNotBeRead", params);
                        CLILogger.getInstance().printWarning(msg);
                        CLILogger.getInstance().printExceptionStackTrace(e);
                    }
                }
                if (passwordVal == null && (passwordVal = this.getValuesFromASADMINPREFS(optionName)) != null) {
                    CLILogger.getInstance().printDebugMessage("password value read from .asadminprefs");
                }
            }
            if (passwordVal == null) {
                if (readPrefsFile && readPasswordOptionFromPrefs) {
                    passwordVal = this.getValuesFromASADMINPREFS(PASSWORD);
                }
                if (passwordVal == null) {
                    if (readMasterPasswordFile && mgr != null && config != null) {
                        try {
                            passwordVal = mgr.readMasterPasswordFile(config);
                        }
                        catch (RepositoryException ex) {
                            throw new CommandException(ex);
                        }
                    }
                    if (passwordVal == null && promptUser) {
                        passwordVal = confirm ? this.getInteractiveOptionWithConfirmation(optionName, promptMsg, confirmationPromptMsg, validate) : this.getInteractiveOption(optionName, this.getLocalizedString(promptMsg, new Object[]{optionName}));
                    }
                }
            }
        }
        if (validate && passwordVal != null && !this.isPasswordValid(passwordVal)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{optionName}));
        }
        return passwordVal;
    }

    private String getInteractiveOptionWithConfirmation(String optionName, String promptMsg, String confirmationPromptMsg, boolean validatePassword) throws CommandValidationException {
        String prompt = this.getLocalizedString(promptMsg, new Object[]{optionName});
        String confirmationPrompt = this.getLocalizedString(confirmationPromptMsg, new Object[]{optionName});
        String optionValue = this.getInteractiveOption(optionName, prompt);
        if (validatePassword && !this.isPasswordValid(optionValue)) {
            if (promptMsg.equals("AdminPasswordPrompt")) {
                String adminPassword = this.getLocalizedString("AdminPassword");
                throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{adminPassword}));
            }
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{optionName}));
        }
        String optionValueAgain = this.getInteractiveOption(optionName, confirmationPrompt);
        if (!optionValue.equals(optionValueAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{optionName}));
        }
        return optionValue;
    }

    protected String getInteractiveOption(String optionName, String prompt) throws CommandValidationException {
        String optionValue;
        if (this.getBooleanOption(INTERACTIVE)) {
            try {
                InputsAndOutputs.getInstance().getUserOutput().print(prompt);
                InputsAndOutputs.getInstance().getUserOutput().flush();
                optionValue = new CliUtil().getPassword();
            }
            catch (NoClassDefFoundError e) {
                optionValue = this.readInput();
            }
            catch (UnsatisfiedLinkError e) {
                optionValue = this.readInput();
            }
            catch (Exception e) {
                throw new CommandValidationException(e);
            }
        } else {
            throw new CommandValidationException(this.getLocalizedString("OptionIsRequired", new Object[]{optionName}));
        }
        return optionValue;
    }

    protected String readInput() {
        try {
            return InputsAndOutputs.getInstance().getUserInput().getLine();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void loadPasswordFileOptions(String optionName) throws CommandException {
        String passwordFileName = this.getOption(PASSWORDFILE);
        File file = this.checkForFileExistence(null, passwordFileName);
        boolean displayWarning = false;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String entry = (String)en.nextElement();
                if (!entry.startsWith(ENV_PREFIX)) continue;
                String optionFromFile = entry.substring(ENV_PREFIX.length()).toLowerCase();
                boolean bl = displayWarning = !optionFromFile.matches(this.NOT_DEPRECATED_PASSWORDFILE_OPTIONS) || displayWarning;
                if (!optionFromFile.equalsIgnoreCase(optionName)) continue;
                String optionValue = prop.getProperty(entry);
                this.setOption(optionName, optionValue);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ignore) {}
        }
        if (displayWarning && !this.warningDisplayed) {
            CLILogger.getInstance().printWarning(this.getLocalizedString("DeprecatedOptionsFromPasswordfile"));
            this.warningDisplayed = true;
        }
    }

    protected File checkForFileExistence(String parent, String fileName) throws CommandException {
        if (fileName == null) {
            return null;
        }
        File file = null;
        file = parent == null ? new File(fileName) : new File(parent, fileName);
        if (!file.canRead()) {
            throw new CommandException(this.getLocalizedString("FileDoesNotExist", new Object[]{fileName}));
        }
        return file;
    }

    protected String getObjectName() throws CommandException {
        String objectName = (String)((Vector)this.getProperty(OBJECT_NAME)).get(0);
        String objectNameStr = this.replacePattern(objectName);
        CLILogger.getInstance().printDebugMessage("Object Name = [" + objectNameStr + "]");
        return objectNameStr;
    }

    protected Object[] getParamsInfo() throws CommandException, CommandValidationException {
        Object[] paramsInfo;
        Vector params = (Vector)this.getProperty(PARAMS);
        String[] typesInfo = this.getTypesInfo();
        Object[] objectArray = paramsInfo = params == null ? null : new Object[params.size()];
        if (typesInfo != null && paramsInfo != null && paramsInfo.length != typesInfo.length) {
            throw new CommandException(this.getLocalizedString("BadDescriptorXML"));
        }
        for (int i = 0; params != null && i < params.size(); ++i) {
            String paramStr = (String)params.get(i);
            CLILogger.getInstance().printDebugMessage("Types Info [" + i + "] = " + typesInfo[i]);
            if (typesInfo[i].equals(ATTRIBUTE_LIST_CLASS)) {
                paramsInfo[i] = this.getAttributeList(paramStr);
                continue;
            }
            if (typesInfo[i].equals(PROPERTIES_CLASS)) {
                paramsInfo[i] = this.createPropertiesParam((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(BOOLEAN_CLASS) || typesInfo[i].equals(PRIMITIVE_BOOLEAN_CLASS)) {
                if (this.createBooleanVal((String)params.get(i)) == null) continue;
                paramsInfo[i] = this.createBooleanVal((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(LONG_CLASS) || typesInfo[i].equals(PRIMITIVE_LONG_CLASS)) {
                if (this.createLongVal((String)params.get(i)) == null) continue;
                paramsInfo[i] = this.createLongVal((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(INTEGER_CLASS) || typesInfo[i].equals(PRIMITIVE_INTEGER_CLASS)) {
                if (this.createIntegerVal((String)params.get(i)) == null) continue;
                paramsInfo[i] = this.createIntegerVal((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(STRING_ARRAY)) {
                CLILogger.getInstance().printDebugMessage("Creating String Array");
                paramsInfo[i] = this.createStringArrayParam((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(MAP_CLASS)) {
                CLILogger.getInstance().printDebugMessage("Creating Map Class");
                paramsInfo[i] = this.createMapParam(paramStr);
                continue;
            }
            if (typesInfo[i].equals(OBJECT_CLASS)) {
                CLILogger.getInstance().printDebugMessage("Creating Object Class");
                paramsInfo[i] = this.replacePattern(paramStr);
                CLILogger.getInstance().printDebugMessage("param value = " + paramsInfo[i]);
                continue;
            }
            CLILogger.getInstance().printDebugMessage((String)params.get(i));
            paramsInfo[i] = this.replacePattern((String)params.get(i));
            CLILogger.getInstance().printDebugMessage("ParamsInfo = " + paramsInfo[i]);
        }
        return paramsInfo;
    }

    protected String[] getTypesInfo() {
        Vector typesList = (Vector)this.getProperty(PARAM_TYPES);
        String[] types = typesList == null ? null : new String[typesList.size()];
        CLILogger.getInstance().printDebugMessage("Types = ");
        for (int i = 0; typesList != null && i < typesList.size(); ++i) {
            types[i] = (String)typesList.get(i);
            CLILogger.getInstance().printDebugMessage(types[i] + PARAM_DELIMITER);
        }
        CLILogger.getInstance().printDebugMessage("");
        return types;
    }

    protected String getOperationName() throws CommandException {
        String operationName = (String)((Vector)this.getProperty(OPERATION)).get(0);
        String operationNameStr = this.replacePattern(operationName);
        CLILogger.getInstance().printDebugMessage("OperationName = " + operationNameStr);
        return operationNameStr;
    }

    protected String getReturnType() {
        String returnType = (String)((Vector)this.getProperty(RETURN_TYPE)).get(0);
        CLILogger.getInstance().printDebugMessage("ReturnType = " + returnType);
        return returnType;
    }

    private AttributeList getAttributeList(String paramStr) throws CommandException {
        AttributeList attrList = new AttributeList();
        StringTokenizer paramsTokenizer = new StringTokenizer(paramStr, PARAM_DELIMITER);
        int size = paramsTokenizer.countTokens();
        for (int i = 0; i < size; ++i) {
            String nameValue = paramsTokenizer.nextToken();
            String nameValueStr = this.replacePattern(nameValue);
            if (nameValueStr == null) continue;
            int index = this.getDelimeterIndex(nameValueStr, "=", 0);
            String attrName = nameValueStr.substring(0, index);
            String attrValue = nameValueStr.substring(index + 1);
            CLILogger.getInstance().printDebugMessage("**Attr Name = " + attrName + ", Value = " + attrValue);
            attrList.add(new Attribute(attrName, attrValue));
        }
        return attrList;
    }

    protected Properties createPropertiesParam(String propertyVal) throws CommandException, CommandValidationException {
        String propertyStr = this.replacePattern(propertyVal);
        if (propertyStr == null) {
            return null;
        }
        Properties properties = new Properties();
        CLITokenizer propertyTok = new CLITokenizer(propertyStr, ":");
        while (propertyTok.hasMoreTokens()) {
            String nameAndvalue = propertyTok.nextToken();
            CLITokenizer nameTok = new CLITokenizer(nameAndvalue, "=");
            if (nameTok.countTokens() == 2) {
                properties.setProperty(nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                continue;
            }
            throw new CommandValidationException(this.getLocalizedString("InvalidPropertySyntax"));
        }
        return properties;
    }

    private Map createMapParam(String paramVal) throws CommandException, CommandValidationException {
        if (paramVal == null) {
            return null;
        }
        HashMap<String, String> mapParam = new HashMap<String, String>();
        try {
            StringTokenizer paramsTokenizer = new StringTokenizer(paramVal, PARAM_DELIMITER);
            int size = paramsTokenizer.countTokens();
            for (int ii = 0; ii < size; ++ii) {
                String nameValue = paramsTokenizer.nextToken();
                String nameValueStr = this.replacePattern(nameValue);
                if (nameValueStr == null) continue;
                if (nameValueStr.startsWith(PROPERTY)) {
                    String propertyStr = nameValueStr.substring(PROPERTY.length() + 1);
                    if (propertyStr.length() <= 0) continue;
                    CLITokenizer propertyTok = new CLITokenizer(propertyStr, ":");
                    while (propertyTok.hasMoreTokens()) {
                        String nameAndvalue = propertyTok.nextToken();
                        CLITokenizer nameTok = new CLITokenizer(nameAndvalue, "=");
                        if (nameTok.countTokens() == 2) {
                            mapParam.put(PROPERTY + nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                            continue;
                        }
                        throw new CommandValidationException(this.getLocalizedString("InvalidPropertySyntax"));
                    }
                    continue;
                }
                int index = this.getDelimeterIndex(nameValueStr, "=", 0);
                if (index <= 0) continue;
                String mapKey = nameValueStr.substring(0, index);
                String mapValue = nameValueStr.substring(index + 1);
                if (mapValue.length() <= 0) continue;
                CLILogger.getInstance().printDebugMessage("**Map Key = " + mapKey + ", Value = " + mapValue);
                mapParam.put(mapKey, mapValue);
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
        return mapParam;
    }

    private Boolean createBooleanVal(String booleanVal) throws CommandException {
        String booleanStr = this.replacePattern(booleanVal);
        return Boolean.valueOf(booleanStr);
    }

    private Long createLongVal(String longVal) throws CommandException {
        String longStr = this.replacePattern(longVal);
        return Long.valueOf(longStr);
    }

    private Integer createIntegerVal(String integerVal) throws CommandException {
        String integerStr = this.replacePattern(integerVal);
        return Integer.valueOf(integerStr);
    }

    protected String[] createStringArrayParam(String str) throws CommandException {
        String strArrayVal = this.replacePattern(str);
        CLILogger.getInstance().printDebugMessage("strArrayVal value = \"" + strArrayVal + "\"");
        if (strArrayVal == null || strArrayVal.equals("") || strArrayVal.equals("null")) {
            return null;
        }
        CLITokenizer cliTokenizer = new CLITokenizer(strArrayVal, ":");
        String[] strArray = new String[cliTokenizer.countTokens()];
        int ii = 0;
        while (cliTokenizer.hasMoreTokens()) {
            strArray[ii++] = cliTokenizer.nextTokenWithoutEscapeAndQuoteChars();
        }
        return strArray;
    }

    public void displayExceptionMessage(Exception e) throws CommandException {
        Throwable rootException = ExceptionUtil.getRootCause((Throwable)e);
        if (rootException.getLocalizedMessage() != null) {
            CLILogger.getInstance().printDetailMessage(rootException.getLocalizedMessage());
        }
        throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
    }

    protected void handleReturnValue(Object returnval) {
        if (returnval == null) {
            return;
        }
        Class<?> cl = returnval.getClass();
        if (cl.isArray()) {
            if (cl == new ObjectName[0].getClass()) {
                ObjectName[] objs = (ObjectName[])returnval;
                if (objs.length == 0) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                    return;
                }
                String displayType = (String)((Vector)this.getProperty(DISPLAY_TYPE)).get(0);
                for (int ii = 0; ii < objs.length; ++ii) {
                    ObjectName objectName = objs[ii];
                    CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
                    CLILogger.getInstance().printMessage(objectName.getKeyProperty(displayType));
                }
            } else {
                Object[] objs = (Object[])returnval;
                if (objs.length == 0) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                    return;
                }
                for (int ii = 0; ii < objs.length; ++ii) {
                    CLILogger.getInstance().printMessage(objs[ii].toString());
                }
            }
        } else if (cl.getName().equals(List.class.getName()) || returnval instanceof List) {
            List returnList = (List)returnval;
            if (returnList.size() > 0) {
                for (int i = 0; i < returnList.size(); ++i) {
                    CLILogger.getInstance().printMessage(returnList.get(i).toString());
                }
            } else {
                CLILogger.getInstance().printDebugMessage("Return list is empty");
            }
        }
    }

    protected int validatePort(String port) throws CommandValidationException {
        int portNum = -1;
        try {
            portNum = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber", new Object[]{port}));
        }
        if (portNum < 0 || portNum > 65535) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortRangeMsg"));
        }
        return portNum;
    }
}

