/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;

public abstract class BaseTransformationRuleCommand
extends GenericCommand {
    protected static final String WEB_SERVICE_OPTION = "webservicename";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected WebServiceEndpointConfig getWebServiceEndpointConfig(MBeanServerConnection mbsc, String fqWebServiceName, boolean isCreateIfNone) throws CommandException, CommandValidationException {
        int firstHashIdx = fqWebServiceName.indexOf("#");
        String wsName = null;
        if (firstHashIdx == -1) throw new CommandException(this.getLocalizedString("InvalidFormatForWebservice"));
        if (firstHashIdx + 1 == fqWebServiceName.length()) {
            throw new CommandException(this.getLocalizedString("InvalidFormatForWebservice"));
        }
        wsName = fqWebServiceName.substring(firstHashIdx + 1);
        String regName = fqWebServiceName.substring(0, firstHashIdx);
        StringTokenizer sTok = new StringTokenizer(fqWebServiceName, "#");
        int numTokens = sTok.countTokens();
        if (numTokens == 3) {
            J2EEApplicationConfig appConfig = this.getApplicationConfigMBean(mbsc, regName);
            if (appConfig == null) {
                throw new CommandException(this.getLocalizedString("NoAppFoundForWS", new Object[]{regName}));
            }
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            WebServiceEndpointInfo info = domainRoot.getWebServiceMgr().getWebServiceEndpointInfo((Object)fqWebServiceName);
            if (info == null) {
                String moduleName = fqWebServiceName.substring(firstHashIdx + 1, fqWebServiceName.lastIndexOf("#"));
                throw new CommandException(this.getLocalizedString("NoModuleOrEndpointFoundForWS", new Object[]{fqWebServiceName}));
            }
            Map epMap = appConfig.getWebServiceEndpointConfigMap();
            if (epMap == null) {
                if (!isCreateIfNone) return null;
                return appConfig.createWebServiceEndpointConfig(wsName, null);
            }
            WebServiceEndpointConfig wsEpConfig = (WebServiceEndpointConfig)epMap.get(wsName);
            if (wsEpConfig != null || !isCreateIfNone) return wsEpConfig;
            return appConfig.createWebServiceEndpointConfig(wsName, null);
        }
        if (numTokens != 2) throw new CommandValidationException(this.getLocalizedString("InvalidFormatForWebservice"));
        String modType = this.getStandAloneModuleType(mbsc, fqWebServiceName);
        if (modType.equals("EJB")) {
            EJBModuleConfig ejbModuleConfig = this.getEJBModuleConfigMBean(mbsc, regName);
            if (ejbModuleConfig == null) {
                throw new CommandException(this.getLocalizedString("NoEJBModuleFoundForWS", new Object[]{regName}));
            }
            Map epMap = ejbModuleConfig.getWebServiceEndpointConfigMap();
            if (epMap == null) {
                if (!isCreateIfNone) return null;
                return ejbModuleConfig.createWebServiceEndpointConfig(wsName, null);
            }
            WebServiceEndpointConfig wsEpConfig = (WebServiceEndpointConfig)epMap.get(wsName);
            if (wsEpConfig != null || !isCreateIfNone) return wsEpConfig;
            return ejbModuleConfig.createWebServiceEndpointConfig(wsName, null);
        }
        if (!modType.equals("SERVLET")) throw new CommandException(this.getLocalizedString("InvalidModuleTypeForWS"));
        WebModuleConfig webModuleConfig = this.getWebModuleConfigMBean(mbsc, regName);
        if (webModuleConfig == null) {
            throw new CommandException(this.getLocalizedString("NoWebModuleFoundForWS", new Object[]{regName}));
        }
        Map epMap = webModuleConfig.getWebServiceEndpointConfigMap();
        if (epMap == null) {
            if (!isCreateIfNone) return null;
            return webModuleConfig.createWebServiceEndpointConfig(wsName, null);
        }
        WebServiceEndpointConfig wsEpConfig = (WebServiceEndpointConfig)epMap.get(wsName);
        if (wsEpConfig != null || !isCreateIfNone) return wsEpConfig;
        return webModuleConfig.createWebServiceEndpointConfig(wsName, null);
    }

    private J2EEApplicationConfig getApplicationConfigMBean(MBeanServerConnection mbsc, String appName) {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        DomainConfig domainConfig = domainRoot.getDomainConfig();
        Map appCfgMap = domainConfig.getJ2EEApplicationConfigMap();
        if (appCfgMap != null) {
            return (J2EEApplicationConfig)appCfgMap.get(appName);
        }
        return null;
    }

    private EJBModuleConfig getEJBModuleConfigMBean(MBeanServerConnection mbsc, String moduleName) {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        DomainConfig domainConfig = domainRoot.getDomainConfig();
        Map appCfgMap = domainConfig.getEJBModuleConfigMap();
        if (appCfgMap != null) {
            return (EJBModuleConfig)appCfgMap.get(moduleName);
        }
        return null;
    }

    private WebModuleConfig getWebModuleConfigMBean(MBeanServerConnection mbsc, String moduleName) {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        DomainConfig domainConfig = domainRoot.getDomainConfig();
        Map appCfgMap = domainConfig.getWebModuleConfigMap();
        if (appCfgMap != null) {
            return (WebModuleConfig)appCfgMap.get(moduleName);
        }
        return null;
    }

    private String getStandAloneModuleType(MBeanServerConnection mbsc, String fqName) throws CommandException {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        WebServiceEndpointInfo info = domainRoot.getWebServiceMgr().getWebServiceEndpointInfo((Object)fqName);
        if (info == null) {
            throw new CommandException(this.getLocalizedString("NoStandaloneModuleFoundForWS", new Object[]{fqName}));
        }
        return info.getServiceImplType();
    }

    protected void validateWebServiceName(String fqWebServiceName, boolean validateIfNull) throws CommandValidationException {
        if (fqWebServiceName == null && !validateIfNull) {
            return;
        }
        int hashIdx = fqWebServiceName.lastIndexOf("#");
        if (hashIdx != -1) {
            if (hashIdx + 1 == fqWebServiceName.length()) {
                throw new CommandValidationException(this.getLocalizedString("InvalidFormatForWebservice"));
            }
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidFormatForWebservice"));
        }
    }
}

