/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.shoal;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import java.util.Properties;

public class ShoalMessagingTest
implements Runnable,
CallBack {
    String serviceName = "service";
    GroupManagementService gms;
    private final Object sendMessagesSignal = new Object();
    private int nbOfMembers = 2;
    int total_msgs_received = 0;

    public ShoalMessagingTest() {
        Properties props = new Properties();
        props.put(ServiceProviderConfigurationKeys.LOOPBACK.toString(), "true");
        this.gms = (GroupManagementService)((Object)GMSFactory.startGMSModule(System.getProperty("INSTANCEID"), "group", GroupManagementService.MemberType.CORE, props));
        try {
            this.gms.addActionFactory(new MessageActionFactoryImpl(this), this.serviceName);
            this.gms.addActionFactory(new JoinNotificationActionFactoryImpl(this));
            this.gms.join();
        }
        catch (GMSException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.gms.getGroupHandle().getAllCurrentMembers().size() < this.nbOfMembers) {
            System.out.println("Waiting for all members to join...");
            Object object = this.sendMessagesSignal;
            synchronized (object) {
                try {
                    this.sendMessagesSignal.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int num_msgs = 10000;
        byte[] payload = this.generatePayload();
        long log_interval = 1000L;
        int total_msgs = 0;
        try {
            for (int i = 0; i < num_msgs; ++i) {
                this.gms.getGroupHandle().sendMessage(this.serviceName, payload);
                if ((long)(++total_msgs) % log_interval != 0L) continue;
                System.out.println("++ sent " + total_msgs);
            }
        }
        catch (GMSException e) {
            e.printStackTrace();
        }
        Object object = this.sendMessagesSignal;
        synchronized (object) {
            try {
                this.sendMessagesSignal.wait(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    byte[] generatePayload() {
        byte[] payload = new byte[128];
        for (int i = 0; i < payload.length; ++i) {
            if (i % 2 != 0) continue;
            payload[i] = 1;
        }
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotification(Signal signal) {
        if (signal instanceof JoinNotificationSignal) {
            if (this.gms.getGroupHandle().getAllCurrentMembers().size() == this.nbOfMembers) {
                Object object = this.sendMessagesSignal;
                synchronized (object) {
                    this.sendMessagesSignal.notify();
                }
            }
        } else if (signal instanceof MessageSignal) {
            ++this.total_msgs_received;
            if (this.total_msgs_received % 1000 == 0) {
                System.out.println("-- received " + this.total_msgs_received);
            }
        } else {
            System.err.println(new StringBuffer().append(this.serviceName).append(": Notification Received from:").append(signal.getMemberToken()).append(":[").append(signal.toString()).append("] has been processed").toString());
        }
    }

    public static void main(String[] args) {
        Thread t = new Thread(new ShoalMessagingTest());
        t.start();
    }
}

