/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEvents;
import com.sun.enterprise.jxtamgmt.ClusterViewManager;
import com.sun.enterprise.jxtamgmt.HealthMessage;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

class MasterNode
implements PipeMsgListener,
Runnable {
    private static final Logger LOG = JxtaUtil.getLogger(MasterNode.class.getName());
    private final ClusterManager manager;
    private InputPipe inputPipe;
    private OutputPipe outputPipe;
    private boolean masterAssigned = false;
    private volatile boolean discoveryInProgress = false;
    private ID localNodeID = ID.nullID;
    private final SystemAdvertisement sysAdv;
    private PipeAdvertisement pipeAdv = null;
    private final PipeService pipeService;
    private final MessageElement sysAdvElement;
    private MessageElement routeAdvElement = null;
    private volatile boolean started = false;
    private volatile boolean stop = false;
    private Thread thread = null;
    private ClusterViewManager clusterViewManager;
    private ClusterView discoveryView;
    private final AtomicLong masterViewID = new AtomicLong();
    final String MASTERLOCK = new String("MASTERLOCK");
    private static final String CCNTL = "CCNTL";
    private static final String MASTERNODE = "MN";
    private static final String MASTERQUERY = "MQ";
    private static final String NODEQUERY = "NQ";
    private static final String MASTERNODERESPONSE = "MR";
    private static final String NODERESPONSE = "NR";
    private static final String NAMESPACE = "MASTER";
    private static final String NODEADV = "NAD";
    private static final String ROUTEADV = "ROUTE";
    private static final String AMASTERVIEW = "AMV";
    private static final String MASTERVIEWSEQ = "SEQ";
    private int interval = 6;
    private long timeout = 10000L;
    private static final String VIEW_CHANGE_EVENT = "VCE";
    private RouteControl routeControl = null;
    private MessageTransport endpointRouter = null;
    private transient Map<ID, OutputPipe> pipeCache = new Hashtable<ID, OutputPipe>();

    MasterNode(ClusterManager manager, long timeout, int interval) {
        PeerGroup group = manager.getNetPeerGroup();
        this.pipeService = group.getPipeService();
        this.localNodeID = group.getPeerID();
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.interval = interval;
        this.manager = manager;
        this.sysAdv = manager.getSystemAdvertisement();
        this.discoveryView = new ClusterView(this.sysAdv);
        this.sysAdvElement = new TextDocumentMessageElement(NODEADV, (TextDocument)((XMLDocument)manager.getSystemAdvertisement().getDocument(MimeMediaType.XMLUTF8)), null);
        this.endpointRouter = group.getEndpointService().getMessageTransport("jxta");
        if (this.endpointRouter != null) {
            this.routeControl = (RouteControl)this.endpointRouter.transportControl((Object)EndpointRouter.GET_ROUTE_CONTROL, null);
            RouteAdvertisement route = this.routeControl.getMyLocalRoute();
            if (route != null) {
                this.routeAdvElement = new TextDocumentMessageElement(ROUTEADV, (TextDocument)((XMLDocument)route.getDocument(MimeMediaType.XMLUTF8)), null);
            }
        }
        try {
            this.pipeAdv = this.createPipeAdv();
            this.outputPipe = this.pipeService.createOutputPipe(this.pipeAdv, 0L);
        }
        catch (IOException io) {
            io.printStackTrace();
            LOG.log(Level.WARNING, "Failed to create master outputPipe : " + io);
        }
    }

    public long getTimeout() {
        return this.timeout * (long)this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMaster(SystemAdvertisement systemAdv) {
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.FINER, "Master node role collision with " + systemAdv.getName() + " .... attempting to resolve");
            this.send(systemAdv.getID(), systemAdv.getName(), this.createMasterCollisionMessage());
            if (this.manager.getNodeID().toString().compareTo(systemAdv.getID().toString()) >= 0) {
                LOG.log(Level.FINER, "Affirming Master Node role");
            } else {
                LOG.log(Level.FINER, "Resigning Master Node role in anticipation of a master node announcement");
                this.clusterViewManager.setMaster(systemAdv, false);
            }
            return false;
        }
        this.clusterViewManager.setMaster(systemAdv, true);
        this.masterAssigned = true;
        String string = this.MASTERLOCK;
        synchronized (string) {
            this.MASTERLOCK.notifyAll();
        }
        LOG.log(Level.FINE, "Discovered a Master node :" + systemAdv.getName());
        return true;
    }

    private Message createMasterCollisionMessage() {
        Message msg = this.createSelfNodeAdvertisement();
        StringMessageElement el = new StringMessageElement(CCNTL, this.localNodeID.toString(), null);
        msg.addMessageElement(NAMESPACE, (MessageElement)el);
        LOG.log(Level.FINER, "Created a Master Collision Message");
        return msg;
    }

    private Message createSelfNodeAdvertisement() {
        Message msg = new Message();
        msg.addMessageElement(NAMESPACE, this.sysAdvElement);
        return msg;
    }

    private void sendSelfNodeAdvertisement(ID id, String name) {
        Message msg = this.createSelfNodeAdvertisement();
        LOG.log(Level.FINER, "Sending a Node Response Message ");
        this.send(id, name, msg);
    }

    private Message createMasterQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        StringMessageElement el = new StringMessageElement(MASTERQUERY, "query", null);
        msg.addMessageElement(NAMESPACE, (MessageElement)el);
        this.addRoute(msg);
        LOG.log(Level.FINER, "Created a Master Node Query Message ");
        return msg;
    }

    void addRoute(Message msg) {
        if (this.routeAdvElement != null && this.routeControl != null) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
    }

    private Message createNodeQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        StringMessageElement el = new StringMessageElement(NODEQUERY, "nodequery", null);
        msg.addMessageElement(NAMESPACE, (MessageElement)el);
        if (this.routeAdvElement != null && this.routeControl != null) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        LOG.log(Level.FINER, "Created a Node Query Message ");
        return msg;
    }

    private Message createMasterResponse(boolean announcement, ID masterID) {
        Message msg = this.createSelfNodeAdvertisement();
        String type = MASTERNODE;
        if (!announcement) {
            type = MASTERNODERESPONSE;
        }
        StringMessageElement el = new StringMessageElement(type, masterID.toString(), null);
        msg.addMessageElement(NAMESPACE, (MessageElement)el);
        if (this.routeAdvElement != null && this.routeControl != null) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        LOG.log(Level.FINER, "Created a Master Response Message with masterId = " + masterID.toString());
        return msg;
    }

    private PipeAdvertisement createPipeAdv() {
        PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        pipeAdv.setPipeID((ID)this.manager.getNetworkManager().getMasterPipeID());
        pipeAdv.setType("JxtaPropagate");
        return pipeAdv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discoverMaster() {
        this.masterViewID.set(this.clusterViewManager.getMasterViewID());
        long timeToWait = this.timeout;
        LOG.log(Level.FINER, "Attempting to discover a master node");
        Message query = this.createMasterQuery();
        this.send(null, null, query);
        LOG.log(Level.FINER, " waiting for " + this.timeout + " ms");
        try {
            String string = this.MASTERLOCK;
            synchronized (string) {
                this.MASTERLOCK.wait(timeToWait);
            }
        }
        catch (InterruptedException intr) {
            Thread.interrupted();
            LOG.log(Level.FINER, "Thread interrupted", intr);
        }
        LOG.log(Level.FINE, "masterAssigned=" + this.masterAssigned);
        return this.masterAssigned;
    }

    public boolean isMaster() {
        LOG.log(Level.FINER, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        return this.clusterViewManager.isMaster();
    }

    boolean isMasterAssigned() {
        return this.masterAssigned;
    }

    public ID getMasterNodeID() {
        return this.clusterViewManager.getMaster().getID();
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    void resetMaster() {
        LOG.log(Level.FINER, "Resetting Master view");
        this.masterAssigned = false;
    }

    SystemAdvertisement processNodeAdvertisement(Message msg) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODEADV);
        if (msgElement == null) {
            LOG.log(Level.WARNING, "Missing NODEADV message element");
            JxtaUtil.printMessageStats(msg, false);
            return null;
        }
        StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)msgElement.getMimeType(), (InputStream)msgElement.getStream());
        SystemAdvertisement adv = new SystemAdvertisement((Element)asDoc);
        if (!adv.getID().equals(this.localNodeID)) {
            LOG.log(Level.FINER, "Received a System advertisment Name :" + adv.getName());
        }
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeAnnouncement(Message msg, SystemAdvertisement source) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, MASTERNODE);
        if (msgElement == null) {
            return false;
        }
        this.processRoute(msg);
        LOG.log(Level.FINER, "Received a Master Node Announcement from Name :" + source.getName());
        if (this.checkMaster(source) && (msgElement = msg.getMessageElement(NAMESPACE, AMASTERVIEW)) != null) {
            ArrayList newLocalView = (ArrayList)JxtaUtil.getObjectFromByteArray(msgElement);
            if (newLocalView != null) {
                LOG.log(Level.FINER, MessageFormat.format("Received an authoritative view from {0}, of size {1} resetting local view containing {2}", source.getName(), newLocalView.size(), this.clusterViewManager.getLocalView().getSize()));
            }
            long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
            msgElement = msg.getMessageElement(NAMESPACE, VIEW_CHANGE_EVENT);
            if (msgElement != null) {
                LOG.log(Level.FINEST, "MasterNode:PMNA: Received Master View with Seq Id=" + seqID + "Current sequence is " + this.clusterViewManager.getMasterViewID());
                if (seqID <= this.clusterViewManager.getMasterViewID()) {
                    LOG.log(Level.FINER, MessageFormat.format("Received an older clusterView sequence {0}. Current sequence :{1} discarding out of sequence view", seqID, this.clusterViewManager.getMasterViewID()));
                    return true;
                }
                ClusterViewEvent cvEvent = (ClusterViewEvent)JxtaUtil.getObjectFromByteArray(msgElement);
                assert (newLocalView != null);
                if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                    LOG.log(Level.FINER, "New ClusterViewManager does not contain self. Publishing Self");
                    this.sendSelfNodeAdvertisement(source.getID(), null);
                    return true;
                }
                this.clusterViewManager.setMasterViewID(seqID);
                this.masterViewID.set(seqID);
                LOG.log(Level.FINER, "MN: New MasterViewID = " + this.clusterViewManager.getMasterViewID());
                this.clusterViewManager.addToView(newLocalView, true, cvEvent);
            } else {
                LOG.log(Level.WARNING, "New View Received without corresponding ViewChangeEvent details");
            }
        }
        String string = this.MASTERLOCK;
        synchronized (string) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeResponse(Message msg, SystemAdvertisement source) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, MASTERNODERESPONSE);
        if (msgElement != null) {
            LOG.log(Level.FINE, "Received a MasterNode Response from Name :" + source.getName());
            this.processRoute(msg);
            this.clusterViewManager.setMaster(source, true);
            msgElement = msg.getMessageElement(NAMESPACE, AMASTERVIEW);
            this.masterAssigned = true;
            if (msgElement != null) {
                ArrayList newLocalView = (ArrayList)JxtaUtil.getObjectFromByteArray(msgElement);
                msgElement = msg.getMessageElement(NAMESPACE, VIEW_CHANGE_EVENT);
                if (msgElement != null) {
                    long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
                    LOG.log(Level.FINEST, "MasterNode:PMNR Received Master View with Seq Id=" + seqID);
                    if (seqID <= this.clusterViewManager.getMasterViewID()) {
                        LOG.log(Level.FINER, MessageFormat.format("Received an older clusterView sequence {0} of size :{1} Current sequence :{2} discarding out of sequence view", seqID, newLocalView.size(), this.clusterViewManager.getMasterViewID()));
                        return true;
                    }
                    LOG.log(Level.FINER, MessageFormat.format("Received a VIEW_CHANGE_EVENT from : {0}, seqID of :{1}, size :{2}", source.getName(), seqID, newLocalView.size()));
                    ClusterViewEvent cvEvent = (ClusterViewEvent)JxtaUtil.getObjectFromByteArray(msgElement);
                    if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                        LOG.log(Level.FINER, "Received view does not contain self. Publishing self");
                        this.sendSelfNodeAdvertisement(source.getID(), null);
                        return true;
                    }
                    this.clusterViewManager.setMasterViewID(seqID);
                    this.masterViewID.set(seqID);
                    this.clusterViewManager.addToView(newLocalView, true, cvEvent);
                    String string = this.MASTERLOCK;
                    synchronized (string) {
                        this.MASTERLOCK.notifyAll();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    boolean processChangeEvent(Message msg, SystemAdvertisement source) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, VIEW_CHANGE_EVENT);
        if (msgElement != null) {
            ClusterViewEvent cvEvent = (ClusterViewEvent)JxtaUtil.getObjectFromByteArray(msgElement);
            msgElement = msg.getMessageElement(NAMESPACE, AMASTERVIEW);
            if (msgElement != null && cvEvent != null) {
                long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
                if (seqID <= this.clusterViewManager.getMasterViewID()) {
                    LOG.log(Level.FINER, MessageFormat.format("Received an older clusterView sequence {0}. Current sequence :{1} discarding out of sequence view", seqID, this.clusterViewManager.getMasterViewID()));
                    return true;
                }
                ArrayList newLocalView = (ArrayList)JxtaUtil.getObjectFromByteArray(msgElement);
                LOG.log(Level.FINER, MessageFormat.format("Received a new view of size :{0}, event :{1}", newLocalView.size(), cvEvent.getEvent().toString()));
                if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                    LOG.log(Level.FINER, "Received ClusterViewManager does not contain self. Publishing Self");
                    this.sendSelfNodeAdvertisement(source.getID(), null);
                    return true;
                }
                this.clusterViewManager.setMasterViewID(seqID);
                this.masterViewID.set(seqID);
                this.clusterViewManager.addToView(newLocalView, true, cvEvent);
            } else {
                return false;
            }
        }
        return false;
    }

    boolean processMasterNodeQuery(Message msg, SystemAdvertisement adv) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, MASTERQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        this.processRoute(msg);
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINER, MessageFormat.format("Received a MasterNode Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            this.clusterViewManager.notifyListeners(cvEvent);
            this.sendNewView(null, cvEvent, this.createMasterResponse(false, this.localNodeID), true);
        }
        return true;
    }

    boolean processNodeQuery(Message msg, SystemAdvertisement adv) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODEQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        this.processRoute(msg);
        LOG.log(Level.FINER, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINER, MessageFormat.format("Received a Node Response from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            this.clusterViewManager.notifyListeners(cvEvent);
            this.sendNewView(null, cvEvent, this.createMasterResponse(false, this.localNodeID), true);
        } else {
            Message response = this.createSelfNodeAdvertisement();
            StringMessageElement el = new StringMessageElement(NODERESPONSE, "noderesponse", null);
            response.addMessageElement(NAMESPACE, (MessageElement)el);
            LOG.log(Level.FINER, "Sending Node response to  :" + adv.getName());
            this.send(adv.getID(), null, response);
        }
        return true;
    }

    boolean processNodeResponse(Message msg, SystemAdvertisement adv) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODERESPONSE);
        if (msgElement == null || adv == null) {
            return false;
        }
        this.processRoute(msg);
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINER, MessageFormat.format("Received a Node Response from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            this.clusterViewManager.notifyListeners(cvEvent);
            this.sendNewView(null, cvEvent, this.createMasterResponse(false, this.localNodeID), true);
        }
        return true;
    }

    void processRoute(Message msg) {
        try {
            MessageElement routeElement = msg.getMessageElement(NAMESPACE, ROUTEADV);
            if (routeElement != null && this.routeControl != null) {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)routeElement.getMimeType(), (InputStream)routeElement.getStream());
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((XMLElement)asDoc);
                this.routeControl.addRoute(route);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            LOG.log(Level.WARNING, io.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeCollision(Message msg, SystemAdvertisement adv) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, CCNTL);
        if (msgElement == null) {
            return false;
        }
        LOG.log(Level.FINER, MessageFormat.format("Received a MasterNode Collision from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        SystemAdvertisement madv = this.manager.getSystemAdvertisement();
        LOG.log(Level.FINER, "Candidate Master :" + madv.getName());
        if (madv.getID().toString().compareTo(adv.getID().toString()) >= 0) {
            LOG.log(Level.FINER, "Affirming Master Node role");
            String string = this.MASTERLOCK;
            synchronized (string) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.announceMaster(this.manager.getSystemAdvertisement());
                this.MASTERLOCK.notifyAll();
            }
        } else {
            LOG.log(Level.FINER, "Resigning Master Node role");
            this.clusterViewManager.setMaster(adv, true);
        }
        return true;
    }

    void probeNode(HealthMessage.Entry entry) throws IOException {
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.INFO, "Probing ID = " + entry.id + ", name = " + entry.adv.getName());
            this.send((ID)entry.id, null, this.createNodeQuery());
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        if (this.manager.isStopping()) {
            LOG.log(Level.FINE, "Since this Peer is Stopping, returning without processing incoming master node message. ");
            return;
        }
        if (this.isStarted()) {
            Message msg = event.getMessage();
            if (msg == null) {
                LOG.log(Level.WARNING, "Received a null message");
                return;
            }
            try {
                SystemAdvertisement adv = this.processNodeAdvertisement(msg);
                if (adv != null && adv.getID().equals(this.localNodeID)) {
                    LOG.log(Level.FINEST, "Discarding loopback message");
                    return;
                }
                if (adv != null) {
                    if (this.isMaster() && this.masterAssigned) {
                        this.clusterViewManager.add(adv);
                    } else if (this.discoveryInProgress) {
                        this.discoveryView.add(adv);
                    }
                }
                if (this.processMasterNodeQuery(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeResponse(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeAnnouncement(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeCollision(msg, adv)) {
                    return;
                }
                if (this.processChangeEvent(msg, adv)) {
                    return;
                }
                if (this.processNodeQuery(msg, adv)) {
                    return;
                }
                if (this.processNodeResponse(msg, adv)) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
            LOG.log(Level.FINER, MessageFormat.format("ClusterViewManager contains {0} entries", this.clusterViewManager.getViewSize()));
        } else {
            LOG.log(Level.FINER, "Started : " + this.isStarted());
        }
    }

    private void announceMaster(SystemAdvertisement adv) {
        Message msg = this.createMasterResponse(true, adv.getID());
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, adv);
        LOG.log(Level.FINER, MessageFormat.format("Announcing Master Node designation Local view contains                                      {0} entries", this.clusterViewManager.getViewSize()));
        this.sendNewView(null, cvEvent, msg, this.masterAssigned && this.isMaster());
    }

    public void run() {
        this.startMasterNodeDiscovery();
        this.discoveryInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMasterNodeDiscovery() {
        MasterNode masterNode = this;
        synchronized (masterNode) {
            this.clusterViewManager.start();
        }
        if (this.masterAssigned) {
            this.discoveryInProgress = false;
            return;
        }
        for (int count = 0; !this.stop && count < this.interval && !this.discoverMaster(); ++count) {
        }
        if (!this.masterAssigned) {
            LOG.log(Level.FINER, "MN Discovery timeout, appointing master");
            this.appointMasterNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appointMasterNode() {
        if (this.masterAssigned) {
            return;
        }
        LOG.log(Level.FINER, "MasterNode: discoveryInProgress=" + this.discoveryInProgress);
        SystemAdvertisement madv = this.discoveryInProgress ? this.discoveryView.getMasterCandidate() : this.clusterViewManager.getMasterCandidate();
        LOG.log(Level.FINER, "MasterNode: Master Candidate=" + madv.getName());
        this.clusterViewManager.setMaster(madv, false);
        this.masterAssigned = true;
        if (madv.getID().equals(this.localNodeID)) {
            LOG.log(Level.FINER, "MasterNode: Setting myself as MasterNode ");
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            LOG.log(Level.FINER, "MasterNode: masterViewId =" + this.masterViewID);
            if (this.discoveryInProgress) {
                List<SystemAdvertisement> list = this.discoveryView.getView();
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.addToView(list, true, cvEvent);
            } else {
                LOG.log(Level.FINER, "MasterNode: Notifying Local Listeners of  Master Change");
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.notifyListeners(cvEvent);
            }
        }
        this.discoveryView.clear();
        this.discoveryView.add(this.sysAdv);
        String string = this.MASTERLOCK;
        synchronized (string) {
            if (madv.getID().equals(this.localNodeID)) {
                LOG.log(Level.FINER, "Assuming Master Node designation ...");
                if (this.clusterViewManager.getViewSize() > 1) {
                    LOG.log(Level.FINER, "MasterNode: announcing MasterNode assumption ");
                    this.announceMaster(this.manager.getSystemAdvertisement());
                }
                this.MASTERLOCK.notifyAll();
            }
        }
    }

    private void send(ID peerid, String name, Message msg) {
        try {
            if (peerid != null) {
                OutputPipe output;
                LOG.log(Level.FINER, "Unicasting Message to :" + name + "ID=" + peerid);
                if (!this.pipeCache.containsKey(peerid)) {
                    output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                    this.pipeCache.put(peerid, output);
                } else {
                    output = this.pipeCache.get(peerid);
                    if (output.isClosed()) {
                        output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                        this.pipeCache.put(peerid, output);
                    }
                }
                output.send(msg);
            } else {
                LOG.log(Level.FINER, "Broadcasting Message");
                this.outputPipe.send(msg);
            }
        }
        catch (IOException io) {
            LOG.log(Level.FINEST, "Failed to send message", io);
        }
    }

    void sendNewView(ID toID, ClusterViewEvent event, Message msg, boolean includeView) {
        if (includeView) {
            this.addAuthoritativeView(msg);
        }
        ByteArrayMessageElement cvEvent = new ByteArrayMessageElement(VIEW_CHANGE_EVENT, MimeMediaType.AOS, JxtaUtil.createByteArrayFromObject(event), null);
        LOG.log(Level.FINER, MessageFormat.format("Created a view element of size {0}bytes", cvEvent.getByteLength()));
        msg.addMessageElement(NAMESPACE, (MessageElement)cvEvent);
        LOG.log(Level.FINER, "Sending new authoritative cluster view to group, event :" + event.getEvent().toString() + " viewSeqId: " + this.clusterViewManager.getMasterViewID());
        this.send(toID, null, msg);
    }

    void addAuthoritativeView(Message msg) {
        List<SystemAdvertisement> view = this.clusterViewManager.getLocalView().getView();
        LOG.log(Level.FINER, "MasterNode: Adding Authoritative View of size " + view.size() + "  to view message");
        ByteArrayMessageElement bame = new ByteArrayMessageElement(AMASTERVIEW, MimeMediaType.AOS, JxtaUtil.createByteArrayFromObject(view), null);
        msg.addMessageElement(NAMESPACE, (MessageElement)bame);
        LOG.log(Level.FINER, MessageFormat.format("Created an Authoritative view element of size {0}bytes", bame.getByteLength()));
        MasterNode.addLongToMessage(msg, NAMESPACE, MASTERVIEWSEQ, this.masterViewID.longValue());
    }

    public synchronized void stop() {
        LOG.log(Level.FINER, "Stopping MasterNode");
        this.outputPipe.close();
        this.inputPipe.close();
        this.pipeCache.clear();
        this.discoveryView.clear();
        this.thread = null;
        this.masterAssigned = false;
        this.started = false;
        this.stop = true;
        this.discoveryInProgress = false;
    }

    public synchronized void start() {
        LOG.log(Level.FINER, "Starting MasterNode");
        this.discoveryInProgress = true;
        this.clusterViewManager = this.manager.getClusterViewManager();
        try {
            this.started = true;
            this.inputPipe = this.pipeService.createInputPipe(this.pipeAdv, (PipeMsgListener)this);
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Failed to create service input pipe" + ioe);
        }
        this.thread = new Thread((Runnable)this, "MasterNode");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void viewChanged(ClusterViewEvent event) {
        if (this.isMaster() && this.masterAssigned) {
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            Message msg = this.createSelfNodeAdvertisement();
            this.sendNewView(null, event, msg, true);
        }
    }

    private static void addLongToMessage(Message message, String nameSpace, String elemName, long data) {
        message.addMessageElement(nameSpace, (MessageElement)new StringMessageElement(elemName, Long.toString(data), null));
    }

    private static long getLongFromMessage(Message message, String nameSpace, String elemName) throws NumberFormatException {
        String seqStr = message.getMessageElement(nameSpace, elemName).toString();
        if (seqStr != null) {
            return Long.parseLong(message.getMessageElement(nameSpace, elemName).toString());
        }
        return -1L;
    }

    RouteControl getRouteControl() {
        if (this.routeControl == null) {
            this.routeControl = (RouteControl)this.endpointRouter.transportControl((Object)EndpointRouter.GET_ROUTE_CONTROL, null);
        }
        return this.routeControl;
    }
}

