/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IdentityHashtable
extends Dictionary
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1421746759512286392L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int KEYS = 0;
    static final int ELEMENTS = 1;
    private static EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
    protected transient Entry[] entries;
    protected transient int count = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;

    public IdentityHashtable(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.entries = new Entry[capacity];
    }

    public IdentityHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashtable() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new Entry[32];
    }

    public synchronized void clear() {
        if (this.count > 0) {
            Entry[] copyOfEntries = this.entries;
            int i = copyOfEntries.length;
            while (--i >= 0) {
                copyOfEntries[i] = null;
            }
            this.count = 0;
        }
    }

    public synchronized Object clone() {
        try {
            Entry[] copyOfEntries = this.entries;
            IdentityHashtable clone = (IdentityHashtable)super.clone();
            clone.entries = new Entry[copyOfEntries.length];
            int i = copyOfEntries.length;
            while (i-- > 0) {
                clone.entries[i] = copyOfEntries[i] != null ? (Entry)copyOfEntries[i].clone() : null;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized boolean contains(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        Entry[] copyOfEntries = this.entries;
        int i = copyOfEntries.length;
        while (i-- > 0) {
            Entry e = copyOfEntries[i];
            while (e != null) {
                if (e.value.equals(obj)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(1);
    }

    public synchronized Object get(Object key) {
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(0);
    }

    public synchronized Object put(Object key, Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = obj;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            copyOfEntries = this.entries;
            index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        }
        copyOfEntries[index] = e = new Entry(hash, key, obj, copyOfEntries[index]);
        ++this.count;
        return null;
    }

    private void rehash() {
        int oldCapacity = this.entries.length;
        Entry[] oldEntries = this.entries;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newEntries = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = newEntries;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldEntries[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newEntries[index];
                newEntries[index] = e;
            }
        }
    }

    public synchronized Object remove(Object key) {
        Entry[] copyOfEntries = this.entries;
        int hash = System.identityHashCode(key);
        int index = (hash & Integer.MAX_VALUE) % copyOfEntries.length;
        Entry e = copyOfEntries[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    copyOfEntries[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.entries.length);
        s.writeInt(this.count);
        for (int i = this.entries.length - 1; i >= 0; --i) {
            Entry entry = this.entries[i];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.entries = new Entry[numBuckets];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private static class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key == e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    class Enumerator
    implements Enumeration {
        int enumeratorType;
        int index;
        Entry entry;

        Enumerator(int enumeratorType) {
            this.enumeratorType = enumeratorType;
            this.index = IdentityHashtable.this.entries.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = IdentityHashtable.this.entries[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = IdentityHashtable.this.entries[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e = this.entry;
                this.entry = e.next;
                if (this.enumeratorType == 0) {
                    return e.key;
                }
                return e.value;
            }
            throw new NoSuchElementException("IdentityHashtable.Enumerator");
        }
    }

    private static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

