/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.peer.PeerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccessPointAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private PeerID pid = null;
    private Vector<String> endpointAddresses = new Vector();

    @Override
    public AccessPointAdvertisement clone() {
        try {
            AccessPointAdvertisement a = (AccessPointAdvertisement)super.clone();
            a.setPeerID(this.getPeerID());
            a.addEndpointAddresses(this.endpointAddresses);
            return a;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof AccessPointAdvertisement)) {
            return false;
        }
        AccessPointAdvertisement ap = (AccessPointAdvertisement)target;
        if (null == this.getPeerID() && null != ap.getPeerID()) {
            return false;
        }
        if (null != this.getPeerID() && !this.getPeerID().equals(ap.getPeerID())) {
            return false;
        }
        if (this.endpointAddresses.size() != ap.endpointAddresses.size()) {
            return false;
        }
        for (String anEA : this.endpointAddresses) {
            if (ap.endpointAddresses.contains(anEA)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (null != this.pid) {
            return this.pid.hashCode();
        }
        return 1;
    }

    public static String getAdvertisementType() {
        return "jxta:APA";
    }

    @Override
    public final String getBaseAdvType() {
        return AccessPointAdvertisement.getAdvertisementType();
    }

    public PeerID getPeerID() {
        return this.pid;
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid;
    }

    public void addEndpointAddresses(List<EndpointAddress> addrs) {
        for (EndpointAddress addr : addrs) {
            this.addEndpointAddress(addr);
        }
    }

    public void clearEndpointAddresses() {
        this.endpointAddresses.clear();
    }

    public void removeEndpointAddress(EndpointAddress addr) {
        this.endpointAddresses.remove(addr.toString());
    }

    public void removeEndpointAddresses(Collection<EndpointAddress> addrs) {
        for (EndpointAddress addr : addrs) {
            this.endpointAddresses.remove(addr.toString());
        }
    }

    public Enumeration<String> getEndpointAddresses() {
        return this.endpointAddresses.elements();
    }

    @Deprecated
    public Vector<String> getVectorEndpointAddresses() {
        return this.endpointAddresses;
    }

    @Deprecated
    public void setEndpointAddresses(Vector<String> addresses) {
        this.endpointAddresses = addresses;
    }

    @Deprecated
    public void addEndpointAddresses(Vector<String> addresses) {
        for (String toAdd : addresses) {
            this.addEndpointAddress(toAdd);
        }
    }

    public void addEndpointAddress(EndpointAddress address) {
        String toAdd = address.toString();
        if (!this.endpointAddresses.contains(toAdd)) {
            this.endpointAddresses.add(toAdd);
        }
    }

    public void addEndpointAddress(String address) {
        if (!this.endpointAddresses.contains(address)) {
            this.endpointAddresses.add(address);
        }
    }

    public void removeEndpointAddresses(List<String> addresses) {
        this.endpointAddresses.removeAll(addresses);
    }

    public int size() {
        return this.endpointAddresses.size();
    }

    public boolean contains(EndpointAddress addr) {
        return this.endpointAddresses.contains(addr.toString());
    }

    public String display() {
        StringBuilder routeBuf = new StringBuilder();
        routeBuf.append("PID=");
        PeerID peerId = this.getPeerID();
        if (peerId == null) {
            routeBuf.append("<null>");
        } else {
            routeBuf.append(peerId.toString());
        }
        Enumeration<String> e = this.getEndpointAddresses();
        while (e.hasMoreElements()) {
            routeBuf.append("\n Addr=").append((Object)e.nextElement());
        }
        return routeBuf.toString();
    }
}

