/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.cm;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;

public class DumpCm {
    private static final IndexQuery ANY = new IndexQuery(0, "*");

    public static void dump(String[] args, DumpCmCallback callback) throws IOException {
        String type = null;
        String dir = null;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-type") && i + 1 < args.length) {
                type = args[++i];
                continue;
            }
            if (args[i].equals("-dir") && i + 1 < args.length) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-file") && i + 1 < args.length) {
                file = args[++i];
                continue;
            }
            throw new IllegalArgumentException("Incorrect option");
        }
        if (callback == null) {
            throw new IllegalArgumentException("No callback was provided.");
        }
        if (type == null || dir == null || file == null) {
            throw new IllegalArgumentException("Missing mandatory option");
        }
        if (type.equals("index")) {
            DumpCm.dumpIndex(dir, file, callback);
        } else if (type.equals("offsets")) {
            DumpCm.dumpOffsets(dir, file, callback);
        } else if (type.equals("db")) {
            DumpCm.dumpDatabase(dir, file, callback);
        } else {
            throw new IllegalArgumentException("Incorrect type");
        }
    }

    public static void dumpIndex(String dir, String file, DumpCmCallback callback) throws IOException {
        NameIndexer indexer = new NameIndexer();
        String SUFFIX = ".idx";
        if (file.endsWith(".idx")) {
            file = file.substring(0, file.length() - ".idx".length());
        }
        indexer.setLocation(dir, file);
        try {
            if (!indexer.open()) {
                throw new IOException("Failed to open index file " + dir + File.separator + file + ".idx");
            }
            callback.println("Index " + dir + File.separator + file + ".idx");
            indexer.query(ANY, new IndexCallback(callback));
        }
        catch (DBException dbe) {
            throw new IOException(dbe.getMessage());
        }
    }

    public static void dumpOffsets(String dir, String file, DumpCmCallback callback) throws IOException {
        BTreeFiler filer = new BTreeFiler();
        String SUFFIX = ".tbl";
        if (file.endsWith(".tbl")) {
            file = file.substring(0, file.length() - ".tbl".length());
        }
        filer.setLocation(dir, file);
        try {
            if (!filer.open()) {
                throw new IOException("Failed to open offsets file " + dir + File.separator + file + ".tbl");
            }
            callback.println("Offsets " + dir + File.separator + file + ".tbl");
            filer.query(ANY, new OffsetsCallback(filer, callback));
        }
        catch (DBException dbe) {
            throw new IOException(dbe.getMessage());
        }
    }

    public static void dumpDatabase(String dir, String file, DumpCmCallback callback) throws IOException {
        BTreeFiler filer = new BTreeFiler();
        String SUFFIX = ".tbl";
        if (file.endsWith(".tbl")) {
            file = file.substring(0, file.length() - ".tbl".length());
        }
        filer.setLocation(dir, file);
        try {
            if (!filer.open()) {
                throw new IOException("Failed to open database file " + dir + File.separator + file + ".tbl");
            }
            callback.println("Database " + dir + File.separator + file + ".tbl");
            filer.query(ANY, new DatabaseCallback(filer, callback));
        }
        catch (DBException dbe) {
            throw new IOException(dbe.getMessage());
        }
    }

    private static final class DatabaseCallback
    implements BTreeCallback {
        private BTreeFiler filer = null;
        private DumpCmCallback callback = null;

        public DatabaseCallback(BTreeFiler filer, DumpCmCallback callback) {
            this.filer = filer;
            this.callback = callback;
        }

        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            try {
                record = this.filer.readRecord(pos);
            }
            catch (DBException dbe) {
                this.callback.println("Error reading record: " + dbe.getMessage());
            }
            if (record != null) {
                this.callback.println(pos + " \t " + val.toString() + "\n" + record.getValue().toString());
            }
            return true;
        }
    }

    private static final class OffsetsCallback
    implements BTreeCallback {
        private BTreeFiler filer = null;
        private DumpCmCallback callback = null;

        public OffsetsCallback(BTreeFiler filer, DumpCmCallback callback) {
            this.filer = filer;
            this.callback = callback;
        }

        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            try {
                record = this.filer.readRecord(pos);
            }
            catch (DBException dbe) {
                this.callback.println("Error reading record: " + dbe.getMessage());
            }
            StringBuilder offsets = new StringBuilder();
            DataInputStream dis = null;
            if (record != null) {
                dis = new DataInputStream(record.getValue().getInputStream());
            }
            try {
                int size = 0;
                if (dis != null) {
                    size = dis.readInt();
                }
                for (int i = 0; i < size; ++i) {
                    if (dis != null) {
                        offsets.append(Long.toString(dis.readLong()));
                    }
                    offsets.append(" ");
                }
            }
            catch (IOException ie) {
                this.callback.println("Error reading record: " + ie.getMessage());
            }
            this.callback.println(pos + " \t " + val.toString() + "\n\t " + offsets.toString());
            return true;
        }
    }

    private static final class IndexCallback
    implements BTreeCallback {
        private DumpCmCallback callback = null;

        public IndexCallback(DumpCmCallback callback) {
            this.callback = callback;
        }

        public boolean indexInfo(Value val, long pos) {
            this.callback.println(pos + " \t " + val.toString());
            return true;
        }
    }

    public static interface DumpCmCallback {
        public void println(String var1);
    }
}

