/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.meter.GenericServiceMonitor;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.impl.rendezvous.rendezvousMeter.ClientConnectionMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.ClientConnectionMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMetric;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitorFilter;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.peer.PeerID;

public class RendezvousServiceMonitor
extends GenericServiceMonitor {
    private Hashtable<PeerID, ClientConnectionMeter> clientConnectionMeters = new Hashtable();
    private LinkedList<RendezvousConnectionMeter> rendezvousConnectionMeters = new LinkedList();
    private RendezvousMeter rendezvousMeter = new RendezvousMeter();
    private RendezvousServiceMetric cumulativeRendezvousServiceMetric;

    protected void init() {
        this.cumulativeRendezvousServiceMetric = (RendezvousServiceMetric)this.getCumulativeServiceMetric();
        this.cumulativeRendezvousServiceMetric.setRendezvousMetric(this.rendezvousMeter.getCumulativeMetrics());
    }

    public RendezvousMeter getRendezvousMeter() {
        return this.rendezvousMeter;
    }

    public synchronized ClientConnectionMeter getClientConnectionMeter(EndpointAddress endpointAddress) {
        PeerID peerID = MetricUtilities.getPeerIdFromEndpointAddress(endpointAddress);
        return this.getClientConnectionMeter(peerID);
    }

    public synchronized ClientConnectionMeter getClientConnectionMeter(PeerID peerId) {
        ClientConnectionMeter clientConnectionMeter = this.clientConnectionMeters.get(peerId);
        if (clientConnectionMeter == null) {
            clientConnectionMeter = new ClientConnectionMeter(peerId);
            this.clientConnectionMeters.put(peerId, clientConnectionMeter);
            this.cumulativeRendezvousServiceMetric.addClientConnectionMetric(clientConnectionMeter.getCumulativeMetrics());
        }
        return clientConnectionMeter;
    }

    public synchronized ClientConnectionMeter getClientConnectionMeter(String peerIdString) {
        PeerID peerID = MetricUtilities.getPeerIdFromString(peerIdString);
        return this.getClientConnectionMeter(peerID);
    }

    public synchronized RendezvousConnectionMeter getRendezvousConnectionMeter(String peerIdStr) {
        PeerID peerID = MetricUtilities.getPeerIdFromString(peerIdStr);
        return this.getRendezvousConnectionMeter(peerID);
    }

    public synchronized RendezvousConnectionMeter getRendezvousConnectionMeter(PeerID peerID) {
        if (peerID == null) {
            peerID = MetricUtilities.BAD_PEERID;
        }
        for (RendezvousConnectionMeter rendezvousConnectionMeter1 : this.rendezvousConnectionMeters) {
            RendezvousConnectionMeter rendezvousConnectionMeter = rendezvousConnectionMeter1;
            if (!peerID.equals(rendezvousConnectionMeter.getPeerID())) continue;
            return rendezvousConnectionMeter;
        }
        RendezvousConnectionMeter rendezvousConnectionMeter = new RendezvousConnectionMeter(peerID);
        this.rendezvousConnectionMeters.add(rendezvousConnectionMeter);
        this.cumulativeRendezvousServiceMetric.addRendezvousConnectionMetric(rendezvousConnectionMeter.getCumulativeMetrics());
        return rendezvousConnectionMeter;
    }

    protected synchronized ServiceMetric collectServiceMetrics() {
        RendezvousServiceMetric rendezvousServiceMetric = (RendezvousServiceMetric)this.createServiceMetric();
        boolean anyData = false;
        Enumeration<ClientConnectionMeter> e = this.clientConnectionMeters.elements();
        while (e.hasMoreElements()) {
            ClientConnectionMeter clientConnectionMeter = e.nextElement();
            ClientConnectionMetric clientConnectionMetric = clientConnectionMeter.collectMetrics();
            if (clientConnectionMetric == null) continue;
            rendezvousServiceMetric.addClientConnectionMetric(clientConnectionMetric);
            anyData = true;
        }
        for (RendezvousConnectionMeter rendezvousConnectionMeter : this.rendezvousConnectionMeters) {
            RendezvousConnectionMetric rendezvousConnectionMetric = rendezvousConnectionMeter.collectMetrics();
            if (rendezvousConnectionMetric == null) continue;
            rendezvousServiceMetric.addRendezvousConnectionMetric(rendezvousConnectionMetric);
            anyData = true;
        }
        RendezvousMetric rendezvousMetric = this.rendezvousMeter.collectMetrics();
        if (rendezvousMetric != null) {
            rendezvousServiceMetric.setRendezvousMetric(rendezvousMetric);
            anyData = true;
        }
        if (anyData) {
            return rendezvousServiceMetric;
        }
        return null;
    }

    public ServiceMetric getServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime, int pulseIndex, long reportRate) {
        int deltaReportRateIndex = this.monitorManager.getReportRateIndex(reportRate);
        RendezvousServiceMetric origMetric = (RendezvousServiceMetric)this.deltaServiceMetrics[deltaReportRateIndex];
        if (origMetric == null) {
            return null;
        }
        RendezvousServiceMonitorFilter rendezvousServiceMonitorFilter = (RendezvousServiceMonitorFilter)serviceMonitorFilter;
        return origMetric.shallowCopy(rendezvousServiceMonitorFilter);
    }

    public ServiceMetric getCumulativeServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime) {
        RendezvousServiceMonitorFilter rendezvousServiceMonitorFilter = (RendezvousServiceMonitorFilter)serviceMonitorFilter;
        RendezvousServiceMetric origMetric = (RendezvousServiceMetric)this.getCumulativeServiceMetric();
        return origMetric.deepCopy(rendezvousServiceMonitorFilter);
    }
}

