/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class ClientConnectionMetric
implements DocumentSerializable {
    public static final String CONNECTED = "connected";
    public static final String DISCONNECTED = "disconnected";
    public static final String REFUSED = "refused";
    private PeerID peerID;
    private String state = null;
    private long transitionTime;
    private long lastLeaseRenewalTime;
    private long lease;
    private int numConnects;
    private int numLeaseRenewals;
    private int numDisconnects;
    private int numConnectionsRefused;
    private int numErrorsAddingClient;
    private int numUnableToRespondToConnectRequest;
    private long totalTimeConnected;

    public ClientConnectionMetric() {
    }

    public ClientConnectionMetric(PeerID peerID) {
        this.peerID = peerID;
        this.state = DISCONNECTED;
    }

    public ClientConnectionMetric(ClientConnectionMetric prototype) {
        this.peerID = prototype.peerID;
        this.state = prototype.state;
        this.transitionTime = prototype.transitionTime;
        this.lastLeaseRenewalTime = prototype.lastLeaseRenewalTime;
        this.lease = prototype.lease;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public String getState() {
        return this.state;
    }

    public long getTransitionTime() {
        return this.transitionTime;
    }

    public boolean isConnected() {
        return this.state != null && this.state.equals(CONNECTED);
    }

    public long getTimeConnectionEstablished() {
        return this.isConnected() ? this.transitionTime : 0L;
    }

    public long getDisconnectTime() {
        return this.isDisconnected() ? this.transitionTime : 0L;
    }

    public boolean isDisconnected() {
        return this.state != null && (this.state.equals(DISCONNECTED) || this.state.equals(REFUSED));
    }

    public long getLease() {
        return this.lease;
    }

    public long getLastLeaseRenewalTime() {
        return this.lastLeaseRenewalTime;
    }

    public int getNumConnects() {
        return this.numConnects;
    }

    public int getNumLeaseRenewals() {
        return this.numLeaseRenewals;
    }

    public int getNumDisconnects() {
        return this.numDisconnects;
    }

    public int getNumConnectionsRefused() {
        return this.numConnectionsRefused;
    }

    public int getNumErrorsAddingClient() {
        return this.numErrorsAddingClient;
    }

    public int getNumUnableToRespondToConnectRequest() {
        return this.numUnableToRespondToConnectRequest;
    }

    public long getTotalTimeConnected() {
        return this.totalTimeConnected;
    }

    public long getTotalTimeConnected(long adjustmentTime) {
        long result = this.totalTimeConnected;
        if (this.isConnected()) {
            result += adjustmentTime - this.transitionTime;
        }
        return result;
    }

    public long getTimeConnected() {
        return this.getTimeConnected(System.currentTimeMillis());
    }

    public long getTimeConnected(long adjustmentTime) {
        if (this.isConnected()) {
            return adjustmentTime - this.transitionTime;
        }
        return 0L;
    }

    private void resetState(String state, long transitionTime) {
        if (this.isConnected()) {
            this.totalTimeConnected += System.currentTimeMillis() - this.transitionTime;
        }
        this.state = state;
        this.transitionTime = transitionTime;
    }

    void clientConnectionEstablished(long transitionTime, long lease) {
        this.resetState(CONNECTED, transitionTime);
        ++this.numConnects;
        this.lease = lease;
    }

    void clientLeaseRenewed(long lastLeaseRenewalTime, long lease) {
        ++this.numLeaseRenewals;
        this.lease = lease;
        this.lastLeaseRenewalTime = System.currentTimeMillis();
        if (!this.isConnected()) {
            this.resetState(CONNECTED, lastLeaseRenewalTime);
        }
    }

    void errorAddingClient() {
        ++this.numErrorsAddingClient;
    }

    void clientConnectionDisconnected(boolean normal, long transitionTime) {
        this.resetState(DISCONNECTED, transitionTime);
        ++this.numDisconnects;
        this.lease = 0L;
    }

    void unableToRespondToConnectRequest() {
        ++this.numUnableToRespondToConnectRequest;
    }

    void clientConnectionRefused(long transitionTime) {
        if (!this.isDisconnected()) {
            this.clientConnectionDisconnected(false, transitionTime);
        }
        this.transitionTime = transitionTime;
        ++this.numConnectionsRefused;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.peerID != null) {
            DocumentSerializableUtilities.addString(element2, "peerID", this.peerID.toString());
        }
        if (this.state != null) {
            DocumentSerializableUtilities.addString(element2, "state", this.state);
        }
        if (this.transitionTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "transitionTime", this.transitionTime);
        }
        if (this.lastLeaseRenewalTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "lastLeaseRenewalTime", this.lastLeaseRenewalTime);
        }
        if (this.lease != 0L) {
            DocumentSerializableUtilities.addLong(element2, "lease", this.lease);
        }
        if (this.numConnects != 0) {
            DocumentSerializableUtilities.addInt(element2, "numConnects", this.numConnects);
        }
        if (this.numLeaseRenewals != 0) {
            DocumentSerializableUtilities.addInt(element2, "numLeaseRenewals", this.numLeaseRenewals);
        }
        if (this.numDisconnects != 0) {
            DocumentSerializableUtilities.addInt(element2, "numDisconnects", this.numDisconnects);
        }
        if (this.numConnectionsRefused != 0) {
            DocumentSerializableUtilities.addInt(element2, "numConnectionsRefused", this.numConnectionsRefused);
        }
        if (this.numErrorsAddingClient != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsAddingClient", this.numErrorsAddingClient);
        }
        if (this.numUnableToRespondToConnectRequest != 0) {
            DocumentSerializableUtilities.addInt(element2, "numUnableToRespondToConnectRequest", this.numUnableToRespondToConnectRequest);
        }
        if (this.totalTimeConnected != 0L) {
            DocumentSerializableUtilities.addLong(element2, "totalTimeConnected", this.totalTimeConnected);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        this.state = null;
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("peerID")) {
                String peerIDText = DocumentSerializableUtilities.getString(childElement);
                this.peerID = MetricUtilities.getPeerIdFromString(peerIDText);
                continue;
            }
            if (tagName.equals("state")) {
                this.state = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("transitionTime")) {
                this.transitionTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("lastLeaseRenewalTime")) {
                this.lastLeaseRenewalTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("lease")) {
                this.lease = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numConnects")) {
                this.numConnects = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numLeaseRenewals")) {
                this.numLeaseRenewals = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numDisconnects")) {
                this.numDisconnects = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numConnectionsRefused")) {
                this.numConnectionsRefused = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numErrorsAddingClient")) {
                this.numErrorsAddingClient = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numUnableToRespondToConnectRequest")) {
                this.numUnableToRespondToConnectRequest = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("totalTimeConnected")) continue;
            this.totalTimeConnected = DocumentSerializableUtilities.getLong(childElement);
        }
    }

    public void mergeMetrics(ClientConnectionMetric otherClientConnectionMetric) {
        if (otherClientConnectionMetric == null) {
            return;
        }
        if (otherClientConnectionMetric.state != null) {
            this.state = otherClientConnectionMetric.state;
        }
        if (otherClientConnectionMetric.transitionTime != 0L) {
            this.transitionTime = otherClientConnectionMetric.transitionTime;
        }
        this.lease = otherClientConnectionMetric.lease;
        this.numConnects += otherClientConnectionMetric.numConnects;
        this.numLeaseRenewals += otherClientConnectionMetric.numLeaseRenewals;
        this.numDisconnects += otherClientConnectionMetric.numDisconnects;
        this.numConnectionsRefused += otherClientConnectionMetric.numConnectionsRefused;
        this.numErrorsAddingClient += otherClientConnectionMetric.numErrorsAddingClient;
        this.numUnableToRespondToConnectRequest += otherClientConnectionMetric.numUnableToRespondToConnectRequest;
        this.totalTimeConnected += otherClientConnectionMetric.totalTimeConnected;
    }
}

