/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.protocol.ResolverSrdiMsg;

public class ResolverSrdiMsgImpl
extends ResolverSrdiMsg {
    private static final Logger LOG = Logger.getLogger(ResolverSrdiMsgImpl.class.getName());
    public static final String handlernameTag = "HandlerName";
    public static final String credentialTag = "jxta:Cred";
    public static final String payloadTag = "Payload";

    public ResolverSrdiMsgImpl() {
    }

    public ResolverSrdiMsgImpl(Element root, MembershipService membership) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        if (!ResolverSrdiMsgImpl.getMessageType().equals(doctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        this.readIt(doc, membership);
    }

    public ResolverSrdiMsgImpl(String handlerName, Credential cred, String payload) {
        this.setHandlerName(handlerName);
        this.setPayload(payload);
        this.setCredential(cred);
    }

    public String toString() {
        StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
        return doc.toString();
    }

    public Document getDocument(MimeMediaType asMimeType) {
        Object e;
        StructuredTextDocument adv;
        block4: {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, ResolverSrdiMsgImpl.getMessageType());
            if (adv instanceof XMLElement) {
                ((XMLElement)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
            }
            e = adv.createElement(handlernameTag, this.getHandlerName());
            adv.appendChild(e);
            if (this.getCredential() != null) {
                try {
                    StructuredDocumentUtils.copyElements(adv, adv, this.getCredential().getDocument(asMimeType));
                }
                catch (Exception ce) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                    LOG.log(Level.WARNING, "Got an Exception during credential creation ", ce);
                }
            }
        }
        e = adv.createElement(payloadTag, this.getPayload());
        adv.appendChild(e);
        return adv;
    }

    private void readIt(XMLElement doc, MembershipService membership) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (elem.getName().equals(handlernameTag)) {
                this.setHandlerName(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(credentialTag)) {
                if (elem.getTextValue() == null) continue;
                try {
                    Credential credential = membership.makeCredential(elem);
                    this.setCredential(credential);
                }
                catch (Exception ce) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Credential creation failed", ce);
                }
                continue;
            }
            if (!elem.getName().equals(payloadTag)) continue;
            this.setPayload(elem.getTextValue());
        }
    }
}

