/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;

public final class PeerGroupConfigAdv
extends ExtendableAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(PeerGroupConfigAdv.class.getName());
    private static final String[] INDEX_FIELDS = new String[0];
    private static final String advType = "jxta:PeerGroupConfigAdv";
    private static final String PEERGROUP_ID_TAG = "PeerGroupID";
    private static final String PEERGROUP_NAME_TAG = "PeerGroupName";
    private static final String PEERGROUP_DESC_TAG = "PeerGroupDesc";
    private ID gid = null;
    private String name = null;
    private Element description = null;

    public static String getAdvertisementType() {
        return advType;
    }

    private PeerGroupConfigAdv() {
    }

    private PeerGroupConfigAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PeerGroupConfigAdv.getAdvertisementType()) && !PeerGroupConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (null == this.getPeerGroupID()) {
            throw new IllegalArgumentException("Peer Group Config Advertisement does not contain a peer group id.");
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (PEERGROUP_ID_TAG.equals(elem.getName())) {
            try {
                URI grID = new URI(elem.getTextValue());
                this.setPeerGroupID(IDFactory.fromURI(grID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Invalid peer group ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Invalid group ID: " + elem.getTextValue());
            }
            return true;
        }
        if (PEERGROUP_NAME_TAG.equals(elem.getName())) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (PEERGROUP_DESC_TAG.equals(elem.getName())) {
            this.setDesc(elem);
            return true;
        }
        return false;
    }

    public PeerGroupConfigAdv clone() {
        try {
            PeerGroupConfigAdv clone = (PeerGroupConfigAdv)super.clone();
            clone.setPeerGroupID(this.getPeerGroupID());
            clone.setName(this.getName());
            clone.setDesc(this.getDesc());
            return clone;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public String getAdvType() {
        return PeerGroupConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return PeerGroupConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        return ID.nullID;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        XMLDocument desc;
        if (null == this.getPeerGroupID()) {
            throw new IllegalStateException("Peer Group Config Advertisement does not contain a peer group id.");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Object e = adv.createElement(PEERGROUP_ID_TAG, this.getPeerGroupID().toString());
        adv.appendChild(e);
        if (null != this.getName()) {
            e = adv.createElement(PEERGROUP_NAME_TAG, this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEX_FIELDS;
    }

    public ID getPeerGroupID() {
        return this.gid;
    }

    public void setPeerGroupID(ID gid) {
        this.gid = gid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (this.description != null) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            XMLDocument newdoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, PEERGROUP_DESC_TAG, description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public XMLDocument getDesc() {
        XMLDocument newDoc = null;
        if (this.description != null) {
            newDoc = (XMLDocument)StructuredDocumentUtils.copyAsDocument(this.description);
        }
        return newDoc;
    }

    public void setDesc(XMLElement desc) {
        this.description = desc != null ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PeerGroupConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new PeerGroupConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new PeerGroupConfigAdv((XMLElement)root);
        }
    }
}

