/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.PeerGroupAdvertisement;

public class PeerGroupAdv
extends PeerGroupAdvertisement {
    private static final Logger LOG = Logger.getLogger(PeerGroupAdv.class.getName());
    private static final String nameTag = "Name";
    private static final String gidTag = "GID";
    private static final String descTag = "Desc";
    private static final String msidTag = "MSID";
    private static final String svcTag = "Svc";
    private static final String mcidTag = "MCID";
    private static final String paramTag = "Parm";
    private static final String[] fields = new String[]{"Name", "GID", "Desc", "MSID"};

    private PeerGroupAdv() {
    }

    private PeerGroupAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PeerGroupAdv.getAdvertisementType()) && !PeerGroupAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (null == this.getPeerGroupID()) {
            throw new IllegalArgumentException("Peer Group Advertisement did not contain a peer group id.");
        }
        if (null == this.getModuleSpecID()) {
            throw new IllegalArgumentException("Peer Group Advertisement did not contain a module spec id.");
        }
    }

    public String getAdvType() {
        return PeerGroupAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(nameTag)) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(descTag)) {
            this.setDesc(elem);
            return true;
        }
        if (elem.getName().equals(gidTag)) {
            try {
                URI grID = new URI(elem.getTextValue());
                this.setPeerGroupID((PeerGroupID)IDFactory.fromURI(grID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad peer group ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(msidTag)) {
            try {
                URI specID = new URI(elem.getTextValue());
                this.setModuleSpecID((ModuleSpecID)IDFactory.fromURI(specID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad msid in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a module spec id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(svcTag)) {
            Enumeration elems = elem.getChildren();
            String classID = null;
            TextElement param = null;
            while (elems.hasMoreElements()) {
                TextElement e = (TextElement)elems.nextElement();
                if (e.getName().equals(mcidTag)) {
                    classID = e.getTextValue();
                    continue;
                }
                if (!e.getName().equals(paramTag)) continue;
                param = e;
            }
            if (classID != null && param != null) {
                try {
                    this.putServiceParam(IDFactory.fromURI(new URI(classID)), param);
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad mcid in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a module class id: " + elem.getTextValue());
                }
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument desc;
        if (null == this.getPeerGroupID()) {
            throw new IllegalStateException("Peer Group Advertisement did not contain a peer group id.");
        }
        if (null == this.getModuleSpecID()) {
            throw new IllegalStateException("Peer Group Advertisement did not contain a module spec id.");
        }
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        Object e = adv.createElement(gidTag, this.getPeerGroupID().toString());
        adv.appendChild(e);
        e = adv.createElement(msidTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        if (null != this.getName()) {
            e = adv.createElement(nameTag, this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        Hashtable<ID, StructuredDocument> serviceParams = this.getServiceParams();
        Enumeration<ID> classIds = serviceParams.keys();
        while (classIds.hasMoreElements()) {
            ModuleClassID classId = (ModuleClassID)classIds.nextElement();
            Object s = adv.createElement(svcTag);
            adv.appendChild(s);
            e = adv.createElement(mcidTag, classId.toString());
            s.appendChild(e);
            e = serviceParams.get(classId);
            StructuredDocumentUtils.copyElements(adv, s, e, paramTag);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PeerGroupAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PeerGroupAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PeerGroupAdv(root);
        }
    }
}

