/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Certificate {
    private static final transient Logger LOG = Logger.getLogger(Certificate.class.getName());
    private List<X509Certificate> certs = null;

    public Certificate() {
    }

    public Certificate(Element root) {
        this();
        this.certs = new ArrayList<X509Certificate>();
        this.initialize(root);
    }

    public static String getMessageType() {
        return "jxta:cert";
    }

    public X509Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public void setCertificates(X509Certificate[] certs) {
        this.certs = new ArrayList<X509Certificate>(Arrays.asList(certs));
    }

    public void setCertificates(List<X509Certificate> certs) {
        this.certs = new ArrayList<X509Certificate>(certs);
    }

    private void initialize(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(Certificate.getMessageType()) && !Certificate.getMessageType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        String value = doc.getTextValue();
        value = value.trim();
        try {
            byte[] cert_der = PSEUtils.base64Decode(new StringReader(value));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.certs.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_der)));
        }
        catch (IOException error) {
            throw new IllegalArgumentException("bad certificate.");
        }
        catch (CertificateException error) {
            throw new IllegalArgumentException("bad certificate.");
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Element elem = (Element)elements.nextElement();
            if (!elem.getKey().equals("Issuer")) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Unhandled Element: " + elem.toString());
                continue;
            }
            Certificate issuer = new Certificate(elem);
            this.certs.addAll(Arrays.asList(issuer.getCertificates()));
        }
        if (this.certs.isEmpty()) {
            throw new IllegalArgumentException("certificate not initialized.");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        String encodedCert;
        try {
            encodedCert = PSEUtils.base64Encode(this.certs.get(0).getEncoded());
        }
        catch (CertificateEncodingException failed) {
            IllegalStateException failure = new IllegalStateException("bad certificate.");
            failure.initCause(failed);
            throw failure;
        }
        catch (IOException failed) {
            IllegalStateException failure = new IllegalStateException("Could not encode certificate.");
            failure.initCause(failed);
            throw failure;
        }
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(encodeAs, Certificate.getMessageType(), encodedCert);
        if (doc instanceof XMLDocument) {
            ((XMLDocument)doc).addAttribute("xmlns:jxta", "http://jxta.org");
            ((XMLDocument)doc).addAttribute("xml:space", "preserve");
        }
        Iterator<X509Certificate> eachCert = this.certs.iterator();
        eachCert.next();
        StructuredDocument addTo = doc;
        while (eachCert.hasNext()) {
            X509Certificate anIssuer = eachCert.next();
            try {
                encodedCert = PSEUtils.base64Encode(anIssuer.getEncoded());
            }
            catch (CertificateEncodingException failed) {
                IllegalStateException failure = new IllegalStateException("bad certificate.");
                failure.initCause(failed);
                throw failure;
            }
            catch (IOException failed) {
                IllegalStateException failure = new IllegalStateException("Could not encode certificate.");
                failure.initCause(failed);
                throw failure;
            }
            Object issuerElement = doc.createElement("Issuer", encodedCert);
            addTo.appendChild(issuerElement);
            if (doc instanceof Attributable) {
                ((Attributable)issuerElement).addAttribute("type", Certificate.getMessageType());
            }
            addTo = issuerElement;
        }
        return doc;
    }
}

