/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.impl.pipe.InputPipeImpl;
import net.jxta.impl.pipe.NonBlockingWireOutputPipe;
import net.jxta.impl.pipe.PipeRegistrar;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WirePipeImpl;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WirePipe
implements EndpointListener,
InputPipe,
PipeRegistrar {
    private static final transient Logger LOG = Logger.getLogger(WirePipe.class.getName());
    private static final int MAX_RECORDED_MSGIDS = 250;
    private volatile boolean closed = false;
    private final PeerGroup peerGroup;
    private final PipeResolver pipeResolver;
    private final WirePipeImpl wireService;
    private final PipeAdvertisement pipeAdv;
    private final RendezVousService rendezvous;
    private final PeerID localPeerId;
    private NonBlockingWireOutputPipe repropagater;
    int messagesReceived = 0;
    private final Map<InputPipe, Object> wireinputpipes = new WeakHashMap<InputPipe, Object>();
    private final List<UUID> msgIds = new ArrayList<UUID>(250);

    public WirePipe(PeerGroup group, PipeResolver pipeResolver, WirePipeImpl wireService, PipeAdvertisement adv) {
        this.peerGroup = group;
        this.pipeResolver = pipeResolver;
        this.wireService = wireService;
        this.pipeAdv = adv;
        this.localPeerId = this.peerGroup.getPeerID();
        this.rendezvous = group.getRendezVousService();
    }

    protected synchronized void finalize() throws Throwable {
        if (!this.closed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Pipe is being finalized without being previously closed. This is likely a bug.");
        }
        this.close();
        super.finalize();
    }

    @Override
    public synchronized boolean register(InputPipe wireinputpipe) {
        boolean registered;
        if (this.closed) {
            return false;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Registering input pipe for " + this.pipeAdv.getPipeID());
        }
        this.wireinputpipes.put(wireinputpipe, null);
        if (1 == this.wireinputpipes.size()) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Registering " + this.pipeAdv.getPipeID() + " with pipe resolver.");
            }
            registered = this.pipeResolver.register(this);
        } else {
            registered = true;
        }
        return registered;
    }

    @Override
    public synchronized boolean forget(InputPipe wireinputpipe) {
        boolean removed;
        boolean bl = removed = null != this.wireinputpipes.remove(wireinputpipe);
        if (this.wireinputpipes.isEmpty()) {
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Deregistering wire pipe with pipe resolver");
            }
            this.pipeResolver.forget(this);
        }
        if (removed && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removed input pipe for " + this.pipeAdv.getPipeID());
        }
        return removed;
    }

    @Override
    public Message waitForMessage() throws InterruptedException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("This method is not really supported.");
        }
        return null;
    }

    @Override
    public Message poll(int timeout) throws InterruptedException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("This method is not really supported.");
        }
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (null != this.repropagater) {
            this.repropagater.close();
            this.repropagater = null;
        }
        ArrayList<InputPipe> inputPipes = new ArrayList<InputPipe>(this.wireinputpipes.keySet());
        for (InputPipe anInputPipe : inputPipes) {
            anInputPipe.close();
        }
        this.wireinputpipes.clear();
        this.msgIds.clear();
        this.wireService.forgetWirePipe(this.pipeAdv.getPipeID());
    }

    @Override
    public String getType() {
        return this.pipeAdv.getType();
    }

    @Override
    public ID getPipeID() {
        return this.pipeAdv.getPipeID();
    }

    @Override
    public String getName() {
        return this.pipeAdv.getName();
    }

    @Override
    public PipeAdvertisement getAdvertisement() {
        return this.pipeAdv;
    }

    @Override
    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        WireHeader header;
        MessageElement elem = message.getMessageElement("jxta", "JxtaWireHeader");
        if (null == elem) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No JxtaWireHeader element. Discarding " + message);
            }
            return;
        }
        try {
            XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(elem);
            header = new WireHeader(doc);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "bad wire header", e);
            }
            return;
        }
        this.processIncomingMessage(message, header, srcAddr, dstAddr);
    }

    void processIncomingMessage(Message message, WireHeader header, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (this.recordSeenMessage(header.getMsgId())) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Discarding duplicate " + message);
            }
            return;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Processing " + message + " from " + srcAddr + " on " + this.pipeAdv.getPipeID());
        }
        this.callLocalListeners(message, srcAddr, dstAddr);
        if (this.peerGroup.isRendezvous()) {
            this.repropagate(message, header);
        }
    }

    private void callLocalListeners(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        ArrayList<InputPipe> listeners = new ArrayList<InputPipe>(this.wireinputpipes.keySet());
        if (listeners.isEmpty()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No local listeners for " + this.pipeAdv.getPipeID());
            }
        } else {
            int listenersCalled = 0;
            for (InputPipeImpl inputPipeImpl : listeners) {
                try {
                    inputPipeImpl.processIncomingMessage(message.clone(), srcAddr, dstAddr);
                    ++listenersCalled;
                }
                catch (Throwable ignored) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) continue;
                    LOG.log(Level.SEVERE, "Uncaught Throwable during callback (" + inputPipeImpl + ") for " + inputPipeImpl.getPipeID(), ignored);
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Called " + listenersCalled + " of " + listeners.size() + " local listeners for " + this.pipeAdv.getPipeID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repropagate(Message message, WireHeader header) {
        block12: {
            if (this.closed) {
                return;
            }
            if (header.getTTL() <= 1) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No TTL remaining - discarding " + message + " on " + header.getPipeID());
                }
                return;
            }
            Message msg = message.clone();
            header.setTTL(header.getTTL() - 1);
            XMLDocument headerDoc = (XMLDocument)header.getDocument(MimeMediaType.XMLUTF8);
            TextDocumentMessageElement elem = new TextDocumentMessageElement("JxtaWireHeader", headerDoc, null);
            msg.replaceMessageElement("jxta", elem);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Repropagating " + msg + " on " + header.getPipeID());
            }
            WirePipe wirePipe = this;
            synchronized (wirePipe) {
                if (this.closed) {
                    return;
                }
                if (null == this.repropagater) {
                    this.repropagater = this.wireService.createOutputPipe(this.pipeAdv, Collections.EMPTY_SET);
                }
            }
            try {
                if (!this.repropagater.sendUnModified(msg, header) && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Failure repropagating " + msg + " on " + header.getPipeID() + ". Could not queue message.");
                }
            }
            catch (IOException failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                LOG.log(Level.WARNING, "Failure repropagating " + msg + " on " + header.getPipeID(), failed);
            }
        }
    }

    void sendMessage(Message message, Set<? extends ID> peers, WireHeader header) throws IOException {
        message = message.clone();
        if ((peers.isEmpty() || peers.contains(this.localPeerId)) && !this.recordSeenMessage(header.getMsgId())) {
            this.callLocalListeners(message, new EndpointAddress(this.localPeerId, null, null), new EndpointAddress(this.pipeAdv.getPipeID(), null, null));
        }
        if (peers.isEmpty()) {
            if (this.peerGroup.isRendezvous()) {
                SrdiIndex srdiIndex = this.pipeResolver.getSrdiIndex();
                List<PeerID> peerids = srdiIndex.query("JxtaPropagate", "Id", this.getPipeID().toString(), Integer.MAX_VALUE);
                peerids.retainAll(this.rendezvous.getConnectedPeerIDs());
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Propagating " + message + " to " + peerids.size() + " subscriber peers.");
                }
                this.rendezvous.propagate(Collections.enumeration(peerids), message, "jxta.service.wirepipe", this.wireService.getServiceParameter(), 1);
            } else {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Propagating " + message + " to whole network.");
                }
                this.rendezvous.propagateToNeighbors(message, "jxta.service.wirepipe", this.wireService.getServiceParameter(), Integer.MAX_VALUE);
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Walking " + message + " through peerview.");
            }
            this.rendezvous.walk(message, "jxta.service.wirepipe", this.wireService.getServiceParameter(), Integer.MAX_VALUE);
        } else {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Propagating " + message + " to " + peers.size() + " peers.");
            }
            this.rendezvous.propagate(Collections.enumeration(peers), message, "jxta.service.wirepipe", this.wireService.getServiceParameter(), 1);
        }
    }

    static String createMsgId() {
        return UUIDFactory.newSeqUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recordSeenMessage(String id) {
        UUID msgid;
        try {
            msgid = new UUID(id);
        }
        catch (IllegalArgumentException notauuid) {
            try {
                msgid = UUIDFactory.newHashUUID(Long.parseLong(id), 0L);
            }
            catch (NumberFormatException notanumber) {
                msgid = UUIDFactory.newHashUUID(id.hashCode(), 0L);
            }
        }
        List<UUID> list = this.msgIds;
        synchronized (list) {
            if (this.msgIds.contains(msgid)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("duplicate " + msgid);
                }
                return true;
            }
            if (this.msgIds.size() < 250) {
                this.msgIds.add(msgid);
            } else {
                this.msgIds.set(this.messagesReceived % 250, msgid);
            }
            ++this.messagesReceived;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("added " + msgid);
        }
        return false;
    }
}

